/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.common;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.Options.SOSOptionString;
import com.sos.i18n.annotation.I18NResourceBundle;
import com.sos.vfs.common.SOSCommonProvider;
import com.sos.vfs.common.SOSEnv;
import com.sos.vfs.common.SOSFileEntry;
import com.sos.vfs.common.SOSFileList;
import com.sos.vfs.common.SOSVFSMessageCodes;
import com.sos.vfs.common.interfaces.IJadeTransferDetailHistoryData;
import com.sos.vfs.common.interfaces.ISOSProvider;
import com.sos.vfs.common.interfaces.ISOSProviderFile;
import com.sos.vfs.common.options.SOSBaseOptions;
import com.sos.vfs.common.options.SOSProviderOptions;
import com.sos.vfs.common.options.SOSTransfer;
import com.sos.vfs.local.SOSLocal;
import com.sos.vfs.sftp.SOSSFTP;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSDate;
import sos.util.SOSString;

@I18NResourceBundle(baseName="SOSVirtualFileSystem", defaultLocale="en")
public class SOSFileListEntry
extends SOSVFSMessageCodes
implements Runnable,
IJadeTransferDetailHistoryData {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSFileListEntry.class);
    private static final Logger JADE_REPORT_LOGGER = LoggerFactory.getLogger((String)"JadeReportLog");
    private static String ENV_VAR_FILE_TRANSFER_STATUS = "YADE_FILE_TRANSFER_STATUS";
    private static String ENV_VAR_FILE_IS_TRANSFERRED = "YADE_FILE_IS_TRANSFERRED";
    private static String DEFAULT_CHECKSUM = "N/A";
    private TransferStatus transferStatus = TransferStatus.transferUndefined;
    private SOSFileList parent = null;
    private SOSFileEntry entry;
    private ISOSProviderFile sourceTransferFile = null;
    private ISOSProviderFile targetTransferFile = null;
    private ISOSProviderFile targetChecksumFile = null;
    private Instant startTime;
    private Instant endTime;
    private String sourceTransferFileName = null;
    private String sourceFileName = null;
    private String sourceFileNameRenamed = null;
    private String sourceFileChecksum = DEFAULT_CHECKSUM;
    private long sourceFileSize = -1L;
    private long sourceFileModificationDateTime = -1L;
    private long sourceFileLastCheckedFileSize = -1L;
    private boolean sourceFileSteady = false;
    private String targetTransferFileName = null;
    private String targetFileName = null;
    private String targetFileChecksum = DEFAULT_CHECKSUM;
    private String targetAtomicFileName = "";
    private boolean targetFileExistsBeforeTransfer = false;
    private boolean transactional = false;
    private long bytesTransferred = 0L;
    private long transferNumber = 0L;

    public SOSFileListEntry(SOSFileEntry fileEntry) {
        super("SOSVirtualFileSystem");
        this.entry = fileEntry;
        this.sourceFileName = this.entry.getFullPath();
        this.sourceFileSize = this.entry.getFilesize();
        this.targetFileName = "";
        this.bytesTransferred = 0L;
    }

    private String changeBackslashes(String val) {
        return val.replaceAll("\\\\", "/");
    }

    public void deleteSourceFile() {
        this.parent.getSourceProvider().getFile(this.sourceFileName).delete(false);
        this.logSourceFileDeleted();
    }

    private void logSourceFileDeleted() {
        String msg = String.format("[%s]%s", this.transferNumber, SOSVfs_I_0113.params(new Object[]{this.sourceFileName}));
        LOGGER.info(msg);
        JADE_REPORT_LOGGER.info(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doTransfer(ISOSProviderFile source, String fileHandlerSourceFileName, ISOSProviderFile target, String fileHandlerTargetFileName) throws Exception {
        boolean closed = false;
        if (target == null) {
            this.setTransferStatus(TransferStatus.transfer_aborted);
            String msg = SOSVfs_E_273.params(new Object[]{"Target"});
            LOGGER.error(msg);
            throw new JobSchedulerException(msg);
        }
        if (source == null) {
            this.setTransferStatus(TransferStatus.transfer_aborted);
            String msg = SOSVfs_E_273.params(new Object[]{"Source"});
            LOGGER.error(msg);
            throw new JobSchedulerException(msg);
        }
        MessageDigest targetChecksum = null;
        boolean targetCreateIntegrityHashFile = this.parent.getBaseOptions().createIntegrityHashFile.isTrue();
        if (targetCreateIntegrityHashFile) {
            try {
                targetChecksum = MessageDigest.getInstance(this.parent.getBaseOptions().integrityHashType.getValue());
            }
            catch (NoSuchAlgorithmException e1) {
                LOGGER.error(e1.toString(), (Throwable)e1);
                this.parent.getBaseOptions().createIntegrityHashFile.value(false);
                targetCreateIntegrityHashFile = false;
            }
        }
        MessageDigest sourceChecksum = null;
        boolean sourceCheckIntegrityHash = this.parent.getBaseOptions().checkIntegrityHash.isTrue();
        if (sourceCheckIntegrityHash) {
            try {
                sourceChecksum = MessageDigest.getInstance(this.parent.getBaseOptions().integrityHashType.getValue());
            }
            catch (NoSuchAlgorithmException e1) {
                LOGGER.error(e1.toString(), (Throwable)e1);
                this.parent.getBaseOptions().checkIntegrityHash.value(false);
                sourceCheckIntegrityHash = false;
            }
        }
        this.executePreCommands(false);
        long totalBytesTransferred = 0L;
        this.setStatus(TransferStatus.transferring);
        long fileSize = this.entry == null ? source.getFileSize() : this.entry.getFilesize();
        try {
            boolean run = true;
            int retryCountSource = 0;
            int retryCountTarget = 0;
            int cumulativeFileSeperatorLength = 0;
            while (run) {
                try {
                    this.startTime = Instant.now();
                    totalBytesTransferred = 0L;
                    cumulativeFileSeperatorLength = 0;
                    byte[] buffer = new byte[this.parent.getBaseOptions().bufferSize.value()];
                    SOSFileListEntry sOSFileListEntry = this;
                    synchronized (sOSFileListEntry) {
                        if (this.parent.getBaseOptions().cumulateFiles.isTrue() && this.parent.getBaseOptions().cumulativeFileSeparator.isNotEmpty()) {
                            String fs = this.parent.getBaseOptions().cumulativeFileSeparator.getValue();
                            fs = this.replaceVariables(fs, null) + System.getProperty("line.separator");
                            byte[] bytes = fs.getBytes();
                            cumulativeFileSeperatorLength = bytes.length;
                            Buffer compressedBytes = this.compress(bytes);
                            target.write(compressedBytes.getBytes());
                            if (sourceCheckIntegrityHash) {
                                sourceChecksum.update(bytes);
                            }
                            if (targetCreateIntegrityHashFile) {
                                targetChecksum.update(compressedBytes.getBytes());
                            }
                        }
                        if (fileSize <= 0L) {
                            byte[] bytes = new byte[]{};
                            Buffer compressedBytes = this.compress(bytes);
                            target.write(compressedBytes.getBytes());
                            if (sourceCheckIntegrityHash) {
                                sourceChecksum.update(bytes);
                            }
                            if (targetCreateIntegrityHashFile) {
                                targetChecksum.update(compressedBytes.getBytes());
                            }
                            if (this.parent.getEventHandler() != null) {
                                HashMap<String, String> values = new HashMap<String, String>();
                                values.put("sourcePath", this.getSourceFilename());
                                values.put("targetPath", this.getTargetFilename());
                                values.put("state", "5");
                                this.parent.getEventHandler().updateDb(null, "YADE_FILE", values);
                            }
                        } else {
                            int bytesTransferred;
                            if (this.parent.getEventHandler() != null) {
                                HashMap<String, String> values = new HashMap<String, String>();
                                values.put("sourcePath", this.getSourceFilename());
                                values.put("targetPath", this.getTargetFilename());
                                values.put("state", "5");
                                this.parent.getEventHandler().updateDb(null, "YADE_FILE", values);
                            }
                            while ((bytesTransferred = source.read(buffer)) != -1) {
                                try {
                                    Buffer compressedBytes = this.compress(buffer, bytesTransferred);
                                    target.write(compressedBytes.getBytes(), 0, compressedBytes.getLength());
                                    if (sourceCheckIntegrityHash) {
                                        sourceChecksum.update(buffer, 0, bytesTransferred);
                                    }
                                    if (targetCreateIntegrityHashFile) {
                                        targetChecksum.update(compressedBytes.getBytes(), 0, compressedBytes.getLength());
                                    }
                                }
                                catch (JobSchedulerException e) {
                                    if (this.parent.getEventHandler() != null) {
                                        HashMap<String, String> values = new HashMap<String, String>();
                                        values.put("sourcePath", this.getSourceFilename());
                                        values.put("state", "7");
                                        values.put("errorMessage", e.getMessage());
                                        this.updateDb(null, "YADE_FILE", values);
                                    }
                                    throw e;
                                }
                                this.setTransferProgress(totalBytesTransferred += (long)bytesTransferred);
                            }
                        }
                    }
                    source.closeInput();
                    target.closeOutput();
                    closed = true;
                    run = false;
                    this.endTime = Instant.now();
                }
                catch (Throwable e) {
                    if (this.parent.getRetryCountMax() < 1) {
                        throw e;
                    }
                    if (retryCountSource > 0 && retryCountSource == this.parent.getRetryCountMax()) {
                        throw e;
                    }
                    if (retryCountTarget > 0 && retryCountTarget == this.parent.getRetryCountMax()) {
                        throw e;
                    }
                    JobSchedulerException.LastErrorMessage = "";
                    this.parent.setLastErrorMessage(e.toString());
                    LOGGER.warn(String.format("[%s][source=%s][target=%s]%s", this.transferNumber, source.getName(), target.getName(), e.toString()), e);
                    if (!closed) {
                        source.closeInput();
                        target.closeOutput();
                        closed = true;
                    }
                    ReconnectResult rvfs = this.tryReconnect("Source", this.parent.getSourceProvider(), source, retryCountSource);
                    retryCountSource = rvfs.counter;
                    ISOSProviderFile vfs = rvfs.providerFile;
                    if (vfs != null) {
                        source = vfs;
                    }
                    ReconnectResult rvft = this.tryReconnect("Target", this.parent.getTargetProvider(), target, retryCountTarget);
                    retryCountTarget = rvft.counter;
                    ISOSProviderFile vft = rvft.providerFile;
                    if (vft != null) {
                        target = vft;
                    }
                    if (vfs != null || vft != null) continue;
                    throw e;
                }
            }
            LOGGER.info(String.format("[%s][transferred]Source=%s, Target=%s, Bytes=%s %s", this.transferNumber, SOSCommonProvider.normalizePath(source.getName()), SOSCommonProvider.normalizePath(target.getName()), totalBytesTransferred, SOSFileListEntry.getDateTimeInfos(this.startTime, this.endTime)));
            if (this.parent.getTargetProvider().isNegativeCommandCompletion()) {
                this.setTransferStatus(TransferStatus.transfer_aborted);
                String msg = String.format("[%s]%s", this.transferNumber, SOSVfs_E_175.params(new Object[]{this.targetTransferFile.getName(), this.parent.getTargetProvider().getReplyString()}));
                LOGGER.error(msg);
                throw new JobSchedulerException(msg);
            }
            if (targetCreateIntegrityHashFile) {
                this.sourceFileChecksum = this.targetFileChecksum = this.toHexString(targetChecksum.digest());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("[%s]%s", this.transferNumber, SOSVfs_I_274.params(new Object[]{this.targetFileChecksum, this.targetFileName, this.parent.getBaseOptions().integrityHashType.getValue()})));
                }
            }
            if (sourceCheckIntegrityHash) {
                this.sourceFileChecksum = this.toHexString(sourceChecksum.digest());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("[%s]%s", this.transferNumber, SOSVfs_I_274.params(new Object[]{this.sourceFileChecksum, this.sourceFileName, this.parent.getBaseOptions().integrityHashType.getValue()})));
                }
            }
            this.setNoOfBytesTransferred(totalBytesTransferred, fileSize);
            totalBytesTransferred += (long)cumulativeFileSeperatorLength;
            this.checkSourceChecksumFile(source, target);
            this.executeTFNPostCommnands();
            boolean bl = true;
            return bl;
        }
        catch (JobSchedulerException e) {
            this.setEntryErrorMessage(this.parent.getSourceProvider(), this.parent.getTargetProvider(), e);
            throw e;
        }
        catch (Throwable e) {
            StringBuilder sb = new StringBuilder("[").append(this.transferNumber).append("]");
            if (this.parent.getSourceProvider() != null) {
                sb.append("[source=").append(this.sourceFileName).append("]");
            }
            if (this.parent.getTargetProvider() != null) {
                sb.append("[target=").append(this.targetTransferFileName).append("]");
            }
            sb.append(e.toString());
            String msg = sb.toString();
            this.parent.setLastErrorMessage(msg);
            throw new JobSchedulerException(msg, e);
        }
        finally {
            if (this.endTime == null) {
                this.endTime = Instant.now();
            }
            if (!closed) {
                source.closeInput();
                target.closeOutput();
                closed = true;
            }
        }
    }

    private ReconnectResult tryReconnect(String range, ISOSProvider provider, ISOSProviderFile file, int retryCount) {
        ReconnectResult r = new ReconnectResult();
        r.counter = retryCount;
        if (provider.isConnected() && !(provider instanceof SOSLocal)) {
            return r;
        }
        boolean run = true;
        while (run) {
            try {
                JobSchedulerException.LastErrorMessage = "";
                r.counter++;
                LOGGER.info("----------------------------------------------------");
                LOGGER.info(String.format("[%s][%s][%s]wait %s and try reconnect %s of %s ...", this.transferNumber, range, file.getName(), this.parent.getBaseOptions().connection_error_retry_interval.getValue(), r.counter, this.parent.getBaseOptions().connection_error_retry_count_max.value()));
                LOGGER.info("----------------------------------------------------");
                if (this.parent.getRetryInterval() > 0) {
                    try {
                        Thread.sleep(this.parent.getRetryInterval() * 1000);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                provider.reconnect();
                r.providerFile = provider.getFile(file.getName());
                return r;
            }
            catch (Throwable e) {
                if (r.counter == this.parent.getRetryCountMax()) {
                    run = false;
                    throw e;
                }
                this.parent.setLastErrorMessage(e.toString());
            }
        }
        return r;
    }

    private void updateDb(Long id, String type, Map<String, String> values) {
        if (this.parent.getEventHandler() != null) {
            this.parent.getEventHandler().updateDb(id, type, values);
        }
    }

    @Override
    public Instant getStartTime() {
        return this.startTime;
    }

    @Override
    public Instant getEndTime() {
        return this.endTime;
    }

    public void createTargetChecksumFile() {
        this.createTargetChecksumFile(this.makeFullPathName(this.parent.getBaseOptions().targetDir.getValue(), this.targetFileName));
    }

    public void createTargetChecksumFile(String targetFileName) {
        if (this.parent.getBaseOptions().createIntegrityHashFile.isTrue() && this.isTransferred()) {
            ISOSProviderFile checksumFile = null;
            try {
                targetFileName = this.resolveDotsInPath(targetFileName);
                checksumFile = this.parent.getTargetProvider().getFile(targetFileName + "." + this.parent.getBaseOptions().integrityHashType.getValue());
                checksumFile.write(this.targetFileChecksum.getBytes());
                LOGGER.info(String.format("[%s]%s", this.transferNumber, SOSVfs_I_285.params(new Object[]{checksumFile.getName()})));
                this.targetChecksumFile = checksumFile;
            }
            catch (JobSchedulerException e) {
                throw e;
            }
            finally {
                if (checksumFile != null) {
                    checksumFile.closeOutput();
                }
            }
        }
    }

    private void checkSourceChecksumFile(ISOSProviderFile sourceFile, ISOSProviderFile targetFile) {
        block9: {
            if (this.parent.getBaseOptions().checkIntegrityHash.isTrue()) {
                ISOSProviderFile sourceFileChecksumFile = null;
                String sourceFileChecksumFileName = sourceFile.getName() + "." + this.parent.getBaseOptions().securityHashType.getValue();
                try {
                    sourceFileChecksumFile = this.parent.getSourceProvider().getFile(sourceFileChecksumFileName);
                    if (sourceFileChecksumFile.fileExists()) {
                        String checksum = sourceFileChecksumFile.file2String().trim();
                        if (!checksum.equals(this.sourceFileChecksum)) {
                            try {
                                if (targetFile.fileExists()) {
                                    targetFile.delete(false);
                                }
                            }
                            catch (Throwable ex) {
                                LOGGER.debug(ex.toString(), ex);
                            }
                            this.setStatus(TransferStatus.transfer_aborted);
                            throw new JobSchedulerException(String.format("Integrity Hash violation. File %1$s, checksum read: '%2$s', checksum calculated: '%3$s'", sourceFileChecksumFileName, checksum, this.sourceFileChecksum));
                        }
                        LOGGER.info(String.format("Integrity Hash is OK: File %1$s, checksum read '%2$s', checksum calculated '%3$s'", sourceFileChecksumFileName, checksum, this.sourceFileChecksum));
                        break block9;
                    }
                    LOGGER.info(String.format("Checksum file '%1$s' not found", sourceFileChecksumFileName));
                }
                catch (JobSchedulerException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOGGER.error(e.toString(), (Throwable)e);
                }
            }
        }
    }

    private void setEntryErrorMessage(ISOSProvider sourceTransfer, ISOSProvider targetTransfer, JobSchedulerException ex) {
        StringBuilder msg = new StringBuilder();
        if (sourceTransfer != null && !sourceTransfer.isConnected()) {
            msg.append("[source not connected]");
        }
        if (targetTransfer != null && !targetTransfer.isConnected()) {
            msg.append("[target not connected]");
        }
        if (this.isEmpty(JobSchedulerException.LastErrorMessage)) {
            msg.append(ex.toString());
            if (ex.getNestedException() != null) {
                msg.append(" ").append(ex.getNestedException().toString());
            }
        } else {
            msg.append(JobSchedulerException.LastErrorMessage);
        }
        this.parent.setLastErrorMessage(msg.toString());
    }

    private void executeCommands(String commandOptionName, ISOSProvider fileTransfer, SOSOptionString optionCommands, SOSOptionString optionCommandDelimiter) {
        this.executeCommands(commandOptionName, fileTransfer, optionCommands, optionCommandDelimiter, null);
    }

    private void executeCommands(String commandOptionName, ISOSProvider provider, SOSOptionString optionCommands, SOSOptionString optionCommandDelimiter, SOSEnv env) {
        String commands = optionCommands.getValue().trim();
        String fileName = "";
        if (commandOptionName.startsWith("source_")) {
            if (this.sourceTransferFile != null) {
                fileName = this.sourceTransferFile.getName();
            }
        } else if (this.targetTransferFile != null) {
            fileName = this.targetTransferFile.getName();
        }
        if (commands.length() > 0) {
            commands = this.replaceVariables(commands, provider);
            String delimiter = null;
            if (optionCommandDelimiter != null) {
                delimiter = optionCommandDelimiter.getValue();
            }
            if (delimiter == null) {
                delimiter = ";";
            }
            if (delimiter.isEmpty()) {
                try {
                    LOGGER.info(String.format("[%s][%s][%s]%s", this.transferNumber, commandOptionName, fileName, commands));
                    provider.executeCommand(commands, env);
                }
                catch (JobSchedulerException e) {
                    throw new JobSchedulerException(String.format("[%s][%s][%s][%s]", this.transferNumber, commandOptionName, fileName, commands), (Throwable)e);
                }
                catch (Exception e) {
                    throw new JobSchedulerException(String.format("[%s][%s][%s][%s]", this.transferNumber, commandOptionName, fileName, commands), (Throwable)e);
                }
            } else {
                String[] values = commands.split(delimiter);
                if (values.length > 1) {
                    LOGGER.debug(String.format("[%s][%s]commands=%s", this.transferNumber, commandOptionName, commands));
                }
                for (String command : values) {
                    if ((command = command.trim()).length() <= 0) continue;
                    try {
                        LOGGER.info(String.format("[%s][%s][%s]%s", this.transferNumber, commandOptionName, fileName, command));
                        provider.executeCommand(command, env);
                    }
                    catch (JobSchedulerException e) {
                        throw new JobSchedulerException(String.format("[%s][%s][%s][%s]", this.transferNumber, commandOptionName, fileName, command), (Throwable)e);
                    }
                    catch (Exception e) {
                        throw new JobSchedulerException(String.format("[%s][%s][%s][%s]", this.transferNumber, commandOptionName, fileName, command), (Throwable)e);
                    }
                }
            }
        }
    }

    public void executeTFNPostCommnands() throws Exception {
        SOSProviderOptions target = this.parent.getBaseOptions().getTransfer().getTarget();
        if (target.alternateOptionsUsed.isTrue()) {
            this.executeCommands("alternative_target_tfn_post_command", this.parent.getTargetProvider(), target.getAlternative().tfnPostCommand, target.getAlternative().commandDelimiter);
        } else {
            this.executeCommands("target_tfn_post_command", this.parent.getTargetProvider(), target.tfnPostCommand, target.commandDelimiter);
        }
        SOSProviderOptions source = this.parent.getBaseOptions().getTransfer().getSource();
        if (source.alternateOptionsUsed.isTrue()) {
            this.executeCommands("alternative_source_tfn_post_command", this.parent.getSourceProvider(), source.getAlternative().tfnPostCommand, source.getAlternative().commandDelimiter);
        } else {
            this.executeCommands("source_tfn_post_command", this.parent.getSourceProvider(), source.tfnPostCommand, source.commandDelimiter);
        }
    }

    public void executePostCommands() throws Exception {
        boolean isTransferred = this.transferStatus.equals((Object)TransferStatus.transferred);
        String status = this.transferStatus.name();
        HashMap<String, String> env = new HashMap<String, String>();
        env.put(ENV_VAR_FILE_TRANSFER_STATUS, status);
        env.put(ENV_VAR_FILE_IS_TRANSFERRED, isTransferred ? "1" : "0");
        SOSEnv envs = new SOSEnv();
        envs.setLocalEnvs(env);
        SOSProviderOptions target = this.parent.getBaseOptions().getTransfer().getTarget();
        if (target.alternateOptionsUsed.isTrue()) {
            if (!isTransferred && target.getAlternative().post_command_disable_for_skipped_transfer.value()) {
                LOGGER.info(String.format("[%s][alternative_target_post_command][skip]disable_for_skipped_transfer=true, status=%s", this.transferNumber, status));
            } else {
                this.executeCommands("alternative_target_post_command", this.parent.getTargetProvider(), target.getAlternative().postCommand, target.getAlternative().commandDelimiter, envs);
            }
        } else if (!isTransferred && (this.parent.getBaseOptions().post_command_disable_for_skipped_transfer.value() || target.post_command_disable_for_skipped_transfer.value())) {
            LOGGER.info(String.format("[%s][target_post_command][skip]disable_for_skipped_transfer=true, status=%s", this.transferNumber, status));
        } else {
            this.executeCommands("target_post_command", this.parent.getTargetProvider(), target.postCommand, target.commandDelimiter, envs);
        }
        SOSProviderOptions source = this.parent.getBaseOptions().getTransfer().getSource();
        if (source.alternateOptionsUsed.isTrue()) {
            if (!isTransferred && source.getAlternative().post_command_disable_for_skipped_transfer.value()) {
                LOGGER.info(String.format("[%s][alternative_source_post_command][skip]disable_for_skipped_transfer=true, status=%s", this.transferNumber, status));
            } else {
                this.executeCommands("alternative_source_post_command", this.parent.getSourceProvider(), source.getAlternative().postCommand, source.getAlternative().commandDelimiter, envs);
            }
        } else if (!isTransferred && source.post_command_disable_for_skipped_transfer.value()) {
            LOGGER.info(String.format("[%s][source_post_command][skip]disable_for_skipped_transfer=true, status=%s", this.transferNumber, status));
        } else {
            this.executeCommands("source_post_command", this.parent.getSourceProvider(), source.postCommand, source.commandDelimiter, envs);
        }
    }

    private void executePreCommands(boolean isSkipped) throws Exception {
        SOSProviderOptions target = this.parent.getBaseOptions().getTransfer().getTarget();
        if (target.alternateOptionsUsed.isTrue()) {
            if (isSkipped) {
                if (target.getAlternative().pre_command_enable_for_skipped_transfer.value()) {
                    this.executeCommands("alternative_target_pre_command enable_for_skipped_transfer=true", this.parent.getTargetProvider(), target.getAlternative().preCommand, target.commandDelimiter);
                }
            } else {
                this.executeCommands("alternative_target_pre_command", this.parent.getTargetProvider(), target.getAlternative().preCommand, target.commandDelimiter);
            }
        } else if (isSkipped) {
            if (this.parent.getBaseOptions().pre_command_enable_for_skipped_transfer.value() || target.pre_command_enable_for_skipped_transfer.value()) {
                this.executeCommands("target_pre_command enable_for_skipped_transfer=true", this.parent.getTargetProvider(), target.preCommand, target.commandDelimiter);
            }
        } else {
            this.executeCommands("target_pre_command", this.parent.getTargetProvider(), target.preCommand, target.commandDelimiter);
        }
        SOSProviderOptions source = this.parent.getBaseOptions().getTransfer().getSource();
        if (source.alternateOptionsUsed.isTrue()) {
            if (isSkipped) {
                if (source.getAlternative().pre_command_enable_for_skipped_transfer.value()) {
                    this.executeCommands("alternative_source_pre_command enable_for_skipped_transfer=true", this.parent.getSourceProvider(), source.getAlternative().preCommand, source.getAlternative().commandDelimiter);
                }
            } else {
                this.executeCommands("alternative_source_pre_command", this.parent.getSourceProvider(), source.getAlternative().preCommand, source.getAlternative().commandDelimiter);
            }
        } else if (isSkipped) {
            if (source.pre_command_enable_for_skipped_transfer.value()) {
                this.executeCommands("source_pre_command enable_for_skipped_transfer=true", this.parent.getSourceProvider(), source.preCommand, source.commandDelimiter);
            }
        } else {
            this.executeCommands("source_pre_command", this.parent.getSourceProvider(), source.preCommand, source.commandDelimiter);
        }
    }

    public boolean isTargetFileExistsBeforeTransfer() {
        return this.targetFileExistsBeforeTransfer;
    }

    public String getTargetAtomicFileName() {
        return this.targetAtomicFileName;
    }

    @Override
    public String getCommand() {
        return "";
    }

    @Override
    public Integer getCommandType() {
        return 0;
    }

    @Override
    public Date getCreated() {
        return null;
    }

    @Override
    public String getCreatedBy() {
        return "";
    }

    public String getFileName4ResultList() {
        String result = this.targetFileName;
        if (this.isEmpty(result)) {
            result = this.sourceFileName;
        }
        if (this.parent.getBaseOptions().resultSetFileName.getValue().endsWith(".source.tmp")) {
            result = this.sourceFileName;
        }
        return result;
    }

    @Override
    public Long getFileSize() {
        return this.sourceFileSize;
    }

    public Long getSourceFileLastCheckedFileSize() {
        return this.sourceFileLastCheckedFileSize;
    }

    public void setSourceFileLastCheckedFileSize(Long val) {
        this.sourceFileLastCheckedFileSize = val;
    }

    @Override
    public String getLastErrorMessage() {
        return "";
    }

    @Override
    public String getMd5() {
        if (this.targetFileChecksum == null || this.targetFileChecksum.equals(DEFAULT_CHECKSUM)) {
            return this.sourceFileChecksum;
        }
        return this.targetFileChecksum;
    }

    @Override
    public Date getModified() {
        return null;
    }

    @Override
    public String getModifiedBy() {
        return "";
    }

    private String getFileNameWithoutPath(String name) {
        return new File(this.adjustFileSeparator(name)).getName();
    }

    private String getPathWithoutFileName(ISOSProvider provider, String fileName) {
        File file = new File(this.adjustFileSeparator(fileName));
        String parent = file.getParent();
        if (parent == null) {
            parent = "./";
        } else if (provider.isSFTP() && SOSSFTP.hasWindowsOpenSSHDriverLetterSpecifier(fileName)) {
            parent = "/" + parent;
        }
        return this.adjustFileSeparator(parent);
    }

    @Override
    public String getPid() {
        String pid = ManagementFactory.getRuntimeMXBean().getName();
        String[] arr = pid.split("@");
        return arr[0];
    }

    @Override
    public String getSizeValue() {
        return "";
    }

    @Override
    public String getSourceFilename() {
        return this.sourceFileName;
    }

    @Override
    public Integer getStatus() {
        return new Integer(this.transferStatus.ordinal());
    }

    @Override
    public String getStatusText() {
        return this.transferStatus.name();
    }

    /*
     * Unable to fully structure code
     */
    public ISOSProviderFile getTargetFile() throws Exception {
        if (SOSFileListEntry.LOGGER.isDebugEnabled()) {
            SOSFileListEntry.LOGGER.debug(String.format("[%s][sourceFileName=%s]-------------------------------------", new Object[]{this.transferNumber, this.sourceFileName}));
        }
        sourceFile = this.parent.getSourceProvider().getFile(this.sourceFileName);
        this.sourceTransferFileName = sourceFile.getName();
        v0 = this.targetFileName = this.entry.getNormalizedFilename() == null ? sourceFile.getName() : this.entry.getNormalizedFilename();
        if (this.parent.getBaseOptions().compressFiles.isTrue()) {
            this.targetFileName = this.targetFileName + this.parent.getBaseOptions().compressedFileExtension.getValue();
        }
        if (this.parent.getBaseOptions().cumulateFiles.isTrue()) {
            this.targetTransferFileName = this.targetFileName = this.parent.getBaseOptions().cumulativeFileName.getValue();
            this.parent.getBaseOptions().appendFiles.value(true);
        } else {
            this.targetTransferFileName = this.targetFileName = this.getFileNameWithoutPath(this.targetFileName);
            if (this.parent.getBaseOptions().getReplacing().isNotEmpty()) {
                try {
                    this.targetFileName = this.parent.getBaseOptions().getReplacing().doReplace(this.targetFileName, this.parent.getBaseOptions().getReplacement().getValue());
                }
                catch (JobSchedulerException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new JobSchedulerException(SOSFileListEntry.SOSVfs_E_0150.get() + " " + e.toString(), e);
                }
            }
        }
        if (this.parent.getBaseOptions().isAtomicTransfer() || this.parent.getBaseOptions().transactionMode.isTrue()) {
            this.targetTransferFileName = this.getTargetAtomicFileName(this.parent.getBaseOptions());
        }
        if (this.parent.getBaseOptions().recursive.value() && this.parent.getBaseOptions().makeDirs.value()) {
            sourceDir = this.getPathWithoutFileName(this.parent.getSourceProvider(), sourceFile.getName());
            if (!this.fileNamesAreEqual(sourceDir, sourceDirOrig = this.parent.getSourceProvider().getFile(this.parent.getBaseOptions().sourceDir.getValue()).getName(), true) && sourceDir.length() > sourceDirOrig.length()) {
                subFolder = sourceDir.substring(sourceDirOrig.length());
                subFolder = this.adjustFileSeparator(this.addFileSeparator(subFolder));
                if (this.parent.isFullPathSelection() && (w = subFolder.indexOf(":")) > -1) {
                    subFolder = subFolder.substring(w + 1);
                    subFolder = StringUtils.stripStart((String)subFolder, (String)"/");
                }
                this.targetFileName = this.targetFileName.replaceFirst("([^/]*)$", subFolder + "$1");
                this.targetTransferFileName = subFolder + this.targetTransferFileName;
                if (SOSFileListEntry.LOGGER.isDebugEnabled()) {
                    SOSFileListEntry.LOGGER.debug(String.format("[%s][target][%s][sourceDir=%s][sourceDirOrig=%s]not equals", new Object[]{this.transferNumber, this.targetFileName, sourceDir, sourceDirOrig}));
                }
                if (this.isNotEmpty(this.getTargetAtomicFileName())) {
                    this.setTargetAtomicFileName(this.targetTransferFileName);
                }
                try {
                    dir = this.addFileSeparator(this.parent.getBaseOptions().targetDir.getValue()) + subFolder;
                    if (this.parent.add2SubFolders(subFolder)) {
                        if (SOSFileListEntry.LOGGER.isDebugEnabled()) {
                            SOSFileListEntry.LOGGER.debug(String.format("[%s][target][%s][%s]check mkdir", new Object[]{this.transferNumber, this.targetFileName, dir}));
                        }
                        this.parent.getTargetProvider().mkdir(dir);
                    }
                    if (!SOSFileListEntry.LOGGER.isDebugEnabled()) ** GOTO lbl51
                    SOSFileListEntry.LOGGER.debug(String.format("[%s][target][%s][%s]dir exists", new Object[]{this.transferNumber, this.targetFileName, dir}));
                }
                catch (IOException e) {
                    throw new JobSchedulerException((Throwable)e);
                }
            } else if (SOSFileListEntry.LOGGER.isDebugEnabled()) {
                SOSFileListEntry.LOGGER.debug(String.format("[%s][target][%s][sourceDir=%s][sourceDirOrig=%s]equals", new Object[]{this.transferNumber, this.targetFileName, sourceDir, sourceDirOrig}));
            }
        }
lbl51:
        // 8 sources

        fileHandlerTargetFileName = this.makeFullPathName(this.parent.getBaseOptions().targetDir.getValue(), this.targetFileName);
        targetFile = this.parent.getTargetProvider().getFile(fileHandlerTargetFileName);
        if (this.parent.getBaseOptions().cumulateFiles.isTrue() && this.parent.getBaseOptions().cumulativeFileDelete.isTrue() && !this.parent.getBaseOptions().getCumulativeTargetDeleted()) {
            targetFile.delete(true);
            this.parent.getBaseOptions().setCumulativeTargetDeleted(true);
            if (SOSFileListEntry.LOGGER.isDebugEnabled()) {
                SOSFileListEntry.LOGGER.debug(String.format("[%s][target][%s]cumulative file deleted", new Object[]{this.transferNumber, SOSCommonProvider.normalizePath(targetFile.getName())}));
            }
        }
        targetFile.setModeAppend(this.parent.getBaseOptions().appendFiles.value());
        targetFile.setModeRestart(this.parent.getBaseOptions().resumeTransfer.value());
        this.targetTransferFile = this.fileNamesAreEqual(this.targetFileName, this.targetTransferFileName, false) == false ? this.parent.getTargetProvider().getFile(this.makeFullPathName(this.parent.getBaseOptions().targetDir.getValue(), this.targetTransferFileName)) : targetFile;
        if (this.parent.getBaseOptions().cumulateFiles.isTrue()) {
            this.targetTransferFile.setModeAppend(this.parent.getBaseOptions().appendFiles.value());
            this.targetTransferFile.setModeRestart(this.parent.getBaseOptions().resumeTransfer.value());
        }
        this.targetFileExistsBeforeTransfer = false;
        if (targetFile.fileExists()) {
            this.targetFileExistsBeforeTransfer = true;
            if (SOSFileListEntry.LOGGER.isDebugEnabled()) {
                SOSFileListEntry.LOGGER.debug(String.format("[%s][target][%s]targetFileExistsBeforeTransfer=true", new Object[]{this.transferNumber, SOSCommonProvider.normalizePath(targetFile.getName())}));
            }
            if (this.parent.getBaseOptions().isDoNotOverwrite()) {
                this.setNotOverwritten(targetFile);
            }
        } else if (SOSFileListEntry.LOGGER.isDebugEnabled()) {
            SOSFileListEntry.LOGGER.debug(String.format("[%s][target][%s]targetFileExistsBeforeTransfer=false", new Object[]{this.transferNumber, SOSCommonProvider.normalizePath(targetFile.getName())}));
        }
        return targetFile;
    }

    public void setRenamedSourceFilename() throws Exception {
        SOSProviderOptions sourceOptions = this.parent.getBaseOptions().getSource();
        if (sourceOptions.replacing.isDirty() && !this.parent.getBaseOptions().removeFiles.value()) {
            String replaceWith = sourceOptions.replacement.getValue();
            try {
                boolean isDebugEnabled = LOGGER.isDebugEnabled();
                String sourceName = new File(this.sourceFileName).getName();
                String sourceParent = this.sourceFileName.substring(0, this.sourceFileName.length() - sourceName.length());
                String sourceNameNew = sourceOptions.replacing.doReplace(sourceName, replaceWith).replace('\\', '/');
                boolean equals = sourceNameNew.equals(sourceName);
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("[%s][source][replaceWath=%s][replaceWith=%s][%s][new=%s]equals=%s", this.transferNumber, sourceOptions.replacing.getValue(), replaceWith, sourceName, sourceNameNew, equals));
                }
                if (!equals) {
                    String sourceDir = this.addFileSeparator(sourceOptions.directory.getValue()).replace('\\', '/');
                    if (this.parent.getBaseOptions().recursive.value()) {
                        String subDirs = sourceParent.substring(sourceDir.length());
                        sourceNameNew = subDirs + sourceNameNew;
                    }
                    if (!sourceNameNew.startsWith("/") && !sourceNameNew.matches("^[a-zA-Z]:[\\\\/].*$")) {
                        sourceNameNew = sourceDir + sourceNameNew;
                    }
                    if (!this.sourceFileName.equals(sourceNameNew = this.resolveDotsInPath(sourceNameNew))) {
                        this.sourceFileNameRenamed = sourceNameNew;
                        if (isDebugEnabled) {
                            LOGGER.debug(String.format("[%s][source]renamedSourceFileName=%s", this.transferNumber, this.sourceFileNameRenamed));
                        }
                    }
                }
            }
            catch (JobSchedulerException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new JobSchedulerException(SOSVfs_E_0150.get(), e);
            }
        }
    }

    @Override
    public String getTargetFilename() {
        return this.targetFileName;
    }

    public String getTargetFileNameAndPath() {
        return SOSCommonProvider.normalizePath(this.parent.getBaseOptions().targetDir.getValue(), this.targetFileName);
    }

    public void setTransactional() {
        this.transactional = true;
    }

    public boolean getTransactional() {
        return this.transactional;
    }

    @Override
    public Integer getTransferDetailsId() {
        return null;
    }

    @Override
    public Integer getTransferId() {
        return null;
    }

    public TransferStatus getTransferStatus() {
        return this.transferStatus;
    }

    private boolean isTransferred() {
        return this.transferStatus.equals((Object)TransferStatus.transferred);
    }

    public boolean isSourceFileSteady() {
        return this.sourceFileSteady;
    }

    private String getTargetAtomicFileName(SOSBaseOptions options) {
        this.targetTransferFileName = this.targetTransferFileName + options.atomicSuffix.getValue().trim();
        this.targetTransferFileName = options.atomicPrefix.getValue() + this.targetTransferFileName;
        this.targetAtomicFileName = this.targetTransferFileName.trim();
        return this.targetAtomicFileName;
    }

    public void setTargetAtomicFileName(String val) {
        this.targetAtomicFileName = val;
    }

    private String makeFileNameReplacing(String fileName) {
        String name = this.adjustFileSeparator(fileName);
        String replacement = this.parent.getBaseOptions().getReplacement().getValue();
        try {
            name = this.parent.getBaseOptions().getReplacing().doReplace(name, replacement);
        }
        catch (JobSchedulerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new JobSchedulerException(SOSVfs_E_0150.get(), e);
        }
        return name;
    }

    private long getBytesTransferred() {
        return this.bytesTransferred;
    }

    protected String normalized(String str) {
        str = this.adjustFileSeparator(str);
        str = this.addFileSeparator(str);
        return str;
    }

    protected String resolveDotsInPath(String path) {
        try {
            return Paths.get(path, new String[0]).normalize().toString().replace('\\', '/');
        }
        catch (Exception e) {
            return path.replace('\\', '/');
        }
    }

    public void renameSourceFile() {
        this.renameSourceFile(this.parent.getSourceProvider().getFile(this.sourceFileName));
    }

    private void renameSourceFile(ISOSProviderFile sourceFile) {
        if (this.sourceFileNameRenamed != null) {
            try {
                ISOSProviderFile renamedSourceFile;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("[%s][source][%s][renamed=%s]", this.transferNumber, sourceFile.getName(), this.sourceFileNameRenamed));
                }
                if ((renamedSourceFile = this.parent.getSourceProvider().getFile(this.sourceFileNameRenamed)).fileExists()) {
                    renamedSourceFile.delete(false);
                }
                if (this.sourceFileNameRenamed.contains("/") && this.parent.getBaseOptions().makeDirs.isTrue()) {
                    String parentName = this.sourceFileNameRenamed.replaceFirst("[^/]*$", "");
                    this.parent.getSourceProvider().mkdir(parentName);
                }
                sourceFile.rename(this.sourceFileNameRenamed);
            }
            catch (JobSchedulerException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new JobSchedulerException(SOSVfs_E_0150.get(), e);
            }
        }
    }

    public void rollbackRenameSourceFile() {
        if (this.sourceFileNameRenamed != null) {
            try {
                ISOSProviderFile sourceFile = this.parent.getSourceProvider().getFile(this.sourceFileName);
                ISOSProviderFile sourceFileRenamed = this.parent.getSourceProvider().getFile(this.sourceFileNameRenamed);
                if (!sourceFile.fileExists() && sourceFileRenamed.fileExists()) {
                    sourceFileRenamed.rename(this.sourceFileName);
                }
            }
            catch (JobSchedulerException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new JobSchedulerException(SOSVfs_E_0150.get(), e);
            }
        }
    }

    public void renameTargetFile() {
        if (!this.skipTransfer()) {
            this.renameTargetFile(this.parent.getTargetProvider().getFile(this.makeFullPathName(this.parent.getBaseOptions().targetDir.getValue(), this.targetFileName)));
        }
    }

    private void renameTargetFile(ISOSProviderFile targetFile) {
        String targetFileNewName = targetFile.getName();
        targetFileNewName = this.resolveDotsInPath(targetFileNewName);
        boolean equals = this.fileNamesAreEqual(this.targetTransferFile.getName(), targetFileNewName, false);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("[%s][target][%s][%s]equals=%s", this.transferNumber, SOSCommonProvider.normalizePath(this.targetTransferFile.getName()), SOSCommonProvider.normalizePath(targetFileNewName), equals));
        }
        if (!equals) {
            try {
                String targetFileOldName;
                block10: {
                    targetFileOldName = SOSCommonProvider.normalizePath(this.targetTransferFile.getName());
                    if (this.parent.getBaseOptions().overwriteFiles.isTrue() && this.targetFileExistsBeforeTransfer) {
                        try {
                            targetFile.delete(false);
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug(String.format("[%s][target][%s][overwriteFiles=true]deleted", this.transferNumber, SOSCommonProvider.normalizePath(targetFile.getName())));
                            }
                        }
                        catch (Throwable e) {
                            if (!this.parent.getTargetProvider().isConnected()) {
                                throw e;
                            }
                            if (!targetFile.fileExists()) break block10;
                            throw e;
                        }
                    }
                }
                this.targetTransferFile.rename(targetFileNewName);
                LOGGER.info(String.format("[%s]%s", this.transferNumber, SOSVFSMessageCodes.SOSVfs_I_150.params(new Object[]{targetFileOldName, SOSCommonProvider.normalizePath(targetFileNewName)})));
            }
            catch (JobSchedulerException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new JobSchedulerException(SOSVfs_E_0150.get(), e);
            }
        }
    }

    private String replaceVariables(String value, ISOSProvider provider) {
        boolean isTraceEnabled = LOGGER.isTraceEnabled();
        if (isTraceEnabled) {
            LOGGER.trace(String.format("[%s][replaceVariables]%s", this.transferNumber, value));
        }
        if (provider != null) {
            EntryPaths targetFile = new EntryPaths(this.parent.getTargetProvider(), this.parent.getBaseOptions().targetDir.getValue(), this.resolveDotsInPath(this.makeFullPathName(this.parent.getBaseOptions().targetDir.getValue(), this.targetFileName)));
            EntryPaths targetTransferFile = new EntryPaths(this.parent.getTargetProvider(), this.parent.getBaseOptions().targetDir.getValue(), this.resolveDotsInPath(this.makeFullPathName(this.parent.getBaseOptions().targetDir.getValue(), this.targetTransferFileName)));
            EntryPaths sourceFile = new EntryPaths(this.parent.getSourceProvider(), this.parent.getBaseOptions().sourceDir.getValue(), this.resolveDotsInPath(this.sourceFileName));
            EntryPaths sourceFileRenamed = new EntryPaths(this.parent.getSourceProvider(), this.parent.getBaseOptions().sourceDir.getValue(), this.sourceFileNameRenamed);
            Properties vars = new Properties();
            vars.put("TargetDirFullName", targetFile.getBaseDirFullName());
            vars.put("SourceDirFullName", sourceFile.getBaseDirFullName());
            vars.put("TargetFileFullName", targetFile.getFullName());
            vars.put("TargetFileRelativeName", targetFile.getRelativeName());
            vars.put("TargetFileBaseName", targetFile.getBaseName());
            vars.put("TargetFileParentFullName", targetFile.getParentDirFullName());
            vars.put("TargetFileParentBaseName", targetFile.getParentDirBaseName());
            vars.put("TargetTransferFileFullName", targetTransferFile.getFullName());
            vars.put("TargetTransferFileRelativeName", targetTransferFile.getRelativeName());
            vars.put("TargetTransferFileBaseName", targetTransferFile.getBaseName());
            vars.put("TargetTransferFileParentFullName", targetTransferFile.getParentDirFullName());
            vars.put("TargetTransferFileParentBaseName", targetTransferFile.getParentDirBaseName());
            vars.put("SourceFileFullName", sourceFile.getFullName());
            vars.put("SourceFileRelativeName", sourceFile.getRelativeName());
            vars.put("SourceFileBaseName", sourceFile.getBaseName());
            vars.put("SourceFileParentFullName", sourceFile.getParentDirFullName());
            vars.put("SourceFileParentBaseName", sourceFile.getParentDirBaseName());
            vars.put("SourceFileRenamedFullName", sourceFileRenamed.getFullName());
            vars.put("SourceFileRenamedRelativeName", sourceFileRenamed.getRelativeName());
            vars.put("SourceFileRenamedBaseName", sourceFileRenamed.getBaseName());
            vars.put("SourceFileRenamedParentFullName", sourceFileRenamed.getParentDirFullName());
            vars.put("SourceFileRenamedParentBaseName", sourceFileRenamed.getParentDirBaseName());
            if (isTraceEnabled) {
                LOGGER.trace(vars.toString());
            }
            this.parent.getBaseOptions().getTextProperties().putAll((Map<?, ?>)vars);
        }
        return this.parent.getBaseOptions().replaceVars(value);
    }

    @Override
    public void run() {
        block23: {
            try {
                ISOSProviderFile sourceFile = this.parent.getSourceProvider().getFile(this.sourceFileName);
                ISOSProviderFile targetFile = null;
                if (this.parent.getBaseOptions().isNeedTargetClient()) {
                    targetFile = this.getTargetFile();
                }
                this.setRenamedSourceFilename();
                if (this.parent.getBaseOptions().transactional.value()) {
                    this.setTransactional();
                }
                boolean removeSourceFile = false;
                switch (this.parent.getBaseOptions().operation.value()) {
                    case getlist: {
                        return;
                    }
                    case delete: {
                        this.executePreCommands(false);
                        sourceFile.delete(true);
                        LOGGER.info(String.format("[%s]%s", this.transferNumber, SOSVfs_I_0113.params(new Object[]{this.sourceFileName})));
                        this.setStatus(TransferStatus.deleted);
                        return;
                    }
                    case rename: {
                        File file = new File(this.sourceFileName);
                        String parentName = this.changeBackslashes(this.normalized(file.getParent()));
                        String fileNameRenamed = this.makeFileNameReplacing(file.getName());
                        if (fileNameRenamed.contains("/") && this.parent.getBaseOptions().makeDirs.isTrue()) {
                            this.parent.getSourceProvider().mkdir(this.normalized(new File(fileNameRenamed).getParent()));
                        }
                        fileNameRenamed = this.changeBackslashes(this.addFileSeparator(parentName) + fileNameRenamed);
                        LOGGER.info(String.format("[%s]%s", this.transferNumber, SOSVfs_I_150.params(new Object[]{this.sourceFileName, fileNameRenamed})));
                        this.targetFileName = fileNameRenamed;
                        sourceFile.rename(fileNameRenamed);
                        this.setStatus(TransferStatus.renamed);
                        return;
                    }
                    case move: {
                        removeSourceFile = true;
                        break;
                    }
                }
                this.sourceTransferFileName = this.getFileNameWithoutPath(this.sourceTransferFileName);
                String fileHandlerSourceFileName = null;
                fileHandlerSourceFileName = this.parent.getSourceProvider().isHTTP() ? this.sourceFileName : this.makeFullPathName(this.getPathWithoutFileName(this.parent.getSourceProvider(), this.sourceFileName), this.sourceTransferFileName);
                this.sourceTransferFile = this.parent.getSourceProvider().getFile(fileHandlerSourceFileName);
                if (this.transferStatus.equals((Object)TransferStatus.ignoredDueToZerobyteConstraint)) {
                    String msg = String.format("[%s][skip][TransferZeroByteFiles=relaxed]Source=%s, Bytes=0", this.transferNumber, SOSCommonProvider.normalizePath(this.sourceFileName));
                    LOGGER.info(msg);
                    JADE_REPORT_LOGGER.info(msg);
                }
                if (this.skipTransfer()) {
                    this.executePreCommands(true);
                } else {
                    String fileHandlerTargetFileName = this.makeFullPathName(this.parent.getBaseOptions().targetDir.getValue(), this.targetFileName);
                    this.doTransfer(this.sourceTransferFile, fileHandlerSourceFileName, this.targetTransferFile, fileHandlerTargetFileName);
                    if (LOGGER.isDebugEnabled() && this.parent.getBaseOptions().checkSteadyStateOfFiles.isTrue()) {
                        LOGGER.debug(String.format("[%s][checkSteadyStateOfFiles][sourceFileModificationDateTime]%s", this.transferNumber, this.sourceFileModificationDateTime));
                    }
                    if (this.parent.getBaseOptions().keepModificationDate.isTrue()) {
                        if (this.sourceFileModificationDateTime <= 0L) {
                            this.sourceFileModificationDateTime = this.sourceTransferFile.getModificationDateTime();
                        }
                        if (this.sourceFileModificationDateTime != -1L && this.targetTransferFile != null) {
                            this.targetTransferFile.setModificationDateTime(this.sourceFileModificationDateTime);
                        }
                    }
                    if ((this.parent.getBaseOptions().isAtomicTransfer() || this.parent.getBaseOptions().getReplacing().isNotEmpty()) && this.parent.getBaseOptions().transactional.isFalse()) {
                        this.renameTargetFile(targetFile);
                    }
                }
                if (!this.parent.getBaseOptions().transactional.isFalse()) break block23;
                this.createTargetChecksumFile(targetFile.getName());
                if (this.sourceFileNameRenamed != null) {
                    this.renameSourceFile(sourceFile);
                }
                if (!removeSourceFile) break block23;
                try {
                    sourceFile.delete(false);
                    this.transferStatus = TransferStatus.moved;
                    this.logSourceFileDeleted();
                }
                catch (Throwable e) {
                    this.transferStatus = TransferStatus.transfer_aborted;
                    targetFile.delete(false);
                    String msg = String.format("[%s][transfer_aborted]Target=%s deleted", this.transferNumber, SOSCommonProvider.normalizePath(targetFile.getName()));
                    LOGGER.info(msg);
                    JADE_REPORT_LOGGER.info(msg);
                    throw e;
                }
            }
            catch (JobSchedulerException e) {
                this.setTransferredStatusAborted();
                Throwable t = e.getCause() == null ? e : e.getCause();
                LOGGER.error("[" + this.transferNumber + "][" + (Object)((Object)this.transferStatus) + "][Source=" + this.sourceFileName + "]" + e.getMessage(), t);
                throw e;
            }
            catch (Throwable e) {
                this.setTransferredStatusAborted();
                String msg = "[" + this.transferNumber + "][" + (Object)((Object)this.transferStatus) + "][Source=" + this.sourceFileName + "]" + e.toString();
                LOGGER.error(msg, e);
                throw new JobSchedulerException(msg, e);
            }
        }
    }

    private void setTransferredStatusAborted() {
        if (this.transferStatus == null) {
            this.setStatus(TransferStatus.transfer_aborted);
            return;
        }
        switch (this.transferStatus) {
            case deleted: 
            case ignoredDueToZerobyteConstraint: 
            case moved: 
            case notOverwritten: {
                break;
            }
            case polling: 
            case renamed: 
            case compressed: 
            case setBack: 
            case transferInProgress: 
            case transferUndefined: 
            case transfer_aborted: 
            case transfer_has_errors: 
            case transfer_skipped: 
            case transferred: 
            case transferring: 
            case waiting4transfer: {
                this.setStatus(TransferStatus.transfer_aborted);
                break;
            }
        }
    }

    public void setNoOfBytesTransferred(long bytes, long fileSize) throws Exception {
        this.bytesTransferred = bytes;
        SOSTransfer connectionOptions = this.parent.getBaseOptions().getTransfer();
        if (!(this.parent.getBaseOptions().checkSize.isFalse() || this.parent.getBaseOptions().compressFiles.isTrue() || this.parent.getBaseOptions().transferMode.isAscii() || connectionOptions.getSource().transferMode.isAscii() || connectionOptions.getTarget().transferMode.isAscii())) {
            if (this.sourceFileSize <= 0L) {
                this.sourceFileSize = fileSize;
            }
            if (this.sourceFileSize != this.bytesTransferred) {
                LOGGER.error(String.format("[%s]%s", this.transferNumber, SOSVfs_E_216.params(new Object[]{this.bytesTransferred, this.sourceFileSize, this.sourceFileName})));
                this.setStatus(TransferStatus.transfer_aborted);
                throw new JobSchedulerException(SOSVfs_E_271.get());
            }
        }
        this.setStatus(TransferStatus.transferred);
    }

    private boolean skipTransfer() {
        return this.transferStatus.equals((Object)TransferStatus.notOverwritten) || this.transferStatus.equals((Object)TransferStatus.transfer_skipped) || this.transferStatus.equals((Object)TransferStatus.ignoredDueToZerobyteConstraint);
    }

    private void setNotOverwritten(ISOSProviderFile targetFile) {
        this.transferStatus = TransferStatus.notOverwritten;
        this.endTime = Instant.now();
        String msg = String.format("[%s][skip][DisableOverwriteFiles=true]Target=%s", this.transferNumber, SOSCommonProvider.normalizePath(targetFile.getName()));
        LOGGER.info(msg);
        JADE_REPORT_LOGGER.info(msg);
    }

    public void setParent(SOSFileList list) {
        this.parent = list;
    }

    public void setSourceFileSteadyProperties(ISOSProviderFile file) {
        this.sourceFileSize = file.getFileSize();
        this.sourceFileModificationDateTime = file.getModificationDateTime();
    }

    public void setStatus(TransferStatus val) {
        String msg = "";
        this.transferStatus = val;
        switch (val) {
            case transferInProgress: {
                msg = SOSVfs_I_0114.get();
                break;
            }
            case waiting4transfer: {
                msg = SOSVfs_I_0115.get();
                break;
            }
            case transfer_skipped: {
                msg = SOSVfs_I_0116.get();
                break;
            }
            case transferring: {
                msg = SOSVfs_I_0117.get();
                break;
            }
            case transferred: {
                msg = SOSVfs_I_0118.get();
                break;
            }
            case transfer_aborted: {
                msg = SOSVfs_I_0119.get();
                break;
            }
        }
        if (this.isNotEmpty(msg)) {
            switch (val) {
                case transferInProgress: {
                    break;
                }
                default: {
                    msg = SOSVfs_I_0120.params(new Object[]{msg, this.sourceFileName});
                }
            }
        }
    }

    public void setSourceFileSteady(boolean val) {
        this.sourceFileSteady = val;
    }

    private void setTransferProgress(long val) {
        this.setStatus(TransferStatus.transferInProgress);
    }

    public void setIgnoredDueToZerobyteConstraint() {
        this.transferStatus = TransferStatus.ignoredDueToZerobyteConstraint;
        this.endTime = Instant.now();
    }

    public boolean isSourceFileExists() {
        try {
            return this.parent.getSourceProvider().getFile(this.sourceFileName).fileExists();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public String getSourceTransferFileName() {
        return this.sourceTransferFileName;
    }

    public String getTargetFileName() {
        if (this.targetFileName == null || this.targetFileName.isEmpty()) {
            return this.getSourceFilename();
        }
        return this.targetFileName;
    }

    public String getTargetTransferFileName() {
        return this.targetTransferFileName;
    }

    private String toHexString(byte[] b) {
        char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        int length = b.length * 2;
        StringBuffer sb = new StringBuffer(length);
        for (byte element : b) {
            sb.append(hexChar[(element & 0xF0) >>> 4]);
            sb.append(hexChar[element & 0xF]);
        }
        return sb.toString();
    }

    public String toString() {
        String msg;
        try {
            msg = String.format("[%s]%s", this.transferNumber, SOSVfs_D_214.params(new Object[]{this.getTargetFileNameAndPath(), this.getSourceFileName(), this.getBytesTransferred(), this.parent.getBaseOptions().operation.getValue(), SOSFileListEntry.getDateTimeInfos(this.startTime, this.endTime)}));
        }
        catch (RuntimeException e) {
            LOGGER.error(e.toString());
            msg = "???";
        }
        return msg;
    }

    public static String getDateTimeInfos(Instant start, Instant end) {
        StringBuilder sb = new StringBuilder("(");
        if (start != null) {
            sb.append(SOSDate.getDateTime((Instant)start));
        }
        sb.append("-");
        if (end != null) {
            sb.append(SOSDate.getDateTime((Instant)end));
        }
        sb.append(")");
        if (start != null && end != null) {
            sb.append(SOSDate.getDuration((Instant)start, (Instant)end));
        }
        return sb.toString();
    }

    public SOSFileEntry getEntry() {
        return this.entry;
    }

    public void setTransferStatus(TransferStatus val) {
        this.setStatus(val);
    }

    private boolean fileNamesAreEqual(String filenameA, String filenameB, boolean caseSensitiv) {
        String a = filenameA.replaceAll("[\\\\/]+", "/");
        String b = filenameB.replaceAll("[\\\\/]+", "/");
        return caseSensitiv ? a.equals(b) : a.equalsIgnoreCase(b);
    }

    public boolean hasTargetChecksumFile() {
        return this.targetChecksumFile != null;
    }

    public ISOSProviderFile getTargetChecksumFile() {
        return this.targetChecksumFile;
    }

    private Buffer compress(byte[] dataToCompress) {
        return this.compress(dataToCompress, dataToCompress.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Buffer compress(byte[] dataToCompress, int length) {
        Buffer buf = new Buffer();
        if (this.parent.getBaseOptions().compressFiles.isTrue()) {
            try {
                try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream(length);
                     GZIPOutputStream zipStream = new GZIPOutputStream(byteStream);){
                    zipStream.write(dataToCompress, 0, length);
                }
                buf.setBytes(byteStream.toByteArray());
                return buf;
            }
            catch (Exception e) {
                throw new JobSchedulerException(SOSVFSMessageCodes.SOSVfs_E_134.params(new Object[]{"GZip"}), (Throwable)e);
            }
        }
        buf.setBytes(dataToCompress);
        buf.setLength(length);
        return buf;
    }

    public long getSourceFileModificationDateTime() {
        return this.sourceFileModificationDateTime;
    }

    public void setTransferNumber(long val) {
        this.transferNumber = val;
    }

    public long getTransferNumber() {
        return this.transferNumber;
    }

    private class EntryPaths {
        private String fullName = "";
        private String relativeName = "";
        private String baseName = "";
        private String baseDirFullName = "";
        private String parentDirFullName = "";
        private String parentDirBaseName = "";

        private EntryPaths(ISOSProvider provider, String baseDirPath, String filePath) {
            if (provider != null && filePath != null) {
                try {
                    if (provider.isSFTP() && SOSSFTP.hasWindowsOpenSSHDriverLetterSpecifier(filePath)) {
                        this.setForOpenSSHWindows(baseDirPath, filePath);
                    } else if (provider.isHTTP()) {
                        this.setHttp(SOSString.isEmpty((String)baseDirPath) ? provider.getProviderOptions().host.getValue() : baseDirPath, filePath);
                    } else {
                        this.setFromPath(baseDirPath, filePath);
                    }
                }
                catch (Exception e) {
                    LOGGER.warn(String.format("[%s]error on resolve path for baseDirPath=%s, filePath=%s", SOSFileListEntry.this.transferNumber, baseDirPath, filePath), (Throwable)e);
                }
            }
        }

        private void setFromPath(String baseDirPath, String filePath) throws Exception {
            Path baseDir = SOSString.isEmpty((String)baseDirPath) ? null : Paths.get(baseDirPath, new String[0]);
            Path file = Paths.get(filePath, new String[0]);
            Path parentDir = file.getParent();
            if (parentDir != null) {
                this.parentDirFullName = parentDir.toString().replace('\\', '/');
                Path pdfn = parentDir.getFileName();
                if (pdfn != null) {
                    this.parentDirBaseName = pdfn.toString();
                }
                if (baseDir == null) {
                    baseDir = parentDir;
                }
            }
            this.fullName = file.toString().replace('\\', '/');
            this.baseName = file.getFileName().toString();
            if (baseDir == null) {
                this.relativeName = this.baseName;
            } else {
                this.baseDirFullName = baseDir.normalize().toString().replace('\\', '/');
                this.relativeName = baseDir.relativize(file).normalize().toString().replace('\\', '/');
            }
        }

        private void setForOpenSSHWindows(String baseDirPath, String filePath) throws Exception {
            File baseDir = SOSString.isEmpty((String)baseDirPath) ? null : new File(baseDirPath);
            File file = new File(filePath);
            File parentDir = file.getParentFile();
            if (parentDir != null) {
                this.parentDirFullName = "/" + parentDir.toString().replace('\\', '/');
                String pdfn = parentDir.getName();
                if (pdfn != null) {
                    this.parentDirBaseName = pdfn;
                }
                if (baseDir == null) {
                    baseDir = parentDir;
                }
            }
            this.fullName = "/" + file.toString().replace('\\', '/');
            this.baseName = file.getName().toString();
            if (baseDir == null) {
                this.relativeName = this.baseName;
            } else {
                this.baseDirFullName = "/" + baseDir.getCanonicalPath().replace('\\', '/');
                this.relativeName = this.baseName;
            }
        }

        private void setHttp(String baseDirPath, String filePath) throws Exception {
            String baseDir = SOSString.isEmpty((String)baseDirPath) ? null : SOSCommonProvider.normalizeDirectoryPath(baseDirPath);
            this.fullName = SOSCommonProvider.normalizePath(filePath);
            this.baseName = SOSCommonProvider.getBaseNameFromPath(this.fullName);
            String parentDir = SOSCommonProvider.getFullParentFromPath(this.fullName);
            if (parentDir != null) {
                this.parentDirFullName = parentDir;
                this.parentDirBaseName = SOSCommonProvider.getBaseNameFromPath(this.parentDirFullName);
                if (baseDir == null) {
                    baseDir = this.parentDirFullName;
                }
            }
            if (baseDir == null) {
                this.relativeName = this.baseName;
            } else {
                this.baseDirFullName = baseDir;
                if (this.fullName.startsWith(this.baseDirFullName)) {
                    String r = this.fullName.substring(this.baseDirFullName.length());
                    this.relativeName = r.startsWith("/") ? r.substring(1) : r;
                }
            }
        }

        public String getFullName() {
            return this.fullName;
        }

        public String getRelativeName() {
            return this.relativeName;
        }

        public String getBaseName() {
            return this.baseName;
        }

        public String getBaseDirFullName() {
            return this.baseDirFullName;
        }

        public String getParentDirFullName() {
            return this.parentDirFullName;
        }

        public String getParentDirBaseName() {
            return this.parentDirBaseName;
        }
    }

    private class ReconnectResult {
        private ISOSProviderFile providerFile;
        private int counter;

        private ReconnectResult() {
        }
    }

    private class Buffer {
        private byte[] bytes = new byte[0];
        private int length = 0;

        private Buffer() {
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public void setBytes(byte[] val) {
            this.bytes = val;
            this.length = val.length;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int val) {
            this.length = val;
        }
    }

    public static enum TransferStatus {
        transferUndefined,
        waiting4transfer,
        transferring,
        transferInProgress,
        transferred,
        transfer_skipped,
        transfer_has_errors,
        transfer_aborted,
        compressed,
        notOverwritten,
        deleted,
        renamed,
        ignoredDueToZerobyteConstraint,
        setBack,
        polling,
        moved;

    }
}

