/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.common;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.Options.SOSOptionString;
import com.sos.JSHelper.Options.SOSOptionTransferType;
import com.sos.exception.SOSYadeSourceConnectionException;
import com.sos.exception.SOSYadeTargetConnectionException;
import com.sos.i18n.annotation.I18NMessage;
import com.sos.i18n.annotation.I18NMessages;
import com.sos.i18n.annotation.I18NResourceBundle;
import com.sos.vfs.common.SOSVFSMessageCodes;
import com.sos.vfs.common.interfaces.ISOSProvider;
import com.sos.vfs.common.options.SOSBaseOptions;
import com.sos.vfs.common.options.SOSProviderOptions;
import com.sos.vfs.ftp.SOSFTP;
import com.sos.vfs.ftp.SOSFTPS;
import com.sos.vfs.http.SOSHTTP;
import com.sos.vfs.jms.SOSJMS;
import com.sos.vfs.local.SOSLocal;
import com.sos.vfs.sftp.SOSSFTP;
import com.sos.vfs.smb.SOSSMB;
import com.sos.vfs.webdav.SOSWebDAV;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@I18NResourceBundle(baseName="SOSVirtualFileSystem", defaultLocale="en")
public class SOSVFSFactory
extends SOSVFSMessageCodes {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSVFSFactory.class);
    public static final String REPORT_LOGGER_NAME = "JadeReportLog";
    public static final String BUNDLE_NAME = "SOSVirtualFileSystem";
    @I18NMessages(value={@I18NMessage(value="%1$s returns instance of %2$s"), @I18NMessage(value="%1$s returns instance of %2$s", locale="en_UK", explanation="%1$s returns instance of %2$s"), @I18NMessage(value="%1$s liefert eine Instanz der Klasse %2$s", locale="de", explanation="%1$s returns instance of %2$s"), @I18NMessage(value="%1$s returns instance of %2$s", locale="es", explanation="%1$s returns instance of %2$s"), @I18NMessage(value="%1$s returns instance of %2$s", locale="fr", explanation="%1$s returns instance of %2$s"), @I18NMessage(value="%1$s returns instance of %2$s", locale="it", explanation="%1$s returns instance of %2$s")}, msgnum="SOSVfs-D-0201", msgurl="SOSVfs-D-0201")
    private SOSBaseOptions options = null;

    public SOSVFSFactory() {
        super(BUNDLE_NAME);
    }

    public SOSVFSFactory(SOSBaseOptions opt) {
        this.options = opt;
    }

    public static ISOSProvider getProvider(SOSOptionTransferType.TransferTypes type, SOSOptionString sshProvider, SOSOptionString webDavProvider, SOSOptionString smbProvider) throws Exception {
        return SOSVFSFactory.getProvider(type.name(), sshProvider, webDavProvider, smbProvider);
    }

    public static ISOSProvider getProvider(String protocol, SOSOptionString sshProvider, SOSOptionString webDavProvider, SOSOptionString smbProvider) throws Exception {
        SOSVFSMessageCodes provider = null;
        if ((protocol = protocol.toLowerCase()).equals(SOSOptionTransferType.TransferTypes.sftp.name()) || protocol.equals(SOSOptionTransferType.TransferTypes.ssh.name())) {
            provider = new SOSSFTP(sshProvider);
        } else if (protocol.equals(SOSOptionTransferType.TransferTypes.local.name())) {
            provider = new SOSLocal();
        } else if (protocol.equals(SOSOptionTransferType.TransferTypes.ftp.name())) {
            provider = new SOSFTP();
        } else if (protocol.equals(SOSOptionTransferType.TransferTypes.ftps.name())) {
            provider = new SOSFTPS();
        } else if (protocol.equals(SOSOptionTransferType.TransferTypes.webdav.name())) {
            provider = new SOSWebDAV(webDavProvider);
        } else if (protocol.equals(SOSOptionTransferType.TransferTypes.http.name())) {
            provider = new SOSHTTP();
        } else if (protocol.equals(SOSOptionTransferType.TransferTypes.smb.name())) {
            provider = new SOSSMB(smbProvider);
        } else if (protocol.equals(SOSOptionTransferType.TransferTypes.mq.name())) {
            provider = new SOSJMS();
        }
        if (provider == null) {
            throw new Exception(SOSVfs_E_0203.params(new Object[]{protocol}));
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(provider.getClass().getName());
        }
        return provider;
    }

    public ISOSProvider getConnectedProvider(SOSProviderOptions providerOptions) throws SOSYadeSourceConnectionException, SOSYadeTargetConnectionException {
        ISOSProvider provider;
        block11: {
            provider = null;
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("[%s]%s", providerOptions.getRange(), providerOptions.getProtocol()));
                }
                provider = SOSVFSFactory.getProvider(providerOptions.getProtocol(), this.options.ssh_provider, this.options.webdav_provider, this.options.smb_provider);
                try {
                    this.handleProviderOptions(providerOptions);
                    provider.setBaseOptions(this.options);
                    provider.connect(providerOptions);
                    this.handleOptions(provider, providerOptions);
                }
                catch (Exception e) {
                    SOSProviderOptions alternative = providerOptions.getAlternative();
                    if (alternative.optionsHaveMinRequirements()) {
                        LOGGER.warn(String.format("Connection failed : %s", e.toString()));
                        LOGGER.info(String.format("Try again using the alternate options ...", new Object[0]));
                        LOGGER.debug(alternative.dirtyString());
                        JobSchedulerException.LastErrorMessage = "";
                        try {
                            provider.disconnect();
                        }
                        catch (Exception ce) {
                            LOGGER.warn(String.format("client disconnect failed : %s", ce.toString()), (Throwable)ce);
                        }
                        provider = SOSVFSFactory.getProvider(alternative.protocol.getValue(), this.options.ssh_provider, this.options.webdav_provider, this.options.smb_provider);
                        this.handleProviderOptions(alternative);
                        provider.connect(alternative);
                        this.handleOptions(provider, alternative);
                        providerOptions.alternateOptionsUsed.value(true);
                        break block11;
                    }
                    LOGGER.error(String.format("Connection failed : %s", e.toString()), (Throwable)e);
                    LOGGER.debug(String.format("alternate options are not defined", new Object[0]));
                    throw e;
                }
            }
            catch (JobSchedulerException ex) {
                if (providerOptions.isSource()) {
                    throw new SOSYadeSourceConnectionException(ex.getCause());
                }
                throw new SOSYadeTargetConnectionException(ex.getCause());
            }
            catch (Exception ex) {
                if (providerOptions.isSource()) {
                    throw new SOSYadeSourceConnectionException((Throwable)ex);
                }
                throw new SOSYadeTargetConnectionException((Throwable)ex);
            }
        }
        return provider;
    }

    private void handleOptions(ISOSProvider provider, SOSProviderOptions providerOptions) throws Exception {
        if (providerOptions.directory.isDirty()) {
            providerOptions.directory.setValue(provider.getFile(providerOptions.directory.getValue()).getName());
            if (providerOptions.isSource()) {
                this.options.sourceDir = providerOptions.directory;
                this.options.localDir = providerOptions.directory;
            } else {
                this.options.targetDir = providerOptions.directory;
                this.options.remoteDir = providerOptions.directory;
            }
        }
        if (providerOptions.excluded_directories.isDirty() && providerOptions.isSource()) {
            this.options.sourceExcludedDirectories = providerOptions.excluded_directories;
        }
    }

    private void handleProviderOptions(SOSProviderOptions providerOptions) throws Exception {
        if (!providerOptions.transferMode.isDirty() || !providerOptions.transferMode.isNotEmpty()) {
            providerOptions.transferMode = this.options.transferMode;
        }
    }
}

