/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.common.options;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.Options.SOSOptionAuthenticationMethod;
import com.sos.JSHelper.Options.SOSOptionElement;
import com.sos.JSHelper.Options.SOSOptionHostName;
import com.sos.JSHelper.Options.SOSOptionJadeOperation;
import com.sos.JSHelper.Options.SOSOptionPassword;
import com.sos.JSHelper.Options.SOSOptionPortNumber;
import com.sos.JSHelper.Options.SOSOptionRegExp;
import com.sos.JSHelper.Options.SOSOptionString;
import com.sos.JSHelper.Options.SOSOptionTime;
import com.sos.JSHelper.Options.SOSOptionTransferType;
import com.sos.i18n.annotation.I18NResourceBundle;
import com.sos.keepass.SOSKeePassPath;
import com.sos.vfs.common.SOSVFSMessageCodes;
import com.sos.vfs.common.options.SOSBaseOptionsSuperClass;
import com.sos.vfs.common.options.SOSProviderOptions;
import com.sos.vfs.common.options.SOSProviderOptionsSuperClass;
import com.sos.vfs.common.options.SOSTransfer;
import java.io.File;
import java.net.InetAddress;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.net.mail.options.SOSSmtpMailOptions;
import sos.settings.SOSProfileSettings;

@I18NResourceBundle(baseName="SOSVirtualFileSystem", defaultLocale="en")
public class SOSBaseOptions
extends SOSBaseOptionsSuperClass {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSBaseOptions.class);
    private static final long serialVersionUID = -8219289268940238015L;
    private static final String SETTINGS_KEY_MAIL_SMTP = "mail_smtp";
    private static final String PREFIX_FILE_URI = "file://";
    private static final String PREFIX_SCHEDULER_ENV_VAR = "scheduler_param_";
    private static final String PREFIX_SOSFTP_ENV_VAR = "sosftp_";
    private static final String FILE_SEPARATOR = "file.separator";
    private static final String ENV_VAR_SSH_PROVIDER_JOBSCHEDULER_1X = "SCHEDULER_VFS_SSH_PROVIDER";
    private static final String ENV_VAR_SSH_PROVIDER_JOBSCHEDULER_JS7 = "JS7_VFS_SSH_PROVIDER";
    private static final String ENV_VAR_WEBDAV_PROVIDER_JOBSCHEDULER_1X = "SCHEDULER_VFS_WEBDAV_PROVIDER";
    private static final String ENV_VAR_WEBDAV_PROVIDER_JOBSCHEDULER_JS7 = "JS7_VFS_WEBDAV_PROVIDER";
    private static final String ENV_VAR_SMB_PROVIDER_JOBSCHEDULER_1X = "SCHEDULER_VFS_SMB_PROVIDER";
    private static final String ENV_VAR_SMB_PROVIDER_JOBSCHEDULER_JS7 = "JS7_VFS_SMB_PROVIDER";
    private SOSSmtpMailOptions mailOptions;
    private Map<String, String> dmzOptions = new HashMap<String, String>();
    private SOSTransfer transfer;
    private Properties allEnvVars = null;
    private Properties envVars = null;
    private Properties schedulerParams = null;
    private String originalSettingsFile = null;
    private String jobSchedulerId;
    private String jobChain;
    private String jobChainNodeName;
    private String job;
    private String orderId;
    private String taskId;
    private Long parentTransferId;
    private boolean checkMandatoryDone = false;
    private boolean readSettingsFileIsActive = false;
    private boolean settingsFileProcessed = false;
    private boolean deleteSettingsFileOnExit = false;
    private boolean cumulativeTargetDeleted = false;
    private final Map<String, String> includeDirectives = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("include", "");
            this.put("source_include", "source_");
            this.put("target_include", "target_");
            this.put("jump_include", "jump_");
            this.put("alternate_source_include", "alternative_source_");
            this.put("alternate_target_include", "alternative_target_");
            this.put("source_alternate_include", "alternative_source_");
            this.put("target_alternate_include", "alternative_target_");
            this.put("alternative_source_include", "alternative_source_");
            this.put("alternative_target_include", "alternative_target_");
            this.put("source_alternative_include", "alternative_source_");
            this.put("target_alternative_include", "alternative_target_");
            this.put("alternate_include", "alternate_");
            this.put("alternatesource_include", "alternatesource_");
            this.put("alternatetarget_include", "alternatetarget_");
        }
    };

    public static String getSSHProviderFromEnv() {
        String val = System.getenv(ENV_VAR_SSH_PROVIDER_JOBSCHEDULER_1X);
        if (val == null) {
            val = System.getenv(ENV_VAR_SSH_PROVIDER_JOBSCHEDULER_JS7);
        }
        return val;
    }

    public static String getWEBDAVProviderFromEnv() {
        String val = System.getenv(ENV_VAR_WEBDAV_PROVIDER_JOBSCHEDULER_1X);
        if (val == null) {
            val = System.getenv(ENV_VAR_WEBDAV_PROVIDER_JOBSCHEDULER_JS7);
        }
        return val;
    }

    public static String getSMBProviderFromEnv() {
        String val = System.getenv(ENV_VAR_SMB_PROVIDER_JOBSCHEDULER_1X);
        if (val == null) {
            val = System.getenv(ENV_VAR_SMB_PROVIDER_JOBSCHEDULER_JS7);
        }
        return val;
    }

    public void checkMandatory() {
        if (this.checkMandatoryDone) {
            return;
        }
        try {
            String localDir;
            this.operation.checkMandatory();
            if (this.operation.getValue().equalsIgnoreCase(SOSOptionJadeOperation.enuJadeOperations.move.getText())) {
                this.removeFiles.value(true);
            }
            if (this.transactionMode.isTrue() && !this.isAtomicTransfer()) {
                this.atomicSuffix.setValue("~");
            }
            if (this.operation.getValue().equalsIgnoreCase(SOSOptionJadeOperation.enuJadeOperations.getlist.getText())) {
                this.removeFiles.setFalse();
            }
            if (this.isEmpty(localDir = this.localDir.getValue())) {
                this.localDir.setValue(this.sourceDir.getValue());
                localDir = this.localDir.getValue();
                localDir = localDir + "";
            }
            if (this.getSource().url.isDirty() && this.sourceDir.isNotDirty()) {
                this.sourceDir.setValue(this.getSource().url.getFolderName());
            }
            if (this.getTarget().url.isDirty() && this.targetDir.isNotDirty()) {
                this.targetDir.setValue(this.getTarget().url.getFolderName());
            }
            this.checkCredentialStore(this.getSource());
            this.checkCredentialStore(this.getTarget());
            if (this.getSource().replacing.isNotEmpty() && this.getSource().replacement.isNotEmpty()) {
                this.removeFiles.setFalse();
            }
            super.checkMandatory();
            if (localDir.startsWith("\\\\")) {
                while (localDir.indexOf("\\") != -1) {
                    localDir = localDir.replace('\\', '/');
                }
            }
            this.localDir.setValue(localDir);
            if (localDir.startsWith(PREFIX_FILE_URI) && !new File(this.createURI(localDir)).exists()) {
                throw new JobSchedulerException(SOSVFSMessageCodes.SOSVfs_E_0010.params(new Object[]{localDir}));
            }
            this.checkReplaceAndReplacing(this.getTarget());
            this.checkReplaceAndReplacing(this.getSource());
            if (this.replacing.isNotEmpty() && this.replacement.isNull()) {
                this.replacement.setValue("");
            }
            if (this.replacing.IsEmpty() && this.replacement.isNotEmpty()) {
                throw new JobSchedulerException(SOSVFSMessageCodes.SOSVfs_E_0020.params(new Object[]{this.replacement.getKey(), this.replacing.getKey()}));
            }
            if (this.appendFiles.value()) {
                String appendFilesKey = this.appendFiles.getKey();
                if (this.isAtomicTransfer()) {
                    String name = this.getOptionNamesAsString(new SOSOptionElement[]{this.atomicPrefix, this.atomicSuffix});
                    throw new JobSchedulerException(SOSVFSMessageCodes.SOSVfs_E_0050.params(new Object[]{appendFilesKey, name}));
                }
                if (this.compressFiles.value()) {
                    String name = this.getOptionNamesAsString(new SOSOptionElement[]{this.compressFiles});
                    throw new JobSchedulerException(SOSVFSMessageCodes.SOSVfs_E_0050.params(new Object[]{appendFilesKey, name}));
                }
                if (!"ftp".equalsIgnoreCase(this.protocol.getValue())) {
                    throw new JobSchedulerException(SOSVFSMessageCodes.SOSVfs_E_0040.params(new Object[]{appendFilesKey, this.protocol.getValue()}));
                }
            }
            if (this.getTarget().protocol.isDirty() && !this.protocol.isDirty()) {
                this.protocol.setValue(this.getTarget().protocol.getValue());
            }
            this.setDefaultHostPort(this.getSource().protocol, this.getSource().port, this.getSource().host);
            this.setDefaultHostPort(this.getTarget().protocol, this.getTarget().port, this.getTarget().host);
            this.setDefaultHostPort(this.getSource().getAlternative().protocol, this.getSource().getAlternative().port, this.getSource().getAlternative().host);
            this.setDefaultHostPort(this.getTarget().getAlternative().protocol, this.getTarget().getAlternative().port, this.getTarget().getAlternative().host);
            this.setDefaultAuth(this.getSource().protocol, this.getSource());
            this.setDefaultAuth(this.getTarget().protocol, this.getTarget());
            this.setDefaultAuth(this.getSource().getAlternative().protocol, this.getSource().getAlternative());
            this.setDefaultAuth(this.getTarget().getAlternative().protocol, this.getTarget().getAlternative());
            if (this.filePath.isDirty() && this.fileSpec.isDirty()) {
                this.filePath.setValue("");
            }
            if (this.filePath.IsEmpty() && this.sourceDir.IsEmpty() && this.getSource().directory.IsEmpty() && this.fileListName.IsEmpty()) {
                throw new JobSchedulerException(String.format("SOSVfs-E-0000: one of these parameters must be specified: '%1$s', '%2$s', '%3$s'", this.filePath.getShortKey(), "source_dir", this.fileListName.getShortKey()));
            }
            if (this.protocolCommandListener.isDirty()) {
                if (this.getSource().protocolCommandListener.isNotDirty()) {
                    this.getSource().protocolCommandListener.value(this.protocolCommandListener.value());
                }
                if (this.getTarget().protocolCommandListener.isNotDirty()) {
                    this.getTarget().protocolCommandListener.value(this.protocolCommandListener.value());
                }
            }
            this.changeDirValues();
            if (this.checkNotProcessedOptions.value()) {
                this.checkNotProcessedOptions();
            }
            this.checkMandatoryDone = true;
        }
        catch (JobSchedulerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new JobSchedulerException(e);
        }
    }

    public SOSSmtpMailOptions getMailOptions() {
        if (this.mailOptions == null) {
            this.mailOptions = new SOSSmtpMailOptions();
        }
        return this.mailOptions;
    }

    public void setMailOptions(SOSSmtpMailOptions opt) {
        this.mailOptions = opt;
    }

    public void setChildClasses(HashMap<String, String> settings) {
        try {
            if (this.transfer == null) {
                this.transfer = new SOSTransfer(settings);
            }
            if (this.mailOptions == null) {
                this.mailOptions = settings.containsKey(SETTINGS_KEY_MAIL_SMTP) ? new SOSSmtpMailOptions(settings) : new SOSSmtpMailOptions();
            }
        }
        catch (Exception e) {
            throw new JobSchedulerException((Throwable)e);
        }
    }

    private void checkReplaceAndReplacing(SOSProviderOptionsSuperClass options) {
        if (options.replacing.isNotEmpty() && options.replacement.isNull()) {
            options.replacement.setValue("");
        }
        if (options.replacing.IsEmpty() && options.replacement.isNotEmpty()) {
            throw new JobSchedulerException(SOSVFSMessageCodes.SOSVfs_E_0020.params(new Object[]{options.replacement.getKey(), options.replacing.getKey()}));
        }
    }

    private void checkCredentialStore(SOSProviderOptions options) {
        if (options.getCredentialStore() != null) {
            options.checkCredentialStoreOptions();
        }
    }

    private void setDefaultAuth(SOSOptionTransferType type, SOSProviderOptions options) {
        SOSOptionTransferType.TransferTypes transferType = type.getEnum();
        if ((type.isHTTP() || transferType.equals((Object)SOSOptionTransferType.TransferTypes.webdav)) && !options.authMethod.isDirty() && !options.sshAuthMethod.isDirty()) {
            options.authMethod.setValue(SOSOptionAuthenticationMethod.enuAuthenticationMethods.url);
            options.sshAuthMethod.setValue(SOSOptionAuthenticationMethod.enuAuthenticationMethods.url);
        }
        if (transferType.equals((Object)SOSOptionTransferType.TransferTypes.local)) {
            options.user.setValue(System.getProperty("user.name"));
            options.user.setNotDirty();
        }
    }

    private void setDefaultHostPort(SOSOptionTransferType type, SOSOptionPortNumber port, SOSOptionHostName host) {
        SOSOptionTransferType.TransferTypes transferType = type.getEnum();
        switch (transferType) {
            case sftp: 
            case ssh: {
                port.setDefaultValue("22");
                break;
            }
            case ftp: {
                port.setDefaultValue("21");
                break;
            }
            case zip: 
            case local: {
                port.setDefaultValue("0");
                if (!host.isNotDirty() && !"localhost".equalsIgnoreCase(host.getValue()) && !"127.0.0.1".equalsIgnoreCase(host.getValue())) break;
                host.setValue(SOSOptionHostName.getLocalHost());
                host.setNotDirty();
                break;
            }
            case ftps: {
                port.setDefaultValue("990");
                break;
            }
            case webdav: 
            case http: 
            case https: {
                if (host.getValue().toLowerCase().startsWith("https://")) {
                    port.setDefaultValue("443");
                    break;
                }
                port.setDefaultValue("80");
                break;
            }
        }
        if (port.isNotDirty()) {
            port.setValue(port.getDefaultValue());
            port.setNotDirty();
            port.setProtected(type.isProtected());
        }
    }

    private String getOptionNamesAsString(SOSOptionElement[] elements) {
        StringBuilder sb = new StringBuilder();
        for (SOSOptionElement element : elements) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(element.getKey()).append("=").append(element.getValue());
        }
        return sb.toString();
    }

    public boolean isAtomicTransfer() {
        return this.atomicPrefix.isNotEmpty() || this.atomicSuffix.isNotEmpty();
    }

    private Properties getEnvVars() throws Exception {
        try {
            this.envVars = new Properties();
            this.schedulerParams = new Properties();
            int len = PREFIX_SOSFTP_ENV_VAR.length();
            Map<String, String> systemEnvs = System.getenv();
            this.allEnvVars = new Properties();
            this.allEnvVars.putAll(systemEnvs);
            for (Object k : this.allEnvVars.keySet()) {
                String key = (String)k;
                String value = (String)this.allEnvVars.get(k);
                if (key.startsWith(PREFIX_SOSFTP_ENV_VAR)) {
                    key = key.substring(len);
                    this.envVars.setProperty(key, value);
                    continue;
                }
                if (key.startsWith("current_pid") || key.startsWith("ppid")) {
                    this.envVars.setProperty(key, value);
                    continue;
                }
                if (key.indexOf(PREFIX_SCHEDULER_ENV_VAR) <= -1) continue;
                this.schedulerParams.setProperty(key.substring(PREFIX_SCHEDULER_ENV_VAR.length()), value);
            }
            return this.envVars;
        }
        catch (Exception e) {
            String msg = SOSVFSMessageCodes.SOSVfs_E_161.params(new Object[]{"reading environment", e.toString()});
            LOGGER.error(msg, (Throwable)e);
            throw new JobSchedulerException(msg, (Throwable)e);
        }
    }

    public void setOptions(HashMap<String, String> map) {
        super.setAllOptions(map);
        this.setChildClasses(map);
    }

    public void setAllOptionsOnJob(HashMap<String, String> params) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("settingsFileProcessed=%s, readSettingsFileIsActive=%s", this.settingsFileProcessed, this.readSettingsFileIsActive));
        }
        if (!this.settingsFileProcessed && !this.readSettingsFileIsActive && params.containsKey("settings") && params.containsKey("profile")) {
            this.settings.setValue(params.get("settings"));
            this.profile.setValue(params.get("profile"));
            this.readSettingsFileIsActive = true;
            params.putAll(this.readSettingsFile(params));
            this.readSettingsFileIsActive = false;
            this.settingsFileProcessed = true;
        }
        this.handleFileOrderSource(params);
        this.setOptions(params);
    }

    private boolean isEmpty(HashMap<String, String> params, String key) {
        return params.get(key) == null || params.get(key).length() == 0;
    }

    private boolean isEqualIgnoreCase(HashMap<String, String> params, String key, String value) {
        return params.get(key) != null && params.get(key).equalsIgnoreCase(value);
    }

    private void handleFileOrderSource(HashMap<String, String> params) {
        boolean b = false;
        boolean bl = b = (this.isEmpty(params, "file_path") || this.isEqualIgnoreCase(params, "file_path", "${scheduler_file_path}")) && this.isEmpty(params, "source_dir") && this.isEmpty(params, "local_dir") && this.isEmpty(params, "file_spec");
        if (b && !this.isEmpty(params, "scheduler_file_path")) {
            LOGGER.debug(String.format("Using value from parameter SCHEDULER_FILE_PATH %s for the parameter file_path, as no file_path, local_dir, file_spec or source_dir has been specified", params.get("scheduler_file_path")));
            params.put("file_path", params.get("scheduler_file_path"));
        }
        boolean bl2 = b = !this.isEmpty(params, "scheduler_file_path") && this.isEqualIgnoreCase(params, "file_path", "${scheduler_file_name}") && this.isEmpty(params, "file_spec");
        if (b) {
            File f = new File(params.get("scheduler_file_path"));
            String path = params.get("source_dir");
            String basename = f.getName();
            LOGGER.debug(String.format("Using base filename %s from parameter SCHEDULER_FILE_PATH %s and path %s for the parameter file_path, as file_path=${scheduler_file_name} and no file_spec has been specified", basename, params.get("scheduler_file_path"), path));
            params.put("file_path", basename);
        }
    }

    public HashMap<String, String> readSettingsFile(Map<String, String> beatParams) {
        this.settings.checkMandatory();
        this.profile.checkMandatory();
        HashMap<String, String> result = new HashMap<String, String>();
        Properties properties = new Properties();
        try {
            LOGGER.debug(String.format("readSettingsFile: settings=%s, profile=%s", this.settings.getValue(), this.profile.getValue()));
            this.getEnvVars();
            SOSProfileSettings conf = new SOSProfileSettings(this.settings.getValue());
            Properties profileProps = conf.getSection(this.profile.getValue());
            if (profileProps.isEmpty()) {
                String sf = this.originalSettingsFile == null ? this.settings.getValue() : this.originalSettingsFile;
                throw new JobSchedulerException(String.format("[%s]not found profile=%s", sf, this.profile.getValue()));
            }
            Properties globalsProps = conf.getSection("globals");
            globalsProps = this.resolveIncludes(conf, globalsProps);
            properties.putAll((Map<?, ?>)globalsProps);
            profileProps = this.resolveIncludes(conf, profileProps);
            properties.putAll((Map<?, ?>)profileProps);
            properties.put("uuid", UUID.randomUUID().toString());
            properties.put("date", SOSOptionTime.getCurrentDateAsString());
            properties.put("time", SOSOptionTime.getCurrentTimeAsString((String)"hh:mm:ss"));
            properties.put("local_user", System.getProperty("user.name"));
            Properties props4Substitute = new Properties();
            props4Substitute.put("profile", this.profile.getValue());
            props4Substitute.put("settings", this.settings.getValue());
            try {
                InetAddress localMachine = InetAddress.getLocalHost();
                properties.put("localhost", localMachine.getHostName());
                properties.put("local_host_ip", localMachine.getHostAddress());
            }
            catch (Exception e) {
                LOGGER.debug(e.toString());
                properties.put("localhost", "localhost");
                properties.put("local_host_ip", "127.0.0.1");
            }
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                String key = (String)e.getKey();
                String value = (String)e.getValue();
                if (beatParams != null && beatParams.containsKey(key)) {
                    value = beatParams.get(key);
                }
                if (this.hasVariableToSubstitute(value)) {
                    LOGGER.trace("ReadSettingsFile() - key = " + key + ", value = " + value);
                    value = this.substituteVariables(value, properties);
                    value = this.substituteVariables(value, props4Substitute);
                    value = this.substituteVariables(value, this.envVars);
                    value = this.substituteVariables(value, this.allEnvVars);
                    value = this.substituteVariables(value, this.schedulerParams);
                    if (this.hasVariableToSubstitute(value)) {
                        switch (key) {
                            case "source_pre_command": 
                            case "source_post_command": 
                            case "source_tfn_post_command": 
                            case "target_pre_command": 
                            case "target_post_command": 
                            case "target_tfn_post_command": 
                            case "jump_post_transfer_commands_on_error": 
                            case "jump_post_transfer_commands_final": 
                            case "jump_post_transfer_commands_on_success": 
                            case "jump_pre_transfer_commands": 
                            case "file_path": {
                                break;
                            }
                            default: {
                                if (SOSKeePassPath.hasKeePassVariables((String)value)) break;
                                LOGGER.warn(SOSVFSMessageCodes.SOSVfs_W_0070.params(new Object[]{value, key}));
                            }
                        }
                    }
                    value = this.unescape(value);
                }
                result.put(key, value);
            }
        }
        catch (JobSchedulerException e) {
            LOGGER.error("ReadSettingsFile(): " + e.toString(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("ReadSettingsFile(): " + e.toString(), (Throwable)e);
            throw new JobSchedulerException((Throwable)e);
        }
        return result;
    }

    private Properties resolveIncludes(SOSProfileSettings conf, Properties props) throws Exception {
        return this.resolveIncludes(conf, props, "");
    }

    private Properties resolveIncludes(SOSProfileSettings conf, Properties props, String prefix) throws Exception {
        Properties allIncludedProps = new Properties();
        if (prefix == null) {
            prefix = "";
        }
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            String key = (String)e.getKey();
            key = key.substring(prefix.length());
            String value = (String)e.getValue();
            if (!this.isIncludeDirective(key)) continue;
            String[] includes = value.split("[;|,]");
            String includePrefix = this.getIncludePrefix(prefix + key);
            if (includePrefix == null) continue;
            for (String include : includes) {
                Properties includedProps = conf.getSection(include = include.trim(), true, includePrefix);
                if (includedProps.isEmpty()) {
                    throw new JobSchedulerException(SOSVFSMessageCodes.SOSVfs_E_0000.params(new Object[]{include, this.settings.getValue()}));
                }
                includedProps = this.resolveIncludes(conf, includedProps, includePrefix);
                allIncludedProps.putAll((Map<?, ?>)includedProps);
            }
        }
        for (Map.Entry<Object, Object> e : allIncludedProps.entrySet()) {
            if (props.containsKey(e.getKey())) continue;
            props.put(e.getKey(), e.getValue());
        }
        return props;
    }

    private boolean hasVariableToSubstitute(String value) {
        boolean result = false;
        value = " " + value.toLowerCase().replaceAll("(\\$|%)\\{(source|target)(transfer)?filename\\}", "").replaceAll("%(source|target)(transfer)?filename%", "");
        if (value.matches("^.*[^\\\\](\\$|%)\\{[^/\\}\\\\]+\\}.*$") || value.matches("^.*[^\\\\]%[^/%\\\\]+%.*$")) {
            result = true;
        }
        return result;
    }

    private String unescape(String value) {
        return value.replaceAll("\\\\((?:\\$|%)\\{[^/\\}\\\\]+\\})", "$1").replaceAll("\\\\(%[^/%\\\\]+%)", "$1");
    }

    private boolean isIncludeDirective(String includeDirective) {
        return this.includeDirectives.containsKey(includeDirective);
    }

    private String getIncludePrefix(String includeDirective) {
        return this.includeDirectives.get(includeDirective);
    }

    private String substituteVariables(String txt, Properties prop) {
        HashMap<String, String> startEndCharsForSubstitute = new HashMap<String, String>();
        startEndCharsForSubstitute.put("${", "}");
        startEndCharsForSubstitute.put("%{", "}");
        startEndCharsForSubstitute.put("%", "%");
        for (Map.Entry e : startEndCharsForSubstitute.entrySet()) {
            txt = this.substituteVariables(txt, prop, (String)e.getKey(), (String)e.getValue());
        }
        return txt;
    }

    private String substituteVariables(String txt, Properties prop, String startPrefix, String endPrefix) {
        try {
            for (Object k : prop.keySet()) {
                String key = (String)k;
                String value = (String)prop.get(key);
                String searchFor = startPrefix + key + endPrefix;
                int pos1 = -1;
                int pos2 = 0;
                while ((pos1 = txt.indexOf(searchFor, pos2)) != -1) {
                    int intEscaped = txt.indexOf("\\" + searchFor);
                    if (intEscaped > -1 && intEscaped == pos1 - 1) {
                        pos1 = -1;
                    }
                    pos2 = pos1 + searchFor.length();
                    if (pos1 <= -1 || pos2 <= pos1) continue;
                    txt = txt.substring(0, pos1) + value + txt.substring(pos2);
                }
            }
            return txt;
        }
        catch (Exception e) {
            throw new JobSchedulerException(SOSVFSMessageCodes.SOSVfs_E_197.params(new Object[]{txt}), (Throwable)e);
        }
    }

    private URI createURI(String fileName) {
        URI uri = null;
        try {
            uri = new URI(fileName);
        }
        catch (Exception e) {
            try {
                String fs;
                File f = new File(fileName);
                String path = f.getCanonicalPath();
                if (fileName.startsWith("/")) {
                    path = fileName;
                }
                if ((fs = System.getProperty(FILE_SEPARATOR)).length() == 1) {
                    char sep = fs.charAt(0);
                    if (sep != '/') {
                        path = path.replace(sep, '/');
                    }
                    if (path.charAt(0) != '/') {
                        path = '/' + path;
                    }
                }
                if (!path.startsWith(PREFIX_FILE_URI)) {
                    path = PREFIX_FILE_URI + path;
                }
                uri = new URI(path);
            }
            catch (Exception ex) {
                throw new JobSchedulerException(SOSVFSMessageCodes.SOSVfs_E_198.params(new Object[]{e.getMessage()}));
            }
        }
        return uri;
    }

    public boolean oneOrMoreSingleFilesSpecified() {
        return this.filePath.isNotEmpty() || this.fileListName.isNotEmpty();
    }

    private void changeDirValues() throws Exception {
        this.changeValue((SOSOptionElement)this.sourceDir, (SOSOptionElement)this.localDir);
        this.changeValue((SOSOptionElement)this.targetDir, (SOSOptionElement)this.remoteDir);
        this.changeValue((SOSOptionElement)this.localDir, (SOSOptionElement)this.sourceDir);
        this.changeValue((SOSOptionElement)this.remoteDir, (SOSOptionElement)this.targetDir);
        this.changeValue((SOSOptionElement)this.getSource().folderName, (SOSOptionElement)this.sourceDir);
        this.changeValue((SOSOptionElement)this.getTarget().folderName, (SOSOptionElement)this.targetDir);
    }

    private void changeValue(SOSOptionElement target, SOSOptionElement source) {
        if (target.IsEmpty() && !source.IsEmpty()) {
            if (source instanceof SOSOptionPassword) {
                LOGGER.trace(SOSVFSMessageCodes.SOSVfs_I_263.params(new Object[]{target.getKey(), "*****"}));
            } else {
                LOGGER.trace(SOSVFSMessageCodes.SOSVfs_I_263.params(new Object[]{target.getKey(), source.getValue()}));
            }
            target.set(source);
        }
    }

    public boolean isDoNotOverwrite() {
        return !this.overwriteFiles.value() && !this.appendFiles.value();
    }

    public SOSTransfer getTransfer() throws Exception {
        if (this.transfer == null) {
            this.transfer = new SOSTransfer(new HashMap<String, String>());
        }
        return this.transfer;
    }

    public SOSOptionRegExp getReplacing() {
        SOSOptionRegExp option = this.replacing;
        try {
            if (this.getTarget().replacing.isDirty()) {
                option = this.getTarget().replacing;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.toString(), (Throwable)e);
        }
        return option;
    }

    public SOSOptionString getReplacement() {
        SOSOptionString option = this.replacement;
        try {
            if (this.getTarget().replacement.isDirty()) {
                option = this.getTarget().replacement;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.toString(), (Throwable)e);
        }
        return option;
    }

    public SOSProviderOptions getSource() throws Exception {
        return this.getTransfer().getSource();
    }

    public SOSProviderOptions getTarget() throws Exception {
        return this.getTransfer().getTarget();
    }

    public boolean isNeedTargetClient() {
        boolean result = true;
        switch (this.operation.value()) {
            case delete: 
            case getlist: 
            case rename: {
                result = false;
                break;
            }
        }
        return result;
    }

    public boolean isFilePollingEnabled() {
        boolean result = false;
        if ((this.pollTimeout.isDirty() || this.pollingDuration.isDirty()) && this.skipTransfer.isFalse()) {
            result = true;
        }
        return result;
    }

    public Map<String, String> getDmzOptions() {
        return this.dmzOptions;
    }

    public void setDmzOption(String key, String value) {
        this.dmzOptions.put(key, value);
    }

    public String getDmzOption(String key) {
        return this.dmzOptions.getOrDefault(key, "");
    }

    public void setOriginalSettingsFile(String val) {
        this.originalSettingsFile = val;
    }

    public String getOriginalSettingsFile() {
        return this.originalSettingsFile;
    }

    public void setDeleteSettingsFileOnExit(boolean val) {
        this.deleteSettingsFileOnExit = val;
    }

    public boolean getDeleteSettingsFileOnExit() {
        return this.deleteSettingsFileOnExit;
    }

    public String getJobSchedulerId() {
        return this.jobSchedulerId;
    }

    public void setJobSchedulerId(String val) {
        this.jobSchedulerId = val;
    }

    public String getJobChain() {
        return this.jobChain;
    }

    public void setJobChain(String val) {
        this.jobChain = val;
    }

    public String getJobChainNodeName() {
        return this.jobChainNodeName;
    }

    public void setJobChainNodeName(String val) {
        this.jobChainNodeName = val;
    }

    public String getJob() {
        return this.job;
    }

    public void setJob(String val) {
        this.job = val;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String val) {
        this.orderId = val;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String val) {
        this.taskId = val;
    }

    public Long getParentTransferId() {
        return this.parentTransferId;
    }

    public void setParentTransferId(Long val) {
        this.parentTransferId = val;
    }

    public boolean getCumulativeTargetDeleted() {
        return this.cumulativeTargetDeleted;
    }

    public void setCumulativeTargetDeleted(boolean val) {
        this.cumulativeTargetDeleted = val;
    }
}

