/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.ftp;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.i18n.annotation.I18NResourceBundle;
import com.sos.vfs.common.SOSCommonFile;
import com.sos.vfs.ftp.common.SOSFTPBaseClass;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import org.apache.commons.net.ftp.FTPFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@I18NResourceBundle(baseName="SOSVirtualFileSystem", defaultLocale="en")
public class SOSFTPFile
extends SOSCommonFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSFTPFile.class);
    private static final String CLASSNAME = SOSFTPFile.class.getSimpleName();
    private String fileName = "";

    public SOSFTPFile(String path) {
        super("SOSVirtualFileSystem");
        this.fileName = path;
    }

    public SOSFTPFile(FTPFile file) {
        super("SOSVirtualFileSystem");
        this.fileName = file.getName();
    }

    @Override
    public boolean fileExists() {
        boolean result = false;
        if (this.getProvider().getFileSize(this.fileName) >= 0L) {
            result = true;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("[%s]fileExists=%s", this.fileName, result));
        }
        return result;
    }

    @Override
    public boolean directoryExists() {
        boolean result = this.getProvider().directoryExists(this.fileName);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("[%s]fileExists=%s", this.fileName, result));
        }
        return result;
    }

    @Override
    public boolean delete(boolean chekIsDirectory) {
        try {
            this.getProvider().delete(this.fileName, chekIsDirectory);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(String.format("[%s]deleted", this.fileName));
            }
        }
        catch (JobSchedulerException e) {
            throw e;
        }
        catch (IOException e) {
            throw new JobSchedulerException("[" + this.fileName + "]" + e.toString(), (Throwable)e);
        }
        return true;
    }

    @Override
    public InputStream getFileInputStream() {
        try {
            if (this.getInputStream() == null) {
                this.setInputStream(this.getProvider().getInputStream(this.fileName));
            }
        }
        catch (JobSchedulerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JobSchedulerException("[" + this.fileName + "]" + e.toString(), (Throwable)e);
        }
        return this.getInputStream();
    }

    private OutputStream getFileOutputStream() {
        try {
            if (this.getOutputStream() == null) {
                this.setOutputStream(this.getProvider().getOutputStream(this.fileName, this.isModeAppend(), this.isModeRestart()));
                if (this.getOutputStream() == null) {
                    throw new JobSchedulerException(this.getProvider().getReplyString());
                }
            }
        }
        catch (JobSchedulerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JobSchedulerException("[" + this.fileName + "]" + e.toString(), (Throwable)e);
        }
        return this.getOutputStream();
    }

    @Override
    public long getFileSize() {
        long result = -1L;
        try {
            result = this.getProvider().getFileSize(this.fileName);
        }
        catch (JobSchedulerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JobSchedulerException("[" + this.fileName + "]" + e.toString(), (Throwable)e);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(String.format("[%s]fileSize=%s", this.fileName, result));
        }
        return result;
    }

    @Override
    public String getName() {
        return this.fileName;
    }

    @Override
    public boolean isDirectory() {
        return this.getProvider().isDirectory(this.fileName);
    }

    @Override
    public void rename(String newPath) {
        this.getProvider().rename(this.fileName, newPath);
    }

    @Override
    public void closeInput() {
        block8: {
            try {
                if (this.getInputStream() == null) break block8;
                try {
                    this.getInputStream().close();
                    this.setInputStream(null);
                    ((SOSFTPBaseClass)this.getProvider()).completePendingCommand();
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage());
                    throw new JobSchedulerException((Throwable)e);
                }
            }
            catch (JobSchedulerException e) {
                throw e;
            }
            catch (Exception e) {
                throw new JobSchedulerException("[" + this.fileName + "]" + e.toString(), (Throwable)e);
            }
            finally {
                this.setInputStream(null);
            }
        }
    }

    @Override
    public void closeOutput() {
        try {
            if (this.getOutputStream() != null) {
                this.getOutputStream().flush();
                this.getOutputStream().close();
                ((SOSFTPBaseClass)this.getProvider()).completePendingCommand();
                if (this.getProvider().isNegativeCommandCompletion()) {
                    throw new JobSchedulerException(SOSVfs_E_175.params(new Object[]{this.fileName, this.getProvider().getReplyString()}));
                }
            }
        }
        catch (JobSchedulerException e) {
            throw e;
        }
        catch (IOException e) {
            throw new JobSchedulerException("[" + this.fileName + "]" + e.toString(), (Throwable)e);
        }
        finally {
            this.setOutputStream(null);
        }
    }

    @Override
    public int read(byte[] buffer) {
        int bytes = 0;
        try {
            InputStream is = this.getFileInputStream();
            if (is != null) {
                bytes = is.read(buffer);
            }
        }
        catch (IOException e) {
            throw new JobSchedulerException("[" + this.fileName + "]" + e.toString(), (Throwable)e);
        }
        return bytes;
    }

    @Override
    public void write(byte[] buffer, int offset, int length) {
        try {
            if (this.getFileOutputStream() == null) {
                throw new JobSchedulerException(SOSVfs_E_176.params(new Object[]{CLASSNAME + "::write", this.fileName}));
            }
            this.getFileOutputStream().write(buffer, offset, length);
        }
        catch (IOException e) {
            throw new JobSchedulerException("[" + this.fileName + "]" + e.toString(), (Throwable)e);
        }
    }

    @Override
    public void write(byte[] buffer) {
        try {
            this.getFileOutputStream().write(buffer);
        }
        catch (IOException e) {
            throw new JobSchedulerException("[" + this.fileName + "]" + e.toString(), (Throwable)e);
        }
    }

    @Override
    public long getModificationDateTime() {
        String dateTime = this.getProvider().getModificationDateTime(this.fileName);
        if (dateTime != null) {
            if (dateTime.startsWith("213 ")) {
                dateTime = dateTime.substring(3);
            }
            try {
                SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
                return df.parse(dateTime.trim()).getTime();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1L;
    }

    @Override
    public long setModificationDateTime(long millis) {
        return ((SOSFTPBaseClass)this.getProvider()).setModificationDateTime(this.fileName, millis);
    }
}

