/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.ftp.common;

import com.sos.JSHelper.Options.SOSOptionProxyProtocol;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSString;

public class SOSFTPSProxySelector
extends ProxySelector {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSFTPSProxySelector.class);
    private SOSOptionProxyProtocol.Protocol proxyProtocol;
    private String proxyHost;
    private int proxyPort;
    private String proxyUser;
    private String proxyPassword;

    public SOSFTPSProxySelector(SOSOptionProxyProtocol.Protocol protocol, String host, int port, String user, String password) {
        this.proxyProtocol = protocol;
        this.proxyHost = host;
        this.proxyPort = port;
        this.proxyUser = user;
        this.proxyPassword = password;
        LOGGER.info(String.format("using proxy. protocol = %s, host = %s:%s, user = %s ", this.proxyProtocol, this.proxyHost, this.proxyPort, this.proxyUser));
    }

    @Override
    public List<Proxy> select(URI uri) {
        Proxy proxy = null;
        ArrayList<Proxy> result = null;
        LOGGER.debug(String.format("using proxy [%s]. protocol = %s, host = %s:%s, user = %s ", uri.getScheme(), this.proxyProtocol, this.proxyHost, this.proxyPort, this.proxyUser));
        if (!SOSString.isEmpty((String)this.proxyUser)) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    PasswordAuthentication p = new PasswordAuthentication(SOSFTPSProxySelector.this.proxyUser, SOSFTPSProxySelector.this.proxyPassword.toCharArray());
                    return p;
                }
            });
        }
        if (this.proxyProtocol.equals((Object)SOSOptionProxyProtocol.Protocol.http)) {
            proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyHost, this.proxyPort));
        } else if (this.proxyProtocol.equals((Object)SOSOptionProxyProtocol.Protocol.socks4) || this.proxyProtocol.equals((Object)SOSOptionProxyProtocol.Protocol.socks5)) {
            proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(this.proxyHost, this.proxyPort));
        }
        if (proxy != null) {
            result = new ArrayList<Proxy>();
            result.add(proxy);
        }
        return result;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress addr, IOException ex) {
        if (uri == null || addr == null || ex == null) {
            throw new IllegalArgumentException("Arguments can't be null.");
        }
        throw new UnsupportedOperationException(String.format("connect failed[uri: %s][socket address: %s]: %s", uri.toString(), addr.toString(), ex.toString()));
    }
}

