/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.ftp.common;

import com.sos.JSHelper.Basics.JSToolBox;
import com.sos.vfs.ftp.common.SOSFTPIllegalReplyException;
import java.util.ArrayList;

public class SOSFTPServerReply
extends JSToolBox {
    private int code = 0;
    private String[] messages;

    public SOSFTPServerReply(int code1, String[] messages1) {
        this.code = code1;
        this.messages = messages1;
    }

    public SOSFTPServerReply(String messages1) {
        this.parseServerReply(messages1);
    }

    public void parseServerReply(String pstrReply) {
        String[] strM;
        if (this.isEmpty(pstrReply)) {
            return;
        }
        int code1 = 0;
        ArrayList<String> messages1 = new ArrayList<String>();
        for (String statement : strM = pstrReply.split("\r\n")) {
            int aux;
            if (statement.startsWith("\n")) {
                statement = statement.substring(1);
            }
            int l = statement.length();
            if (code1 == 0 && l < 3) {
                throw new SOSFTPIllegalReplyException();
            }
            try {
                aux = Integer.parseInt(statement.substring(0, 3));
            }
            catch (Exception e) {
                if (code1 == 0) {
                    throw new SOSFTPIllegalReplyException();
                }
                aux = 0;
            }
            if (code1 != 0 && aux != 0 && aux != code1) {
                throw new SOSFTPIllegalReplyException();
            }
            if (code1 == 0) {
                code1 = aux;
            }
            if (aux > 0) {
                if (l > 3) {
                    char s = statement.charAt(3);
                    String message = statement.substring(4, l);
                    messages1.add(message);
                    if (s == ' ') break;
                    if (s == '-') continue;
                    throw new SOSFTPIllegalReplyException();
                }
                if (l == 3) break;
                messages1.add(statement);
                continue;
            }
            messages1.add(statement);
        }
        int size = messages1.size();
        String[] m = new String[size];
        for (int i = 0; i < size; ++i) {
            m[i] = (String)messages1.get(i);
        }
        this.code = code1;
        this.messages = m;
    }

    public int getCode() {
        return this.code;
    }

    public boolean isSuccessCode() {
        int aux = this.code - 200;
        return aux >= 0 && aux < 100;
    }

    public boolean isErrorCode() {
        return this.code >= 500;
    }

    public String[] getMessages() {
        return this.messages;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(((Object)((Object)this)).getClass().getName());
        buffer.append(" [code=");
        buffer.append(this.code);
        buffer.append(", message=");
        for (int i = 0; i < this.messages.length; ++i) {
            if (i > 0) {
                buffer.append(" ");
            }
            buffer.append(this.messages[i]);
        }
        buffer.append("]");
        return buffer.toString();
    }
}

