/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.jms;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.vfs.common.SOSCommonProvider;
import com.sos.vfs.common.SOSFileEntry;
import com.sos.vfs.common.options.SOSProviderOptions;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOSJMS
extends SOSCommonProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSJMS.class);
    private ConnectionFactory factory = null;
    private Connection jmsConnection = null;
    private Session session = null;

    @Override
    public boolean isConnected() {
        return this.jmsConnection != null;
    }

    @Override
    public void connect(SOSProviderOptions options) throws Exception {
        super.connect(options);
        this.doConnect();
    }

    @Override
    public void disconnect() {
        try {
            if (this.jmsConnection != null) {
                this.jmsConnection.close();
            }
        }
        catch (JMSException e) {
            LOGGER.error("Error occured closing the jms connection! ", (Throwable)e);
        }
    }

    private void doConnect() {
        try {
            if (this.host.toLowerCase().startsWith("tcp://")) {
                URL url = new URL(this.host);
                this.port = url.getPort() == -1 ? url.getDefaultPort() : url.getPort();
                this.host = url.getHost();
            }
            LOGGER.info(SOSVfs_D_0101.params(new Object[]{this.host, this.port}));
            this.logReply();
        }
        catch (Exception ex) {
            throw new JobSchedulerException((Throwable)ex);
        }
    }

    public String createConnectionUrl(String protocol, String host, String port) {
        return protocol + "://" + host + ":" + port;
    }

    public Connection createConnection(String uri) {
        this.factory = new ActiveMQConnectionFactory(uri);
        this.jmsConnection = null;
        try {
            this.jmsConnection = this.factory.createConnection();
        }
        catch (JMSException e) {
            LOGGER.error("JMSException occurred while trying to connect: ", (Throwable)e);
        }
        return this.jmsConnection;
    }

    public Session createSession(Connection jmsConnection) {
        this.session = null;
        try {
            this.session = jmsConnection.createSession(false, 2);
        }
        catch (JMSException e) {
            LOGGER.error("JMSException occurred while trying to create Session: ", (Throwable)e);
        }
        return this.session;
    }

    public Destination createDestination(Session session, String queueName) {
        Queue destination = null;
        try {
            destination = session.createQueue(queueName);
        }
        catch (JMSException e) {
            LOGGER.error("JMSException occurred while trying to create Destination: ", (Throwable)e);
        }
        return destination;
    }

    public MessageProducer createMessageProducer(Session session, Destination destination) {
        MessageProducer producer = null;
        try {
            producer = session.createProducer(destination);
        }
        catch (JMSException e) {
            LOGGER.error("JMSException occurred while trying to create MessageProducer: ", (Throwable)e);
        }
        return producer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String text, String connectionUrl, String queueName) {
        Connection jmsConnection = this.createConnection(connectionUrl);
        Session session = this.createSession(jmsConnection);
        Destination destination = this.createDestination(session, queueName);
        MessageProducer producer = this.createMessageProducer(session, destination);
        TextMessage message = null;
        try {
            message = session.createTextMessage(text);
            producer.send((Message)message);
        }
        catch (JMSException e) {
            LOGGER.error("JMSException occurred in ProducerJob while trying to write Message to Destination: ", (Throwable)e);
        }
        finally {
            if (jmsConnection != null) {
                try {
                    jmsConnection.close();
                }
                catch (JMSException e) {
                    LOGGER.error("JMSException occurred in ProducerJob while trying to close the connection: ", (Throwable)e);
                }
            }
        }
    }

    public MessageConsumer createMessageConsumer(Session session, Destination destination) {
        MessageConsumer consumer = null;
        try {
            consumer = session.createConsumer(destination);
        }
        catch (JMSException e) {
            LOGGER.error("JMSException occurred while trying to create MessageConsumer: ", (Throwable)e);
        }
        return consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String read(Connection jmsConnection, String queueName, Boolean closeMessage) {
        String messageText = null;
        try {
            Session session = this.createSession(jmsConnection);
            Destination destination = this.createDestination(session, queueName);
            jmsConnection.start();
            MessageConsumer consumer = this.createMessageConsumer(session, destination);
            Message receivedMessage = null;
            while ((receivedMessage = consumer.receive(1L)) == null) {
            }
            if (receivedMessage instanceof TextMessage) {
                TextMessage message = (TextMessage)receivedMessage;
                messageText = message.getText();
                LOGGER.debug("Reading message from queue: " + messageText);
            }
            if (closeMessage.booleanValue()) {
                receivedMessage.acknowledge();
            }
        }
        catch (JMSException e) {
            LOGGER.error("JMSException occurred while trying to read from Destination: ", (Throwable)e);
        }
        finally {
            if (jmsConnection != null) {
                try {
                    jmsConnection.close();
                }
                catch (JMSException e) {
                    LOGGER.error("JMSException occurred while trying to close the connection: ", (Throwable)e);
                }
            }
        }
        return messageText;
    }

    @Override
    public OutputStream getOutputStream(String fileName, boolean append, boolean resume) {
        return null;
    }

    @Override
    public SOSFileEntry getFileEntry(String path) throws Exception {
        return null;
    }

    @Override
    public List<SOSFileEntry> listNames(String path, int maxFiles, boolean checkIfExists, boolean checkIfIsDirectory) throws Exception {
        return null;
    }
}

