/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.jms.test;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.protobuf.compiler.CommandLineSupport;
import org.apache.activemq.util.IndentPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileProducerTool
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileProducerTool.class);
    private Destination destination;
    private int messageCount = 10;
    private long sleepTime;
    private boolean verbose = true;
    private int messageSize = 255;
    private static int parallelThreads = 1;
    private long timeToLive;
    private String user = ActiveMQConnection.DEFAULT_USER;
    private String password = ActiveMQConnection.DEFAULT_PASSWORD;
    private String url = "failover://tcp://localhost:61616";
    private String subject = "SOSDEx.Files";
    private boolean topic;
    private boolean transacted;
    private boolean persistent;
    private static Object lockResults = new Object();

    public static void main(String[] args) {
        ArrayList<FileProducerTool> threads = new ArrayList<FileProducerTool>();
        FileProducerTool producerTool = new FileProducerTool();
        Object[] unknown = CommandLineSupport.setOptions((Object)producerTool, (String[])args);
        if (unknown.length > 0) {
            LOGGER.debug("Unknown options: " + Arrays.toString(unknown));
            System.exit(-1);
        }
        producerTool.showParameters();
        for (int threadCount = 1; threadCount <= parallelThreads; ++threadCount) {
            producerTool = new FileProducerTool();
            CommandLineSupport.setOptions((Object)producerTool, (String[])args);
            producerTool.start();
            threads.add(producerTool);
        }
        while (true) {
            Iterator itr = threads.iterator();
            int running = 0;
            while (itr.hasNext()) {
                FileProducerTool thread = (FileProducerTool)itr.next();
                if (!thread.isAlive()) continue;
                ++running;
            }
            if (running <= 0) break;
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        LOGGER.debug("All threads completed their work");
    }

    public void showParameters() {
        LOGGER.debug("Connecting to URL: " + this.url);
        LOGGER.debug("Publishing a Message with size " + this.messageSize + " to " + (this.topic ? "topic" : "queue") + ": " + this.subject);
        LOGGER.debug("Using " + (this.persistent ? "persistent" : "non-persistent") + " messages");
        LOGGER.debug("Sleeping between publish " + this.sleepTime + " ms");
        LOGGER.debug("Running " + parallelThreads + " parallel threads");
        if (this.timeToLive != 0L) {
            LOGGER.debug("Messages time to live " + this.timeToLive + " ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ActiveMQConnection connection = null;
        try {
            ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.user, this.password, this.url);
            connection = (ActiveMQConnection)connectionFactory.createConnection();
            connection.start();
            Session session = connection.createSession(this.transacted, 1);
            this.destination = this.topic ? session.createTopic(this.subject) : session.createQueue(this.subject);
            MessageProducer producer = session.createProducer(this.destination);
            if (this.persistent) {
                producer.setDeliveryMode(2);
            } else {
                producer.setDeliveryMode(1);
            }
            if (this.timeToLive != 0L) {
                producer.setTimeToLive(this.timeToLive);
            }
            this.sendLoop4File(connection, this.destination, session, producer);
            LOGGER.debug("[" + this.getName() + "] Done.");
            Object object = lockResults;
            synchronized (object) {
                ActiveMQConnection c = connection;
                LOGGER.debug("[" + this.getName() + "] Results:\n");
                c.getConnectionStats().dump(new IndentPrinter());
            }
        }
        catch (Exception e) {
            LOGGER.error("[" + this.getName() + "] Caught: " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                connection.close();
            }
            catch (Exception exception) {}
        }
    }

    protected void sendLoop4File(ActiveMQConnection connection, Destination destination, Session session, MessageProducer producer) throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        String returnFileName = "C:/KB/jerry.log";
        properties.put("sourceFileName", returnFileName);
        File fleFile = new File(returnFileName);
        properties.put("FileSize", String.valueOf(fleFile.length()));
        properties.put("targetFileName", fleFile.getName());
        properties.put("submitterURI", "com.sos.VirtualFileSystem.JMS.ActiveMQImpl");
        properties.put("submitterVersion", "1.0");
        int priority = producer.getPriority();
        int intDeliveryMode = producer.getDeliveryMode();
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(returnFileName));
        OutputStream out = connection.createOutputStream(destination, properties, intDeliveryMode, priority, this.timeToLive);
        byte[] buf = new byte[32768];
        int c = 0;
        do {
            if ((c = in.read(buf, 0, 32768)) <= 0) continue;
            out.write(buf, 0, c);
        } while (c >= 0);
        in.close();
        out.close();
    }

    protected void sendLoop4Message(Session session, MessageProducer producer) throws Exception {
        for (int i = 0; i < this.messageCount || this.messageCount == 0; ++i) {
            TextMessage message = session.createTextMessage(this.createMessageText(i));
            if (this.verbose) {
                String msg = message.getText();
                if (msg.length() > 50) {
                    msg = msg.substring(0, 50) + "...";
                }
                LOGGER.debug("[" + this.getName() + "] Sending message: '" + msg + "'");
            }
            producer.send((Message)message);
            if (this.transacted) {
                LOGGER.debug("[" + this.getName() + "] Committing " + this.messageCount + " messages");
                session.commit();
            }
            Thread.sleep(this.sleepTime);
        }
    }

    private String createMessageText(int index) {
        StringBuilder buffer = new StringBuilder(this.messageSize);
        buffer.append("Message: " + index + " sent at: " + new Date());
        if (buffer.length() > this.messageSize) {
            return buffer.substring(0, this.messageSize);
        }
        for (int i = buffer.length(); i < this.messageSize; ++i) {
            buffer.append(' ');
        }
        return buffer.toString();
    }

    public void setPersistent(boolean durable) {
        this.persistent = durable;
    }

    public void setMessageCount(int messageCount) {
        this.messageCount = messageCount;
    }

    public void setMessageSize(int messageSize) {
        this.messageSize = messageSize;
    }

    public void setPassword(String pwd) {
        this.password = pwd;
    }

    public void setSleepTime(long sleepTime) {
        this.sleepTime = sleepTime;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public void setParallelThreads(int parallelThreads) {
        if (parallelThreads < 1) {
            parallelThreads = 1;
        }
        FileProducerTool.parallelThreads = parallelThreads;
    }

    public void setTopic(boolean topic) {
        this.topic = topic;
    }

    public void setQueue(boolean queue) {
        this.topic = !queue;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

