/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.local;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.io.Files.JSFile;
import com.sos.i18n.annotation.I18NResourceBundle;
import com.sos.vfs.common.SOSVFSMessageCodes;
import com.sos.vfs.common.interfaces.ISOSProvider;
import com.sos.vfs.common.interfaces.ISOSProviderFile;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.TimeUnit;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@I18NResourceBundle(baseName="SOSVirtualFileSystem", defaultLocale="en")
public class SOSLocalFile
extends JSFile
implements ISOSProviderFile {
    private static final long serialVersionUID = 7478704922673917684L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSLocalFile.class);
    private static final String CLASS_NAME = SOSLocalFile.class.getSimpleName();
    private ISOSProvider provider = null;
    private InputStream is = null;
    private OutputStream os = null;
    private boolean append = false;

    public SOSLocalFile(String path) {
        super(path);
    }

    @Override
    public boolean fileExists() throws Exception {
        return super.exists();
    }

    @Override
    public boolean directoryExists() throws Exception {
        return super.exists();
    }

    @Override
    public boolean delete(boolean checkIsDirectory) {
        try {
            this.getProvider().delete(this.getAbsolutePath(), checkIsDirectory);
        }
        catch (Throwable e) {
            throw new JobSchedulerException(e);
        }
        return true;
    }

    @Override
    public InputStream getFileInputStream() {
        String method = CLASS_NAME + "::getFileInputStream";
        try {
            if (this.is == null) {
                this.is = new FileInputStream(new File(this.strFileName));
            }
        }
        catch (FileNotFoundException e) {
            String msg = SOSVFSMessageCodes.SOSVfs_E_134.params(new Object[]{method});
            throw new JobSchedulerException(msg + " / " + this.strFileName, (Throwable)e);
        }
        return this.is;
    }

    private OutputStream getFileOutputStream() {
        String method = CLASS_NAME + "::getFileOutputStream";
        try {
            if (this.os == null) {
                this.os = new FileOutputStream(new File(this.strFileName), this.append);
            }
        }
        catch (FileNotFoundException e) {
            String msg = SOSVFSMessageCodes.SOSVfs_E_134.params(new Object[]{method});
            throw new JobSchedulerException(msg + " / " + this.strFileName, (Throwable)e);
        }
        return this.os;
    }

    @Override
    public long getFileSize() {
        return super.length();
    }

    @Override
    public ISOSProvider getProvider() {
        return this.provider;
    }

    @Override
    public void setProvider(ISOSProvider val) {
        this.provider = val;
    }

    @Override
    public String getName() {
        return super.getPath();
    }

    @Override
    public boolean isDirectory() {
        return super.isDirectory();
    }

    @Override
    public void rename(String newFileName) {
        this.getProvider().rename(this.getAbsolutePath(), newFileName);
    }

    public void compressFile(File outputFile) throws Exception {
        BufferedInputStream in = null;
        DeflaterOutputStream out = null;
        try {
            int bytesRead;
            in = new BufferedInputStream(new FileInputStream(this.fleFile));
            out = new GZIPOutputStream(new FileOutputStream(outputFile));
            byte[] buffer = new byte[60000];
            while ((bytesRead = in.read(buffer)) != -1) {
                ((GZIPOutputStream)out).write(buffer, 0, bytesRead);
            }
        }
        catch (Exception e) {
            throw new JobSchedulerException(SOSVFSMessageCodes.SOSVfs_E_134.params(new Object[]{"GZip"}), (Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void close() {
        if (this.os != null) {
            this.closeOutput();
        } else if (this.is != null) {
            this.closeInput();
        }
    }

    @Override
    public void closeInput() {
        String method = CLASS_NAME + "::closeInput";
        try {
            if (this.is != null) {
                this.is.close();
            }
        }
        catch (IOException e) {
            throw new JobSchedulerException(SOSVFSMessageCodes.SOSVfs_E_134.params(new Object[]{method}), (Throwable)e);
        }
        finally {
            this.is = null;
        }
    }

    @Override
    public void closeOutput() {
        String method = CLASS_NAME + "::closeOutput";
        try {
            this.getFileOutputStream().flush();
            this.getFileOutputStream().close();
        }
        catch (IOException e) {
            throw new JobSchedulerException(SOSVFSMessageCodes.SOSVfs_E_134.params(new Object[]{method}), (Throwable)e);
        }
        finally {
            this.os = null;
        }
    }

    @Override
    public int read(byte[] buffer) {
        String method = CLASS_NAME + "::read";
        try {
            return this.getFileInputStream().read(buffer);
        }
        catch (IOException e) {
            throw new JobSchedulerException(SOSVFSMessageCodes.SOSVfs_E_134.params(new Object[]{method}), (Throwable)e);
        }
    }

    @Override
    public void write(byte[] buffer, int offset, int length) {
        String method = CLASS_NAME + "::write";
        try {
            this.getFileOutputStream().write(buffer, offset, length);
        }
        catch (IOException e) {
            throw new JobSchedulerException(SOSVFSMessageCodes.SOSVfs_E_134.params(new Object[]{method}), (Throwable)e);
        }
    }

    @Override
    public void write(byte[] buffer) {
        String method = CLASS_NAME + "::write";
        try {
            this.getFileOutputStream().write(buffer);
        }
        catch (IOException e) {
            throw new JobSchedulerException(SOSVFSMessageCodes.SOSVfs_E_134.params(new Object[]{method}), (Throwable)e);
        }
    }

    @Override
    public String file2String() {
        InputStream is = this.getFileInputStream();
        if (is == null) {
            throw new JobSchedulerException(SOSVFSMessageCodes.SOSVfs_E_265.get());
        }
        StringBuilder sb = new StringBuilder((int)this.getFileSize());
        byte[] buffer = new byte[1024];
        try {
            int bytes;
            while ((bytes = is.read(buffer)) != -1) {
                sb.append(new String(buffer).substring(0, bytes));
            }
            is.close();
            is = null;
        }
        catch (Exception e) {
            throw new JobSchedulerException(SOSVFSMessageCodes.SOSVfs_E_134.params(new Object[]{"file2String"}), (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return sb.toString();
    }

    @Override
    public void setModeAppend(boolean val) {
        this.append = val;
    }

    @Override
    public long getModificationDateTime() {
        try {
            FileTime ft = Files.getLastModifiedTime(Paths.get(this.strFileName, new String[0]), new LinkOption[0]);
            return ft.to(TimeUnit.MILLISECONDS);
        }
        catch (Throwable e) {
            LOGGER.error(String.format("[%s]%s", this.strFileName, e.toString()), e);
            return -1L;
        }
    }

    @Override
    public long setModificationDateTime(long millis) {
        if (millis <= 0L) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("[%s][skip]setModificationDateTime=%s", this.strFileName, millis));
            }
            return millis;
        }
        try {
            Files.setLastModifiedTime(Paths.get(this.strFileName, new String[0]), FileTime.fromMillis(millis));
            return millis;
        }
        catch (Throwable e) {
            LOGGER.error(String.format("[%s][%s]%s", this.strFileName, millis, e.toString()), e);
            return -1L;
        }
    }

    @Override
    public void setModeRestart(boolean restart) {
    }
}

