/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.sftp.jcraft;

import com.jcraft.jsch.SftpATTRS;
import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.i18n.annotation.I18NResourceBundle;
import com.sos.vfs.common.SOSCommonProviderFile;
import com.sos.vfs.sftp.jcraft.SOSSFTPJCraft;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@I18NResourceBundle(baseName="SOSVirtualFileSystem", defaultLocale="en")
public class SOSSFTPFileJCraft
extends SOSCommonProviderFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSSFTPFileJCraft.class);

    public SOSSFTPFileJCraft(String fileName) {
        super(fileName);
    }

    @Override
    public int read(byte[] buffer) {
        try {
            InputStream is = this.getFileInputStream();
            if (is == null) {
                throw new Exception(SOSVfs_E_177.get());
            }
            return is.read(buffer);
        }
        catch (Exception e) {
            throw new JobSchedulerException(SOSVfs_E_173.params(new Object[]{"read", this.fileName}), (Throwable)e);
        }
    }

    @Override
    public InputStream getFileInputStream() {
        try {
            if (this.getInputStream() == null) {
                this.fileName = this.adjustRelativePathName(this.fileName);
                int mode = 0;
                if (this.isModeAppend()) {
                    mode = 2;
                } else if (this.isModeRestart()) {
                    mode = 1;
                }
                SOSSFTPJCraft handler = (SOSSFTPJCraft)this.getProvider();
                this.setInputStream(handler.getChannelSftp().get(this.fileName, mode));
            }
        }
        catch (Exception e) {
            throw new JobSchedulerException(SOSVfs_E_158.params(new Object[]{"getFileInputStream()", this.fileName}), (Throwable)e);
        }
        return this.getInputStream();
    }

    @Override
    public void write(byte[] buffer, int offset, int length) {
        try {
            OutputStream os = this.getFileOutputStream();
            if (os == null) {
                throw new Exception(SOSVfs_E_147.get());
            }
            os.write(buffer, offset, length);
        }
        catch (Exception e) {
            throw new JobSchedulerException(SOSVfs_E_173.params(new Object[]{"write", this.fileName}), (Throwable)e);
        }
    }

    @Override
    public void write(byte[] buffer) {
        try {
            this.getFileOutputStream().write(buffer);
        }
        catch (IOException e) {
            throw new JobSchedulerException(SOSVfs_E_134.params(new Object[]{"write()"}), (Throwable)e);
        }
    }

    private OutputStream getFileOutputStream() {
        try {
            if (this.getOutputStream() == null) {
                this.fileName = this.adjustRelativePathName(this.fileName);
                this.setOutputStream(this.getProvider().getOutputStream(this.fileName, this.isModeAppend(), this.isModeRestart()));
            }
        }
        catch (Exception e) {
            throw new JobSchedulerException(SOSVfs_E_158.params(new Object[]{"getFileOutputStream()", this.fileName}), (Throwable)e);
        }
        return this.getOutputStream();
    }

    @Override
    public long getModificationDateTime() {
        String path = "";
        try {
            path = this.adjustRelativePathName(this.fileName);
            SOSSFTPJCraft handler = (SOSSFTPJCraft)this.getProvider();
            SftpATTRS attrs = handler.getAttributes(path);
            if (attrs == null) {
                throw new Exception("SftpATTRS is null");
            }
            return Long.valueOf(attrs.getMTime()) * 1000L;
        }
        catch (Exception e) {
            LOGGER.error(String.format("[%s]%s", path, e.toString()), (Throwable)e);
            return -1L;
        }
    }

    @Override
    public long setModificationDateTime(long millis) {
        if (millis <= 0L) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("[%s][skip]setModificationDateTime=%s", this.fileName, millis));
            }
            return millis;
        }
        try {
            SOSSFTPJCraft handler = (SOSSFTPJCraft)this.getProvider();
            int seconds = (int)(millis / 1000L);
            handler.getChannelSftp().setMtime(this.adjustRelativePathName(this.fileName), seconds);
            return millis;
        }
        catch (Exception e) {
            LOGGER.error(String.format("[%s][%s]%s", this.fileName, millis, e.toString()), (Throwable)e);
            return -1L;
        }
    }
}

