/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.sftp.jcraft;

import com.google.common.base.Joiner;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.ProxySOCKS4;
import com.jcraft.jsch.ProxySOCKS5;
import com.jcraft.jsch.SOSRequiredAuthKeyboardInteractive;
import com.jcraft.jsch.SOSRequiredAuthPassword;
import com.jcraft.jsch.SOSRequiredAuthPublicKey;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.UserInfo;
import com.jcraft.jsch.agentproxy.AgentProxyException;
import com.jcraft.jsch.agentproxy.Connector;
import com.jcraft.jsch.agentproxy.ConnectorFactory;
import com.jcraft.jsch.agentproxy.RemoteIdentityRepository;
import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.Options.SOSOptionFolderName;
import com.sos.JSHelper.Options.SOSOptionInFileName;
import com.sos.JSHelper.Options.SOSOptionProxyProtocol;
import com.sos.JSHelper.Options.SOSOptionTransferType;
import com.sos.exception.SOSMissingDataException;
import com.sos.i18n.annotation.I18NResourceBundle;
import com.sos.keepass.SOSKeePassDatabase;
import com.sos.vfs.common.SOSCommandResult;
import com.sos.vfs.common.SOSCommonProvider;
import com.sos.vfs.common.SOSEnv;
import com.sos.vfs.common.SOSFileEntry;
import com.sos.vfs.common.SOSFileEntryFile;
import com.sos.vfs.common.interfaces.ISOSProviderFile;
import com.sos.vfs.common.options.SOSProviderOptions;
import com.sos.vfs.sftp.SOSSFTP;
import com.sos.vfs.sftp.common.ISOSSFTP;
import com.sos.vfs.sftp.common.SOSSFTPUserInfo;
import com.sos.vfs.sftp.common.SOSSSHServerInfo;
import com.sos.vfs.sftp.jcraft.SOSSFTPFileJCraft;
import com.sos.vfs.sftp.jcraft.common.SOSSFTPLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jurr.jsch.bugfix111.JSCH111BugFix;
import org.linguafranca.pwdb.Entry;
import org.slf4j.LoggerFactory;
import sos.util.SOSDate;
import sos.util.SOSString;

@I18NResourceBundle(baseName="SOSVirtualFileSystem", defaultLocale="en")
public class SOSSFTPJCraft
extends SOSCommonProvider
implements ISOSSFTP {
    private static final org.slf4j.Logger LOGGER = LoggerFactory.getLogger(SOSSFTPJCraft.class);
    private static final int DEFAULT_CONNECTION_TIMEOUT = 30000;
    private JSch secureChannel = null;
    private Session sshSession = null;
    private ChannelSftp channelSftp = null;
    private ChannelExec channelExec = null;
    private Integer exitCode;
    private String exitSignal;
    private StringBuilder stdOut;
    private StringBuilder stdErr;
    private SOSSSHServerInfo serverInfo = null;
    private boolean simulateShell = false;
    private int sessionConnectTimeout = 0;
    private int channelConnectTimeout = 0;
    private final String lineSeparator = System.getProperty("line.separator");

    public SOSSFTPJCraft() {
        JSCH111BugFix.init();
        JSch.setLogger((Logger)new SOSSFTPLogger());
        this.secureChannel = new JSch();
    }

    @Override
    public boolean isConnected() {
        if (this.channelSftp != null) {
            return this.channelSftp.isConnected();
        }
        return this.sshSession != null && this.sshSession.isConnected();
    }

    @Override
    public void connect(SOSProviderOptions options) throws Exception {
        super.connect(options);
        LOGGER.info("[" + this.getProviderOptions().protocol.getValue() + "]" + SOSVfs_D_0101.params(new Object[]{this.getProviderOptions().host.getValue(), this.getProviderOptions().port.value()}));
        try {
            this.doConnect();
        }
        catch (JobSchedulerException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JobSchedulerException((Throwable)ex);
        }
    }

    @Override
    public void disconnect() {
        this.reply = "disconnect OK";
        if (this.channelSftp != null) {
            try {
                if (this.channelSftp.isConnected()) {
                    this.channelSftp.disconnect();
                    LOGGER.debug("[sftp]disconnected");
                } else {
                    LOGGER.debug("[sftp]not connected");
                }
                this.channelSftp = null;
            }
            catch (Exception ex) {
                this.reply = "[sftp][disconnect]" + ex.toString();
            }
        }
        if (this.channelExec != null) {
            try {
                if (this.channelExec.isConnected()) {
                    this.channelExec.disconnect();
                    LOGGER.debug("[exec]disconnected");
                } else {
                    LOGGER.debug("[exec]not connected");
                }
                this.channelExec = null;
            }
            catch (Exception ex) {
                this.reply = "[exec][disconnect]" + ex.toString();
            }
        }
        if (this.sshSession != null) {
            try {
                if (this.sshSession.isConnected()) {
                    this.sshSession.disconnect();
                    LOGGER.debug("[session]disconnected");
                } else {
                    LOGGER.debug("[session]not connected");
                }
                this.sshSession = null;
            }
            catch (Exception ex) {
                this.reply = "[session][disconnect]" + ex.toString();
            }
        }
        LOGGER.info(this.reply);
    }

    @Override
    public void mkdir(String path) {
        try {
            boolean isDebugEnabled = LOGGER.isDebugEnabled();
            String p = path.replaceAll("//+", "/").replaceFirst("/$", "");
            SOSOptionFolderName folderName = new SOSOptionFolderName(path);
            this.reply = "mkdir OK";
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(String.format("[mkdir][%s]try to create ...", p));
            }
            String[] subfolders = folderName.getSubFolderArrayReverse();
            int idx = subfolders.length;
            for (String subFolder : folderName.getSubFolderArrayReverse()) {
                SftpATTRS attributes = this.getAttributes(subFolder);
                if (attributes != null && attributes.isDir()) {
                    if (!isDebugEnabled) break;
                    LOGGER.debug(SOSVfs_E_180.params(new Object[]{subFolder}));
                    break;
                }
                if (attributes != null && !attributes.isDir()) {
                    throw new JobSchedulerException(SOSVfs_E_277.params(new Object[]{subFolder}));
                }
                --idx;
            }
            subfolders = folderName.getSubFolderArray();
            for (int i = idx; i < subfolders.length; ++i) {
                this.channelSftp.mkdir(subfolders[i]);
                if (!isDebugEnabled) continue;
                LOGGER.debug(String.format("[mkdir][%s]created", subfolders[i]));
            }
        }
        catch (Exception e) {
            this.reply = e.toString();
            throw new JobSchedulerException(String.format("[%s] mkdir failed", path), (Throwable)e);
        }
    }

    @Override
    public void rmdir(String path) {
        try {
            if (SOSString.isEmpty((String)path)) {
                throw new SOSMissingDataException("path");
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(String.format("[rmdir][%s]try to remove ...", path));
            }
            LinkedList<SOSFileEntry> toRemove = new LinkedList<SOSFileEntry>();
            this.dirInfo(path, toRemove, true);
            boolean isDebugEnabled = LOGGER.isDebugEnabled();
            while (!toRemove.isEmpty()) {
                SOSFileEntry resource = (SOSFileEntry)toRemove.pop();
                String resourcePath = resource.getFullPath();
                if (isDebugEnabled) {
                    LOGGER.debug(this.getHostID(SOSVfs_D_179.params(new Object[]{"rmdir", resourcePath})));
                }
                if (resource.isDirectory()) {
                    this.channelSftp.rmdir(resourcePath);
                    if (!isDebugEnabled) continue;
                    LOGGER.debug(this.getHostID(SOSVfs_D_181.params(new Object[]{"rmdir", resourcePath, "rmdir OK"})));
                    continue;
                }
                this.channelSftp.rm(resourcePath);
                if (!isDebugEnabled) continue;
                LOGGER.debug(this.getHostID(SOSVfs_D_181.params(new Object[]{"rmdir", resourcePath, "rm OK"})));
            }
            this.channelSftp.rmdir(path);
            this.reply = "rmdir OK";
            LOGGER.info(this.getHostID(SOSVfs_D_181.params(new Object[]{"rmdir", path, this.getReplyString()})));
        }
        catch (Exception e) {
            this.reply = e.toString();
            throw new JobSchedulerException(String.format("[%s]rmdir failed", path), (Throwable)e);
        }
    }

    private void dirInfo(String path, Deque<SOSFileEntry> result, boolean recursive) throws Exception {
        List<SOSFileEntry> infos = this.listNames(path, -1, false, false);
        for (SOSFileEntry resource : infos) {
            result.push(resource);
            if (!recursive || !resource.isDirectory()) continue;
            this.dirInfo(resource.getFullPath(), result, recursive);
        }
    }

    @Override
    public boolean fileExists(String filename) {
        boolean result = false;
        SftpATTRS attributes = this.getAttributes(filename);
        result = attributes != null ? !attributes.isLink() || attributes.isDir() : false;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[%s]fileExists=%s", filename, result));
        }
        return result;
    }

    @Override
    public boolean directoryExists(String filename) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[%s]directoryExists", filename));
        }
        return this.isDirectory(filename);
    }

    @Override
    public boolean isDirectory(String filename) {
        boolean result = false;
        SftpATTRS attributes = this.getAttributes(filename);
        if (attributes != null && !(result = attributes.isDir())) {
            result = attributes.isLink();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[%s]isDirectory=%s", filename, result));
        }
        return result;
    }

    @Override
    public long size(String filename) throws Exception {
        filename = SOSSFTPJCraft.normalizePath(filename);
        long size = -1L;
        SftpATTRS attributes = this.getAttributes(filename);
        if (attributes != null) {
            size = attributes.getSize();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[%s]size=%s", filename, size));
        }
        return size;
    }

    protected SftpATTRS getAttributes(String filename) {
        SftpATTRS attributes;
        block2: {
            attributes = null;
            try {
                attributes = this.channelSftp.stat(filename);
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause == null || !(cause instanceof NullPointerException) || this.channelSftp.isConnected()) break block2;
                throw new JobSchedulerException(String.format("[%s]not connected", filename));
            }
        }
        return attributes;
    }

    @Override
    public SOSFileEntry getFileEntry(String pathname) throws Exception {
        SftpATTRS attrs = this.getAttributes(pathname);
        if (attrs != null && !attrs.isDir()) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(String.format("[%s]found", pathname));
            }
            SOSFileEntryFile f = new SOSFileEntryFile(pathname);
            return this.getFileEntry(attrs, f.getName(), f.getParent());
        }
        return null;
    }

    private SOSFileEntry getFileEntry(SftpATTRS attrs, String fileName, String parentPath) {
        SOSFileEntry entry = new SOSFileEntry(SOSFileEntry.EntryType.FILESYSTEM);
        entry.setDirectory(attrs.isDir());
        entry.setFilename(fileName);
        entry.setFilesize(attrs.getSize());
        entry.setParentPath(parentPath);
        if (parentPath != null && SOSSFTP.hasWindowsOpenSSHDriverLetterSpecifier(parentPath)) {
            entry.setFullPath("/" + entry.getFullPath());
        }
        return entry;
    }

    @Override
    public List<SOSFileEntry> listNames(String path, int maxFiles, boolean checkIfExists, boolean checkIfIsDirectory) {
        path = SOSSFTPJCraft.normalizePath(path);
        try {
            ArrayList<SOSFileEntry> result = new ArrayList<SOSFileEntry>();
            if (path.isEmpty()) {
                path = ".";
            }
            if (checkIfExists && !this.fileExists(path)) {
                return result;
            }
            if (checkIfIsDirectory && !this.isDirectory(path)) {
                this.reply = "ls OK";
                return result;
            }
            final ArrayList list = new ArrayList();
            ChannelSftp.LsEntrySelector selector = new ChannelSftp.LsEntrySelector(){

                public int select(ChannelSftp.LsEntry entry) {
                    String filename = entry.getFilename();
                    if (filename.equals(".") || filename.equals("..")) {
                        return 0;
                    }
                    list.add(entry);
                    return 0;
                }
            };
            this.channelSftp.ls(path, selector);
            int size = list.size();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(String.format("[%s][ls] %s files or folders", path, size));
            }
            for (int i = 0; i < size; ++i) {
                ChannelSftp.LsEntry file = (ChannelSftp.LsEntry)list.get(i);
                result.add(this.getFileEntry(file.getAttrs(), file.getFilename(), path));
            }
            this.reply = "ls OK";
            return result;
        }
        catch (Exception e) {
            this.reply = e.toString();
            return null;
        }
    }

    @Override
    public void delete(String path, boolean checkIsDirectory) {
        try {
            if (checkIsDirectory && this.isDirectory(path)) {
                throw new JobSchedulerException(SOSVfs_E_186.params(new Object[]{path}));
            }
            this.channelSftp.rm(path);
        }
        catch (Exception ex) {
            this.reply = ex.toString();
            throw new JobSchedulerException(SOSVfs_E_187.params(new Object[]{"delete", path}), (Throwable)ex);
        }
        this.reply = "rm OK";
        LOGGER.info(this.getHostID(SOSVfs_D_181.params(new Object[]{"delete", path, this.getReplyString()})));
    }

    @Override
    public void rename(String from, String to) {
        from = SOSSFTPJCraft.normalizePath(from);
        to = SOSSFTPJCraft.normalizePath(to);
        try {
            this.channelSftp.rename(from, to);
        }
        catch (Exception e) {
            this.reply = e.toString();
            throw new JobSchedulerException(SOSVfs_E_188.params(new Object[]{"rename", from, to}), (Throwable)e);
        }
        this.reply = "mv OK";
        LOGGER.info(this.getHostID(SOSVfs_I_189.params(new Object[]{from, to, this.getReplyString()})));
    }

    @Override
    public void executeCommand(String cmd) {
        this.executeCommand(cmd, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeCommand(String cmd, SOSEnv env) {
        this.channelExec = null;
        this.exitCode = null;
        InputStream out = null;
        InputStream err = null;
        BufferedReader errReader = null;
        try {
            String line;
            boolean isErrorExitCode;
            boolean isDebugEnabled = LOGGER.isDebugEnabled();
            if (this.sshSession == null) {
                throw new JobSchedulerException(SOSVfs_E_190.params(new Object[]{"sshSession"}));
            }
            this.channelExec = (ChannelExec)this.sshSession.openChannel("exec");
            this.channelExec.setPty(this.isSimulateShell());
            StringBuilder localEnvs = new StringBuilder();
            if (env != null) {
                if (env.getGlobalEnvs() != null && env.getGlobalEnvs().size() > 0) {
                    if (isDebugEnabled) {
                        LOGGER.debug(String.format("[set global envs]%s", env.getGlobalEnvs()));
                    }
                    env.getGlobalEnvs().forEach((k, v) -> this.channelExec.setEnv(k, v));
                }
                if (env.getLocalEnvs() != null && env.getLocalEnvs().size() > 0) {
                    this.getSSHServerInfo();
                    env.getLocalEnvs().forEach((k, v) -> {
                        if (this.serverInfo.getShell().equals((Object)SOSSSHServerInfo.Shell.WINDOWS)) {
                            localEnvs.append(String.format("set %s=%s&", k, v));
                        } else {
                            localEnvs.append(String.format("export \"%s=%s\";", k, v));
                        }
                    });
                    if (isDebugEnabled) {
                        LOGGER.debug(String.format("[set local envs]%s", localEnvs));
                    }
                }
            }
            cmd = cmd.trim().replaceAll("\u0000", "\\\\\\\\").replaceAll("\"", "\\\"");
            if (localEnvs.length() > 0) {
                cmd = localEnvs.toString() + cmd;
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(String.format("[cmd]%s", cmd));
            }
            this.channelExec.setCommand(cmd);
            this.channelExec.setInputStream(null);
            this.channelExec.setErrStream(null);
            out = this.channelExec.getInputStream();
            err = this.channelExec.getErrStream();
            this.channelExec.connect(this.channelConnectTimeout);
            this.stdOut = new StringBuilder();
            byte[] tmp = new byte[1024];
            while (true) {
                int i22;
                if (out.available() > 0 && (i22 = out.read(tmp, 0, 1024)) >= 0) {
                    this.stdOut.append(new String(tmp, 0, i22));
                    continue;
                }
                if (this.channelExec.isClosed()) break;
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception i22) {}
            }
            this.exitCode = this.channelExec.getExitStatus();
            boolean bl = isErrorExitCode = this.exitCode != null && !this.exitCode.equals(new Integer(0));
            if (!isErrorExitCode && this.stdOut.length() > 0) {
                LOGGER.info(String.format("[%s][std:out]%s", cmd, this.stdOut.toString().trim()));
            }
            errReader = new BufferedReader(new InputStreamReader(err));
            this.stdErr = new StringBuilder();
            while ((line = errReader.readLine()) != null) {
                this.stdErr.append(line + this.lineSeparator);
            }
            if (isErrorExitCode) {
                StringBuffer msg = new StringBuffer("[" + cmd + "]");
                if (this.stdOut.length() > 0) {
                    msg.append("[std:out=" + this.stdOut.toString().trim() + "]");
                }
                if (this.stdErr.length() > 0) {
                    msg.append("[std:err=" + this.stdErr.toString().trim() + "]");
                }
                msg.append("remote command terminated with the exit code " + this.exitCode.toString());
                throw new JobSchedulerException(msg.toString());
            }
            if (this.stdErr.length() > 0) {
                LOGGER.info(String.format("[%s][std:err]%s", cmd, this.stdErr.toString().trim()));
            }
            this.reply = "OK";
        }
        catch (JobSchedulerException ex) {
            this.reply = ex.toString();
            if (this.getProviderOptions().raiseExceptionOnError.value()) {
                throw ex;
            }
            LOGGER.info(String.format("[%s]%s", cmd, this.reply));
        }
        catch (Exception ex) {
            this.reply = ex.toString();
            if (this.getProviderOptions().raiseExceptionOnError.value()) {
                throw new JobSchedulerException(SOSVfs_E_134.params(new Object[]{"ExecuteCommand"}), (Throwable)ex);
            }
            LOGGER.info(String.format("[%s]%s", cmd, this.reply));
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception ex) {}
            }
            if (errReader != null) {
                try {
                    errReader.close();
                }
                catch (Exception ex) {}
            }
            if (err != null) {
                try {
                    err.close();
                }
                catch (Exception ex) {}
            }
            if (this.channelExec != null) {
                try {
                    this.channelExec.disconnect();
                }
                catch (Exception ex) {}
            }
        }
    }

    @Override
    public boolean isExecSessionExists() {
        return this.channelExec != null;
    }

    @Override
    public boolean isExecSessionConnected() {
        return this.channelExec != null && this.channelExec.isConnected();
    }

    @Override
    public void execSessionSendSignalContinue() throws Exception {
        if (this.channelExec != null) {
            this.channelExec.sendSignal("CONT");
        }
    }

    @Override
    public InputStream getInputStream(String fileName) {
        try {
            return this.channelSftp.get(fileName);
        }
        catch (Exception ex) {
            throw new JobSchedulerException(SOSVfs_E_193.params(new Object[]{"getInputStream()", fileName}), (Throwable)ex);
        }
    }

    @Override
    public OutputStream getOutputStream(String fileName, boolean append, boolean resume) {
        try {
            int transferMode = 0;
            if (append) {
                transferMode = 2;
            } else if (resume) {
                transferMode = 1;
            }
            return this.channelSftp.put(fileName, transferMode);
        }
        catch (Exception ex) {
            throw new JobSchedulerException(SOSVfs_E_193.params(new Object[]{"getOutputStream()", fileName}), (Throwable)ex);
        }
    }

    @Override
    public ISOSProviderFile getFile(String fileName) {
        fileName = this.adjustFileSeparator(fileName);
        SOSSFTPFileJCraft file = new SOSSFTPFileJCraft(fileName);
        file.setProvider(this);
        return file;
    }

    @Override
    public String getModificationDateTime(String path) {
        String dateTime = null;
        try {
            SftpATTRS objAttr = this.channelSftp.stat(path);
            if (objAttr != null) {
                long mt = Long.valueOf(objAttr.getMTime()) * 1000L;
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                dateTime = df.format(new Date(mt));
            }
        }
        catch (SftpException sftpException) {
            // empty catch block
        }
        return dateTime;
    }

    private void usePublicKeyMethod() throws Exception {
        String method = "usePublicKeyMethod";
        boolean isDebugEnabled = LOGGER.isDebugEnabled();
        Object kd = this.getProviderOptions().keepass_database.value();
        Object ke = this.getProviderOptions().keepass_database_entry.value();
        if (this.getProviderOptions().useKeyAgent.isTrue()) {
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s]isUseKeyAgent", method));
            }
            Connector con = null;
            try {
                ConnectorFactory cf = ConnectorFactory.getDefault();
                con = cf.createConnector();
            }
            catch (AgentProxyException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            if (con != null) {
                RemoteIdentityRepository irepo = new RemoteIdentityRepository(con);
                this.secureChannel.setIdentityRepository((IdentityRepository)irepo);
            }
        } else if (kd == null || ke == null) {
            SOSOptionInFileName authenticationFile = this.getProviderOptions().authFile;
            authenticationFile.checkMandatory(true);
            if (authenticationFile.isNotEmpty()) {
                try {
                    if (this.getProviderOptions().passphrase.isNotEmpty()) {
                        if (isDebugEnabled) {
                            LOGGER.debug(String.format("[%s]file=%s, passphrase=?", method, this.getProviderOptions().authFile.getValue()));
                        }
                        this.secureChannel.addIdentity(authenticationFile.getJSFile().getPath(), this.getProviderOptions().passphrase.getValue());
                    }
                    if (isDebugEnabled) {
                        LOGGER.debug(String.format("[%s]file=%s", method, this.getProviderOptions().authFile.getValue()));
                    }
                    this.secureChannel.addIdentity(authenticationFile.getJSFile().getPath());
                }
                catch (JSchException e) {
                    throw new Exception(String.format("[%s][%s]%s", method, this.getProviderOptions().authFile.getValue(), e.toString()), e);
                }
            } else if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s]authFile is empty", method));
            }
        } else {
            SOSKeePassDatabase kpd = (SOSKeePassDatabase)kd;
            Entry entry = (Entry)ke;
            try {
                byte[] pr = kpd.getAttachment(entry, this.getProviderOptions().keepass_attachment_property_name.getValue());
                String keePassPath = entry.getPath() + "@" + this.getProviderOptions().keepass_attachment_property_name.getValue();
                if (this.getProviderOptions().passphrase.isNotEmpty()) {
                    if (isDebugEnabled) {
                        LOGGER.debug(String.format("[%s][keepass]attachment=%s, passphrase=?", method, keePassPath));
                    }
                    this.secureChannel.addIdentity(SOSSFTPJCraft.class.getSimpleName(), pr, (byte[])null, this.getProviderOptions().passphrase.getValue().getBytes());
                } else {
                    if (isDebugEnabled) {
                        LOGGER.debug(String.format("[%s][keepass]attachment=%s", method, keePassPath));
                    }
                    this.secureChannel.addIdentity(SOSSFTPJCraft.class.getSimpleName(), pr, (byte[])null, (byte[])null);
                }
            }
            catch (Exception e) {
                throw new Exception(String.format("[%s][keepass]%s", method, e.toString()), e);
            }
        }
    }

    private void usePasswordMethod() throws Exception {
        LOGGER.debug("[password]");
        this.sshSession.setPassword(this.getProviderOptions().password.getValue());
    }

    private void useKeyboardInteractive() throws Exception {
        Object ui;
        boolean isDebugEnabled = LOGGER.isDebugEnabled();
        if (isDebugEnabled) {
            LOGGER.debug("useKeyboardInteractive");
        }
        if ((ui = this.getProviderOptions().user_info.value()) == null) {
            if (isDebugEnabled) {
                LOGGER.debug(String.format("use default %s implementation", SOSSFTPUserInfo.class.getSimpleName()));
            }
            ui = new SOSSFTPUserInfo();
        }
        this.sshSession.setUserInfo((UserInfo)ui);
    }

    private String usePreferredAuthentications(String debugKey, String preferredAuthentications) throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[usePreferredAuthentications][%s]preferredAuthentications=%s", debugKey, preferredAuthentications));
        }
        try {
            this.usePublicKeyMethod();
        }
        catch (Exception e) {
            LOGGER.warn(e.toString());
        }
        if (this.getProviderOptions().authMethod.isKeyboardInteractive()) {
            this.useKeyboardInteractive();
        } else {
            this.usePasswordMethod();
        }
        return preferredAuthentications;
    }

    private String useRequiredAuthentications(String requiredAuthentications) throws Exception {
        String preferredAuthentications = requiredAuthentications;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[useRequiredAuthentications]preferredAuthentications=%s", preferredAuthentications));
        }
        this.sessionConnectTimeout = 30000;
        this.sshSession.setConfig("userauth.publickey", SOSRequiredAuthPublicKey.class.getName());
        this.usePublicKeyMethod();
        if (this.getProviderOptions().authMethod.isKeyboardInteractive()) {
            this.sshSession.setConfig("userauth.keyboard-interactive", SOSRequiredAuthKeyboardInteractive.class.getName());
            this.useKeyboardInteractive();
        } else {
            this.sshSession.setConfig("userauth.password", SOSRequiredAuthPassword.class.getName());
            this.usePasswordMethod();
        }
        return preferredAuthentications;
    }

    private void doConnect() throws Exception {
        this.setKnownHostsFile();
        this.createSession();
        String preferredAuthentications = null;
        if (this.getProviderOptions().preferred_authentications.isNotEmpty()) {
            preferredAuthentications = this.usePreferredAuthentications("preferred_authentications", this.getProviderOptions().preferred_authentications.getValue());
        } else if (this.getProviderOptions().required_authentications.isNotEmpty()) {
            preferredAuthentications = this.useRequiredAuthentications(this.getProviderOptions().required_authentications.getValue());
        } else if (this.getProviderOptions().password.isNotEmpty() && this.getProviderOptions().authFile.isNotEmpty()) {
            preferredAuthentications = this.usePreferredAuthentications("password,publickey", "password,publickey");
        } else {
            preferredAuthentications = this.getProviderOptions().authMethod.getValue();
            if (this.getProviderOptions().authMethod.isPublicKey()) {
                this.usePublicKeyMethod();
            } else if (this.getProviderOptions().authMethod.isPassword()) {
                this.usePasswordMethod();
            } else if (this.getProviderOptions().authMethod.isKeyboardInteractive()) {
                this.useKeyboardInteractive();
            }
        }
        try {
            this.sshSession.setConfig("PreferredAuthentications", preferredAuthentications);
            this.setServerAlive();
            this.setSessionConnectTimeout();
            this.setChannelConnectTimeout();
            this.setConfigFromFiles();
            this.printConnectionInfos();
            this.sshSession.connect();
            if (this.getProviderOptions().protocol.getValue().equals(SOSOptionTransferType.TransferTypes.sftp.name())) {
                this.createSftpClient();
            }
        }
        catch (Exception e) {
            throw new JobSchedulerException(this.getHostID(e.getClass().getName() + " - " + e.toString()), (Throwable)e);
        }
        this.reply = "OK";
        LOGGER.info(SOSVfs_D_133.params(new Object[]{this.getProviderOptions().user.getValue()}));
        this.logReply();
    }

    private void printConnectionInfos() {
        ArrayList<String> msg = new ArrayList<String>();
        if (this.sshSession.getTimeout() > 0) {
            msg.add("SessionConnectTimeout=" + this.ms2string(this.sshSession.getTimeout()));
        }
        if (this.sshSession.getServerAliveInterval() > 0) {
            msg.add("ServerAliveInterval=" + this.ms2string(this.sshSession.getServerAliveInterval()) + ", ServerAliveCountMax=" + this.sshSession.getServerAliveCountMax());
        }
        if (this.channelConnectTimeout > 0) {
            msg.add("ChannelConnectTimeout=" + this.ms2string(this.channelConnectTimeout));
        }
        if (msg.size() > 0) {
            LOGGER.info(Joiner.on((String)", ").join(msg));
        }
    }

    private String ms2string(int val) {
        if (val <= 0) {
            return String.valueOf(val).concat("ms");
        }
        try {
            return String.valueOf(Math.round(val / 1000)).concat("s");
        }
        catch (Throwable e) {
            return String.valueOf(val).concat("ms");
        }
    }

    private void setServerAlive() {
        String sai = this.getProviderOptions().server_alive_interval.getValue();
        if (!SOSString.isEmpty((String)sai)) {
            try {
                this.sshSession.setServerAliveInterval(SOSDate.resolveAge((String)"ms", (String)sai).intValue());
                String sacm = this.getProviderOptions().server_alive_count_max.getValue();
                if (!SOSString.isEmpty((String)sacm)) {
                    this.sshSession.setServerAliveCountMax(Integer.parseInt(sacm));
                }
            }
            catch (Exception ex) {
                LOGGER.warn(String.format("[setServerAlive]%s", ex.toString()), (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setConfigFromFiles() {
        if (!SOSString.isEmpty((String)this.getProviderOptions().configuration_files.getValue())) {
            boolean isDebugEnabled = LOGGER.isDebugEnabled();
            String[] arr = this.getProviderOptions().configuration_files.getValue().split(";");
            for (int i = 0; i < arr.length; ++i) {
                String file = arr[i].trim();
                LOGGER.info(String.format("use configuration file: %s", file));
                FileInputStream in = null;
                try {
                    in = new FileInputStream(file);
                    Properties p = new Properties();
                    p.load(in);
                    for (Map.Entry<Object, Object> entry : p.entrySet()) {
                        String key = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        if (isDebugEnabled) {
                            LOGGER.debug(String.format("set configuration setting: %s = %s", key, value));
                        }
                        this.sshSession.setConfig(key, value);
                    }
                    continue;
                }
                catch (Exception ex) {
                    LOGGER.warn(String.format("error on read configuration file[%s]: %s", file, ex.toString()));
                    continue;
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
    }

    private void setSessionConnectTimeout() throws Exception {
        String ct = this.getProviderOptions().connect_timeout.getValue();
        if (!SOSString.isEmpty((String)ct)) {
            this.sessionConnectTimeout = SOSDate.resolveAge((String)"ms", (String)ct).intValue();
        }
        if (this.sessionConnectTimeout > 0) {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("session connect timeout = %s", ct == null ? Integer.valueOf(this.sessionConnectTimeout) : ct));
                }
                this.sshSession.setTimeout(this.sessionConnectTimeout);
            }
            catch (Exception ex) {
                LOGGER.warn(String.format("[setSessionConnectTimeout]%s", ex.toString()), (Throwable)ex);
            }
        }
    }

    private void setChannelConnectTimeout() throws Exception {
        String ct = this.getProviderOptions().channel_connect_timeout.getValue();
        if (!SOSString.isEmpty((String)ct)) {
            this.channelConnectTimeout = SOSDate.resolveAge((String)"ms", (String)ct).intValue();
        }
    }

    private void setKnownHostsFile() throws JSchException {
        if (this.secureChannel != null && this.getProviderOptions().strictHostKeyChecking.isTrue()) {
            File knownHostsFile = new File(System.getProperty("user.home"), ".ssh/known_hosts");
            this.secureChannel.setKnownHosts(knownHostsFile.getAbsolutePath());
        }
    }

    private void createSession() throws Exception {
        if (this.secureChannel == null) {
            throw new JobSchedulerException(SOSVfs_E_190.params(new Object[]{"secureChannel"}));
        }
        LOGGER.debug(String.format("user=%s, host=%s, port=%s", this.user, this.host, this.port));
        this.sshSession = this.secureChannel.getSession(this.user, this.host, this.port);
        Properties config = new Properties();
        config.put("StrictHostKeyChecking", this.getProviderOptions().strictHostKeyChecking.getValue());
        if (this.getProviderOptions().useZlibCompression.value()) {
            config.put("compression.s2c", "zlib@openssh.com,zlib,none");
            config.put("compression.c2s", "zlib@openssh.com,zlib,none");
            config.put("compression_level", this.getProviderOptions().zlibCompressionLevel.getValue());
            LOGGER.info(String.format("use zlib_compression: compression.s2c = %s, compression.c2s = %s, compression_level = %s", config.getProperty("compression.s2c"), config.getProperty("compression.c2s"), this.getProviderOptions().zlibCompressionLevel.getValue()));
        }
        this.sshSession.setConfig(config);
        this.setCommandsTimeout();
        this.setProxy();
    }

    private void setCommandsTimeout() throws Exception {
    }

    private void setProxy() throws Exception {
        SOSOptionProxyProtocol proxyProtocol = this.getProviderOptions().proxyProtocol;
        String proxyHost = this.getProviderOptions().proxyHost.getValue();
        String proxyUser = this.getProviderOptions().proxyUser.getValue();
        String proxyPassword = this.getProviderOptions().proxyPassword.getValue();
        int proxyPort = this.getProviderOptions().proxyPort.value();
        if (!SOSString.isEmpty((String)proxyHost)) {
            LOGGER.info(String.format("using proxy: protocol=%s, host=%s, port=%d, user=%s, pass=?", proxyProtocol.getValue(), proxyHost, proxyPort, proxyUser));
            if (proxyProtocol.isHttp()) {
                ProxyHTTP proxy = new ProxyHTTP(proxyHost, proxyPort);
                if (!SOSString.isEmpty((String)proxyUser)) {
                    proxy.setUserPasswd(proxyUser, proxyPassword);
                }
                this.sshSession.setProxy((Proxy)proxy);
            } else if (proxyProtocol.isSocks5()) {
                ProxySOCKS5 proxy = new ProxySOCKS5(proxyHost, proxyPort);
                if (!SOSString.isEmpty((String)proxyUser)) {
                    proxy.setUserPasswd(proxyUser, proxyPassword);
                }
                this.sshSession.setProxy((Proxy)proxy);
                this.sessionConnectTimeout = 30000;
            } else if (proxyProtocol.isSocks4()) {
                ProxySOCKS4 proxy = new ProxySOCKS4(proxyHost, proxyPort);
                if (!SOSString.isEmpty((String)proxyUser)) {
                    proxy.setUserPasswd(proxyUser, proxyPassword);
                }
                this.sshSession.setProxy((Proxy)proxy);
                this.sessionConnectTimeout = 30000;
            } else {
                throw new Exception(String.format("unknown proxy protocol = %s", proxyProtocol.getValue()));
            }
        }
    }

    private void createSftpClient() throws Exception {
        if (this.sshSession == null) {
            throw new JobSchedulerException(SOSVfs_E_190.params(new Object[]{"sshSession"}));
        }
        this.channelSftp = (ChannelSftp)this.sshSession.openChannel("sftp");
        this.sshSession.setConfig("compression_level", this.getProviderOptions().zlibCompressionLevel.getValue());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("createSftpClient connect timeout = %s", this.channelConnectTimeout));
        }
        if (this.channelConnectTimeout > 0) {
            this.channelSftp.connect(this.channelConnectTimeout);
        } else {
            this.channelSftp.connect();
        }
    }

    @Override
    public String getStdErr() {
        return this.stdErr.toString();
    }

    @Override
    public void resetStdErr() {
        this.stdErr = null;
    }

    @Override
    public String getStdOut() {
        return this.stdOut.toString();
    }

    @Override
    public void resetStdOut() {
        this.stdOut = null;
    }

    @Override
    public Integer getExitCode() {
        return this.exitCode;
    }

    @Override
    public String getExitSignal() {
        return this.exitSignal;
    }

    @Override
    public long putFile(String source, String target) {
        try {
            Instant start = Instant.now();
            this.channelSftp.put(source, SOSSFTPJCraft.normalizePath(target), 0);
            Instant end = Instant.now();
            this.reply = "put OK (" + SOSDate.getDuration((Instant)start, (Instant)end) + ")";
            LOGGER.info(this.getHostID(SOSVfs_I_183.params(new Object[]{"putFile", source, target, this.getReplyString()})));
            long size = this.size(target);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("[put][%s]size=%s", target, size));
            }
            return size;
        }
        catch (Exception e) {
            this.reply = e.toString();
            throw new JobSchedulerException(SOSVfs_E_185.params(new Object[]{"putFile()", source, target}), (Throwable)e);
        }
    }

    @Override
    public void putFile(File source, String target, int chmod) throws Exception {
        this.putFile(source.getCanonicalPath(), target);
        this.channelSftp.chmod(chmod, target);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[put][%s]chmod=%s", target, chmod));
        }
    }

    @Override
    public void get(String source, String target) {
        try {
            Instant start = Instant.now();
            this.channelSftp.get(source, SOSSFTPJCraft.normalizePath(target));
            Instant end = Instant.now();
            this.reply = "get OK (" + SOSDate.getDuration((Instant)start, (Instant)end) + ")";
            LOGGER.info(this.getHostID(SOSVfs_I_183.params(new Object[]{"get", source, target, this.getReplyString()})));
        }
        catch (Exception e) {
            this.reply = e.toString();
            throw new JobSchedulerException(SOSVfs_E_185.params(new Object[]{"get()", source, target}), (Throwable)e);
        }
    }

    @Override
    public SOSSSHServerInfo getSSHServerInfo() {
        if (this.serverInfo == null) {
            this.serverInfo = new SOSSSHServerInfo(null, this.executeResultCommand("uname"));
        }
        return this.serverInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SOSCommandResult executeResultCommand(String cmd) {
        boolean isDebugEnabled;
        SOSCommandResult result;
        block52: {
            BufferedReader errReader;
            InputStream err;
            ChannelExec channel;
            block51: {
                channel = null;
                InputStream in = null;
                err = null;
                errReader = null;
                result = new SOSCommandResult(cmd);
                try {
                    cmd = cmd.trim();
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace(String.format("[cmd]%s", cmd));
                    }
                    channel = (ChannelExec)this.sshSession.openChannel("exec");
                    channel.setPty(this.isSimulateShell());
                    channel.setCommand(cmd);
                    channel.setInputStream(null);
                    channel.setErrStream(null);
                    in = channel.getInputStream();
                    err = channel.getErrStream();
                    channel.connect(this.channelConnectTimeout);
                    byte[] tmp23332 = new byte[1024];
                    while (true) {
                        int i233332;
                        if (in.available() > 0 && (i233332 = in.read(tmp23332, 0, 1024)) >= 0) {
                            result.addStdOut(new String(tmp23332, 0, i233332));
                            continue;
                        }
                        if (channel.isClosed()) {
                            if (in.available() > 0) continue;
                            result.setExitCode(channel.getExitStatus());
                            errReader = new BufferedReader(new InputStreamReader(err));
                            break;
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Throwable i233332) {}
                    }
                }
                catch (Throwable e22222) {
                    boolean isDebugEnabled2;
                    block49: {
                        block48: {
                            try {
                                result.setException(e22222);
                                if (in == null) break block48;
                            }
                            catch (Throwable throwable) {
                                boolean isDebugEnabled22;
                                block50: {
                                    if (in != null) {
                                        try {
                                            in.close();
                                        }
                                        catch (Throwable throwable2) {
                                            // empty catch block
                                        }
                                    }
                                    if (errReader != null) {
                                        try {
                                            errReader.close();
                                        }
                                        catch (Throwable throwable3) {
                                            // empty catch block
                                        }
                                    }
                                    if (err != null) {
                                        try {
                                            err.close();
                                        }
                                        catch (Throwable throwable4) {
                                            // empty catch block
                                        }
                                    }
                                    isDebugEnabled22 = LOGGER.isDebugEnabled();
                                    if (channel != null) {
                                        try {
                                            channel.disconnect();
                                        }
                                        catch (Throwable ex) {
                                            if (!isDebugEnabled22) break block50;
                                            LOGGER.debug(String.format("[executeResultCommand][disconnect]%s", ex.toString()), ex);
                                        }
                                    }
                                }
                                if (!isDebugEnabled22) throw throwable;
                                LOGGER.debug(result.toString());
                                throw throwable;
                            }
                            try {
                                in.close();
                            }
                            catch (Throwable e22222) {
                                // empty catch block
                            }
                        }
                        if (errReader != null) {
                            try {
                                errReader.close();
                            }
                            catch (Throwable e22222) {
                                // empty catch block
                            }
                        }
                        if (err != null) {
                            try {
                                err.close();
                            }
                            catch (Throwable e22222) {
                                // empty catch block
                            }
                        }
                        isDebugEnabled2 = LOGGER.isDebugEnabled();
                        if (channel != null) {
                            try {
                                channel.disconnect();
                            }
                            catch (Throwable ex) {
                                if (!isDebugEnabled2) break block49;
                                LOGGER.debug(String.format("[executeResultCommand][disconnect]%s", ex.toString()), ex);
                            }
                        }
                    }
                    if (!isDebugEnabled2) return result;
                    LOGGER.debug(result.toString());
                    return result;
                }
                while (true) {
                    String line;
                    if ((line = errReader.readLine()) == null) {
                        if (in != null) {
                            break;
                        }
                        break block51;
                    }
                    result.addStdErr(line + this.lineSeparator);
                }
                try {
                    in.close();
                }
                catch (Throwable tmp23332) {
                    // empty catch block
                }
            }
            if (errReader != null) {
                try {
                    errReader.close();
                }
                catch (Throwable tmp23332) {
                    // empty catch block
                }
            }
            if (err != null) {
                try {
                    err.close();
                }
                catch (Throwable tmp23332) {
                    // empty catch block
                }
            }
            isDebugEnabled = LOGGER.isDebugEnabled();
            if (channel != null) {
                try {
                    channel.disconnect();
                }
                catch (Throwable ex) {
                    if (!isDebugEnabled) break block52;
                    LOGGER.debug(String.format("[executeResultCommand][disconnect]%s", ex.toString()), ex);
                }
            }
        }
        if (!isDebugEnabled) return result;
        LOGGER.debug(result.toString());
        return result;
    }

    @Override
    public boolean isSimulateShell() {
        return this.simulateShell;
    }

    @Override
    public void setSimulateShell(boolean val) {
        this.simulateShell = val;
    }

    protected ChannelSftp getChannelSftp() {
        return this.channelSftp;
    }
}

