/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.sftp.sshj;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.i18n.annotation.I18NResourceBundle;
import com.sos.vfs.common.SOSCommonProviderFile;
import com.sos.vfs.sftp.sshj.SOSSFTPSSHJ;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.schmizz.sshj.sftp.FileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@I18NResourceBundle(baseName="SOSVirtualFileSystem", defaultLocale="en")
public class SOSSFTPFileSSHJ
extends SOSCommonProviderFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSSFTPFileSSHJ.class);

    public SOSSFTPFileSSHJ(String fileName) {
        super(fileName);
    }

    @Override
    public int read(byte[] buffer) {
        try {
            InputStream is = this.getFileInputStream();
            if (is == null) {
                throw new Exception(SOSVfs_E_177.get());
            }
            return is.read(buffer);
        }
        catch (Exception e) {
            throw new JobSchedulerException(SOSVfs_E_173.params(new Object[]{"read", this.fileName}), (Throwable)e);
        }
    }

    @Override
    public InputStream getFileInputStream() {
        try {
            if (this.getInputStream() == null) {
                this.fileName = this.adjustRelativePathName(this.fileName);
                SOSSFTPSSHJ handler = (SOSSFTPSSHJ)this.getProvider();
                this.setInputStream(handler.getInputStream(this.fileName));
            }
        }
        catch (Exception e) {
            throw new JobSchedulerException(SOSVfs_E_158.params(new Object[]{"getFileInputStream()", this.fileName}), (Throwable)e);
        }
        return this.getInputStream();
    }

    @Override
    public void write(byte[] buffer, int offset, int length) {
        try {
            OutputStream os = this.getFileOutputStream();
            if (os == null) {
                throw new Exception(SOSVfs_E_147.get());
            }
            os.write(buffer, offset, length);
        }
        catch (Exception e) {
            throw new JobSchedulerException(SOSVfs_E_173.params(new Object[]{"write", this.fileName}), (Throwable)e);
        }
    }

    @Override
    public void write(byte[] buffer) {
        try {
            this.getFileOutputStream().write(buffer);
        }
        catch (IOException e) {
            throw new JobSchedulerException(SOSVfs_E_134.params(new Object[]{"write()"}), (Throwable)e);
        }
    }

    private OutputStream getFileOutputStream() {
        try {
            if (this.getOutputStream() == null) {
                this.fileName = this.adjustRelativePathName(this.fileName);
                this.setOutputStream(this.getProvider().getOutputStream(this.fileName, this.isModeAppend(), this.isModeRestart()));
            }
        }
        catch (Exception e) {
            throw new JobSchedulerException(SOSVfs_E_158.params(new Object[]{"getFileOutputStream()", this.fileName}), (Throwable)e);
        }
        return this.getOutputStream();
    }

    @Override
    public long getModificationDateTime() {
        String path = "";
        try {
            path = this.adjustRelativePathName(this.fileName);
            SOSSFTPSSHJ handler = (SOSSFTPSSHJ)this.getProvider();
            FileAttributes attrs = handler.getFileAttributes(path);
            if (attrs == null) {
                throw new Exception("FileAttributes is null");
            }
            return attrs.getMtime() * 1000L;
        }
        catch (Exception e) {
            LOGGER.error(String.format("[%s]%s", path, e.toString()), (Throwable)e);
            return -1L;
        }
    }

    @Override
    public long setModificationDateTime(long millis) {
        if (millis <= 0L) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("[%s][skip]setModificationDateTime=%s", this.fileName, millis));
            }
            return millis;
        }
        try {
            SOSSFTPSSHJ handler = (SOSSFTPSSHJ)this.getProvider();
            String path = this.adjustRelativePathName(this.fileName);
            FileAttributes attrs = handler.getFileAttributes(path);
            if (attrs == null) {
                throw new Exception("FileAttributes is null");
            }
            long seconds = millis / 1000L;
            FileAttributes newattrs = new FileAttributes.Builder().withAtimeMtime(attrs.getAtime(), seconds).build();
            handler.getSFTPClient().setattr(path, newattrs);
            return millis;
        }
        catch (Exception e) {
            LOGGER.error(String.format("[%s][%s]%s", this.fileName, millis, e.toString()), (Throwable)e);
            return -1L;
        }
    }
}

