/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.sftp.sshj.common.proxy;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.charset.Charset;
import sos.util.SOSString;

public class Proxy {
    private final java.net.Proxy proxy;
    private final String host;
    private final String user;
    private final String password;
    private final int connectTimeout;
    private int port;
    private Charset charset = Charset.defaultCharset();

    public Proxy(Proxy.Type type, String host, int port, String user, String password, int connectTimeout) {
        this.host = host;
        this.user = user;
        this.password = password;
        this.connectTimeout = connectTimeout;
        this.setPort(type, port);
        this.proxy = new java.net.Proxy(type, new InetSocketAddress(this.host, this.port));
    }

    public java.net.Proxy getProxy() {
        return this.proxy;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setCharset(Charset val) {
        this.charset = val;
    }

    public Charset getCharset() {
        return this.charset;
    }

    private void setPort(Proxy.Type type, int port) {
        if (port <= 0) {
            switch (type) {
                case HTTP: {
                    port = 80;
                }
                case SOCKS: {
                    port = 1080;
                }
            }
        }
        this.port = port;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[");
        if (this.proxy != null) {
            sb.append("type=").append((Object)this.proxy.type());
        }
        sb.append(",host=").append(this.host);
        sb.append(",port=").append(this.port);
        sb.append(",user=").append(this.user);
        if (!SOSString.isEmpty((String)this.password)) {
            sb.append(",password=********");
        }
        sb.append(",charset=").append(this.charset);
        sb.append(",connectTimeout=").append(this.connectTimeout).append("ms");
        sb.append("]");
        return sb.toString();
    }
}

