/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.smb.smbj;

import com.hierynomus.msdtyp.AccessMask;
import com.hierynomus.msdtyp.FileTime;
import com.hierynomus.mserref.NtStatus;
import com.hierynomus.msfscc.FileAttributes;
import com.hierynomus.msfscc.fileinformation.FileAllInformation;
import com.hierynomus.msfscc.fileinformation.FileBasicInformation;
import com.hierynomus.msfscc.fileinformation.FileIdBothDirectoryInformation;
import com.hierynomus.msfscc.fileinformation.FileSettableInformation;
import com.hierynomus.mssmb2.SMB2CreateDisposition;
import com.hierynomus.mssmb2.SMB2CreateOptions;
import com.hierynomus.mssmb2.SMB2Dialect;
import com.hierynomus.mssmb2.SMB2ShareAccess;
import com.hierynomus.mssmb2.SMBApiException;
import com.hierynomus.protocol.commons.EnumWithValue;
import com.hierynomus.smbj.SMBClient;
import com.hierynomus.smbj.SmbConfig;
import com.hierynomus.smbj.auth.AuthenticationContext;
import com.hierynomus.smbj.connection.Connection;
import com.hierynomus.smbj.session.Session;
import com.hierynomus.smbj.share.DiskShare;
import com.hierynomus.smbj.share.File;
import com.hierynomus.smbj.utils.SmbFiles;
import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.i18n.annotation.I18NResourceBundle;
import com.sos.vfs.common.SOSCommonProvider;
import com.sos.vfs.common.SOSFileEntry;
import com.sos.vfs.common.interfaces.ISOSProviderFile;
import com.sos.vfs.smb.common.ASOSSMB;
import com.sos.vfs.smb.common.ISOSSMB;
import com.sos.vfs.smb.smbj.SOSSMBJFile;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSDate;
import sos.util.SOSString;

@I18NResourceBundle(baseName="SOSVirtualFileSystem", defaultLocale="en")
public class SOSSMBJ
extends ASOSSMB
implements ISOSSMB {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSSMBJ.class);
    private static final String WIN_PATH_SEPARATOR = "\\";
    private static final String UNIX_PATH_SEPARATOR = "/";
    private SMBClient client = null;
    private Connection connection = null;
    private Session session = null;
    private DiskShare diskShare;
    private String shareName;
    private boolean accessMaskMaximumAllowed = false;
    private String pathSeparator;

    @Override
    public void doConnect() throws Exception {
        try {
            this.createClient();
            this.connection = this.client.connect(this.host, this.port);
            this.session = this.connection.authenticate(this.getAuthenticationContext());
        }
        catch (Throwable ex) {
            throw new JobSchedulerException(this.getLogPrefix(), ex);
        }
    }

    @Override
    public void doDisconnect() throws Exception {
        try {
            if (this.diskShare != null) {
                this.diskShare.close();
            }
            if (this.session != null) {
                this.session.close();
            }
            if (this.connection != null) {
                this.connection.close(true);
            }
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            this.close((AutoCloseable)this.diskShare);
            this.close((AutoCloseable)this.session);
            this.close((Closeable)this.connection);
            this.close((Closeable)this.client);
            this.diskShare = null;
            this.session = null;
            this.connection = null;
            this.client = null;
        }
    }

    @Override
    public boolean fileExists(String path) {
        this.tryConnectShare("fileExists", path);
        boolean result = this.diskShare.fileExists(this.getSmbPath(path));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[%s]fileExists=%s", path, result));
        }
        return result;
    }

    @Override
    public boolean directoryExists(String path) {
        return this.isDirectory(path);
    }

    @Override
    public long size(String path) throws Exception {
        this.tryConnectShare("size", path);
        long size = -1L;
        try (File f = this.openFile2Read(path);){
            if (f != null) {
                size = this.getSize(f.getFileInformation());
            }
        }
        catch (SMBApiException e) {
            switch (NtStatus.valueOf((long)e.getStatusCode())) {
                case STATUS_OBJECT_NAME_NOT_FOUND: {
                    break;
                }
                default: {
                    throw e;
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[%s]size=%s", path, size));
        }
        return size;
    }

    @Override
    public boolean isDirectory(String path) {
        this.tryConnectShare("isDirectory", path);
        try {
            boolean r = this.diskShare.getFileInformation(this.getSmbPath(path)).getStandardInformation().isDirectory();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("%s[isDirectory][%s]%s", this.getLogPrefix(), path, r));
            }
            return r;
        }
        catch (Throwable e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("%s[isDirectory][%s][exception]%s", this.getLogPrefix(), path, e.toString()));
            }
            return false;
        }
    }

    @Override
    public void mkdir(String path) {
        try {
            this.tryConnectShare("mkdir", path);
            new SmbFiles().mkdirs(this.diskShare, this.getSmbPath(path));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("%s[mkdir][%s]created", this.getLogPrefix(), path));
            }
            this.reply = "OK";
        }
        catch (JobSchedulerException e) {
            this.reply = e.toString();
            throw e;
        }
        catch (Throwable e) {
            this.reply = e.toString();
            throw new JobSchedulerException(String.format("%s[mkdir][%s]%s", this.getLogPrefix(), path, this.reply), e);
        }
    }

    @Override
    public void rmdir(String path) {
        try {
            this.tryConnectShare("rmdir", path);
            this.diskShare.rmdir(this.getSmbPath(path), true);
            this.reply = "rmdir OK";
            LOGGER.info(String.format("%s[rmdir][%s]%s", this.getLogPrefix(), path, this.getReplyString()));
        }
        catch (JobSchedulerException e) {
            this.reply = e.toString();
            throw e;
        }
        catch (Throwable e) {
            this.reply = e.toString();
            throw new JobSchedulerException(String.format("%s[rmdir][%s]%s", this.getLogPrefix(), path, this.reply), e);
        }
    }

    @Override
    public void delete(String path, boolean checkIsDirectory) {
        try {
            this.tryConnectShare("delete", path);
            this.diskShare.rm(this.getSmbPath(path));
            this.reply = "rm OK";
            LOGGER.info(String.format("%s[rm][%s]%s", this.getLogPrefix(), path, this.getReplyString()));
        }
        catch (JobSchedulerException e) {
            this.reply = e.toString();
            throw e;
        }
        catch (Throwable e) {
            this.reply = e.toString();
            throw new JobSchedulerException(String.format("%s[rm][%s]%s", this.getLogPrefix(), path, this.reply), e);
        }
    }

    @Override
    public void rename(String from, String to) {
        try {
            this.tryConnectShare("rename", from);
            try (File f = this.openExistingFile4Rename(from);){
                if (f != null) {
                    f.rename(this.getSmbPath(to));
                }
            }
            this.reply = "rename OK";
            LOGGER.info(String.format("%s[rename][%s][%s]%s", this.getLogPrefix(), from, to, this.getReplyString()));
        }
        catch (JobSchedulerException e) {
            this.reply = e.toString();
            throw e;
        }
        catch (Throwable e) {
            this.reply = e.toString();
            throw new JobSchedulerException(String.format("%s[rename][%s][%s]%s", this.getLogPrefix(), from, to, this.reply), e);
        }
    }

    @Override
    public SOSFileEntry getFileEntry(String path) throws Exception {
        this.tryConnectShare("getFileEntry", path);
        try (File f = this.openFile2Read(path);){
            if (f != null) {
                SOSFileEntry sOSFileEntry = this.getFileEntry(f.getFileInformation(), this.getParent(path));
                return sOSFileEntry;
            }
        }
        return null;
    }

    private SOSFileEntry getFileEntry(FileAllInformation fi, String parentPath) throws Exception {
        SOSFileEntry entry = new SOSFileEntry(SOSFileEntry.EntryType.SMB);
        entry.setDirectory(fi.getStandardInformation().isDirectory());
        entry.setFilename(SOSCommonProvider.getBaseNameFromPath(SOSSMBJ.normalizePath(fi.getNameInformation())));
        entry.setFilesize(this.getSize(fi));
        entry.setParentPath(parentPath);
        return entry;
    }

    private SOSFileEntry getFileEntry(FileIdBothDirectoryInformation fi, String parentPath) throws Exception {
        SOSFileEntry entry = new SOSFileEntry(SOSFileEntry.EntryType.SMB);
        entry.setDirectory(EnumWithValue.EnumUtils.isSet((long)fi.getFileAttributes(), (EnumWithValue)FileAttributes.FILE_ATTRIBUTE_DIRECTORY));
        entry.setFilename(fi.getFileName());
        entry.setFilesize(this.getSize(fi));
        entry.setParentPath(parentPath);
        return entry;
    }

    @Override
    public List<SOSFileEntry> listNames(String path, int maxFiles, boolean checkIfExists, boolean checkIfIsDirectory) {
        this.tryConnectShare("listNames", path);
        try {
            ArrayList<SOSFileEntry> result = new ArrayList<SOSFileEntry>();
            if (checkIfExists && !this.directoryExists(path)) {
                return result;
            }
            if (checkIfIsDirectory && !this.isDirectory(path)) {
                this.reply = "ls OK";
                return result;
            }
            List list = this.diskShare.list(this.getSmbPath(path));
            for (FileIdBothDirectoryInformation fin : list) {
                if (fin.getFileName() == null || fin.getFileName().equals(".") || fin.getFileName().equals("..")) continue;
                result.add(this.getFileEntry(fin, path));
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(String.format("[%s][listNames]%s files or folders", path, result.size()));
            }
            this.reply = "ls OK";
            return result;
        }
        catch (JobSchedulerException e) {
            this.reply = e.toString();
            throw e;
        }
        catch (Throwable e) {
            this.reply = e.toString();
            throw new JobSchedulerException(this.reply, e);
        }
    }

    @Override
    public InputStream getInputStream(String path) {
        return ((SOSSMBJFile)this.getFile(path)).getFileInputStream();
    }

    @Override
    public OutputStream getOutputStream(String path, boolean append, boolean resume) {
        return ((SOSSMBJFile)this.getFile(path)).getFileOutputStream();
    }

    @Override
    public String getModificationDateTime(String path) {
        String r = null;
        try {
            this.tryConnectShare("getModificationDateTime", path);
            try (File f = this.openFile2Read(path);){
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                r = df.format(f.getFileInformation().getBasicInformation().getLastWriteTime().toDate());
            }
        }
        catch (Throwable e) {
            LOGGER.error(String.format("%s[getModificationDateTime][%s]%s", this.getLogPrefix(), path, e.toString()), e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("%s[%s]getModificationDateTime=%s", this.getLogPrefix(), path, r));
        }
        return r;
    }

    @Override
    public long getModificationTimeStamp(String path) throws Exception {
        long r = -1L;
        try {
            this.tryConnectShare("getModificationTimeStamp", path);
            try (File f = this.openFile2Read(path);){
                r = f.getFileInformation().getBasicInformation().getLastWriteTime().toEpochMillis();
            }
        }
        catch (Throwable e) {
            LOGGER.error(String.format("%s[getModificationTimeStamp][%s]%s", this.getLogPrefix(), path, e.toString()), e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[%s]getModificationTimeStamp=%s", path, r));
        }
        return r;
    }

    @Override
    public void setModificationTimeStamp(String path, long millis) throws Exception {
        if (millis <= 0L) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("[%s][skip]setModificationTimeStamp=%s", path, millis));
            }
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[%s]setModificationTimeStamp=%s", path, millis));
        }
        try {
            this.tryConnectShare("setModificationTimeStamp", path);
            try (File f = this.openExistingFile2Write(path);){
                FileBasicInformation current = f.getFileInformation().getBasicInformation();
                FileTime ft = FileTime.ofEpochMillis((long)millis);
                f.setFileInformation((FileSettableInformation)new FileBasicInformation(current.getCreationTime(), ft, ft, ft, current.getFileAttributes()));
            }
        }
        catch (Throwable e) {
            LOGGER.error(String.format("%s[setModificationTimeStamp][%s][%s]%s", this.getLogPrefix(), path, millis, e.toString()), e);
        }
    }

    @Override
    public ISOSProviderFile getFile(String fileName) {
        fileName = this.adjustFileSeparator(fileName);
        SOSSMBJFile file = new SOSSMBJFile(fileName);
        file.setProvider(this);
        return file;
    }

    protected File openFile2Read(String path) {
        return this.openFile(path, AccessMask.GENERIC_READ, SMB2CreateDisposition.FILE_OPEN);
    }

    private File openExistingFile2Write(String path) {
        return this.openFile(path, AccessMask.GENERIC_WRITE, SMB2CreateDisposition.FILE_OPEN);
    }

    protected File openFile2Write(String path, boolean append) {
        this.tryConnectShare("openFile2Write", path);
        SMB2CreateDisposition cd = append ? SMB2CreateDisposition.FILE_OPEN_IF : SMB2CreateDisposition.FILE_OVERWRITE_IF;
        return this.openFile(path, AccessMask.GENERIC_WRITE, cd);
    }

    private File openExistingFile4Rename(String path) {
        HashSet<AccessMask> ams = new HashSet<AccessMask>();
        if (this.accessMaskMaximumAllowed) {
            ams.add(AccessMask.MAXIMUM_ALLOWED);
        } else {
            ams.add(AccessMask.GENERIC_WRITE);
            ams.add(AccessMask.DELETE);
        }
        HashSet<FileAttributes> fa = new HashSet<FileAttributes>();
        fa.add(FileAttributes.FILE_ATTRIBUTE_NORMAL);
        HashSet sa = new HashSet();
        sa.addAll(SMB2ShareAccess.ALL);
        HashSet<SMB2CreateOptions> co = new HashSet<SMB2CreateOptions>();
        co.add(SMB2CreateOptions.FILE_NON_DIRECTORY_FILE);
        return this.diskShare.openFile(this.getSmbPath(path), ams, fa, sa, SMB2CreateDisposition.FILE_OPEN, co);
    }

    private File openFile(String path, AccessMask accessMask, SMB2CreateDisposition createDisposition) {
        HashSet<AccessMask> ams = new HashSet<AccessMask>();
        if (this.accessMaskMaximumAllowed) {
            ams.add(AccessMask.MAXIMUM_ALLOWED);
        } else {
            ams.add(accessMask);
        }
        HashSet sa = new HashSet();
        sa.addAll(SMB2ShareAccess.ALL);
        HashSet<SMB2CreateOptions> co = new HashSet<SMB2CreateOptions>();
        co.add(SMB2CreateOptions.FILE_WRITE_THROUGH);
        return this.diskShare.openFile(this.getSmbPath(path), ams, null, sa, createDisposition, co);
    }

    private void tryConnectShare(String caller, String path) {
        try {
            if (this.diskShare == null || !this.diskShare.isConnected()) {
                this.diskShare = (DiskShare)this.session.connectShare(this.getShareName(path));
            }
            this.setPathSeparator();
        }
        catch (Throwable e) {
            String msg = "[" + caller + "][tryConnectShare][" + path + "]" + e.toString();
            LOGGER.error(msg, e);
            throw new JobSchedulerException(msg, e);
        }
    }

    private void setPathSeparator() {
        if (this.pathSeparator == null) {
            String ni = null;
            try {
                ni = this.diskShare.getFileInformation("").getNameInformation();
                if (ni != null && ni.contains(UNIX_PATH_SEPARATOR)) {
                    this.pathSeparator = UNIX_PATH_SEPARATOR;
                }
            }
            catch (Throwable e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[setPathSeparator][diskShare nameInformation=" + ni + "]" + e, e);
                }
            }
            finally {
                if (this.pathSeparator == null) {
                    this.pathSeparator = WIN_PATH_SEPARATOR;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.info("[setPathSeparator][diskShare nameInformation=" + ni + "]pathSeparator=" + this.pathSeparator);
                }
            }
        }
    }

    private String getShareName(String path) {
        if (this.shareName == null) {
            if (path == null) {
                this.shareName = "";
            } else {
                String p = SOSSMBJ.normalizePath(path);
                p = p.startsWith(UNIX_PATH_SEPARATOR) ? p.substring(1) : p;
                String[] arr = p.split(UNIX_PATH_SEPARATOR);
                this.shareName = arr.length == 0 ? "" : arr[0];
            }
        }
        return this.shareName;
    }

    private String getSmbPath(String path) {
        String p = SOSSMBJ.normalizePath(path);
        p = p.startsWith(UNIX_PATH_SEPARATOR) ? p.substring(1) : p;
        int snl = this.getShareName(path).length();
        if (snl > 0 && p.length() > snl) {
            p = p.substring(snl + 1);
        }
        String string = p = p.endsWith(UNIX_PATH_SEPARATOR) ? p.substring(0, p.length() - 1) : p;
        if (this.pathSeparator.equals(WIN_PATH_SEPARATOR)) {
            p = p.replace(UNIX_PATH_SEPARATOR, WIN_PATH_SEPARATOR);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[getSmbPath][path=%s]smbPath=%s", path, p));
        }
        return p;
    }

    private void createClient() throws Exception {
        SmbConfig.Builder b = SmbConfig.builder();
        Properties p = this.setConfigFromFiles(b);
        this.setConnectTimeout(b);
        try {
            SmbConfig config = b.build();
            if (LOGGER.isDebugEnabled()) {
                List<String> excluded = Arrays.asList("authenticators;socketFactory;random;securityProvider;transportLayerFactory;clientGSSContextConfig;ntlmConfig".split(";"));
                LOGGER.debug(String.format("%s[createClient][config]%s", this.getLogPrefix(), SOSString.toString((Object)config, excluded)));
            }
            this.client = new SMBClient(config);
        }
        catch (Throwable e) {
            if (p.size() > 0) {
                LOGGER.info(String.format("%s[createClient][config]%s", this.getLogPrefix(), p));
            }
            throw e;
        }
    }

    private AuthenticationContext getAuthenticationContext() {
        char[] p = SOSString.isEmpty((String)this.getProviderOptions().password.getValue()) ? new char[]{} : this.getProviderOptions().password.getValue().toCharArray();
        return new AuthenticationContext(this.user, p, this.getDomain());
    }

    private Properties setConfigFromFiles(SmbConfig.Builder b) {
        Properties p = this.getConfigFromFiles(new Properties());
        if (p.size() > 0) {
            p.entrySet().forEach(e -> {
                String key = e.getKey().toString().trim();
                String val = e.getValue().toString().trim();
                try {
                    switch (key) {
                        case "workStationName": {
                            b.withWorkStationName(val);
                            break;
                        }
                        case "soTimeout": {
                            long t = SOSDate.resolveAge((String)"ms", (String)val);
                            b.withSoTimeout(t, TimeUnit.MILLISECONDS);
                            break;
                        }
                        case "timeout": {
                            long t = SOSDate.resolveAge((String)"ms", (String)val);
                            b.withTimeout(t, TimeUnit.MILLISECONDS);
                            break;
                        }
                        case "readTimeout": {
                            long t = SOSDate.resolveAge((String)"ms", (String)val);
                            b.withReadTimeout(t, TimeUnit.MILLISECONDS);
                            break;
                        }
                        case "transactTimeout": {
                            long t = SOSDate.resolveAge((String)"ms", (String)val);
                            b.withTransactTimeout(t, TimeUnit.MILLISECONDS);
                            break;
                        }
                        case "writeTimeout": {
                            long t = SOSDate.resolveAge((String)"ms", (String)val);
                            b.withWriteTimeout(t, TimeUnit.MILLISECONDS);
                            break;
                        }
                        case "bufferSize": {
                            b.withBufferSize(Integer.parseInt(val));
                            break;
                        }
                        case "readBufferSize": {
                            b.withReadBufferSize(Integer.parseInt(val));
                            break;
                        }
                        case "transactBufferSize": {
                            b.withTransactBufferSize(Integer.parseInt(val));
                            break;
                        }
                        case "writeBufferSize": {
                            b.withWriteBufferSize(Integer.parseInt(val));
                            break;
                        }
                        case "dialects": {
                            List l = Arrays.stream(val.split(";")).map(d -> SMB2Dialect.valueOf((String)d.trim())).collect(Collectors.toList());
                            b.withDialects(l);
                            break;
                        }
                        case "signingRequired": {
                            b.withSigningRequired(Boolean.parseBoolean(val));
                            break;
                        }
                        case "dfsEnabled": {
                            b.withDfsEnabled(Boolean.parseBoolean(val));
                            break;
                        }
                        case "multiProtocolNegotiate": {
                            b.withMultiProtocolNegotiate(Boolean.parseBoolean(val));
                            break;
                        }
                        case "encryptData": {
                            b.withEncryptData(Boolean.parseBoolean(val));
                            break;
                        }
                        case "sossmbj.accessMaskMaximumAllowed": {
                            this.accessMaskMaximumAllowed = Boolean.parseBoolean(val);
                            break;
                        }
                        case "sossmbj.pathSeparator": {
                            this.pathSeparator = val;
                        }
                    }
                }
                catch (Throwable te) {
                    LOGGER.warn(String.format("[setConfigFromFiles][%s=%s]%s", key, val, te.toString()), te);
                }
            });
        }
        return p;
    }

    private void setConnectTimeout(SmbConfig.Builder b) {
        String ct = this.getProviderOptions().connect_timeout.getValue();
        if (!SOSString.isEmpty((String)ct)) {
            try {
                long t = SOSDate.resolveAge((String)"ms", (String)ct);
                if (t > 0L) {
                    b.withSoTimeout(t, TimeUnit.MILLISECONDS);
                }
            }
            catch (Exception ex) {
                LOGGER.warn(String.format("%s[setConnectTimeout][%s]%s", this.getLogPrefix(), ct, ex.toString()), (Throwable)ex);
            }
        }
    }

    private void close(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void close(AutoCloseable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private long getSize(FileAllInformation fi) {
        if (fi == null) {
            return -1L;
        }
        return fi.getStandardInformation().getEndOfFile();
    }

    private long getSize(FileIdBothDirectoryInformation fi) {
        if (fi == null) {
            return -1L;
        }
        return fi.getEndOfFile();
    }
}

