/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.webdav.jackrabbit;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.i18n.annotation.I18NResourceBundle;
import com.sos.vfs.common.SOSCommonProviderFile;
import com.sos.vfs.webdav.jackrabbit.SOSWebDAV;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@I18NResourceBundle(baseName="SOSVirtualFileSystem", defaultLocale="en")
public class SOSWebDAVFile
extends SOSCommonProviderFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSWebDAVFile.class);
    private String fileName = null;

    public SOSWebDAVFile(String path) {
        super(path);
        this.fileName = path;
    }

    @Override
    public String getName() {
        return this.fileName;
    }

    @Override
    public int read(byte[] buffer) {
        try {
            InputStream is = this.getFileInputStream();
            if (is == null) {
                throw new JobSchedulerException(SOSVfs_E_177.get());
            }
            return is.read(buffer);
        }
        catch (Exception e) {
            throw new JobSchedulerException(SOSVfs_E_173.params(new Object[]{"read", this.fileName}), (Throwable)e);
        }
    }

    @Override
    public void write(byte[] buffer, int offset, int length) {
        try {
            if (this.getOutputStream() == null) {
                this.setOutputStream(this.getProvider().getOutputStream(this.fileName, this.isModeAppend(), this.isModeRestart()));
            }
            if (this.getOutputStream() == null) {
                throw new Exception(SOSVfs_E_147.get());
            }
            this.getOutputStream().write(buffer, offset, length);
        }
        catch (Exception e) {
            throw new JobSchedulerException(SOSVfs_E_173.params(new Object[]{"write", this.fileName}), (Throwable)e);
        }
    }

    @Override
    public void write(byte[] bteBuffer) {
        try {
            if (this.getOutputStream() == null) {
                this.setOutputStream(this.getProvider().getOutputStream(this.fileName, this.isModeAppend(), this.isModeRestart()));
            }
            if (this.getOutputStream() == null) {
                throw new Exception(SOSVfs_E_147.get());
            }
            this.getOutputStream().write(bteBuffer);
        }
        catch (Exception e) {
            throw new JobSchedulerException(SOSVfs_E_173.params(new Object[]{"write", this.fileName}), (Throwable)e);
        }
    }

    @Override
    public long setModificationDateTime(long timeStamp) {
        return -1L;
    }

    @Override
    public long getModificationDateTime() {
        try {
            SOSWebDAV handler = (SOSWebDAV)this.getProvider();
            return handler.getModificationTimeStamp(this.fileName);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return -1L;
        }
    }
}

