/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.webdav.webdavclient4j;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.Options.SOSOptionFolderName;
import com.sos.i18n.annotation.I18NResourceBundle;
import com.sos.vfs.common.SOSCommonProvider;
import com.sos.vfs.common.SOSFileEntry;
import com.sos.vfs.common.interfaces.ISOSProviderFile;
import com.sos.vfs.common.options.SOSProviderOptions;
import com.sos.vfs.webdav.common.ISOSWebDAV;
import com.sos.vfs.webdav.webdavclient4j.SOSWebDAVFile;
import com.sos.vfs.webdav.webdavclient4j.common.SOSWebDAVOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpURL;
import org.apache.commons.httpclient.HttpsURL;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.contrib.ssl.StrictSSLProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.ssl.TrustChain;
import org.apache.commons.ssl.TrustMaterial;
import org.apache.webdav.lib.WebdavResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSString;

@I18NResourceBundle(baseName="SOSVirtualFileSystem", defaultLocale="en")
public class SOSWebDAV
extends SOSCommonProvider
implements ISOSWebDAV {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSWebDAV.class);
    private HttpURL rootUrl = null;
    private String path = null;
    private WebdavResource davClient = null;
    private String host = null;
    private int port = 0;
    private String userName = null;
    private String password = null;
    private String proxyHost = null;
    private int proxyPort = 0;
    private String proxyUser = null;
    private String proxyPassword = null;

    @Override
    public void connect(SOSProviderOptions options) throws Exception {
        super.connect(options);
        this.host = this.getProviderOptions().host.getValue();
        this.port = this.getProviderOptions().port.value();
        if (this.getProviderOptions().authMethod.isURL()) {
            URL url = new URL(this.host);
            this.port = url.getPort() == -1 ? url.getDefaultPort() : url.getPort();
        }
        LOGGER.info(SOSVfs_D_0101.params(new Object[]{this.host, this.port}));
        this.logReply();
        try {
            this.doLogin();
        }
        catch (JobSchedulerException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JobSchedulerException((Throwable)ex);
        }
    }

    @Override
    public void disconnect() {
        this.reply = "disconnect OK";
        if (this.davClient != null) {
            try {
                this.davClient.close();
                this.davClient = null;
            }
            catch (Exception ex) {
                this.reply = "disconnect: " + ex;
            }
        }
        LOGGER.info(this.reply);
    }

    @Override
    public boolean isConnected() {
        return this.davClient != null;
    }

    @Override
    public void mkdir(String path) {
        WebdavResource res = null;
        try {
            SOSOptionFolderName folderName = new SOSOptionFolderName(path);
            this.reply = "";
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(String.format("[mkdir][%s]try to create ...", path));
            }
            String[] subfolders = folderName.getSubFolderArrayReverse();
            int idx = subfolders.length;
            for (String strSubFolder : folderName.getSubFolderArrayReverse()) {
                res = this.getResource(strSubFolder);
                if (res.isCollection()) {
                    LOGGER.debug(SOSVfs_E_180.params(new Object[]{strSubFolder}));
                    break;
                }
                if (res.exists()) {
                    throw new JobSchedulerException(SOSVfs_E_277.params(new Object[]{strSubFolder}));
                }
                --idx;
            }
            subfolders = folderName.getSubFolderArray();
            for (int i = idx; i < subfolders.length; ++i) {
                subfolders[i] = this.getWebdavRessourcePath(subfolders[i]);
                if (this.davClient.mkcolMethod(subfolders[i])) {
                    this.reply = "mkdir OK";
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug(String.format("[mkdir][%s]created", subfolders[i]));
                    continue;
                }
                throw new Exception(this.getStatusMessage(this.davClient));
            }
        }
        catch (Exception e) {
            this.reply = e.toString();
            throw new JobSchedulerException(String.format("[%s] mkdir failed", path), (Throwable)e);
        }
        finally {
            if (res != null) {
                try {
                    res.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void rmdir(String path) {
        try {
            this.reply = "rmdir OK";
            path = this.getWebdavRessourcePath(path);
            path = SOSWebDAV.normalizePath(path + "/");
            if (!this.davClient.deleteMethod(path)) {
                throw new JobSchedulerException(this.getStatusMessage(this.davClient));
            }
            this.reply = "rmdir OK";
            LOGGER.debug(this.getHostID(SOSVfs_D_181.params(new Object[]{"rmdir", path, this.getReplyString()})));
            LOGGER.info(this.getHostID(SOSVfs_D_181.params(new Object[]{"rmdir", path, this.getReplyString()})));
        }
        catch (Exception e) {
            this.reply = e.toString();
            throw new JobSchedulerException(SOSVfs_E_134.params(new Object[]{"[rmdir]"}), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDirectory(String path) {
        WebdavResource res = null;
        try {
            res = this.getResource(path);
            boolean bl = res.isCollection();
            return bl;
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (res != null) {
                    res.close();
                }
            }
            catch (Exception exception) {}
        }
        return false;
    }

    @Override
    public SOSFileEntry getFileEntry(String path) throws Exception {
        WebdavResource file = this.getResource(path);
        if (file != null && !file.isCollection()) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(String.format("[%s]found", path));
            }
            String parent = "/";
            try {
                parent = SOSCommonProvider.normalizePath(Paths.get(path, new String[0]).getParent().toString());
            }
            catch (Exception e) {
                LOGGER.error(String.format("[%s][can't get parent path]%s", path, e.toString()), (Throwable)e);
            }
            return this.getFileEntry(file, parent);
        }
        return null;
    }

    private SOSFileEntry getFileEntry(WebdavResource file, String parentPath) {
        SOSFileEntry entry = new SOSFileEntry(SOSFileEntry.EntryType.HTTP);
        entry.setDirectory(file.isCollection());
        entry.setFilename(file.getName());
        entry.setFilesize(file.getGetContentLength());
        entry.setParentPath(parentPath);
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<SOSFileEntry> listNames(String path, int maxFiles, boolean checkIfExists, boolean checkIfIsDirectory) {
        WebdavResource res = null;
        try {
            ArrayList<SOSFileEntry> result = new ArrayList<SOSFileEntry>();
            if (path.isEmpty()) {
                path = ".";
            }
            res = this.getResource(path);
            if (checkIfExists && !res.exists()) {
                ArrayList<SOSFileEntry> arrayList = result;
                return arrayList;
            }
            if (checkIfIsDirectory && !res.isCollection()) {
                this.reply = "ls OK";
                ArrayList<SOSFileEntry> arrayList = result;
                return arrayList;
            }
            WebdavResource[] list = res.listWebdavResources();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(String.format("[%s][listWebdavResources] %s files or folders", path, list.length));
            }
            for (int i = 0; i < list.length; ++i) {
                result.add(this.getFileEntry(list[i], path));
            }
            this.reply = "ls OK";
            ArrayList<SOSFileEntry> arrayList = result;
            return arrayList;
        }
        catch (Exception e) {
            this.reply = e.toString();
            List<SOSFileEntry> list = null;
            return list;
        }
        finally {
            if (res != null) {
                try {
                    res.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size(String path) throws Exception {
        long size = -1L;
        WebdavResource res = null;
        try {
            res = this.getResource(path);
            if (res.exists()) {
                size = res.getGetContentLength();
            }
        }
        catch (Exception e) {
            LOGGER.trace(e.getMessage());
        }
        finally {
            if (res != null) {
                try {
                    res.close();
                }
                catch (Exception exception) {}
            }
        }
        return size;
    }

    @Override
    public void delete(String path, boolean checkIsDirectory) {
        try {
            path = this.getWebdavRessourcePath(path);
            path = SOSWebDAV.normalizePath(path);
            if (checkIsDirectory && this.isDirectory(path)) {
                throw new JobSchedulerException(SOSVfs_E_186.params(new Object[]{path}));
            }
            if (!this.davClient.deleteMethod(path)) {
                throw new Exception(this.getStatusMessage(this.davClient));
            }
        }
        catch (Exception ex) {
            this.reply = ex.toString();
            throw new JobSchedulerException(SOSVfs_E_187.params(new Object[]{"delete", path}), (Throwable)ex);
        }
        this.reply = "rm OK";
        LOGGER.info(this.getHostID(SOSVfs_D_181.params(new Object[]{"delete", path, this.getReplyString()})));
    }

    @Override
    public void rename(String from, String to) {
        from = SOSWebDAV.normalizePath(from);
        to = SOSWebDAV.normalizePath(to);
        try {
            from = this.getWebdavRessourcePath(from);
            from = this.normalizeWebDavPath(from);
            to = this.getWebdavRessourcePath(to);
            to = this.normalizeWebDavPath(to);
            if (!this.davClient.moveMethod(from, to)) {
                throw new Exception(this.getStatusMessage(this.davClient));
            }
        }
        catch (Exception e) {
            this.reply = e.toString();
            throw new JobSchedulerException(SOSVfs_E_188.params(new Object[]{"rename", from, to}), (Throwable)e);
        }
        this.reply = "mv OK";
        LOGGER.info(this.getHostID(SOSVfs_I_189.params(new Object[]{from, to, this.getReplyString()})));
    }

    @Override
    public InputStream getInputStream(String path) {
        try {
            path = this.getWebdavRessourcePath(path);
            return this.davClient.getMethodData(path);
        }
        catch (Exception ex) {
            throw new JobSchedulerException(SOSVfs_E_193.params(new Object[]{"getInputStream()", path}), (Throwable)ex);
        }
    }

    @Override
    public OutputStream getOutputStream(String path, boolean append, boolean resume) {
        WebdavResource res = null;
        try {
            res = this.getResource(path, false);
            SOSWebDAVOutputStream sOSWebDAVOutputStream = new SOSWebDAVOutputStream(res);
            return sOSWebDAVOutputStream;
        }
        catch (Exception ex) {
            throw new JobSchedulerException(SOSVfs_E_193.params(new Object[]{"getOutputStream()", path}), (Throwable)ex);
        }
        finally {
            try {
                if (res != null) {
                    res.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public ISOSProviderFile getFile(String fileName) {
        if (!this.isAbsolute(fileName = this.adjustFileSeparator(fileName))) {
            fileName = (this.path + fileName).replaceAll("//+", "/");
        }
        SOSWebDAVFile file = new SOSWebDAVFile(fileName);
        file.setProvider(this);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getModificationDateTime(String path) {
        WebdavResource res = null;
        String dateTime = null;
        try {
            res = this.getResource(path);
            if (res.exists()) {
                long lm = res.getGetLastModified();
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                dateTime = df.format(new Date(lm));
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (res != null) {
                try {
                    res.close();
                }
                catch (Exception exception) {}
            }
        }
        return dateTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getModificationTimeStamp(String path) throws Exception {
        WebdavResource res = null;
        try {
            res = this.getResource(path);
            if (res.exists()) {
                long l = res.getGetLastModified();
                return l;
            }
            long l = -1L;
            return l;
        }
        finally {
            if (res != null) {
                try {
                    res.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean fileExists(String filename) {
        WebdavResource res = null;
        try {
            res = this.getResource(filename);
            boolean bl = res.exists();
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (res != null) {
                    res.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public boolean directoryExists(String filename) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[%s]directoryExists", filename));
        }
        return this.isDirectory(filename);
    }

    private boolean isAbsolute(String fileName) {
        return fileName.startsWith(this.path);
    }

    private WebdavResource getResource(String path) throws Exception {
        return this.getResource(path, true);
    }

    private WebdavResource getWebdavResource(HttpURL url) throws Exception {
        WebdavResource res = null;
        res = SOSString.isEmpty((String)this.proxyHost) ? new WebdavResource(url) : new WebdavResource(url, this.proxyHost, this.proxyPort, (Credentials)new UsernamePasswordCredentials(this.proxyUser, this.proxyPassword));
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebdavResource getResource(String path, boolean flgTryWithTrailingSlash) throws Exception {
        path = SOSWebDAV.normalizePath(path);
        WebdavResource res = this.getWebdavResource(this.getWebdavRessourceURL(path));
        if (flgTryWithTrailingSlash && !path.endsWith("/") && !res.exists()) {
            WebdavResource res2 = null;
            try {
                res2 = this.getWebdavResource(this.getWebdavRessourceURL(path + "/"));
                if (res2.exists()) {
                    res = res2;
                }
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    if (res2 != null) {
                        res2.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return res;
    }

    private String normalizeWebDavPath(String path) {
        return path.replaceAll("//+", "/");
    }

    private HttpURL setRootHttpURL(String puser, String ppassword, String phost, int pport) throws Exception {
        this.rootUrl = null;
        Object httpUrl = null;
        this.path = "/";
        if (this.getProviderOptions().authMethod.isURL()) {
            URL url = new URL(phost);
            String phostRootUrl = url.getProtocol() + "://" + url.getAuthority();
            if (url.getPort() == -1) {
                phostRootUrl = phostRootUrl + ":" + url.getDefaultPort();
            }
            String normalizedHost = phostRootUrl + url.getPath();
            phostRootUrl = phostRootUrl + "/";
            if (!url.getPath().endsWith("/")) {
                normalizedHost = normalizedHost + "/";
            }
            httpUrl = "https".equalsIgnoreCase(url.getProtocol()) ? new HttpsURL(normalizedHost) : new HttpURL(normalizedHost);
            this.path = httpUrl.getPath();
            if ("https".equalsIgnoreCase(httpUrl.getScheme())) {
                this.rootUrl = new HttpsURL(phostRootUrl);
                StrictSSLProtocolSocketFactory psf = new StrictSSLProtocolSocketFactory();
                psf.setCheckHostname(this.getProviderOptions().verifyCertificateHostname.value());
                if (!psf.getCheckHostname()) {
                    LOGGER.info("*********************** Security warning *********************************************************************");
                    LOGGER.info("Jade option \"verify_certificate_hostname\" is currently \"false\". ");
                    LOGGER.info("The certificate verification process will not verify the DNS name of the certificate presented by the server,");
                    LOGGER.info("with the hostname of the server in the URL used by the Yade client.");
                    LOGGER.info("**************************************************************************************************************");
                }
                if (this.getProviderOptions().acceptUntrustedCertificate.value()) {
                    psf.useDefaultJavaCiphers();
                    psf.addTrustMaterial((TrustChain)TrustMaterial.TRUST_ALL);
                }
                Protocol p = new Protocol("https", (ProtocolSocketFactory)psf, pport);
                Protocol.registerProtocol((String)"https", (Protocol)p);
            } else {
                this.rootUrl = new HttpURL(phostRootUrl);
            }
        } else {
            httpUrl = new HttpURL(phost, pport, this.path);
            this.rootUrl = new HttpURL(phost, pport, this.path);
        }
        if (!SOSString.isEmpty((String)puser)) {
            httpUrl.setUserinfo(puser, ppassword);
        }
        return httpUrl;
    }

    private HttpURL getWebdavRessourceURL(String path) throws Exception {
        Object url = null;
        if (this.rootUrl != null) {
            path = (path = this.getWebdavRessourcePath(path)).startsWith("/") ? path.substring(1) : path;
            url = "https".equalsIgnoreCase(this.rootUrl.getScheme()) ? new HttpsURL(this.rootUrl.getEscapedURI() + path) : new HttpURL(this.rootUrl.getEscapedURI() + path);
            url.setUserinfo(this.userName, this.password);
        }
        return url;
    }

    private String getWebdavRessourcePath(String path) {
        if (!path.startsWith("/")) {
            // empty if block
        }
        return path;
    }

    private HttpURL getWebdavRessourceURL(HttpURL url) throws Exception {
        url.setUserinfo(this.userName, this.password);
        return url;
    }

    private void doLogin() throws Exception {
        this.userName = this.getProviderOptions().user.getValue();
        this.password = this.getProviderOptions().password.getValue();
        this.proxyHost = this.getProviderOptions().proxyHost.getValue();
        this.proxyPort = this.getProviderOptions().proxyPort.value();
        this.proxyUser = this.getProviderOptions().proxyUser.getValue();
        this.proxyPassword = this.getProviderOptions().proxyPassword.getValue();
        LOGGER.debug(SOSVfs_D_132.params(new Object[]{this.userName}));
        HttpURL httpUrl = this.setRootHttpURL(this.userName, this.password, this.host, this.port);
        try {
            if (!SOSString.isEmpty((String)this.proxyHost)) {
                LOGGER.info(String.format("using proxy: %s:%s, proxy user = %s", this.proxyHost, this.proxyPort, this.proxyUser));
            }
            this.davClient = this.getWebdavResource(this.getWebdavRessourceURL(httpUrl));
            if (!this.davClient.exists() && SOSString.isEmpty((String)this.davClient.getStatusMessage())) {
                this.davClient.setProperties(0);
            }
            if (!this.davClient.exists()) {
                throw new JobSchedulerException(this.getStatusMessage(this.davClient));
            }
        }
        catch (JobSchedulerException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new JobSchedulerException(SOSVfs_E_167.params(new Object[]{this.getProviderOptions().authMethod.getValue(), this.getProviderOptions().authFile.getValue()}), (Throwable)ex);
        }
        this.reply = "OK";
        LOGGER.info(SOSVfs_D_133.params(new Object[]{this.userName}));
        this.logReply();
    }

    private String getStatusMessage(WebdavResource client) {
        String msg = client.getStatusMessage();
        String uri = "";
        try {
            uri = client.getHttpURL().getURI();
        }
        catch (Exception ex) {
            uri = String.format("unknown uri = %s", ex.toString());
        }
        if (SOSString.isEmpty((String)msg)) {
            msg = "no details provided.";
            if (uri.toLowerCase().startsWith("https://") && client.getStatusCode() == 0 && !this.getProviderOptions().acceptUntrustedCertificate.value()) {
                msg = msg + " maybe is this the problem by using of a self-signed certificate (option accept_untrusted_certificate = false)";
            }
        }
        String proxy = "";
        if (!SOSString.isEmpty((String)this.proxyHost)) {
            proxy = String.format("[proxy %s:%s, proxy user = %s]", this.proxyHost, this.proxyPort, this.proxyUser);
        }
        return String.format("[%s]%s %s", uri, proxy, msg);
    }

    @Override
    public long copy(String source, String target) {
        LOGGER.info("not implemented yet");
        return 0L;
    }
}

