/*
 * Decompiled with CFR 0.152.
 */
package sos.textprocessor;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.settings.SOSConnectionSettings;
import sos.util.SOSClassUtil;

public abstract class SOSTextProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSTextProcessor.class);
    protected SOSConnectionSettings settings = null;
    protected String language = "de";
    protected boolean hasLocalizedTemplates = false;
    protected Map<String, String> scriptLanguages = new HashMap<String, String>();
    protected String scriptLanguage = "javascript";
    protected String dateFormat = "dd.MM.yyyy";
    protected String datetimeFormat = "dd.MM.yyyy HH:mm";
    protected Map<String, String> dateFormats = new HashMap<String, String>();
    protected Map<String, String> datetimeFormats = new HashMap<String, String>();
    protected Map<String, String> replacements = new HashMap<String, String>();
    protected String templateApplicationName = "";
    protected String templateSectionName = "";
    protected String templateName = "";
    protected File templateFile = null;
    protected Properties templates = null;
    protected Properties templateScriptLanguages = null;
    protected String templateScriptLanguage = null;
    protected String templateContent = "";
    protected Properties scripts = null;
    protected String scriptApplicationName = "";
    protected String scriptSectionName = "";
    protected File documentFile = null;
    protected String documentContent = "";
    protected boolean forceReload = false;

    public SOSTextProcessor() throws Exception {
        this.init();
    }

    public SOSTextProcessor(SOSConnectionSettings settings) throws Exception {
        this.setSettings(settings);
        this.init();
    }

    public SOSTextProcessor(SOSConnectionSettings settings, String templateSectionName, String templateApplicationName) throws Exception {
        this.setSettings(settings);
        this.setTemplateSectionName(templateSectionName);
        this.setTemplateApplicationName(templateApplicationName);
        this.init();
    }

    public void init() throws Exception {
        this.dateFormats.put("de", "dd.MM.yyyy");
        this.dateFormats.put("en", "MM/dd/yyyy");
        this.datetimeFormats.put("de", "dd.MM.yyyy HH:mm");
        this.datetimeFormats.put("en", "MM/dd/yyyy HH:mm");
        this.scriptLanguages = new HashMap<String, String>();
        this.scriptLanguages.put("javascript", "Javascript");
        this.scriptLanguages.put("perlscript", "PerlScript");
        this.scriptLanguages.put("vbscript", "VBScript");
        this.initLanguage();
    }

    public void init(SOSConnectionSettings settings) throws Exception {
        this.setSettings(settings);
        this.init();
    }

    public void initLanguage() throws Exception {
        if (this.getDateFormats().containsKey(this.getLanguage()) && this.getDatetimeFormats().containsKey(this.getLanguage())) {
            this.setDateFormat(this.getDateFormats().get(this.getLanguage()).toString());
            this.setDatetimeFormat(this.getDatetimeFormats().get(this.getLanguage()).toString());
        } else {
            this.setDateFormat(this.getDateFormats().get("de").toString());
            this.setDatetimeFormat(this.getDatetimeFormats().get("de").toString());
        }
    }

    public String getTemplate(String templateName) throws Exception {
        LOGGER.debug(SOSClassUtil.getMethodName() + " begin: template=" + templateName);
        this.setTemplateName(templateName);
        if (this.templates == null || !this.templates.containsKey(templateName)) {
            this.loadTemplate(templateName);
        }
        if (this.templates == null || !this.templates.containsKey(templateName)) {
            throw new Exception("template not found: " + templateName);
        }
        String string = this.templateContent = this.templates.get(templateName) == null ? null : this.templates.get(templateName).toString();
        if (this.templateScriptLanguages == null) {
            this.templateScriptLanguages = new Properties();
        }
        this.templateScriptLanguage = !this.templateScriptLanguages.containsKey(templateName) ? "javascript" : this.templateScriptLanguages.get(templateName).toString();
        if (this.templateScriptLanguage == null || this.templateScriptLanguage.isEmpty()) {
            this.templateScriptLanguage = "javascript";
        }
        LOGGER.trace(SOSClassUtil.getMethodName() + ": templateContent=" + this.templateContent);
        LOGGER.trace(SOSClassUtil.getMethodName() + ": templateScriptLanguage=" + this.templateScriptLanguage);
        LOGGER.debug(SOSClassUtil.getMethodName() + " end");
        return this.templateContent;
    }

    public Properties getTemplates() throws Exception {
        Object key2 = null;
        Object value = null;
        if (!this.isForceReload() && this.templates != null && !this.templates.isEmpty()) {
            return this.templates;
        }
        if (this.settings == null) {
            throw new Exception("settings have not been loaded.");
        }
        if (this.getTemplateApplicationName() == null || this.getTemplateApplicationName().isEmpty()) {
            throw new Exception("no template application name has been given for settings.");
        }
        if (this.getTemplateSectionName() == null || this.getTemplateSectionName().isEmpty()) {
            throw new Exception("no template section name has been given for settings.");
        }
        this.setTemplates(this.getSettings().getSection(this.getTemplateApplicationName(), this.getTemplateSectionName() + (this.hasLocalizedTemplates() ? "_" + this.getLanguage() : "")));
        if (this.templates == null || this.templates.isEmpty()) {
            return this.templates;
        }
        for (Object key2 : this.templates.keySet()) {
            if (key2 == null || (value = this.templates.get(key2.toString())) == null || value.toString() == null || !value.toString().trim().isEmpty()) continue;
            value = this.loadTemplateDocument(key2.toString());
            this.templates.put(key2.toString(), value == null ? "" : value.toString());
        }
        return this.templates;
    }

    public Properties getTemplates(boolean forceReload) throws Exception {
        this.setForceReload(forceReload);
        return this.getTemplates();
    }

    public Properties getTemplates(SOSConnectionSettings settings) throws Exception {
        this.setSettings(settings);
        return this.getTemplates();
    }

    public Properties getTemplates(String templateSectionName, String templateApplicationName) throws Exception {
        this.setTemplateSectionName(templateSectionName);
        this.setTemplateApplicationName(templateApplicationName);
        return this.getTemplates();
    }

    public Properties getTemplates(SOSConnectionSettings settings, String templateSectionName, String templateApplicationName) throws Exception {
        this.setSettings(settings);
        this.setTemplateSectionName(templateSectionName);
        this.setTemplateApplicationName(templateApplicationName);
        return this.getTemplates();
    }

    protected String loadTemplate(String templateName) throws Exception {
        LOGGER.debug(SOSClassUtil.getMethodName() + " begin: templateName=" + templateName);
        this.setTemplateName(templateName);
        this.templateContent = this.getSettings().getSectionEntry(this.getTemplateApplicationName(), this.getTemplateSectionName() + (this.hasLocalizedTemplates() ? "_" + this.getLanguage() : ""), templateName);
        LOGGER.trace(SOSClassUtil.getMethodName() + ": templateContent=" + this.templateContent);
        if (this.templateContent == null || this.templateContent.trim().isEmpty()) {
            this.loadTemplateDocument(templateName);
        } else {
            if (this.templates == null) {
                this.templates = new Properties();
            }
            this.templates.put(templateName, this.templateContent);
            this.checkTemplateScriptLanguage(templateName);
        }
        LOGGER.debug(SOSClassUtil.getMethodName() + " end");
        return this.templateContent;
    }

    protected String loadTemplateDocument(String templateName) throws Exception {
        LOGGER.debug(SOSClassUtil.getMethodName() + " begin: templateName=" + templateName);
        this.setTemplateName(templateName);
        byte[] content = this.getSettings().getSectionEntryDocument(this.getTemplateApplicationName(), this.getTemplateSectionName() + (this.hasLocalizedTemplates() ? "_" + this.getLanguage() : ""), templateName);
        this.templateContent = content == null ? null : new String(content);
        LOGGER.trace(SOSClassUtil.getMethodName() + ": templateContent=" + this.templateContent);
        if (this.templateContent != null) {
            if (this.templates == null) {
                this.templates = new Properties();
            }
            this.templates.put(templateName, this.templateContent);
            this.checkTemplateScriptLanguage(templateName);
        }
        LOGGER.debug(SOSClassUtil.getMethodName() + " end");
        return this.templateContent;
    }

    protected String checkTemplateScriptLanguage(String templateName) throws Exception {
        if (this.templateContent == null || this.templateContent.isEmpty()) {
            return this.templateContent;
        }
        if (this.templateScriptLanguages == null) {
            this.templateScriptLanguages = new Properties();
        }
        this.templateScriptLanguages.put(templateName, "javascript");
        int firstPos = this.templateContent.indexOf("\n");
        if (firstPos > 0) {
            String firstLine = this.templateContent.substring(0, this.templateContent.indexOf("\n") - 1);
            if (firstLine.toLowerCase().matches("(.*)(vbscript)(.*)")) {
                this.templateScriptLanguages.put(templateName, "vbscript");
                this.templateContent = this.templateContent.substring(firstPos + 1);
            } else if (firstLine.toLowerCase().matches("(.*)(perlscript)(.*)")) {
                this.templateScriptLanguages.put(templateName, "perlscript");
                this.templateContent = this.templateContent.substring(firstPos + 1);
            }
        }
        return this.templateContent;
    }

    public String getTemplateScriptLanguage(String templateName) throws Exception {
        if (this.templateScriptLanguages == null || !this.templateScriptLanguages.containsKey(templateName)) {
            throw new Exception("template not found: " + templateName);
        }
        return this.templateScriptLanguages.get(templateName).toString();
    }

    public File getTemplateFile(String templateName) throws Exception {
        this.setTemplateName(templateName);
        if (this.templates == null || !this.templates.containsKey(templateName)) {
            this.loadTemplate(templateName);
        }
        if (!this.templates.containsKey(templateName)) {
            throw new Exception("template not found: " + templateName);
        }
        String string = this.templateContent = this.templates.get(templateName) == null ? null : this.templates.get(templateName).toString();
        if (this.templateContent == null) {
            return null;
        }
        this.setTemplateFile(File.createTempFile("sos", ".tmp"));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.templateFile.getAbsolutePath()));
        out.write(this.templateContent.getBytes());
        out.flush();
        out.close();
        return this.templateFile;
    }

    public File getTemplateFile(SOSConnectionSettings settings, String templateName) throws Exception {
        this.setSettings(settings);
        this.setTemplateName(templateName);
        return this.getTemplateFile(templateName);
    }

    public File getTemplateFile(SOSConnectionSettings settings, String templateName, String templateSectionName, String templateApplicationName) throws Exception {
        this.setSettings(settings);
        this.setTemplateName(templateName);
        this.setTemplateSectionName(templateSectionName);
        this.setTemplateApplicationName(templateApplicationName);
        return this.getTemplateFile(templateName);
    }

    public File getTemplateFile(String templateName, String templateSectionName, String templateApplicationName) throws Exception {
        this.setTemplateName(templateName);
        this.setTemplateSectionName(templateSectionName);
        this.setTemplateApplicationName(templateApplicationName);
        return this.getTemplateFile(templateName);
    }

    protected String loadScript(String scriptName) throws Exception {
        byte[] content = this.getSettings().getSectionEntryDocument(this.getScriptApplicationName(), this.getScriptSectionName(), scriptName);
        if (content != null) {
            if (this.scripts == null) {
                this.scripts = new Properties();
            }
            this.scripts.put(scriptName, new String(content));
            return new String(content);
        }
        return null;
    }

    public String getScript(String scriptName) throws Exception {
        if (this.scripts == null || !this.scripts.containsKey(scriptName)) {
            this.loadScript(scriptName);
        }
        if (this.scripts == null || !this.scripts.containsKey(scriptName)) {
            throw new Exception("script not found: " + scriptName);
        }
        return this.scripts.get(scriptName) == null ? null : this.scripts.get(scriptName).toString();
    }

    public Properties getScripts() throws Exception {
        return this.getScripts(false);
    }

    public Properties getScripts(boolean force) throws Exception {
        Object key2 = null;
        if (!force && this.scripts != null && !this.scripts.isEmpty()) {
            return this.scripts;
        }
        if (this.settings == null) {
            throw new Exception("settings have not been loaded.");
        }
        if (this.getScriptApplicationName() == null || this.getScriptApplicationName().isEmpty()) {
            throw new Exception("no script application name has been given for settings.");
        }
        if (this.getScriptSectionName() == null || this.getScriptSectionName().isEmpty()) {
            throw new Exception("no script section name has been given for settings.");
        }
        this.setScripts(this.getSettings().getSection(this.getScriptApplicationName(), this.getScriptSectionName()));
        if (this.scripts == null || this.scripts.isEmpty()) {
            return this.scripts;
        }
        for (Object key2 : this.scripts.keySet()) {
            if (key2 == null) continue;
            this.loadScript(key2.toString());
        }
        return this.scripts;
    }

    public Properties getScripts(SOSConnectionSettings settings) throws Exception {
        this.setSettings(settings);
        return this.getScripts();
    }

    public Properties getScripts(SOSConnectionSettings settings, String scriptSectionName, String scriptApplicationName) throws Exception {
        this.setSettings(settings);
        this.setScriptSectionName(scriptSectionName);
        this.setScriptApplicationName(scriptApplicationName);
        return this.getScripts();
    }

    public Properties getScripts(String scriptSectionName, String scriptApplicationName) throws Exception {
        this.setScriptSectionName(scriptSectionName);
        this.setScriptApplicationName(scriptApplicationName);
        return this.getScripts();
    }

    public abstract void process() throws Exception;

    public abstract File process(File var1) throws Exception;

    public abstract File process(File var1, String var2) throws Exception;

    public abstract File process(File var1, Map<String, String> var2) throws Exception;

    public abstract File process(File var1, String var2, Map<String, String> var3) throws Exception;

    public abstract String process(String var1) throws Exception;

    public abstract String process(String var1, String var2) throws Exception;

    public abstract String process(String var1, Map<String, String> var2) throws Exception;

    public abstract String process(String var1, String var2, Map<String, String> var3) throws Exception;

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public Map<String, String> getDateFormats() {
        return this.dateFormats;
    }

    protected void setDateFormats(Map<String, String> dateFormats) {
        this.dateFormats = dateFormats;
    }

    public String getDatetimeFormat() {
        return this.datetimeFormat;
    }

    public void setDatetimeFormat(String datetimeFormat) {
        this.datetimeFormat = datetimeFormat;
    }

    public Map<String, String> getDatetimeFormats() {
        return this.datetimeFormats;
    }

    protected void setDatetimeFormats(Map<String, String> datetimeFormats) {
        this.datetimeFormats = datetimeFormats;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) throws Exception {
        this.language = language;
        this.initLanguage();
    }

    public Map<String, String> getReplacements() {
        return this.replacements;
    }

    public void setReplacements(Map<String, String> replacements) {
        this.replacements = replacements;
    }

    public String getDocumentContent() throws Exception {
        return this.documentContent;
    }

    protected void setDocumentContent(String documentContent) {
        this.documentContent = documentContent;
    }

    public String getTemplateContent() {
        return this.templateContent;
    }

    protected void setTemplateContent(String templateContent) {
        this.templateContent = templateContent;
    }

    public SOSConnectionSettings getSettings() {
        return this.settings;
    }

    public void setSettings(SOSConnectionSettings settings) throws Exception {
        if (settings == null) {
            throw new Exception(SOSClassUtil.getMethodName() + ": missing settings object.");
        }
        this.settings = settings;
    }

    public File getDocumentFile() throws Exception {
        return this.documentFile;
    }

    public void setDocumentFile(File documentFile) throws Exception {
        this.documentFile = documentFile;
    }

    public String getTemplateApplicationName() {
        return this.templateApplicationName;
    }

    public void setTemplateApplicationName(String templateApplicationName) {
        this.templateApplicationName = templateApplicationName;
    }

    public String getTemplateSectionName() {
        return this.templateSectionName;
    }

    public void setTemplateSectionName(String templateSectionName) {
        this.templateSectionName = templateSectionName;
    }

    protected void setTemplates(Properties templates) {
        this.templates = templates;
    }

    public File getTemplateFile() {
        return this.templateFile;
    }

    protected void setTemplateFile(File templateFile) {
        this.templateFile = templateFile;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public boolean hasLocalizedTemplates() {
        return this.hasLocalizedTemplates;
    }

    public void setHasLocalizedTemplates(boolean hasLocalizedTemplates) {
        this.hasLocalizedTemplates = hasLocalizedTemplates;
    }

    public String getScriptLanguage() {
        return this.scriptLanguage;
    }

    public void setScriptLanguage(String scriptLanguage) throws Exception {
        if (!this.scriptLanguages.containsKey(scriptLanguage)) {
            throw new Exception("unknown script language: " + scriptLanguage);
        }
        this.scriptLanguage = scriptLanguage;
    }

    public Map<String, String> getScriptLanguages() {
        return this.scriptLanguages;
    }

    public String getTemplateScriptLanguage() {
        return this.templateScriptLanguage;
    }

    protected void setTemplateScriptLanguage(String templateScriptLanguage) {
        this.templateScriptLanguage = templateScriptLanguage;
    }

    public Properties getTemplateScriptLanguages() {
        return this.templateScriptLanguages;
    }

    protected void setTemplateScriptLanguages(Properties templateScriptLanguages) {
        this.templateScriptLanguages = templateScriptLanguages;
    }

    public String getScriptApplicationName() {
        return this.scriptApplicationName;
    }

    public void setScriptApplicationName(String scriptApplicationName) {
        this.scriptApplicationName = scriptApplicationName;
    }

    public String getScriptSectionName() {
        return this.scriptSectionName;
    }

    public void setScriptSectionName(String scriptSectionName) {
        this.scriptSectionName = scriptSectionName;
    }

    protected void setScripts(Properties scripts) {
        this.scripts = scripts;
    }

    public boolean isForceReload() {
        return this.forceReload;
    }

    public void setForceReload(boolean forceReload) {
        this.forceReload = forceReload;
    }
}

