/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.hibernate;

import com.sos.commons.hibernate.exception.SOSHibernateException;
import com.sos.commons.hibernate.exception.SOSHibernateFactoryBuildException;
import com.sos.commons.hibernate.exception.SOSHibernateInvalidSessionException;
import com.sos.commons.hibernate.exception.SOSHibernateLockAcquisitionException;
import com.sos.commons.hibernate.exception.SOSHibernateOpenSessionException;
import com.sos.commons.util.SOSDate;
import com.sos.commons.util.SOSReflection;
import com.sos.commons.util.SOSString;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Id;
import jakarta.persistence.Parameter;
import java.lang.reflect.Field;
import java.net.ConnectException;
import java.net.SocketException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.JDBCConnectionException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.query.Query;

public class SOSHibernate {
    protected static final String DEFAULT_DIALECT_MYSQL = MySQLDialect.class.getName();
    public static final String DEFAULT_DIALECT_ORACLE = OracleDialect.class.getName();
    protected static final String DEFAULT_DIALECT_PGSQL = PostgreSQLDialect.class.getName();
    protected static final String DEFAULT_DIALECT_MSSQL = SQLServerDialect.class.getName();
    protected static final String DEFAULT_DIALECT_H2 = H2Dialect.class.getName();
    protected static final String HIBERNATE_PROPERTY_CONNECTION_DRIVERCLASS_DEPRECATED = "hibernate.connection.driver_class";
    protected static final String HIBERNATE_PROPERTY_CONNECTION_URL_DEPRECATED = "hibernate.connection.url";
    protected static final String HIBERNATE_PROPERTY_CONNECTION_USERNAME_DEPRECATED = "hibernate.connection.username";
    protected static final String HIBERNATE_PROPERTY_CONNECTION_PASSWORD_DEPRECATED = "hibernate.connection.password";
    public static final String HIBERNATE_PROPERTY_CONNECTION_DRIVERCLASS = "jakarta.persistence.jdbc.driver";
    public static final String HIBERNATE_PROPERTY_CONNECTION_URL = "jakarta.persistence.jdbc.url";
    public static final String HIBERNATE_PROPERTY_CONNECTION_USERNAME = "jakarta.persistence.jdbc.user";
    public static final String HIBERNATE_PROPERTY_CONNECTION_PASSWORD = "jakarta.persistence.jdbc.password";
    public static final String HIBERNATE_PROPERTY_DIALECT = "hibernate.dialect";
    public static final String HIBERNATE_PROPERTY_ALLOW_METADATA_ON_BOOT = "hibernate.boot.allow_jdbc_metadata_access";
    public static final String HIBERNATE_PROPERTY_CONNECTION_AUTO_COMMIT = "hibernate.connection.autocommit";
    public static final String HIBERNATE_PROPERTY_TRANSACTION_ISOLATION = "hibernate.connection.isolation";
    public static final String HIBERNATE_PROPERTY_USE_SCROLLABLE_RESULTSET = "hibernate.jdbc.use_scrollable_resultset";
    public static final String HIBERNATE_PROPERTY_CURRENT_SESSION_CONTEXT_CLASS = "hibernate.current_session_context_class";
    public static final String HIBERNATE_PROPERTY_ID_STRUCTURE_NAMING_STRATEGY = "hibernate.id.db_structure_naming_strategy";
    public static final String HIBERNATE_PROPERTY_PERSISTENCE_VALIDATION_MODE = "jakarta.persistence.validation.mode";
    public static final String HIBERNATE_PROPERTY_JPA_ID_GENERATOR_GLOBAL_SCOPE_COMPLIANCE = "hibernate.jpa.compliance.global_id_generators";
    public static final String HIBERNATE_SOS_PROPERTY_SHOW_CONFIGURATION_PROPERTIES = "hibernate.sos.show_configuration_properties";
    public static final String HIBERNATE_SOS_PROPERTY_CREDENTIAL_STORE_FILE = "hibernate.sos.credential_store_file";
    public static final String HIBERNATE_SOS_PROPERTY_CREDENTIAL_STORE_KEY_FILE = "hibernate.sos.credential_store_key_file";
    public static final String HIBERNATE_SOS_PROPERTY_CREDENTIAL_STORE_PASSWORD = "hibernate.sos.credential_store_password";
    public static final String HIBERNATE_SOS_PROPERTY_CREDENTIAL_STORE_ENTRY_PATH = "hibernate.sos.credential_store_entry_path";
    public static final String HIBERNATE_SOS_PROPERTY_DECRYPTION_PRIVATE_KEY = "hibernate.sos.decryption_key";
    public static final String HIBERNATE_SOS_PROPERTY_DECRYPTION_PRIVATE_KEYPWD = "hibernate.sos.decryption_keypassword";
    public static final String HIBERNATE_SOS_PROPERTY_KEYSTORE = "hibernate.sos.keystore_path";
    public static final String HIBERNATE_SOS_PROPERTY_KEYSTORE_TYPE = "hibernate.sos.keystore_type";
    public static final String HIBERNATE_SOS_PROPERTY_KEYSTORE_PWD = "hibernate.sos.keystore_password";
    public static final String HIBERNATE_SOS_PROPERTY_KEYSTORE_KEYPWD = "hibernate.sos.keystore_keypassword";
    public static final String HIBERNATE_SOS_PROPERTY_KEYSTORE_KEYALIAS = "hibernate.sos.keystore_keyalias";
    public static final int LIMIT_IN_CLAUSE = 1000;

    public static Exception findLockException(Exception cause) {
        for (Throwable e = cause; e != null; e = e.getCause()) {
            if (e instanceof SOSHibernateLockAcquisitionException) {
                return (SOSHibernateLockAcquisitionException)((Object)e);
            }
            if (!(e instanceof LockAcquisitionException)) continue;
            return (LockAcquisitionException)e;
        }
        return null;
    }

    public static Exception findConstraintViolationException(Exception cause) {
        for (Throwable e = cause; e != null; e = e.getCause()) {
            if (e instanceof ConstraintViolationException) {
                return (ConstraintViolationException)e;
            }
            if (!(e instanceof SQLIntegrityConstraintViolationException)) continue;
            return (SQLIntegrityConstraintViolationException)e;
        }
        return null;
    }

    public static boolean isConnectException(Throwable cause) {
        for (Throwable e = cause; e != null; e = e.getCause()) {
            if (e instanceof SOSHibernateFactoryBuildException) {
                return true;
            }
            if (e instanceof SOSHibernateInvalidSessionException) {
                return true;
            }
            if (e instanceof SOSHibernateOpenSessionException) {
                return true;
            }
            if (e instanceof JDBCConnectionException) {
                return true;
            }
            if (!(e instanceof ConnectException) && !(e instanceof SocketException)) continue;
            return true;
        }
        return false;
    }

    public static Object getId(Object item) throws SOSHibernateException {
        if (item == null) {
            return null;
        }
        List l = Arrays.stream(item.getClass().getDeclaredFields()).filter(m -> m.isAnnotationPresent(Id.class)).collect(Collectors.toList());
        int size = l.size();
        if (size < 1) {
            l = Arrays.stream(item.getClass().getDeclaredFields()).filter(m -> m.isAnnotationPresent(EmbeddedId.class)).collect(Collectors.toList());
            size = l.size();
        }
        if (size < 1) {
            return null;
        }
        Object[] id = new Object[size];
        for (int i = 0; i < size; ++i) {
            Field field = (Field)l.get(i);
            try {
                field.setAccessible(true);
                id[i] = field.get(item);
                continue;
            }
            catch (Throwable e) {
                throw new SOSHibernateException(String.format("[getId][can't get field]%s", item.getClass().getSimpleName(), e.toString()), e);
            }
        }
        if (size == 1) {
            return id[0];
        }
        return id;
    }

    public static void setId(Object item, Object value) throws SOSHibernateException {
        if (item == null) {
            return;
        }
        List l = Arrays.stream(item.getClass().getDeclaredFields()).filter(m -> m.isAnnotationPresent(Id.class)).collect(Collectors.toList());
        int size = l.size();
        if (size < 1) {
            l = Arrays.stream(item.getClass().getDeclaredFields()).filter(m -> m.isAnnotationPresent(EmbeddedId.class)).collect(Collectors.toList());
            size = l.size();
        }
        if (size < 1) {
            return;
        }
        Object[] id = new Object[size];
        if (size == 1) {
            id[0] = value;
        } else {
            int i;
            Object[] o = null;
            if (SOSReflection.isArray(value.getClass())) {
                o = (Object[])value;
            } else {
                for (i = 0; i < size; ++i) {
                    id[i] = value;
                }
            }
            for (i = 0; i < size; ++i) {
                id[i] = o[i];
            }
        }
        for (int i = 0; i < size; ++i) {
            Field field = (Field)l.get(i);
            try {
                field.setAccessible(true);
                field.set(item, id[i]);
                continue;
            }
            catch (Exception ex) {
                throw new SOSHibernateException(String.format("[setId][can't set field]%s", item.getClass().getSimpleName(), ex.toString()), ex);
            }
        }
    }

    public static String getQueryParametersAsString(Query<?> query) {
        if (query == null) {
            return null;
        }
        try {
            Set set = query.getParameters();
            if (set != null && set.size() > 0) {
                StringBuilder sb = new StringBuilder();
                int i = 0;
                for (Parameter parameter : set) {
                    Object val;
                    if (i > 0) {
                        sb.append(",");
                    }
                    if ((val = query.getParameterValue(parameter.getName())) != null && val instanceof Date) {
                        val = SOSDate.getDateTimeAsString((Date)((Date)val));
                    }
                    sb.append(parameter.getName() + "=" + val);
                    ++i;
                }
                return sb.toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static String toString(Object o) {
        if (o == null) {
            return null;
        }
        List excludeFieldNames = Arrays.stream(o.getClass().getDeclaredFields()).filter(m -> m.getType().isAssignableFrom(byte[].class)).map(Field::getName).collect(Collectors.toList());
        List excludeDBItemFieldNames = Arrays.stream(o.getClass().getSuperclass().getDeclaredFields()).map(Field::getName).collect(Collectors.toList());
        excludeFieldNames.addAll(excludeDBItemFieldNames);
        return SOSString.toString((Object)o, excludeFieldNames);
    }

    public static <T> List<T> getInClausePartition(int part, List<T> list) {
        return list.subList(part, Math.min(part + 1000, list.size()));
    }

    public static <T> List<List<T>> getInClausePartitions(List<T> list) {
        ArrayList<List<T>> partitions = new ArrayList<List<T>>();
        for (int i = 0; i < list.size(); i += 1000) {
            partitions.add(SOSHibernate.getInClausePartition(i, list));
        }
        return partitions;
    }

    public static String quoteColumn(Dialect dialect, String columnName) {
        if (dialect != null && columnName != null) {
            String[] arr = ((String)columnName).split("\\.");
            if (arr.length == 1) {
                columnName = dialect.openQuote() + (String)columnName + dialect.closeQuote();
            } else {
                StringBuilder sb = new StringBuilder();
                String cn = arr[arr.length - 1];
                for (int i = 0; i < arr.length - 1; ++i) {
                    sb.append(arr[i] + ".");
                }
                sb.append(dialect.openQuote() + cn + dialect.closeQuote());
                columnName = sb.toString();
            }
        }
        return columnName;
    }

    protected static String getLogIdentifier(String identifier) {
        if (identifier == null) {
            return "";
        }
        if (identifier.startsWith("[")) {
            return identifier;
        }
        return String.format("[%s]", identifier);
    }

    protected static String getMethodName(String logIdentifier, String name) {
        return String.format("%s[%s]", logIdentifier, name);
    }
}

