/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.hibernate;

import com.sos.commons.hibernate.SOSHibernate;
import com.sos.commons.hibernate.SOSHibernateFactory;
import com.sos.commons.hibernate.SOSHibernateSession;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.hibernate.dialect.Dialect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOSHibernateSynchronizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSHibernateSynchronizer.class);
    private static final boolean SYNCHRONIZER_AUTO_COMMIT = false;
    private BatchPreparator preparator;
    private boolean doDelete = false;
    private boolean useInsertBatch = false;
    private int insertBatchSize = 100;
    private Map<Integer, Object> parameters = new HashMap<Integer, Object>();

    public void setParameters(Map<Integer, Object> parameters) {
        if (parameters != null) {
            this.parameters = parameters;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(SOSHibernateSession sourceSession, String sourceTable, String sourceSelectQuery, String primaryKeyColumn, SOSHibernateSession targetSession, String targetTable) throws Exception {
        this.preparator = new BatchPreparator(sourceSession.getFactory().getDialect(), sourceTable, primaryKeyColumn, targetSession.getFactory().getDbms(), targetSession.getFactory().getDialect());
        Connection sourceConnection = sourceSession.getConnection();
        Connection targetConnection = targetSession.getConnection();
        boolean sourceAutoCommit = this.setAutoCommit(sourceConnection);
        boolean targetAutoCommit = this.setAutoCommit(targetConnection);
        try {
            Integer maxTargetId = 0;
            boolean run = true;
            while (run) {
                int r = this.process(sourceConnection, sourceTable, sourceSelectQuery, primaryKeyColumn, targetConnection, targetTable, maxTargetId);
                if (r >= 1) continue;
                run = false;
            }
        }
        finally {
            this.restoreAutoCommit("target", targetConnection, targetAutoCommit);
            this.restoreAutoCommit("source", sourceConnection, sourceAutoCommit);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int process(Connection sourceConnection, String sourceTable, String sourceSelectQuery, String primaryKeyColumn, Connection targetConnection, String targetTable, Number maxTargetId) throws Exception {
        ArrayList<Object> primaryKeys = new ArrayList<Object>();
        int countInserted = 0;
        int size = 0;
        try (PreparedStatement select = sourceConnection.prepareStatement(sourceSelectQuery);){
            block46: {
                if (this.parameters != null) {
                    for (Map.Entry<Integer, Object> entry : this.parameters.entrySet()) {
                        select.setObject(entry.getKey(), entry.getValue());
                    }
                }
                try (ResultSet rs = select.executeQuery();){
                    int currentBatchSize;
                    if (this.preparator.insertQuery == null) {
                        this.preparator.init(rs, targetTable);
                    }
                    try (PreparedStatement insert = targetConnection.prepareStatement(this.preparator.insertQuery);){
                        currentBatchSize = 0;
                        while (rs.next()) {
                            Object primaryKey = rs.getObject(primaryKeyColumn);
                            primaryKeys.add(primaryKey);
                            if (maxTargetId.longValue() < ((Number)primaryKey).longValue()) {
                                for (int i = 1; i <= this.preparator.columns.size(); ++i) {
                                    insert.setObject(i, rs.getObject(i), rs.getMetaData().getColumnType(i));
                                }
                                if (this.useInsertBatch) {
                                    insert.addBatch();
                                    ++currentBatchSize;
                                } else if (this.insertSingleRow(targetConnection, insert)) {
                                    ++countInserted;
                                }
                            }
                            if (currentBatchSize % this.insertBatchSize != 0) continue;
                            if (this.insertBatch(targetConnection, insert)) {
                                countInserted += currentBatchSize;
                            }
                            currentBatchSize = 0;
                        }
                        if (currentBatchSize > 0 && this.insertBatch(targetConnection, insert)) {
                            countInserted += currentBatchSize;
                        }
                    }
                    if (!this.useInsertBatch) {
                        targetConnection.commit();
                    }
                    size = primaryKeys.size();
                    LOGGER.info("[total=" + size + "][target][inserted=" + countInserted + "][not inserted=" + (size - countInserted) + "]");
                    if (!this.doDelete) {
                        int insert = 0;
                        return insert;
                    }
                    if (size <= 0) break block46;
                    try (PreparedStatement delete = sourceConnection.prepareStatement(this.preparator.deleteQuery);){
                        currentBatchSize = 0;
                        for (int i = 0; i < primaryKeys.size(); ++i) {
                            delete.setObject(1, primaryKeys.get(i));
                            delete.addBatch();
                            if (++currentBatchSize % this.insertBatchSize != 0) continue;
                            delete.executeBatch();
                            delete.clearBatch();
                            sourceConnection.commit();
                            currentBatchSize = 0;
                        }
                        if (currentBatchSize > 0) {
                            delete.executeBatch();
                            delete.clearBatch();
                            sourceConnection.commit();
                        }
                    }
                    catch (Throwable e) {
                        throw new SQLException("[source]" + e.toString(), e);
                    }
                }
            }
            int n = size;
            return n;
        }
        catch (SQLException ex) {
            this.rollback("target", targetConnection);
            this.rollback("source", sourceConnection);
            throw ex;
        }
    }

    private boolean insertBatch(Connection targetConnection, PreparedStatement insert) throws Exception {
        try {
            insert.executeBatch();
            insert.clearBatch();
            targetConnection.commit();
            return true;
        }
        catch (Exception e) {
            Exception cve = SOSHibernate.findConstraintViolationException(e);
            if (cve == null) {
                throw new SQLException("[target]" + e.toString(), e);
            }
            this.rollback("target", targetConnection);
            LOGGER.info("[target][insert]" + e.toString());
            return false;
        }
    }

    private boolean insertSingleRow(Connection targetConnection, PreparedStatement insert) throws Exception {
        try {
            insert.executeUpdate();
            return true;
        }
        catch (Exception e) {
            Exception cve = SOSHibernate.findConstraintViolationException(e);
            if (cve == null) {
                throw new SQLException("[target]" + e.toString(), e);
            }
            this.rollback("target", targetConnection);
            LOGGER.info("[target][insert]" + e.toString());
            return false;
        }
    }

    private boolean setAutoCommit(Connection connection) throws SQLException {
        boolean orig = connection.getAutoCommit();
        if (orig) {
            connection.setAutoCommit(false);
        }
        return orig;
    }

    private void rollback(String source, Connection connection) {
        try {
            connection.rollback();
        }
        catch (Throwable e) {
            LOGGER.error("[" + source + "]" + e.toString(), e);
        }
    }

    private void restoreAutoCommit(String source, Connection connection, boolean orig) {
        if (orig) {
            try {
                connection.setAutoCommit(orig);
            }
            catch (Throwable e) {
                LOGGER.error("[" + source + "]" + e.toString(), e);
            }
        }
    }

    private Number getMaxId(Connection connection, String table, String primaryKeyColumn) throws SQLException {
        Number id = null;
        try (Statement stmt = connection.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT MAX(" + primaryKeyColumn + ") AS max_id FROM " + table);){
            if (rs.next()) {
                id = (Number)rs.getObject("max_id");
            }
        }
        return id == null ? (Number)0L : (Number)id;
    }

    private class BatchPreparator {
        private final Dialect deleteDialect;
        private final String deleteTableName;
        private final String primaryKeyColumn;
        private final SOSHibernateFactory.Dbms insertDbms;
        private final Dialect insertDialect;
        private Map<String, Integer> columns;
        private String insertQuery;
        private String deleteQuery;

        private BatchPreparator(Dialect deleteDialect, String deleteTableName, String primaryKeyColumn, SOSHibernateFactory.Dbms insertDbms, Dialect insertDialect) {
            this.deleteDialect = deleteDialect;
            this.deleteTableName = deleteTableName;
            this.primaryKeyColumn = primaryKeyColumn;
            this.insertDbms = insertDbms;
            this.insertDialect = insertDialect;
        }

        private void init(ResultSet rs, String insertTableName) throws SQLException {
            this.setColumns(rs);
            try {
                this.setInsertQuery(insertTableName);
                this.setDeleteQuery();
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new SQLException(e);
            }
        }

        private void setColumns(ResultSet rs) throws SQLException {
            if (this.columns == null) {
                this.columns = new LinkedHashMap<String, Integer>();
                ResultSetMetaData meta = rs.getMetaData();
                int count = meta.getColumnCount();
                for (int i = 1; i <= count; ++i) {
                    this.columns.put(meta.getColumnName(i).toLowerCase(), meta.getColumnType(i));
                }
            }
        }

        private void setInsertQuery(String tableName) throws Exception {
            if (this.insertQuery == null) {
                this.insertQuery = this.createInsertQuery(tableName);
            }
        }

        private String createInsertQuery(String tableName) {
            StringBuilder sql = new StringBuilder("INSERT INTO ").append(tableName);
            sql.append("(");
            sql.append(this.columns.entrySet().stream().map(e -> SOSHibernate.quoteColumn(this.insertDialect, (String)e.getKey())).collect(Collectors.joining(",")));
            sql.append(") VALUES (");
            sql.append(this.columns.entrySet().stream().map(e -> "?").collect(Collectors.joining(",")));
            sql.append(")");
            return sql.toString();
        }

        private String createInsertIgnoreDuplicateQuery(String tableName) {
            String prefix = "";
            Object suffix = "";
            switch (this.insertDbms) {
                case MYSQL: {
                    prefix = "IGNORE ";
                    break;
                }
                case MSSQL: 
                case PGSQL: {
                    suffix = " ON CONFLICT (" + SOSHibernate.quoteColumn(this.insertDialect, this.primaryKeyColumn) + ") DO NOTHING";
                    break;
                }
                case ORACLE: {
                    suffix = " ON DUPLICATE KEY IGNORE";
                    suffix = " WHERE NOT EXISTS (SELECT 1 FROM " + tableName + " WHERE " + SOSHibernate.quoteColumn(this.insertDialect, this.primaryKeyColumn) + " = ?)";
                    break;
                }
            }
            StringBuilder sql = new StringBuilder("INSERT ").append(prefix).append("INTO ").append(tableName);
            sql.append("(");
            sql.append(this.columns.entrySet().stream().map(e -> SOSHibernate.quoteColumn(this.insertDialect, (String)e.getKey())).collect(Collectors.joining(",")));
            sql.append(") VALUES (");
            sql.append(this.columns.entrySet().stream().map(e -> "?").collect(Collectors.joining(",")));
            sql.append(")").append((String)suffix);
            return sql.toString();
        }

        private void setDeleteQuery() throws Exception {
            if (this.deleteQuery == null) {
                this.deleteQuery = "DELETE FROM " + this.deleteTableName + " WHERE " + SOSHibernate.quoteColumn(this.deleteDialect, this.primaryKeyColumn) + "=?";
            }
        }
    }
}

