/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.hibernate.function.json.h2;

import java.io.Reader;
import java.io.StringReader;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import javax.json.JsonValue;

public class Functions {
    public static final String NAME_JSON_VALUE = "SOS_JSON_VALUE";
    public static final String NAME_JSON_ARRAY_LENGTH = "SOS_JSON_ARRAY_LENGTH";

    public static String jsonValue(String jsonValue, String path) {
        try {
            JsonObject json;
            if (jsonValue == null || path == null) {
                return null;
            }
            JsonStructure jsonStruct = Functions.string2json(jsonValue);
            if (jsonStruct == null) {
                return null;
            }
            String[] paths = path.split("\\.");
            if (path.length() < 2) {
                return jsonStruct.toString();
            }
            if (!jsonStruct.getValueType().equals((Object)JsonValue.ValueType.OBJECT)) {
                return null;
            }
            JsonObject result = json = (JsonObject)jsonStruct;
            for (String p : paths) {
                if (p.equals("$")) continue;
                SOSJsonArray arr = Functions.newSOSJsonArray(p);
                p = arr.index > -1 ? arr.name : p;
                result = (JsonValue)json.get((Object)p);
                if (result == null) {
                    return null;
                }
                if (result.getValueType().equals((Object)JsonValue.ValueType.OBJECT)) {
                    json = result;
                    continue;
                }
                if (!result.getValueType().equals((Object)JsonValue.ValueType.ARRAY) || arr.index <= -1) continue;
                try {
                    result = (JsonValue)((JsonArray)result).get(arr.index);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return result.getValueType().equals((Object)JsonValue.ValueType.STRING) ? Functions.trim(result.toString()) : result.toString();
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static int jsonArrayLength(String jsonValue, String path) {
        int length = -1;
        try {
            JsonObject json;
            if (jsonValue == null || path == null) {
                return length;
            }
            JsonStructure jsonStruct = Functions.string2json(jsonValue);
            if (jsonStruct == null) {
                return length;
            }
            String[] paths = path.split("\\.");
            if (path.length() < 2) {
                return length;
            }
            if (!jsonStruct.getValueType().equals((Object)JsonValue.ValueType.OBJECT)) {
                return length;
            }
            JsonObject result = json = (JsonObject)jsonStruct;
            for (String p : paths) {
                if (p.equals("$")) continue;
                SOSJsonArray arr = Functions.newSOSJsonArray(p);
                p = arr.index > -1 ? arr.name : p;
                result = (JsonValue)json.get((Object)p);
                if (result == null) {
                    return length;
                }
                if (result.getValueType().equals((Object)JsonValue.ValueType.OBJECT)) {
                    json = result;
                    continue;
                }
                if (!result.getValueType().equals((Object)JsonValue.ValueType.ARRAY)) continue;
                if (arr.index > -1) {
                    try {
                        result = (JsonValue)((JsonArray)result).get(arr.index);
                        if (!result.getValueType().equals((Object)JsonValue.ValueType.ARRAY)) continue;
                        length = ((JsonArray)result).size();
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                length = ((JsonArray)result).size();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return length;
    }

    private static SOSJsonArray newSOSJsonArray(String propertyName) {
        return new Functions().new SOSJsonArray(propertyName);
    }

    private static JsonStructure string2json(String response) throws Exception {
        JsonStructure json = null;
        StringReader sr = null;
        JsonReader jr = null;
        try {
            sr = new StringReader(response);
            jr = Json.createReader((Reader)sr);
            json = jr.read();
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            if (jr != null) {
                jr.close();
            }
            if (sr != null) {
                sr.close();
            }
        }
        return json;
    }

    private static String trim(String str) {
        return str.substring(1, str.length() - 1);
    }

    private class SOSJsonArray {
        private String name;
        private int index = -1;

        private SOSJsonArray(String name) {
            int i;
            if (name.endsWith("]") && (i = name.indexOf("[")) > -1) {
                try {
                    this.index = Integer.parseInt(name.substring(i + 1, name.length() - 1));
                    this.name = name.substring(0, i);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

