/*
 * Decompiled with CFR 0.152.
 */
package sos.xml;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class SOSXMLStream
extends FileInputStream {
    static int minBytes = 512;
    private int fileSize;
    private int posBegin = 0;
    private int posEnd = 0;
    private int state = 0;
    private int cntBytes = 0;
    private StringBuilder resultString = new StringBuilder();

    public SOSXMLStream(int _which, String path) throws FileNotFoundException {
        super(path);
        int which = _which;
        byte[] lastBuff = new byte[4];
        boolean isStarting = true;
        try {
            DataInputStream fileIn = new DataInputStream(new FileInputStream(path));
            this.fileSize = fileIn.available();
            try {
                while ((this.cntBytes = fileIn.available()) > 0 && this.state < 3) {
                    this.cntBytes = this.cntBytes > minBytes ? minBytes : this.cntBytes;
                    byte[] buff = new byte[4 + this.cntBytes];
                    if (isStarting) {
                        this.cntBytes = fileIn.read(buff, 0, this.cntBytes);
                    } else {
                        this.cntBytes = fileIn.read(buff, 4, this.cntBytes);
                        buff[0] = lastBuff[0];
                        buff[1] = lastBuff[1];
                        buff[2] = lastBuff[2];
                        buff[3] = lastBuff[3];
                    }
                    lastBuff = new byte[4];
                    if (this.cntBytes <= minBytes) {
                        System.arraycopy(buff, this.cntBytes, lastBuff, 0, 4);
                    }
                    String buffStr = new String(buff);
                    if (isStarting) {
                        this.resultString.append(buffStr.substring(0, this.cntBytes));
                    } else if (this.cntBytes < minBytes) {
                        this.resultString.append(buffStr.substring(4, this.cntBytes + 4));
                    } else {
                        this.resultString.append(buffStr.substring(4, this.cntBytes + 4));
                    }
                    isStarting = false;
                    int xmlpos = buffStr.indexOf("<?xml");
                    this.state = xmlpos != -1 && (this.state == 0 || this.state == 2) ? ++this.state : (this.state > 1 ? 2 : 0);
                    if (this.state == 1) {
                        this.posBegin = this.fileSize - (buff.length - xmlpos + fileIn.available());
                        this.posEnd = this.fileSize;
                        ++this.state;
                    }
                    if (this.state != 3) continue;
                    if (which == 1) {
                        this.posEnd = this.fileSize - (buff.length - xmlpos + fileIn.available());
                        continue;
                    }
                    --which;
                    this.state = 2;
                    this.posBegin = this.fileSize - (buff.length - xmlpos + fileIn.available());
                    this.posEnd = this.fileSize;
                }
                fileIn.close();
                if (which > 1) {
                    throw new FileNotFoundException();
                }
                this.skip(this.posBegin);
            }
            catch (IOException iOException) {}
        }
        catch (IOException e) {
            throw new FileNotFoundException();
        }
        catch (Exception e) {
            throw new FileNotFoundException();
        }
    }

    public SOSXMLStream(int which, File file) throws FileNotFoundException {
        super(file.getAbsolutePath());
    }

    public SOSXMLStream(int which, FileDescriptor fileDescriptor) {
        super(fileDescriptor);
    }

    @Override
    public int read() throws IOException {
        if (this.available() < 1) {
            return -1;
        }
        return super.read();
    }

    @Override
    public int read(byte[] byteArray) throws IOException {
        if (this.available() < 1) {
            return -1;
        }
        if (byteArray.length > this.available()) {
            return this.read(byteArray, 0, this.available());
        }
        return this.read(byteArray, 0, byteArray.length);
    }

    @Override
    public int read(byte[] byteArray, int int1, int int2) throws IOException {
        if (this.available() < 1) {
            return -1;
        }
        if (this.available() >= int2) {
            return super.read(byteArray, int1, int2);
        }
        return super.read(byteArray, int1, this.available());
    }

    @Override
    public long skip(long long0) throws IOException {
        if (long0 == 0L) {
            return 0L;
        }
        if (long0 > (long)this.available()) {
            return super.skip(this.available());
        }
        return super.skip(long0);
    }

    @Override
    public int available() throws IOException {
        return this.posEnd - this.fileSize - super.available();
    }
}

