/*
 * Decompiled with CFR 0.152.
 */
package sos.xml;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.apache.xalan.xsltc.cmdline.getopt.GetOpt;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import sos.util.SOSFile;

public class SOSXMLValidator
implements ContentHandler,
ErrorHandler,
DTDHandler,
EntityResolver {
    private static final String USAGE = "\nUSAGE: java SOSXMLValidator -i <xml-file> | <dir> [-s schema] [-h]\nvalidate the specified xml file or the xml files in the specified directory.";
    private String[] args;
    private String inputFile;
    private String schemaFile;

    public SOSXMLValidator() {
    }

    public SOSXMLValidator(String[] args) {
        this.args = args;
    }

    public void validate() throws Exception {
        if (this.inputFile == null || this.inputFile.isEmpty()) {
            throw new Exception("no input file was given.");
        }
        SOSXMLValidator.validate(this.inputFile);
    }

    public static void validate(File file) throws Exception {
        SOSXMLValidator.validate(file.getAbsolutePath());
    }

    public static void validate(String fileName) throws Exception {
        try {
            SOSXMLValidator valXML = new SOSXMLValidator();
            SAXParser parser = new SAXParser();
            parser.setFeature("http://xml.org/sax/features/validation", true);
            parser.setFeature("http://apache.org/xml/features/validation/schema", true);
            parser.setContentHandler((ContentHandler)valXML);
            parser.setEntityResolver((EntityResolver)valXML);
            parser.setDTDHandler((DTDHandler)valXML);
            parser.setErrorHandler((ErrorHandler)valXML);
            try {
                parser.parse(SOSXMLValidator.createURL(fileName).toString());
            }
            catch (SAXParseException e) {
                throw new Exception(e.getMessage(), e);
            }
            catch (SAXException e) {
                throw new Exception(e.getMessage(), e);
            }
        }
        catch (Exception e) {
            throw new Exception("error occurred in SOSXMLValidator.validate(): " + e.getMessage(), e);
        }
    }

    public static void validate(InputSource is) throws Exception {
        try {
            SOSXMLValidator valXML = new SOSXMLValidator();
            SAXParser parser = new SAXParser();
            parser.setFeature("http://xml.org/sax/features/validation", true);
            parser.setFeature("http://apache.org/xml/features/validation/schema", true);
            parser.setContentHandler((ContentHandler)valXML);
            parser.setEntityResolver((EntityResolver)valXML);
            parser.setDTDHandler((DTDHandler)valXML);
            parser.setErrorHandler((ErrorHandler)valXML);
            try {
                parser.parse(is);
            }
            catch (SAXParseException e) {
                throw new Exception("Error validating xml: " + e.getMessage(), e);
            }
            catch (SAXException e) {
                throw new Exception("Error validating xml: " + e.getMessage(), e);
            }
        }
        catch (Exception e) {
            throw new Exception("Error validating xml: " + e.getMessage(), e);
        }
    }

    public static void validate(InputSource i, File schemaFile) throws Exception {
        SOSXMLValidator.validate(i, schemaFile.getAbsolutePath());
    }

    public static void validate(String fileName, String schemaFile) throws Exception {
        try {
            SOSXMLValidator valXML = new SOSXMLValidator();
            SAXParser parser = new SAXParser();
            parser.setFeature("http://xml.org/sax/features/validation", true);
            parser.setFeature("http://apache.org/xml/features/validation/schema", true);
            if (schemaFile != null && !schemaFile.isEmpty()) {
                if (schemaFile.trim().indexOf(" ") != -1) {
                    parser.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", (Object)schemaFile);
                } else {
                    parser.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", (Object)schemaFile);
                }
            }
            parser.setContentHandler((ContentHandler)valXML);
            parser.setEntityResolver((EntityResolver)valXML);
            parser.setDTDHandler((DTDHandler)valXML);
            parser.setErrorHandler((ErrorHandler)valXML);
            try {
                parser.parse(SOSXMLValidator.createURL(fileName).toString());
            }
            catch (SAXParseException e) {
                throw new Exception(e.getMessage(), e);
            }
            catch (SAXException e) {
                throw new Exception(e.getMessage(), e);
            }
        }
        catch (Exception e) {
            throw new Exception("error occurred in SOSXMLValidator.validate(): " + e.getMessage());
        }
    }

    public static void validate(InputSource is, String schemaFile) throws Exception {
        try {
            SOSXMLValidator valXML = new SOSXMLValidator();
            SAXParser parser = new SAXParser();
            parser.setFeature("http://xml.org/sax/features/validation", true);
            parser.setFeature("http://apache.org/xml/features/validation/schema", true);
            parser.setContentHandler((ContentHandler)valXML);
            parser.setEntityResolver((EntityResolver)valXML);
            parser.setDTDHandler((DTDHandler)valXML);
            parser.setErrorHandler((ErrorHandler)valXML);
            if (schemaFile != null && !schemaFile.isEmpty()) {
                if (schemaFile.trim().indexOf(" ") != -1) {
                    parser.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", (Object)schemaFile);
                } else {
                    parser.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", (Object)schemaFile);
                }
            }
            try {
                parser.parse(is);
            }
            catch (SAXParseException e) {
                throw new Exception("Error validating xml: " + e.getMessage(), e);
            }
            catch (SAXException e) {
                throw new Exception("Error validating xml: " + e.getMessage(), e);
            }
        }
        catch (Exception e) {
            throw new Exception("Error validating xml: " + e.getMessage(), e);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String string1, String name, String string2, Attributes atts) throws SAXException {
    }

    @Override
    public void endElement(String string1, String name, String string2) throws SAXException {
    }

    @Override
    public void characters(char[] cbuf, int start, int len) {
    }

    @Override
    public void ignorableWhitespace(char[] cbuf, int start, int len) {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        return null;
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) {
    }

    @Override
    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) {
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        throw new SAXException(e.getMessage(), e);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        throw new SAXException(e.getMessage(), e);
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
    }

    @Override
    public void startPrefixMapping(String string, String string1) throws SAXException {
    }

    private static URL createURL(String fileName) throws SAXException {
        URL url = null;
        try {
            url = new URL(fileName);
        }
        catch (MalformedURLException ex) {
            File f = new File(fileName);
            try {
                String path = f.getAbsolutePath();
                String fs = System.getProperty("file.separator");
                if (fs.length() == 1) {
                    char sep = fs.charAt(0);
                    if (sep != '/') {
                        path = path.replace(sep, '/');
                    }
                    if (path.charAt(0) != '/') {
                        path = '/' + path;
                    }
                }
                path = "file://" + path;
                url = new URL(path);
            }
            catch (MalformedURLException e) {
                throw new SAXException("error in createURL(): " + e.getMessage(), e);
            }
        }
        return url;
    }

    public void parseArguments() throws Exception {
        int c;
        if (this.args.length == 0) {
            throw new Exception("no arguments specified.");
        }
        GetOpt getopt = new GetOpt(this.args, "i:s:h");
        block7: while ((c = getopt.getNextOption()) != -1) {
            switch (c) {
                case 105: {
                    this.inputFile = getopt.getOptionArg();
                    File f = new File(this.inputFile);
                    if (f.exists()) continue block7;
                    this.usage("input file missing: " + this.inputFile);
                    continue block7;
                }
                case 115: {
                    this.schemaFile = getopt.getOptionArg();
                    continue block7;
                }
                case 104: {
                    this.usage(null);
                    continue block7;
                }
            }
            this.usage(null);
        }
        if (this.inputFile == null) {
            this.usage("error occurred: more arguments should be specified.");
        }
    }

    public void usage(String message) {
        if (message != null) {
            System.err.println(message);
        }
        System.err.println(USAGE);
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        block9: {
            SOSXMLValidator validator = null;
            try {
                validator = new SOSXMLValidator(args);
                validator.parseArguments();
                File dir = new File(validator.inputFile);
                if (dir.isFile()) {
                    System.out.print("\nfile [" + validator.inputFile + "]: validation in progress ... ");
                    if (validator.schemaFile != null && !validator.schemaFile.isEmpty()) {
                        SOSXMLValidator.validate(validator.inputFile, validator.schemaFile);
                    } else {
                        SOSXMLValidator.validate(validator.inputFile);
                    }
                    System.out.println("ok");
                    break block9;
                }
                if (dir.isDirectory()) {
                    Vector filelist = SOSFile.getFilelist((String)dir.getAbsolutePath(), (String)"\\.xml$", (int)0);
                    for (File currentFile : filelist) {
                        System.out.print("\nfile [" + currentFile.getAbsolutePath() + "]: validation in progress ... ");
                        if (validator.schemaFile != null && !validator.schemaFile.isEmpty()) {
                            SOSXMLValidator.validate(currentFile.getAbsolutePath(), validator.schemaFile);
                        } else {
                            SOSXMLValidator.validate(currentFile.getAbsolutePath());
                        }
                        System.out.println("ok");
                    }
                    break block9;
                }
                throw new Exception("file not found: " + validator.inputFile);
            }
            catch (Exception e) {
                System.out.println("");
                validator.usage(e.getMessage());
            }
        }
    }
}

