/*
 * Decompiled with CFR 0.152.
 */
package com.sos.graphviz.jobchain.diagram;

import com.sos.graphviz.Edge;
import com.sos.graphviz.Graph;
import com.sos.graphviz.GraphIO;
import com.sos.graphviz.Node;
import com.sos.graphviz.SingleNodeProperties;
import com.sos.graphviz.enums.FileType;
import com.sos.graphviz.enums.RankDir;
import com.sos.graphviz.enums.SVGColor;
import com.sos.graphviz.enums.Shape;
import com.sos.graphviz.enums.Style;
import com.sos.graphviz.jobchain.JobChainDiagrammData;
import com.sos.graphviz.jobchain.datasource.jobscheduler.DataSourceFileOrderSinks;
import com.sos.graphviz.jobchain.datasource.jobscheduler.DataSourceFileOrderSources;
import com.sos.graphviz.jobchain.datasource.jobscheduler.DataSourceJobChainNodes;
import com.sos.graphviz.jobchain.datasource.jobscheduler.DataSourceOrders;
import com.sos.scheduler.model.SchedulerObjectFactory;
import com.sos.scheduler.model.objects.JSObjBase;
import com.sos.scheduler.model.objects.JSObjJobChain;
import com.sos.scheduler.model.objects.JSObjOrder;
import com.sos.scheduler.model.objects.JobChain;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobChainDiagramCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobChainDiagramCreator.class);
    private static final String HTML_BR = "<br/>";
    private File outputFile;
    private FileType graphVizImageType = FileType.png;
    private String dotOutputPath;
    private File liveFolder;
    private JobChainDiagrammData jobChainDiagrammData;
    private String jobChainXml;
    private JSObjJobChain jsObjJobChain;

    public JobChainDiagramCreator(String jobChainXml, File liveFolder) {
        this.jobChainXml = jobChainXml;
        this.liveFolder = liveFolder;
    }

    public JobChainDiagramCreator(JSObjJobChain jsObjJobChain, File liveFolder) {
        this.jsObjJobChain = jsObjJobChain;
        this.liveFolder = liveFolder;
    }

    private void newErrorNode(String state) {
        if (this.jobChainDiagrammData.getListOfJobChainNodes().get(state) == null) {
            Node nNotExist = this.jobChainDiagrammData.getGraph().getNodeOrNull(state);
            nNotExist.getSingleNodeProperties().setFillcolor(SVGColor.orangered);
            nNotExist.getSingleNodeProperties().setColor(SVGColor.blue);
            String strH = "<b>" + JSObjBase.escapeHTML((String)state) + "</b>" + HTML_BR;
            strH = strH + "<i><font point-size=\"8\" color=\"yellow\" >missing</font></i><br/>";
            nNotExist.getSingleNodeProperties().setLabel(strH);
        } else {
            Node nErrorState = this.jobChainDiagrammData.getGraph().getNodeOrNull(state);
            if (nErrorState != null) {
                nErrorState.getSingleNodeProperties().setFillcolor(SVGColor.orange);
                nErrorState.getSingleNodeProperties().setColor(SVGColor.blue);
                String strH = "<b>" + JSObjBase.escapeHTML((String)state) + "</b>";
                nErrorState.getSingleNodeProperties().setLabel(strH);
            }
        }
    }

    private Edge newEdge(String from, String to) {
        Edge e = this.jobChainDiagrammData.getGraph().newEdge(from, to);
        e.getEdgeProperties().setColor(SVGColor.cadetblue);
        e.getEdgeProperties().setArrowSize(0.5);
        e.getEdgeProperties().setFontSize(8.0);
        e.getEdgeProperties().setFontName("Arial");
        if (this.jobChainDiagrammData.getListOfFileOrderSinks().get(to) != null) {
            Node nFileSink = this.jobChainDiagrammData.getGraph().getNodeOrNull(to);
            String strH = "<b>" + JSObjBase.escapeHTML((String)to) + "</b>" + HTML_BR;
            strH = strH + "<i><font point-size=\"8\" color=\"blue\" >File Sink</font></i><br/>";
            nFileSink.getSingleNodeProperties().setLabel(strH);
            nFileSink.getSingleNodeProperties().setFillcolor(SVGColor.beige);
        } else {
            JobChain.JobChainNode jobChainToNode = this.jobChainDiagrammData.getListOfJobChainNodes().get(to);
            if (jobChainToNode == null) {
                Node nNotExist = this.jobChainDiagrammData.getGraph().getNodeOrNull(to);
                String strH = "<b>" + JSObjBase.escapeHTML((String)to) + "</b>" + HTML_BR;
                strH = strH + "<i><font point-size=\"8\" color=\"yellow\" >missing</font></i><br/>";
                nNotExist.getSingleNodeProperties().setLabel(strH);
                nNotExist.getSingleNodeProperties().setFillcolor(SVGColor.lightgray);
            } else {
                Node nExist = this.jobChainDiagrammData.getGraph().getNodeOrNull(to);
                String strH = "<b>" + JSObjBase.escapeHTML((String)to) + "</b>" + HTML_BR;
                nExist.getSingleNodeProperties().setLabel(strH);
            }
        }
        return e;
    }

    private String getOrderNodeId(String n) {
        return "order:" + n;
    }

    private void creatingOrders(String firstState) throws Exception {
        this.jobChainDiagrammData.getListOfOrders().getList();
        while (this.jobChainDiagrammData.getListOfOrders().hasNext()) {
            JSObjOrder order = this.jobChainDiagrammData.getListOfOrders().next();
            String jobchainName = order.getJobChainName();
            if (!jobchainName.equalsIgnoreCase(this.jobChainDiagrammData.getListOfOrders().getName())) continue;
            String from = order.getId();
            String to = firstState;
            LOGGER.debug("createGraphVizImageFile.order found:" + from);
            if (order.getState() != null) {
                to = order.getState();
            }
            Node node = this.jobChainDiagrammData.getGraph().newNode(this.getOrderNodeId(from));
            SingleNodeProperties singleNodeProperties = node.getSingleNodeProperties();
            singleNodeProperties.setShape(Shape.ellipse);
            singleNodeProperties.setFillcolor(SVGColor.chartreuse);
            String label = "Order:" + order.getId() + HTML_BR;
            if (order.getTitle() != null) {
                label = label + "<i><font point-size=\"8\" color=\"blue\" >" + JSObjBase.escapeHTML((String)order.getTitle()) + "</font></i>" + HTML_BR;
            }
            singleNodeProperties.setLabel(label);
            Edge eOrderEdge = this.newEdge(this.getOrderNodeId(from), to);
            eOrderEdge.getEdgeProperties().setConstraint(true);
            eOrderEdge.getEdgeProperties().setStyle(Style.dashed);
            eOrderEdge.getEdgeProperties().setColor(SVGColor.black);
        }
    }

    private File createGraphVizImageFile(File imageOutputFolder, boolean showErrorNodes) throws Exception {
        String strH;
        JSObjJobChain jobchain = this.jobChainDiagrammData.getListOfOrders().getJobChain();
        LOGGER.debug("createGraphVizImageFile.job chain.title:" + jobchain.getTitle());
        int fileOrderSourceCnt = 0;
        this.jobChainDiagrammData.getListOfFileOrderSinks().getList();
        this.jobChainDiagrammData.getListOfJobChainNodes().getList();
        if (this.jobChainDiagrammData.getListOfJobChainNodes().size() == 0) {
            return null;
        }
        this.jobChainDiagrammData.getListOfFileOrderSources().getList();
        while (this.jobChainDiagrammData.getListOfFileOrderSources().hasNext()) {
            JobChain.FileOrderSource fileOrderSource = this.jobChainDiagrammData.getListOfFileOrderSources().next();
            String dir = fileOrderSource.getDirectory();
            LOGGER.debug("createGraphVizImageFile.file_order_source found:" + dir);
            String regExp = fileOrderSource.getRegex();
            Node node = this.jobChainDiagrammData.getGraph().newNode("FileOrderSource" + ++fileOrderSourceCnt);
            SingleNodeProperties singleNodeProperties = node.getSingleNodeProperties();
            singleNodeProperties.setFillcolor(SVGColor.beige);
            strH = "";
            strH = "<b>Folder: " + dir + " </b>" + HTML_BR;
            strH = strH + "<i><b>" + JSObjBase.escapeHTML((String)("RegExp: " + regExp)) + "</b></i>" + HTML_BR;
            singleNodeProperties.setColor(SVGColor.blue);
            singleNodeProperties.setLabel(strH);
        }
        String firstState = this.jobChainDiagrammData.getListOfJobChainNodes().getFirstNode();
        if (firstState == null || firstState.isEmpty()) {
            firstState = this.jobChainDiagrammData.getListOfJobChainNodes().getFirstNode();
        }
        this.creatingOrders(firstState);
        String state = null;
        String nextState = null;
        fileOrderSourceCnt = 0;
        this.jobChainDiagrammData.getListOfFileOrderSources().reset();
        while (this.jobChainDiagrammData.getListOfFileOrderSources().hasNext()) {
            JobChain.FileOrderSource fileOrderSource = this.jobChainDiagrammData.getListOfFileOrderSources().next();
            ++fileOrderSourceCnt;
            nextState = fileOrderSource.getNextState();
            if (nextState.trim().isEmpty()) {
                nextState = firstState;
            }
            Edge e = this.newEdge("FileOrderSource" + fileOrderSourceCnt, nextState);
            e.getEdgeProperties().setConstraint(true);
        }
        this.jobChainDiagrammData.getListOfJobChainNodes().reset();
        while (this.jobChainDiagrammData.getListOfJobChainNodes().hasNext()) {
            JobChain.JobChainNode jobChainNode = this.jobChainDiagrammData.getListOfJobChainNodes().next();
            state = jobChainNode.getState();
            int i = state.lastIndexOf(":");
            LOGGER.debug("createGraphVizImageFile.job_chain_node found:" + state);
            if (i > 0 && this.jobChainDiagrammData.getListOfJobChainNodes().get(state.substring(0, i)) != null) {
                String from = state.substring(0, i);
                Edge e = this.newEdge(from, state);
                e.getEdgeProperties().setConstraint(true);
            }
            if ((nextState = jobChainNode.getNextState()) == null || nextState.isEmpty()) continue;
            strH = "";
            String suspend = "";
            boolean isSuspend = false;
            if (jobChainNode.getOnError() != null && "suspend".equals(jobChainNode.getOnError())) {
                suspend = "on error suspend";
                isSuspend = true;
            }
            boolean isSetback = false;
            if (jobChainNode.getOnError() != null && "setback".equals(jobChainNode.getOnError())) {
                isSetback = true;
            }
            strH = "<b>" + JSObjBase.escapeHTML((String)state) + "</b>" + HTML_BR;
            strH = strH + "<i><font point-size=\"8\" color=\"blue\" >" + JSObjBase.escapeHTML((String)jobChainNode.getJob()) + "</font></i>" + HTML_BR;
            if (isSuspend) {
                strH = strH + "<i><font point-size=\"8\" color=\"red\" >" + JSObjBase.escapeHTML((String)suspend) + "</font></i>" + HTML_BR;
            }
            if (isSetback) {
                Edge eSetbackState = this.newEdge(state, state);
                eSetbackState.getEdgeProperties().setConstraint(false);
                eSetbackState.getEdgeProperties().setStyle(Style.dotted);
                eSetbackState.getEdgeProperties().setLabel("..setback");
            }
            Node n = this.jobChainDiagrammData.getGraph().newNode(state);
            n.getSingleNodeProperties().setLabel(strH);
            Edge e = this.newEdge(state, nextState);
            e.getEdgeProperties().setLabel("..next");
            if (jobChainNode.getOnReturnCodes() != null) {
                for (Object onReturnCodeItem : jobChainNode.getOnReturnCodes().getOnReturnCode()) {
                    JobChain.JobChainNode.OnReturnCodes.OnReturnCode.ToState toState;
                    if (!(onReturnCodeItem instanceof JobChain.JobChainNode.OnReturnCodes.OnReturnCode) || (toState = ((JobChain.JobChainNode.OnReturnCodes.OnReturnCode)onReturnCodeItem).getToState()) == null) continue;
                    String toStateValue = toState.getState();
                    Edge eReturnCode = this.newEdge(state, toStateValue);
                    eReturnCode.getEdgeProperties().setLabel("..exit:" + ((JobChain.JobChainNode.OnReturnCodes.OnReturnCode)onReturnCodeItem).getReturnCode());
                }
            }
            String errorState = jobChainNode.getErrorState();
            if (!showErrorNodes || isSetback || isSuspend || errorState == null) continue;
            Edge eErrorState = this.newEdge(state, errorState);
            eErrorState.getEdgeProperties().setConstraint(true);
            eErrorState.getEdgeProperties().setStyle(Style.dotted);
            if (this.jobChainDiagrammData.getListOfFileOrderSinks().get(errorState) != null) continue;
            this.newErrorNode(errorState);
        }
        GraphIO io = new GraphIO(this.jobChainDiagrammData.getGraph());
        if (this.dotOutputPath == null || this.dotOutputPath.isEmpty()) {
            io.setDotDir(this.liveFolder.getAbsolutePath());
            LOGGER.debug("createGraphVizImageFile.dotOutputPath" + this.liveFolder.getAbsolutePath());
        } else {
            io.setDotDir(this.dotOutputPath);
            LOGGER.debug("createGraphVizImageFile.dotOutputPath" + this.dotOutputPath);
        }
        if (this.dotOutputPath == null || this.dotOutputPath.isEmpty()) {
            this.dotOutputPath = "./";
        }
        String name = this.jobChainDiagrammData.getListOfOrders().getName();
        LOGGER.debug("createGraphVizImageFile.jobchain.getObjectName()" + name);
        File output = new File(imageOutputFolder.getAbsolutePath(), name + "." + this.graphVizImageType);
        io.writeGraphToFile(this.graphVizImageType, output);
        return output;
    }

    public File createGraphVizFile(boolean showErrorNodes) throws Exception {
        SchedulerObjectFactory schedulerObjectFactory = new SchedulerObjectFactory();
        schedulerObjectFactory.initMarshaller(JobChain.class);
        this.jobChainDiagrammData = new JobChainDiagrammData();
        Graph graph = new Graph();
        graph.getGraphProperties().setDirection(RankDir.TB);
        graph.getGraphProperties().setFontSize("8");
        graph.getGlobalNodeProperties().setFontsize("8");
        graph.getGlobalNodeProperties().setShape(Shape.box);
        graph.getGlobalNodeProperties().setStyle(Style.rounded + "," + Style.filled);
        graph.getGlobalNodeProperties().setFillcolor(SVGColor.azure);
        graph.getGlobalNodeProperties().setFontname("Arial");
        graph.getGraphProperties().setRatio("auto");
        this.jobChainDiagrammData.setGraph(graph);
        DataSourceFileOrderSinks listOfFileOrderSinks = this.jsObjJobChain != null ? new DataSourceFileOrderSinks(schedulerObjectFactory, this.jsObjJobChain) : new DataSourceFileOrderSinks(schedulerObjectFactory, this.jobChainXml);
        this.jobChainDiagrammData.setListOfFileOrderSinks(listOfFileOrderSinks);
        DataSourceFileOrderSources listOfFileOrderSources = new DataSourceFileOrderSources(schedulerObjectFactory, listOfFileOrderSinks.getJobChain());
        this.jobChainDiagrammData.setListOfFileOrderSources(listOfFileOrderSources);
        DataSourceJobChainNodes listOfJobChainNodes = new DataSourceJobChainNodes(schedulerObjectFactory, listOfFileOrderSinks.getJobChain());
        this.jobChainDiagrammData.setListOfJobChainNodes(listOfJobChainNodes);
        DataSourceOrders listOfOrders = new DataSourceOrders(this.liveFolder, schedulerObjectFactory, listOfFileOrderSinks.getJobChain());
        this.jobChainDiagrammData.setListOfOrders(listOfOrders);
        this.outputFile = this.createGraphVizImageFile(this.liveFolder, showErrorNodes);
        return this.outputFile;
    }

    public File getOutfile() {
        return this.outputFile;
    }

    public void setGraphVizImageType(FileType graphVizImageType) {
        this.graphVizImageType = graphVizImageType;
    }

    public void setDotOutputPath(String dotOutputPath) {
        this.dotOutputPath = dotOutputPath;
    }

    public void setLiveFolder(File liveFolder) {
        this.liveFolder = liveFolder;
    }
}

