/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.command;

import sos.scheduler.command.SOSSchedulerCommand;

public class RemoteScheduler {
    private String host;
    private int port;

    public RemoteScheduler(String host, int tcpPort) {
        this.host = host;
        this.port = tcpPort;
    }

    public RemoteScheduler(String host, int tcpPort, int udpPort) {
        this.host = host;
        this.port = tcpPort;
    }

    public String sendCommand(String command) throws Exception {
        SOSSchedulerCommand schedulerCommand = new SOSSchedulerCommand();
        schedulerCommand.setHost(this.host);
        schedulerCommand.setPort(this.port);
        try {
            schedulerCommand.connect();
            schedulerCommand.sendRequest(command);
            String response = schedulerCommand.getResponse();
            return response;
        }
        catch (Exception e) {
            throw new Exception("Error contacting remote Job Scheduler " + this + ": " + e, e);
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return "http://" + this.host + ":" + this.port;
    }
}

