/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.cron;

import com.sos.JSHelper.Basics.JSToolBox;
import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.scheduler.model.SchedulerObjectFactory;
import com.sos.scheduler.model.objects.Commands;
import com.sos.scheduler.model.objects.JSObjOrder;
import com.sos.scheduler.model.objects.JobChain;
import com.sos.scheduler.model.objects.JobChains;
import com.sos.scheduler.model.objects.Jobs;
import com.sos.scheduler.model.objects.Order;
import com.sos.scheduler.model.objects.Spooler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBElement;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sos.util.SOSDate;

public class CronConverter
extends JSToolBox {
    private static final Logger LOGGER = LoggerFactory.getLogger(CronConverter.class);
    protected Pattern cronRegExPattern;
    protected Pattern cronRegExSystemPattern;
    protected Pattern cronRegExAliasPattern;
    protected Pattern cronRegExCommentPattern;
    protected Pattern cronRegExJobNamePattern;
    protected Pattern cronRegExPuppetNamePattern;
    protected Pattern cronRegExJobTitlePattern;
    protected Pattern cronRegExJobTimeoutPattern;
    protected Pattern cronRegExEnvironmentPattern;
    protected Pattern currentCronPattern;
    protected String strBaseDirectory = "CronTabConverter";
    protected String strMockCommand = "ping -n 20 localhost";
    private static final String CLASSNAME = "CronConverter";
    private static final String TRUE = "true";
    private static final String NEWLINE = "\n";
    private static final String STATE_ERROR = "!error";
    private static final String STATE_SUCCESS = "success";
    private static final String SYSTEM_CRONTAB_NAME = "/etc/crontab";
    private static final String ATTRIBUTE_ERROR_STATE = "error_state";
    private static final String ATTRIBUTE_NEXT_STATE = "next_state";
    private static final String ATTRIBUTE_JOB_CHAIN = "job_chain";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_STATE = "state";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_ORDER = "order";
    private static final String ATTRIBUTE_TITLE = "title";
    private static final String ATTRIBUTE_LANGUAGE = "language";
    private static final String TAG_JOB_CHAIN_NODE = "job_chain_node";
    private static final String TAG_ADD_ORDER = "add_order";
    private static final String TAG_JOB = "job";
    private static final String TAG_RUN_TIME = "run_time";
    private static final String TAG_SCRIPT = "script";
    private static final String TAG_SPOOLER = "spooler";
    private static final String OPTION_CREATE_MOCK = "createMock";
    private static final String OPTION_CREATE_JobChains = "createJobChains";
    private static final String OPTION_TIMEOUT = "timeout";
    private static final String OPTION_CHANGEUSER = "changeuser";
    private static final String OPTION_VERBOSE = "v";
    private static final String OPTION_TARGET = "target";
    private static final String OPTIONS_SYSTAB = "systab";
    private static final String OPTION_CRONTAB = "crontab";
    private static final String CRON_REGEX = "-?([^\\s]+)\\s+([^\\s]+)\\s+([^\\s]+)\\s+([^\\s]+)\\s+([^\\s]+)\\s+(.+)$";
    private static final String CRON_REGEX_SYSTEM = "-?([^\\s]+)\\s+([^\\s]+)\\s+([^\\s]+)\\s+([^\\s]+)\\s+([^\\s]+)\\s+([^\\s]+)\\s+(.+)$";
    private static final String CRON_REGEX_ALIAS = "(@reboot|@yearly|@annually|@monthly|@weekly|@daily|@midnight|@hourly)\\s+(.+)$";
    private static final String CRON_REGEX_COMMENT = "^\\s*#\\s*(.+)";
    private static final String CRON_REGEX_JOBNAME = "\\s*job_name\\s*=\\s*(.+)";
    private static final String CRON_REGEX_PUPPETNAME = "\\s*Puppet Name\\s*:\\s*(.+)";
    private static final String CRON_REGEX_JOBTITLE = "\\s*job_title\\s*=\\s*(.+)";
    private static final String CRON_REGEX_JOBTIMEOUT = "\\s*job_timeout\\s*=\\s*(.+)";
    private static final String CRON_REGEX_ENVIRONMENT = "^\\s*(\\w+)\\s*=\\s*(.+)";
    private static final String COMMAND_REGEX = "[^\\s]*/[^\\s]*";
    private static final String JOBNAME_REGEX = "(.*)_(\\d*)$";
    private final DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
    private final DocumentBuilder docBuilder;
    private final Pattern commandRegExPattern;
    private final Pattern jobNameRegExPattern;
    private final boolean flgCreateExtensionTags = false;
    private final boolean flgCreateSubFolderStructure = true;
    private boolean oldRunTime = false;
    private boolean usedNewRunTime = false;
    private boolean systemCronTab = false;
    private boolean flgCreateAMock = false;
    private boolean flgCreateJobChainJobs = false;
    private String changeUserCommand = "";
    private String strCronLine = "";
    private HashSet<String> skipLines = new HashSet();
    private HashSet<String> reservedJobNames = new HashSet();
    private String timeout = "600";
    private String lastComment = "";

    public boolean isCreateAMock() {
        return this.flgCreateAMock;
    }

    public void setCreateAMock(boolean createAMok) {
        this.flgCreateAMock = createAMok;
    }

    public boolean isCreateJobChainJobs() {
        return this.flgCreateJobChainJobs;
    }

    public void setCreateJobChainJobs(boolean createJobChainJobs) {
        this.flgCreateJobChainJobs = createJobChainJobs;
    }

    public static void main(String[] args) {
        LOGGER.info("SOS CronConverter - Main");
        try {
            String sourceFile = "";
            String targetFile = "";
            String changeUser = "";
            File source = null;
            File target = null;
            int logLevel = 0;
            boolean sysTab = false;
            boolean useOldRunTime = false;
            String jobTimeout = "";
            Options options = new Options();
            OptionBuilder.withArgName((String)"0|1");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"set to 1 if source is the system crontab (with user field)");
            Option optSysTab = OptionBuilder.create((String)OPTIONS_SYSTAB);
            OptionBuilder.withArgName((String)"file");
            OptionBuilder.hasArgs();
            OptionBuilder.isRequired();
            OptionBuilder.withDescription((String)"crontab file");
            Option optSourceFile = OptionBuilder.create((String)OPTION_CRONTAB);
            OptionBuilder.withArgName((String)"file");
            OptionBuilder.hasArgs();
            OptionBuilder.isRequired();
            OptionBuilder.withDescription((String)"xml configuration file");
            Option optTargetFile = OptionBuilder.create((String)OPTION_TARGET);
            OptionBuilder.withArgName((String)"level");
            OptionBuilder.hasArg();
            OptionBuilder.withType((Object)new Integer(0));
            OptionBuilder.withDescription((String)"loglevel [0=info] [1=debug1]...[9=debug]");
            Option optLogLevel = OptionBuilder.create((String)OPTION_VERBOSE);
            OptionBuilder.withArgName((String)"command");
            OptionBuilder.hasArgs();
            OptionBuilder.withDescription((String)"change user command for -systab=1. 'su' or 'sudo' or define your own command using $SCHEDULER_CRONTAB_USER.");
            Option optChangeUser = OptionBuilder.create((String)OPTION_CHANGEUSER);
            OptionBuilder.withArgName((String)"seconds");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"job timeout (0 for unlimited");
            Option optTimeOut = OptionBuilder.create((String)OPTION_TIMEOUT);
            Option optOldRunTime = new Option("oldRunTime", "");
            OptionBuilder.withArgName((String)"true|false");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"set to true if script has to be mok'ed");
            Option optCreateMok = OptionBuilder.create((String)OPTION_CREATE_MOCK);
            OptionBuilder.withArgName((String)"true|false");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"set to true if you want to create jobChains and jobs");
            Option optCreateJobChains = OptionBuilder.create((String)OPTION_CREATE_JobChains);
            options.addOption(optSysTab);
            options.addOption(optSourceFile);
            options.addOption(optTargetFile);
            options.addOption(optLogLevel);
            options.addOption(optChangeUser);
            options.addOption(optCreateMok);
            options.addOption(optCreateJobChains);
            GnuParser parser = new GnuParser();
            CommandLine line = null;
            try {
                line = parser.parse(options, args);
            }
            catch (Exception e) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("cronconverter", options, true);
                System.exit(0);
            }
            sourceFile = CronConverter.getWholeArgument(line.getOptionValues(OPTION_CRONTAB));
            if (SYSTEM_CRONTAB_NAME.equalsIgnoreCase(sourceFile)) {
                sysTab = true;
            }
            targetFile = CronConverter.getWholeArgument(line.getOptionValues(OPTION_TARGET));
            String ll = line.getOptionValue(OPTION_VERBOSE, "1");
            logLevel = Integer.parseInt(ll);
            if (line.hasOption(optSysTab.getOpt())) {
                sysTab = "1".equals(line.getOptionValue(optSysTab.getOpt()).trim());
            }
            useOldRunTime = line.hasOption("oldRunTime");
            changeUser = "";
            if (line.hasOption(OPTION_CHANGEUSER)) {
                changeUser = CronConverter.getWholeArgument(line.getOptionValues(OPTION_CHANGEUSER));
            }
            jobTimeout = line.getOptionValue(OPTION_TIMEOUT);
            if (logLevel == 0) {
                logLevel = 1;
            }
            target = new File(targetFile);
            source = new File(sourceFile);
            CronConverter cc = new CronConverter();
            if (jobTimeout != null && !jobTimeout.isEmpty()) {
                cc.setTimeout(jobTimeout);
            }
            cc.setChangeUserCommand(changeUser);
            if (line.hasOption(OPTION_CREATE_MOCK)) {
                cc.setCreateAMock(TRUE.equalsIgnoreCase(line.getOptionValue(OPTION_CREATE_MOCK)));
            }
            if (line.hasOption(OPTION_CREATE_JobChains)) {
                cc.setCreateJobChainJobs(TRUE.equalsIgnoreCase(line.getOptionValue(OPTION_CREATE_JobChains)));
            }
            cc.setSystemCronTab(sysTab);
            cc.oldRunTime = useOldRunTime;
            cc.cronFile2SchedulerXMLFile(source, target);
            SchedulerObjectFactory objSchedulerObjectFactory = new SchedulerObjectFactory();
            objSchedulerObjectFactory.initMarshaller(Spooler.class);
            Spooler objSchedulerConfig = (Spooler)objSchedulerObjectFactory.unMarshall(target);
            Spooler.Config objConfig = (Spooler.Config)objSchedulerConfig.getConfig().get(0);
            LOGGER.debug("" + objConfig.getPort());
            LOGGER.debug("" + objConfig.getTcpPort());
            LOGGER.debug("" + objConfig.getUdpPort());
            String strPathName = new File(sourceFile).getParent();
            strPathName = strPathName + "/live/";
            new File(strPathName).mkdirs();
            Jobs objJobs = objConfig.getJobs();
            if (objJobs != null) {
                for (Object objJob : objConfig.getJobs().getJob()) {
                    String strJobName = objJob.getName();
                    objJob.setName("");
                    objJob.setParent(objSchedulerObjectFactory);
                    LOGGER.debug("job name = " + strJobName);
                    File fleTargetFile = new File(strPathName + strJobName + ".job.xml");
                    objJob.marshal(fleTargetFile);
                }
            } else {
                LOGGER.debug("no jobs found");
            }
            JobChains objJobchains = objConfig.getJobChains();
            if (objJobchains != null) {
                for (JobChain objJobchain : objConfig.getJobChains().getJobChain()) {
                    String strJobChainName = objJobchain.getName();
                    objJobchain.setName("");
                    objJobchain.setParent(objSchedulerObjectFactory);
                    LOGGER.debug("chain name = " + strJobChainName);
                    File fleTargetFile = new File(strPathName + strJobChainName + ".job_chain.xml");
                    objJobchain.marshal(fleTargetFile);
                }
            } else {
                LOGGER.debug("no chains found");
            }
            Commands objCommands = objConfig.getCommands();
            if (objCommands != null) {
                for (Object objO : objCommands.getAddJobsOrAddOrderOrCheckFolders()) {
                    System.out.println(objO.getClass().getName());
                    JAXBElement objJ = (JAXBElement)objO;
                    if (!(objO instanceof Order)) continue;
                    Order objOrder = (Order)objO;
                    JSObjOrder objJSO = new JSObjOrder(objSchedulerObjectFactory);
                    objJSO.getOrderFromXMLString(objOrder.toXMLString());
                    String strOrderFileName = objJSO.createFileName(strPathName);
                    LOGGER.debug("order name = " + strOrderFileName);
                    File fleTargetFile = new File(strOrderFileName);
                    objOrder.marshal(fleTargetFile);
                }
            } else {
                LOGGER.debug("no orders found");
            }
            LOGGER.debug("ready");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private static String getWholeArgument(String[] optionValues) {
        String value = "";
        for (int i = 0; i < optionValues.length; ++i) {
            value = value + optionValues[i];
            if (i + 1 >= optionValues.length) continue;
            value = value + " ";
        }
        return value;
    }

    public CronConverter() throws Exception {
        this.docBuilder = this.docFactory.newDocumentBuilder();
        this.cronRegExAliasPattern = Pattern.compile(CRON_REGEX_ALIAS);
        this.cronRegExPattern = Pattern.compile(CRON_REGEX);
        this.cronRegExSystemPattern = Pattern.compile(CRON_REGEX_SYSTEM);
        this.cronRegExCommentPattern = Pattern.compile(CRON_REGEX_COMMENT);
        this.cronRegExEnvironmentPattern = Pattern.compile(CRON_REGEX_ENVIRONMENT);
        this.commandRegExPattern = Pattern.compile(COMMAND_REGEX);
        this.jobNameRegExPattern = Pattern.compile(JOBNAME_REGEX);
        this.cronRegExJobNamePattern = Pattern.compile(CRON_REGEX_JOBNAME);
        this.cronRegExPuppetNamePattern = Pattern.compile(CRON_REGEX_PUPPETNAME);
        this.cronRegExJobTitlePattern = Pattern.compile(CRON_REGEX_JOBTITLE);
        this.cronRegExJobTimeoutPattern = Pattern.compile(CRON_REGEX_JOBTIMEOUT);
        this.currentCronPattern = this.cronRegExPattern;
    }

    public void cronFile2SchedulerXMLFile(File cronFile, File schedulerXML) throws Exception {
        try {
            Document configurationDocument = this.cronFile2SchedulerXML(cronFile, new HashMap<String, Element>());
            LOGGER.debug("writing " + schedulerXML.getAbsolutePath());
            FileOutputStream fout = new FileOutputStream(schedulerXML, false);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)fout, "UTF-8");
            OutputFormat format = new OutputFormat(configurationDocument);
            format.setEncoding("UTF-8");
            format.setIndenting(true);
            format.setIndent(2);
            XMLSerializer serializer = new XMLSerializer((Writer)out, format);
            serializer.setNamespaces(true);
            serializer.serialize(configurationDocument);
            out.close();
        }
        catch (Exception e) {
            throw new JobSchedulerException("Error writing JobScheduler configuration file: " + e, (Throwable)e);
        }
    }

    public Document cronFile2SchedulerXML(File cronFile, HashMap<String, Element> cron2jobMapping) throws Exception {
        try {
            HashSet<String> jobNames = new HashSet<String>();
            if (this.reservedJobNames != null) {
                jobNames.addAll(this.reservedJobNames);
            }
            HashMap<String, String> environmentVariables = new HashMap<String, String>();
            Document configurationDoc = this.docBuilder.newDocument();
            Element spoolerElement = configurationDoc.createElement(TAG_SPOOLER);
            configurationDoc.appendChild(spoolerElement);
            Element configElement = configurationDoc.createElement("config");
            spoolerElement.appendChild(configElement);
            Element jobsElement = configurationDoc.createElement("jobs");
            configElement.appendChild(jobsElement);
            BufferedReader in = new BufferedReader(new FileReader(cronFile));
            Vector<Element> vecJobs = new Vector<Element>();
            Vector<String> vecCronRecords = new Vector<String>();
            this.lastComment = "";
            String lastCommentJobName = "";
            String lastCommentJobTitle = "";
            String lastCommentJobTimeout = "";
            while ((this.strCronLine = in.readLine()) != null) {
                if (this.strCronLine.trim().length() == 0) {
                    this.lastComment = "";
                    continue;
                }
                if (this.skipLines != null && this.skipLines.contains(this.strCronLine)) {
                    LOGGER.debug("Skipping line " + this.strCronLine);
                    this.lastComment = "";
                    lastCommentJobName = "";
                    lastCommentJobTitle = "";
                    lastCommentJobTimeout = "";
                    continue;
                }
                Matcher commentMatcher = this.cronRegExCommentPattern.matcher(this.strCronLine);
                if (commentMatcher.matches()) {
                    Matcher jobNameMatcher = this.cronRegExJobNamePattern.matcher(commentMatcher.group(1));
                    Matcher puppetNameMatcher = this.cronRegExPuppetNamePattern.matcher(commentMatcher.group(1));
                    Matcher jobTitleMatcher = this.cronRegExJobTitlePattern.matcher(commentMatcher.group(1));
                    Matcher jobTimeoutMatcher = this.cronRegExJobTimeoutPattern.matcher(commentMatcher.group(1));
                    if (jobNameMatcher.matches()) {
                        lastCommentJobName = jobNameMatcher.group(1);
                        lastCommentJobName = lastCommentJobName.replaceAll(" ", "_");
                        LOGGER.debug("Found job name in comment: " + lastCommentJobName);
                        continue;
                    }
                    if (puppetNameMatcher.matches()) {
                        lastCommentJobName = puppetNameMatcher.group(1).trim();
                        if (this.isEmpty(lastCommentJobTitle)) {
                            lastCommentJobTitle = lastCommentJobName;
                        }
                        lastCommentJobName = lastCommentJobName.trim().replaceAll(" ", "_");
                        LOGGER.debug("Found job name in comment: " + lastCommentJobName);
                        continue;
                    }
                    if (jobTitleMatcher.matches()) {
                        lastCommentJobTitle = jobTitleMatcher.group(1);
                        LOGGER.debug("Found job title in comment: " + lastCommentJobTitle);
                        continue;
                    }
                    if (jobTimeoutMatcher.matches()) {
                        lastCommentJobTimeout = jobTimeoutMatcher.group(1);
                        LOGGER.debug("Found job timeout in comment: " + lastCommentJobTimeout);
                        continue;
                    }
                    if (this.isNotEmpty(this.lastComment)) {
                        this.lastComment = this.lastComment + NEWLINE;
                    }
                    this.lastComment = this.lastComment + commentMatcher.group(1);
                    continue;
                }
                Matcher environmentMatcher = this.cronRegExEnvironmentPattern.matcher(this.strCronLine);
                if (environmentMatcher.matches()) {
                    String envName = environmentMatcher.group(1);
                    String envValue = environmentMatcher.group(2);
                    LOGGER.debug("Found environment variable [" + envName + "]: " + envValue);
                    if (envValue.startsWith("\"") && envValue.endsWith("\"")) {
                        envValue = envValue.substring(1, envValue.length() - 1);
                    }
                    environmentVariables.put(envName, envValue);
                    this.lastComment = "";
                }
                Matcher cronMatcher = this.currentCronPattern.matcher(this.strCronLine);
                Matcher cronAliasMatcher = this.cronRegExAliasPattern.matcher(this.strCronLine);
                if (!cronMatcher.matches() && !cronAliasMatcher.matches()) continue;
                vecCronRecords.add(this.strCronLine);
                Document jobDocument = this.createJobElement(this.strCronLine, environmentVariables);
                Element jobElement = jobDocument.getDocumentElement();
                boolean jobNameChanged = false;
                if (this.isNotEmpty(lastCommentJobName)) {
                    lastCommentJobName = lastCommentJobName.replaceAll(">", "_");
                    jobElement.setAttribute(ATTRIBUTE_NAME, lastCommentJobName.replaceAll("/", "_"));
                    lastCommentJobName = "";
                }
                if (this.isNotEmpty(lastCommentJobTitle)) {
                    jobElement.setAttribute(ATTRIBUTE_TITLE, lastCommentJobTitle);
                    lastCommentJobTitle = "";
                }
                if (this.isNotEmpty(lastCommentJobTimeout)) {
                    jobElement.setAttribute(OPTION_TIMEOUT, lastCommentJobTimeout);
                    lastCommentJobTimeout = "";
                }
                String jobName = jobElement.getAttribute(ATTRIBUTE_NAME);
                while (jobNames.contains(jobName)) {
                    jobName = this.incrementJobName(jobName);
                    jobNameChanged = true;
                }
                if (jobNameChanged) {
                    LOGGER.debug("Setting new job name \"" + jobName + "\"");
                    jobElement.setAttribute(ATTRIBUTE_NAME, jobName);
                }
                jobNames.add(jobName);
                Node importedJob = configurationDoc.importNode(jobElement, true);
                cron2jobMapping.put(this.strCronLine, jobElement);
                if (this.isNotEmpty(this.lastComment)) {
                    this.lastComment = this.lastComment.replaceAll("--", "__");
                    Comment jobComment = configurationDoc.createComment(this.lastComment);
                    jobsElement.appendChild(jobComment);
                }
                jobsElement.appendChild(importedJob);
                this.lastComment = "";
                vecJobs.add(jobElement);
            }
            if (this.isCreateJobChainJobs()) {
                Element jobChainsElement = configurationDoc.createElement("job_chains");
                configElement.appendChild(jobChainsElement);
                int i = 0;
                for (Element objJobElement : vecJobs) {
                    this.strCronLine = (String)vecCronRecords.get(i++);
                    Document objJCD = this.createJobChainElement(objJobElement);
                    Element objJC = objJCD.getDocumentElement();
                    jobChainsElement.appendChild(configurationDoc.importNode(objJC, true));
                }
                Element commandsElement = configurationDoc.createElement("commands");
                configElement.appendChild(commandsElement);
                i = 0;
                for (Element objJobElement : vecJobs) {
                    this.strCronLine = (String)vecCronRecords.get(i++);
                    Document objJCD = this.createOrderElement(objJobElement);
                    Element objJC = objJCD.getDocumentElement();
                    commandsElement.appendChild(configurationDoc.importNode(objJC, true));
                }
            }
            in.close();
            return configurationDoc;
        }
        catch (Exception e) {
            throw new JobSchedulerException("Error converting file " + cronFile.getAbsolutePath() + " to JobScheduler XML: " + e, (Throwable)e);
        }
    }

    private String incrementJobName(String jobName) {
        Matcher jobNameMatcher = this.jobNameRegExPattern.matcher(jobName);
        if (jobNameMatcher.matches()) {
            String baseName = jobNameMatcher.group(1);
            String counter = jobNameMatcher.group(2);
            int iCounter = Integer.parseInt(counter);
            jobName = baseName + "_" + ++iCounter;
        } else {
            jobName = jobName + "_1";
        }
        return jobName;
    }

    public Document createJobElement(String cronline) throws Exception {
        return this.createJobElement(cronline, new HashMap<String, String>());
    }

    public Document createJobChainElement(Element pobjJobElement) throws DOMException, Exception {
        Document jobchain = this.docBuilder.newDocument();
        Element jobChainElement = jobchain.createElement(ATTRIBUTE_JOB_CHAIN);
        jobChainElement.setAttribute(ATTRIBUTE_NAME, pobjJobElement.getAttribute(ATTRIBUTE_NAME));
        Element jobChainNode = jobchain.createElement(TAG_JOB_CHAIN_NODE);
        jobChainNode.setAttribute(ATTRIBUTE_STATE, "100");
        jobChainNode.setAttribute(TAG_JOB, this.getNameWithoutPath(pobjJobElement.getAttribute(ATTRIBUTE_NAME)));
        jobChainNode.setAttribute(ATTRIBUTE_NEXT_STATE, STATE_SUCCESS);
        jobChainNode.setAttribute(ATTRIBUTE_ERROR_STATE, STATE_ERROR);
        jobChainElement.appendChild(jobChainNode);
        jobChainNode = jobchain.createElement(TAG_JOB_CHAIN_NODE);
        jobChainNode.setAttribute(ATTRIBUTE_STATE, STATE_SUCCESS);
        jobChainElement.appendChild(jobChainNode);
        jobChainNode = jobchain.createElement(TAG_JOB_CHAIN_NODE);
        jobChainNode.setAttribute(ATTRIBUTE_STATE, STATE_ERROR);
        jobChainElement.appendChild(jobChainNode);
        jobchain.appendChild(jobChainElement);
        return jobchain;
    }

    private Element createExtension(Document pobjDoc) throws DOMException, Exception {
        Element objExtensions = pobjDoc.createElement("extensions");
        Element objExtension = pobjDoc.createElementNS("www.sos-berlin.com/schema/joe", "extension");
        Element objGenerator = pobjDoc.createElement("generator");
        objExtension.appendChild(objGenerator);
        objGenerator.setAttribute(ATTRIBUTE_NAME, CLASSNAME);
        objGenerator.setAttribute("date", SOSDate.getCurrentTimeAsString());
        objGenerator.setAttribute("vendor", "www.sos-berlin.com");
        Element objComments = pobjDoc.createElement("comment");
        CDATASection objCommentNode = pobjDoc.createCDATASection(this.lastComment);
        objComments.appendChild(objCommentNode);
        objExtension.appendChild(objComments);
        Element objDocu = pobjDoc.createElement("docu");
        CDATASection objDocuNode = pobjDoc.createCDATASection(this.strCronLine);
        objDocu.appendChild(objDocuNode);
        objGenerator.appendChild(objDocu);
        objExtensions.appendChild(objExtension);
        return objExtensions;
    }

    public Document createOrderElement(Element pobjJobElement) throws Exception {
        Document objOrderDocument = this.docBuilder.newDocument();
        Element addOrderElement = objOrderDocument.createElement(TAG_ADD_ORDER);
        String strOrderID = pobjJobElement.getAttribute(ATTRIBUTE_NAME);
        addOrderElement.setAttribute(ATTRIBUTE_ID, this.getNameWithoutPath(strOrderID));
        addOrderElement.setAttribute(ATTRIBUTE_TITLE, pobjJobElement.getAttribute(ATTRIBUTE_NAME));
        addOrderElement.setAttribute(ATTRIBUTE_JOB_CHAIN, pobjJobElement.getAttribute(ATTRIBUTE_NAME));
        Element runTimeElement = objOrderDocument.createElement(TAG_RUN_TIME);
        LOGGER.debug(this.strCronLine);
        this.cronRegExPattern = Pattern.compile(CRON_REGEX);
        Matcher cronRegExMatcher = this.cronRegExPattern.matcher(this.strCronLine);
        this.createRunTime(cronRegExMatcher, runTimeElement);
        addOrderElement.appendChild(runTimeElement);
        objOrderDocument.appendChild(addOrderElement);
        return objOrderDocument;
    }

    private String getNameWithoutPath(String pstrName) {
        String strRet = pstrName;
        int i = pstrName.lastIndexOf("/");
        if (i != -1) {
            strRet = pstrName.substring(i + 1);
        }
        return strRet;
    }

    public Document createJobElement(String cronline, HashMap<String, String> environmentVariables) throws Exception {
        try {
            LOGGER.info("processing line: " + cronline);
            Document eleJob = this.docBuilder.newDocument();
            Element jobElement = eleJob.createElement(TAG_JOB);
            Matcher cronRegExAliasMatcher = this.cronRegExAliasPattern.matcher(cronline);
            if (cronRegExAliasMatcher.matches()) {
                LOGGER.debug("Current line matches pattern (@reboot|@yearly|@annually|@monthly|@weekly|@daily|@midnight|@hourly)\\s+(.+)$");
                cronline = this.convertAlias(cronRegExAliasMatcher);
            }
            Matcher cronRegExMatcher = this.cronRegExPattern.matcher(cronline);
            int commandIndex = 6;
            if (this.isSystemCronTab()) {
                commandIndex = 7;
                cronRegExMatcher = this.cronRegExSystemPattern.matcher(cronline);
            }
            if (!cronRegExMatcher.matches()) {
                throw new JobSchedulerException("Fail to parse cron line \"" + cronline + "\"");
            }
            String jobname = this.getJobName(cronRegExMatcher.group(commandIndex));
            jobElement.setAttribute(ATTRIBUTE_NAME, jobname);
            if (this.isCreateJobChainJobs()) {
                jobElement.setAttribute(ATTRIBUTE_ORDER, "yes");
            } else {
                jobElement.setAttribute(ATTRIBUTE_ORDER, "no");
            }
            jobElement.setAttribute(ATTRIBUTE_TITLE, "Cron Job " + cronRegExMatcher.group(commandIndex).trim());
            if (this.timeout != null && !"0".equals(this.timeout)) {
                jobElement.setAttribute(OPTION_TIMEOUT, this.timeout);
            }
            String schedulerUser = "";
            String command = cronRegExMatcher.group(commandIndex);
            if (this.isSystemCronTab()) {
                schedulerUser = cronRegExMatcher.group(6);
                command = (this.changeUserCommand + " " + command).trim();
            }
            if (!this.isCreateJobChainJobs()) {
                LOGGER.debug("Creating params element");
                Element paramsElement = eleJob.createElement("params");
                LOGGER.debug("Creating param element (command)");
                Element paramCommandElement = eleJob.createElement("param");
                paramCommandElement.setAttribute(ATTRIBUTE_NAME, "command");
                paramCommandElement.setAttribute("value", command);
                paramsElement.appendChild(paramCommandElement);
                jobElement.appendChild(paramsElement);
            }
            LOGGER.debug("Creating script element");
            Element scriptElement = eleJob.createElement(TAG_SCRIPT);
            scriptElement.setAttribute(ATTRIBUTE_LANGUAGE, "shell");
            String script = NEWLINE;
            if (this.isNotEmpty(schedulerUser)) {
                script = script + "export SCHEDULER_CRONTAB_USER=" + schedulerUser + NEWLINE;
            }
            Iterator<String> envIter = environmentVariables.keySet().iterator();
            while (envIter.hasNext()) {
                String envName = envIter.next().toString();
                String envValue = environmentVariables.get(envName).toString();
                script = script + envName + "=" + envValue + NEWLINE;
                script = script + "export " + envName + NEWLINE;
            }
            script = script + "echo created by CronConverter, at " + SOSDate.getCurrentTimeAsString() + NEWLINE;
            if (this.isCreateAMock()) {
                script = script + "echo mock-mode: " + command + NEWLINE;
                if (this.isNotEmpty(this.strMockCommand)) {
                    script = script + this.strMockCommand + NEWLINE;
                }
                script = script + "exit 0\n";
            } else {
                script = script + command;
            }
            CDATASection scriptData = eleJob.createCDATASection(script);
            scriptElement.appendChild(scriptData);
            jobElement.appendChild(scriptElement);
            if (!this.isCreateJobChainJobs()) {
                Element runTimeElement = eleJob.createElement(TAG_RUN_TIME);
                this.createRunTime(cronRegExMatcher, runTimeElement);
                if (this.usedNewRunTime && this.oldRunTime) {
                    this.usedNewRunTime = false;
                    Document runTimeDocument = this.docBuilder.newDocument();
                    runTimeDocument.appendChild(runTimeDocument.importNode(runTimeElement, true));
                    StringWriter out = new StringWriter();
                    OutputFormat format = new OutputFormat(runTimeDocument);
                    format.setIndenting(true);
                    format.setIndent(2);
                    format.setOmitXMLDeclaration(true);
                    XMLSerializer serializer = new XMLSerializer((Writer)out, format);
                    serializer.serialize(runTimeDocument);
                    Comment runTimeComment = eleJob.createComment("This run_time is currently not supported:\n" + out.toString());
                    jobElement.appendChild(runTimeComment);
                } else {
                    jobElement.appendChild(runTimeElement);
                }
            }
            eleJob.appendChild(jobElement);
            return eleJob;
        }
        catch (Exception e) {
            throw new JobSchedulerException("Error occured creating job from cron line: " + cronline, (Throwable)e);
        }
    }

    private void createRunTime(Matcher pcronRegExMatcher, Element runTimeElement) throws Exception {
        try {
            if (!pcronRegExMatcher.matches()) {
                throw new JobSchedulerException("Fail to parse cron line \"" + this.strCronLine + "\", regexp is " + pcronRegExMatcher.toString());
            }
            String minutes = pcronRegExMatcher.group(1);
            String hours = pcronRegExMatcher.group(2);
            String days = pcronRegExMatcher.group(3);
            String months = pcronRegExMatcher.group(4);
            String weekdays = pcronRegExMatcher.group(5);
            if ("@reboot".equals(minutes)) {
                runTimeElement.setAttribute("once", "yes");
                return;
            }
            Vector<Element> childElements = new Vector<Element>();
            Element periodElement = runTimeElement.getOwnerDocument().createElement("period");
            LOGGER.debug("processing hours [" + hours + "] and minutes [" + minutes + "]");
            if (minutes.startsWith("*")) {
                if ("*".equalsIgnoreCase(minutes)) {
                    periodElement.setAttribute("repeat", "60");
                } else {
                    String repeat = minutes.substring(2);
                    repeat = CronConverter.formatTwoDigits(repeat);
                    periodElement.setAttribute("repeat", "00:" + repeat);
                }
                if (hours.startsWith("*")) {
                    if (!"*".equalsIgnoreCase(hours)) {
                        throw new JobSchedulerException("Combination of minutes and hours not supported: " + minutes + " " + hours);
                    }
                    childElements.add(periodElement);
                } else {
                    LOGGER.debug("Found specific hours, creating periods with begin and end.");
                    String[] hourArray = hours.split(",");
                    for (int i = 0; i < hourArray.length; ++i) {
                        String currentHour = hourArray[i];
                        if (currentHour.indexOf("/") != -1) {
                            String[] additionalHours = this.getArrayFromColumn(currentHour);
                            hourArray = CronConverter.combineArrays(hourArray, additionalHours);
                            continue;
                        }
                        String[] currentHourArray = currentHour.split("-");
                        Element currentPeriodElement = (Element)periodElement.cloneNode(true);
                        String beginHour = currentHourArray[0];
                        int iEndHour = (Integer.parseInt(beginHour) + 1) % 24;
                        if (iEndHour == 0) {
                            iEndHour = 24;
                        }
                        String endHour = "" + iEndHour;
                        if (currentHourArray.length > 1) {
                            endHour = currentHourArray[1];
                        }
                        beginHour = CronConverter.formatTwoDigits(beginHour);
                        endHour = CronConverter.formatTwoDigits(endHour);
                        currentPeriodElement.setAttribute("begin", beginHour + ":00");
                        currentPeriodElement.setAttribute("end", endHour + ":00");
                        childElements.add(currentPeriodElement);
                    }
                }
            } else {
                String[] minutesArray;
                for (String element : minutesArray = this.getArrayFromColumn(minutes)) {
                    String[] hourArray;
                    Element currentPeriodElement = (Element)periodElement.cloneNode(true);
                    String currentMinute = element;
                    currentMinute = CronConverter.formatTwoDigits(currentMinute);
                    if (hours.startsWith("*")) {
                        currentPeriodElement.setAttribute("absolute_repeat", "01:00");
                        this.usedNewRunTime = true;
                        if (!"*".equalsIgnoreCase(hours)) {
                            String repeat = hours.substring(2);
                            repeat = CronConverter.formatTwoDigits(repeat);
                            currentPeriodElement.setAttribute("absolute_repeat", repeat + ":00");
                        }
                        currentPeriodElement.setAttribute("begin", "00:" + currentMinute);
                        childElements.add(currentPeriodElement);
                        continue;
                    }
                    for (String element2 : hourArray = hours.split(",")) {
                        currentPeriodElement = (Element)periodElement.cloneNode(true);
                        String currentHour = element2;
                        if (currentHour.indexOf("-") == -1) {
                            currentHour = CronConverter.formatTwoDigits(currentHour);
                            currentPeriodElement.setAttribute("single_start", currentHour + ":" + currentMinute);
                        } else {
                            String[] currentHourArray = currentHour.split("[-/]");
                            int beginHour = Integer.parseInt(currentHourArray[0]);
                            int endHour = Integer.parseInt(currentHourArray[1]);
                            int beginMinute = Integer.parseInt(currentMinute);
                            int endMinute = beginMinute + 1;
                            endMinute = beginMinute;
                            if (endMinute == 60) {
                                endMinute = 0;
                                ++endHour;
                            }
                            if ((endHour %= 24) == 0) {
                                endHour = 24;
                            }
                            String stepSize = "1";
                            if (currentHourArray.length == 3) {
                                stepSize = CronConverter.formatTwoDigits(currentHourArray[2]);
                            }
                            currentPeriodElement.setAttribute("absolute_repeat", stepSize + ":00");
                            this.usedNewRunTime = true;
                            currentPeriodElement.setAttribute("begin", CronConverter.formatTwoDigits(beginHour) + ":" + CronConverter.formatTwoDigits(beginMinute));
                            currentPeriodElement.setAttribute("end", CronConverter.formatTwoDigits(endHour) + ":" + CronConverter.formatTwoDigits(endMinute));
                        }
                        childElements.add(currentPeriodElement);
                    }
                }
            }
            LOGGER.debug("processing days [" + days + "]");
            boolean monthDaysSet = false;
            if (days.startsWith("*")) {
                if (!"*".equals(days)) {
                    Element monthDaysElement = runTimeElement.getOwnerDocument().createElement("monthdays");
                    String repeat = days.substring(2);
                    int iRepeat = Integer.parseInt(repeat);
                    for (int i = 1; i <= 30; i += iRepeat) {
                        String day = "" + i;
                        this.addDay(day, monthDaysElement, childElements);
                    }
                    childElements.clear();
                    childElements.add(monthDaysElement);
                    monthDaysSet = true;
                }
            } else {
                String[] daysArray;
                Element monthDaysElement = runTimeElement.getOwnerDocument().createElement("monthdays");
                for (String day : daysArray = this.getArrayFromColumn(days)) {
                    this.addDay(day, monthDaysElement, childElements);
                }
                childElements.clear();
                childElements.add(monthDaysElement);
                monthDaysSet = true;
            }
            if (!"*".equals(weekdays) && monthDaysSet) {
                LOGGER.info("Weekdays will not be processed as days are already set in current line.");
            } else {
                LOGGER.debug("processing weekdays [" + weekdays + "]");
                weekdays = CronConverter.replaceDayNames(weekdays);
                if (weekdays.startsWith("*/")) {
                    throw new JobSchedulerException("Repeat intervals for the weekdays column [" + weekdays + "] are not supported. Please use the days column.");
                }
                if (!"*".equals(weekdays)) {
                    String[] daysArray;
                    Element weekDaysElement = runTimeElement.getOwnerDocument().createElement("weekdays");
                    for (String day : daysArray = this.getArrayFromColumn(weekdays)) {
                        this.addDay(day, weekDaysElement, childElements);
                    }
                    childElements.clear();
                    childElements.add(weekDaysElement);
                }
            }
            LOGGER.debug("processing months [" + months + "]");
            if (months.startsWith("*")) {
                if (!"*".equals(months)) {
                    months = CronConverter.replaceMonthNames(months);
                    Vector<Element> newChildElements = new Vector<Element>();
                    String repeat = months.substring(2);
                    int iRepeat = Integer.parseInt(repeat);
                    for (int i = 1; i <= 12; i += iRepeat) {
                        String month = "" + i;
                        Element monthElement = runTimeElement.getOwnerDocument().createElement("month");
                        this.usedNewRunTime = true;
                        monthElement.setAttribute("month", month);
                        for (Element child : childElements) {
                            monthElement.appendChild(child.cloneNode(true));
                        }
                        newChildElements.add(monthElement);
                    }
                    childElements = newChildElements;
                }
            } else {
                String[] monthArray;
                Vector<Element> newChildElements = new Vector<Element>();
                for (String month : monthArray = this.getArrayFromColumn(months)) {
                    Element monthElement = runTimeElement.getOwnerDocument().createElement("month");
                    this.usedNewRunTime = true;
                    monthElement.setAttribute("month", month);
                    for (Element child : childElements) {
                        monthElement.appendChild(child.cloneNode(true));
                    }
                    newChildElements.add(monthElement);
                }
                childElements = newChildElements;
            }
            for (Element someElement : childElements) {
                runTimeElement.appendChild(someElement);
            }
        }
        catch (Exception e) {
            throw new JobSchedulerException("Error creating run time: " + e, (Throwable)e);
        }
    }

    private static String[] combineArrays(String[] hourArray, String[] additionalHours) {
        int i;
        String[] newArray = new String[hourArray.length + additionalHours.length];
        for (i = 0; i < hourArray.length; ++i) {
            newArray[i] = hourArray[i];
        }
        for (i = 0; i < additionalHours.length; ++i) {
            newArray[i + hourArray.length] = additionalHours[i];
        }
        return newArray;
    }

    private void addDay(String day, Element parentDaysElement, Vector<Element> childElements) throws Exception {
        LOGGER.debug("adding day: " + day);
        Element dayElement = parentDaysElement.getOwnerDocument().createElement("day");
        dayElement.setAttribute("day", day);
        for (Element child : childElements) {
            dayElement.appendChild(child.cloneNode(true));
        }
        parentDaysElement.appendChild(dayElement);
    }

    private String[] getArrayFromColumn(String column) {
        String[] elements = column.split(",");
        Vector<String> result = new Vector<String>();
        for (String element : elements) {
            if (element.indexOf("-") == -1) {
                result.add(element);
                continue;
            }
            String[] range = element.split("[-/]");
            if (range.length < 2 || range.length > 3) {
                try {
                    LOGGER.warn("unknown crontab synthax: " + element);
                }
                catch (Exception exception) {}
                continue;
            }
            int from = Integer.parseInt(range[0]);
            int to = Integer.parseInt(range[1]);
            int stepSize = 1;
            if (range.length == 3) {
                stepSize = Integer.parseInt(range[2]);
            }
            for (int j = from; j <= to; j += stepSize) {
                result.add("" + j);
            }
        }
        String[] dummy = new String[1];
        return result.toArray(dummy);
    }

    private static String replaceDayNames(String element) {
        element = element.replaceAll("(?i)mon", "1");
        element = element.replaceAll("(?i)tue", "2");
        element = element.replaceAll("(?i)wed", "3");
        element = element.replaceAll("(?i)thu", "4");
        element = element.replaceAll("(?i)fri", "5");
        element = element.replaceAll("(?i)sat", "6");
        element = element.replaceAll("(?i)sun", "7");
        return element;
    }

    private static String replaceMonthNames(String element) {
        element = element.replaceAll("(?i)jan", "1");
        element = element.replaceAll("(?i)feb", "2");
        element = element.replaceAll("(?i)mar", "3");
        element = element.replaceAll("(?i)apr", "4");
        element = element.replaceAll("(?i)may", "5");
        element = element.replaceAll("(?i)jun", "6");
        element = element.replaceAll("(?i)jul", "7");
        element = element.replaceAll("(?i)aug", "8");
        element = element.replaceAll("(?i)sep", "9");
        element = element.replaceAll("(?i)oct", "10");
        element = element.replaceAll("(?i)nov", "11");
        element = element.replaceAll("(?i)dec", "12");
        return element;
    }

    private String getJobName(String pstrCommand) {
        int i;
        Matcher commandMatcher = this.commandRegExPattern.matcher(pstrCommand);
        if (commandMatcher.find()) {
            pstrCommand = commandMatcher.group();
        } else {
            int space = pstrCommand.indexOf(" ");
            if (space != -1) {
                pstrCommand = pstrCommand.substring(0, space);
            }
        }
        if (pstrCommand.startsWith("\"")) {
            pstrCommand = pstrCommand.substring(1);
        }
        if (pstrCommand.endsWith("\"")) {
            pstrCommand = pstrCommand.substring(0, pstrCommand.length() - 1);
        }
        if (pstrCommand.startsWith("/") || pstrCommand.startsWith("\\")) {
            pstrCommand = pstrCommand.substring(1);
        }
        if ((i = pstrCommand.indexOf("}")) >= 0) {
            pstrCommand = pstrCommand.substring(i + 1);
        }
        if (pstrCommand.startsWith("/")) {
            pstrCommand = pstrCommand.substring(1);
        }
        if (this.isNotEmpty(this.strBaseDirectory)) {
            pstrCommand = this.strBaseDirectory + "/" + pstrCommand;
        }
        return pstrCommand;
    }

    private String convertAlias(Matcher matcher) throws Exception {
        LOGGER.debug("Converting alias...");
        try {
            String alias = matcher.group(1);
            String rest = matcher.group(2);
            String result = "";
            if ("@yearly".equals(alias) || "@annually".equals(alias)) {
                result = "0 0 1 1 * ";
            } else if ("@monthly".equals(alias)) {
                result = "0 0 1 * * ";
            } else if ("@weekly".equals(alias)) {
                result = "0 0 * * 0 ";
            } else if ("@daily".equals(alias) || "@midnight".equals(alias)) {
                result = "0 0 * * * ";
            } else if ("@hourly".equals(alias)) {
                result = "0 * * * * ";
            } else if ("@reboot".equals(alias)) {
                result = "@reboot @reboot @reboot @reboot @reboot";
            }
            result = result + rest;
            LOGGER.debug("Alias converted to " + result);
            return result;
        }
        catch (Exception e) {
            throw new JobSchedulerException("Error converting alias: " + e, (Throwable)e);
        }
    }

    private static String formatTwoDigits(String number) {
        if (number.length() == 1) {
            return "0" + number;
        }
        return number;
    }

    private static String formatTwoDigits(int number) {
        return CronConverter.formatTwoDigits("" + number);
    }

    public boolean isSystemCronTab() {
        return this.systemCronTab;
    }

    public void setSystemCronTab(boolean systemCronTab) {
        this.currentCronPattern = systemCronTab ? this.cronRegExSystemPattern : this.cronRegExPattern;
        this.systemCronTab = systemCronTab;
    }

    protected boolean isOldRunTime() {
        return this.oldRunTime;
    }

    protected void setOldRunTime(boolean oldRunTime) {
        this.oldRunTime = oldRunTime;
    }

    public HashSet<String> getSkipLines() {
        return this.skipLines;
    }

    public void setSkipLines(HashSet<String> skipLines) {
        this.skipLines = skipLines;
    }

    public HashSet<String> getReservedJobNames() {
        return this.reservedJobNames;
    }

    public void setReservedJobNames(HashSet<String> reservedJobNames) {
        this.reservedJobNames = reservedJobNames;
    }

    protected DocumentBuilder getDocBuilder() {
        return this.docBuilder;
    }

    public String getChangeUserCommand() {
        return this.changeUserCommand;
    }

    public void setChangeUserCommand(String changeUserCommand) {
        if ("su".equalsIgnoreCase(changeUserCommand)) {
            changeUserCommand = "su $SCHEDULER_CRONTAB_USER -c";
        } else if ("sudo".equalsIgnoreCase(changeUserCommand)) {
            changeUserCommand = "sudo -u $SCHEDULER_CRONTAB_USER";
        }
        this.changeUserCommand = changeUserCommand;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }
}

