/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.job;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import sos.connection.SOSConnection;
import sos.marshalling.SOSExport;
import sos.scheduler.job.JobSchedulerJob;
import sos.spooler.Variable_set;
import sos.util.SOSClassUtil;
import sos.util.SOSDate;
import sos.util.SOSString;

public class JobSchedulerExportJob
extends JobSchedulerJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobSchedulerExportJob.class);
    private String exportPath = "";
    private String outputFilenameMask = "[dataobject]_[id]_[datetime].xml";
    private Variable_set parameters = null;
    private String queryFilename = "";
    private SOSConnection sosConnection = null;
    private String sosSettingsFile = null;
    private SOSString sosString = null;
    private SOSConnection sosUpdateStateConnection = null;
    private String sosSettingsUpdateStateFile = null;

    @Override
    public boolean spooler_init() {
        boolean rc = super.spooler_init();
        if (rc) {
            try {
                this.sosString = new SOSString();
                this.setParameters(this.spooler.create_variable_set());
                if (this.spooler_task.params() != null) {
                    this.getParameters().merge(this.spooler_task.params());
                }
                if (this.spooler_job.order_queue() != null) {
                    this.getParameters().merge(this.spooler_task.order().params());
                }
                if (this.getParameters().value("export_path") == null || this.getParameters().value("export_path").isEmpty()) {
                    this.spooler_log.warn(".. missing parameter [export_path]: ");
                    throw new Exception(".. missing parameter [export_path]: ");
                }
                this.exportPath = this.getParameters().value("export_path");
                this.spooler_log.debug1(".. parameter [export_path]: ");
                if (this.getParameters().value("query_filename") != null && !this.getParameters().value("query_filename").isEmpty()) {
                    this.queryFilename = this.getParameters().value("query_filename");
                    this.spooler_log.debug1(".. parameter [query_filename]: " + this.queryFilename);
                    if (!new File(this.queryFilename).exists()) {
                        this.spooler_log.warn("..missing query file " + this.queryFilename);
                        throw new Exception("..missing query file " + this.queryFilename);
                    }
                } else {
                    this.spooler_log.warn(".. missing parameter [query_filename] ");
                    throw new Exception(".. missing parameter [query_filename] ");
                }
                if (this.getParameters().value("sos_settings_file") != null && !this.getParameters().value("sos_settings_file").isEmpty()) {
                    this.sosSettingsFile = this.getParameters().value("sos_settings_file");
                    this.spooler_log.debug1(".. parameter [sos_settings_file]: " + this.sosSettingsFile);
                }
                if (this.getParameters().value("sos_setting_file_status_update") != null && !this.getParameters().value("sos_setting_file_status_update").isEmpty()) {
                    this.sosSettingsUpdateStateFile = this.getParameters().value("sos_setting_file_status_update");
                    this.spooler_log.debug1(".. parameter [sos_setting_file_status_update]: " + this.sosSettingsUpdateStateFile);
                }
                this.sosConnection = this.getConnections(this.sosSettingsFile);
                this.sosUpdateStateConnection = this.sosString.parseToString((Object)this.sosSettingsFile).equalsIgnoreCase(this.sosString.parseToString((Object)this.sosSettingsUpdateStateFile)) ? this.sosConnection : this.getConnections(this.sosSettingsUpdateStateFile);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                return false;
            }
        }
        return rc;
    }

    public boolean spooler_process() {
        long timeInSec = System.currentTimeMillis();
        boolean rc = true;
        String filename = "";
        String sSignalId = "";
        int signalId = -1;
        String jobChainname = "";
        String operation = null;
        try {
            this.setParameters(this.spooler.create_variable_set());
            if (this.spooler_task.order() != null && this.spooler_task.order().title() != null) {
                sSignalId = this.spooler_task.order().title();
                int iPos = sSignalId.indexOf(":");
                if (iPos > -1) {
                    sSignalId = sSignalId.substring(iPos + 1);
                }
                sSignalId = sSignalId.trim();
                try {
                    signalId = Integer.parseInt(sSignalId);
                }
                catch (Exception e) {
                    this.spooler_log.warn("..missing signal_id in Title: " + sSignalId);
                    return false;
                }
            } else {
                this.spooler_log.warn("..missing signal_id in Title: " + sSignalId);
                return false;
            }
            if (this.spooler_task.params() != null) {
                this.getParameters().merge(this.spooler_task.params());
            }
            if (this.spooler_job.order_queue() != null) {
                this.getParameters().merge(this.spooler_task.order().params());
            }
            if (this.getParameters().value("export_path") == null || this.getParameters().value("export_path").isEmpty()) {
                LOGGER.warn(".. missing parameter [export_path]: ");
                throw new Exception(".. missing parameter [export_path]: ");
            }
            this.exportPath = this.getParameters().value("export_path");
            this.spooler_log.debug1(".. parameter [export_path]: ");
            if (this.getParameters().value("query_filename") != null && !this.getParameters().value("query_filename").isEmpty()) {
                this.queryFilename = this.getParameters().value("query_filename");
                this.spooler_log.debug1(".. parameter [query_filename]: " + this.queryFilename);
                if (!new File(this.queryFilename).exists()) {
                    throw new Exception("..missing query file " + this.queryFilename);
                }
            } else {
                this.spooler_log.warn(".. missing parameter [query_filename] ");
                throw new Exception("..missing query file " + this.queryFilename);
            }
            if (this.getParameters().value("operation") != null && !this.getParameters().value("operation").isEmpty()) {
                operation = this.getParameters().value("operation");
                this.spooler_log.debug1(".. parameter [operation]: ");
            }
            jobChainname = this.spooler_task.order().job_chain().name();
            filename = this.normalizedPath(this.exportPath) + this.getNewFilename(jobChainname, sSignalId);
            this.export(this.sosConnection, this.queryFilename, filename, jobChainname, operation);
            File f = new File(filename);
            File fMove = new File(this.normalizedPath(this.exportPath) + f.getName().substring(0, f.getName().length() - 1));
            if (f.renameTo(fMove)) {
                this.spooler_task.order().params().set_var("filename", fMove.getCanonicalPath());
                this.spooler_log.debug1("filename is renamed in " + fMove.getCanonicalPath());
            } else {
                this.spooler_log.warn("filename could not rename to " + fMove.getCanonicalPath());
            }
            String upStr = "UPDATE SCHEDULER_SIGNAL_OBJECTS SET \"STATUS\" = 2 WHERE  \"SIGNAL_ID\" = " + signalId;
            this.sosUpdateStateConnection.executeUpdate(upStr);
            this.sosUpdateStateConnection.commit();
            String time = Math.round((System.currentTimeMillis() - timeInSec) / 1000L) + "s";
            String stateText = "successfully export Database to XML-File " + filename + " (" + time + ")";
            this.spooler_log.info(stateText);
            this.spooler_job.set_state_text(stateText);
            return this.spooler_job.order_queue() != null ? rc : false;
        }
        catch (Exception e) {
            if (this.sosConnection != null) {
                try {
                    this.sosConnection.rollback();
                }
                catch (Exception fMove) {
                    // empty catch block
                }
                try {
                    String upStr = "UPDATE SCHEDULER_SIGNAL_OBJECTS SET \"STATUS\" = 1002 WHERE  \"SIGNAL_ID\" = " + signalId;
                    this.sosUpdateStateConnection.executeUpdate(upStr);
                    this.sosUpdateStateConnection.commit();
                }
                catch (Exception upStr) {
                    // empty catch block
                }
            }
            String stateText = "error occurred export filename : " + filename + " cause: " + e.getMessage();
            this.spooler_job.set_state_text(stateText);
            LOGGER.error(stateText);
            return false;
        }
    }

    @Override
    public void spooler_exit() {
        super.spooler_exit();
        try {
            if (this.sosConnection != null) {
                this.sosConnection.disconnect();
            }
            if (this.sosUpdateStateConnection != null) {
                this.sosUpdateStateConnection.disconnect();
            }
        }
        catch (Exception e) {
            this.spooler_log.warn("spooler_exit(): disconnect failed: " + e.toString());
        }
    }

    public void export(SOSConnection sosConnection, String queryfile, String filename, String jobChain, String operation) throws Exception {
        Element queries = null;
        SOSExport export = null;
        try {
            export = new SOSExport(sosConnection, filename, "EXPORT");
            queries = this.getQueryElement(queryfile, jobChain);
            if (queries != null) {
                this.exportQueryRecursiv(queries, export, -1, operation);
            }
        }
        catch (Exception e) {
            this.spooler_log.warn("error in " + SOSClassUtil.getClassName() + " :" + e.getMessage());
            throw new Exception("error in " + SOSClassUtil.getClassName() + " :" + e.getMessage());
        }
    }

    public Variable_set getParameters() {
        return this.parameters;
    }

    public void setParameters(Variable_set parameters) {
        this.parameters = parameters;
    }

    private String getNewFilename(String jobChainname, String signalId) throws Exception {
        String filename = "";
        filename = this.outputFilenameMask;
        filename = filename.replaceAll("\\[id\\]", signalId);
        filename = filename.replaceAll("\\[dataobject\\]", jobChainname);
        filename = filename.replaceAll("\\[datetime\\]", SOSDate.getCurrentTimeAsString((String)"yyyymmdd-hhMMss"));
        filename = filename + "~";
        return filename;
    }

    private String normalizedPath(String path) throws Exception {
        try {
            if (path.endsWith("/")) {
                return path;
            }
            return path + "/";
        }
        catch (Exception e) {
            throw new Exception("..error in " + SOSClassUtil.getMethodName() + ": " + e);
        }
    }

    private SOSConnection getConnections(String settingsfile) throws Exception {
        SOSConnection conn = null;
        if (!this.sosString.parseToString((Object)settingsfile).isEmpty()) {
            conn = this.getConnectionFromINIFile(settingsfile);
        }
        if (conn == null) {
            conn = this.getConnection();
        }
        return conn;
    }

    private SOSConnection getConnectionFromINIFile(String settingsfile) throws Exception {
        SOSConnection conn = null;
        try {
            this.spooler_log.debug3("DB Connecting.. .");
            conn = SOSConnection.createInstance((String)settingsfile);
            conn.connect();
            this.spooler_log.debug3("DB Connected");
        }
        catch (Exception e) {
            throw new Exception("error in " + SOSClassUtil.getMethodName() + ": connect to database failed: " + e.getMessage(), e);
        }
        return conn;
    }

    private Element getQueryElement(String queryfile, String jobChain) throws Exception {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = db.parse(queryfile);
            Element docEle = dom.getDocumentElement();
            NodeList nl = docEle.getElementsByTagName("queries");
            if (nl != null && nl.getLength() > 0) {
                for (int i = 0; i < nl.getLength(); ++i) {
                    Element el = (Element)nl.item(i);
                    if (!el.getAttribute("name").equalsIgnoreCase(jobChain)) continue;
                    return el;
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new Exception("..error in " + SOSClassUtil.getClassName() + " :" + e.getMessage());
        }
    }

    private HashMap getKeys(String keys) throws Exception {
        try {
            HashMap<String, String> retval = new HashMap<String, String>();
            Variable_set set = this.getParameters();
            String[] split = keys.split(",");
            for (int i = 0; i < split.length; ++i) {
                String name = split[i];
                String value = set.value(split[i]);
                retval.put(name, value);
            }
            return retval;
        }
        catch (Exception e) {
            this.spooler_log.warn("error in " + SOSClassUtil.getClassName() + " :" + e.getMessage());
            throw new Exception("error in " + SOSClassUtil.getClassName() + " :" + e.getMessage());
        }
    }

    private String replaceAllParameter(String query) throws Exception {
        try {
            String retval = query;
            Variable_set set = this.getParameters();
            String[] split = set.names().split(";");
            this.spooler_log.debug1("query before replace: " + query);
            for (int i = 0; i < split.length; ++i) {
                String name = "\\$\\{" + split[i] + "\\}";
                String value = set.value(split[i]);
                retval = retval.replaceAll(name, value);
                retval = retval.replaceAll(name.toLowerCase(), value);
                retval = retval.replaceAll(name.toUpperCase(), value);
            }
            this.spooler_log.debug1("query after replace: " + retval);
            return retval;
        }
        catch (Exception e) {
            this.spooler_log.warn("error in " + SOSClassUtil.getClassName() + " :" + e.getMessage());
            throw new Exception("error in " + SOSClassUtil.getClassName() + " :" + e.getMessage());
        }
    }

    private void exportQueryRecursiv(Element queries, SOSExport export, int queryId, String operation) throws Exception {
        NodeList listOfQueries = null;
        NodeList newlistOfQueries = null;
        boolean bDoExport = false;
        try {
            if (queryId == -1) {
                bDoExport = true;
            }
            if (queries != null) {
                listOfQueries = queries.getChildNodes();
                for (int i = 0; i < listOfQueries.getLength(); ++i) {
                    Element elem;
                    Node child = listOfQueries.item(i);
                    if (child.getNodeType() != 1 || !"query".equalsIgnoreCase((elem = (Element)listOfQueries.item(i)).getTagName())) continue;
                    String query = child.getFirstChild().getNodeValue();
                    query = query.replaceAll("\\n", "");
                    query = query.replaceAll("\\t", "");
                    query = this.replaceAllParameter(query);
                    String tag = "export";
                    if (!this.sosString.parseToString((Object)elem.getAttribute("tag")).isEmpty()) {
                        tag = this.sosString.parseToString((Object)elem.getAttribute("tag"));
                    }
                    String keys = "";
                    if (!this.sosString.parseToString((Object)elem.getAttribute("keys")).isEmpty()) {
                        keys = this.sosString.parseToString((Object)elem.getAttribute("keys"));
                    }
                    HashMap ldel = new HashMap();
                    if (operation != null && "delete".equalsIgnoreCase(operation)) {
                        ldel = this.getKeys(elem.getAttribute("keys"));
                    }
                    queryId = queryId == -1 && bDoExport ? export.query(tag, keys, query, null, operation, (Map)ldel, queryId) : (queryId > -1 && bDoExport ? export.add(tag, keys, query, "", operation, (Map)ldel, queryId) : export.query(tag, keys, query, "", operation, (Map)ldel, queryId));
                    newlistOfQueries = elem.getElementsByTagName("query");
                    if (newlistOfQueries.getLength() <= 0) continue;
                    this.exportQueryRecursiv(elem, export, queryId, operation);
                }
                if (bDoExport) {
                    export.doExport();
                }
            }
        }
        catch (Exception e) {
            throw new Exception("..error in " + SOSClassUtil.getClassName() + " :" + e.getMessage());
        }
    }
}

