/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.job;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.search.AndTerm;
import javax.mail.search.HeaderTerm;
import javax.mail.search.SearchTerm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.net.SOSMail;
import sos.net.SOSMailAttachment;
import sos.net.SOSMailReceiver;
import sos.net.SOSMimeMessage;
import sos.scheduler.job.JobSchedulerMailJob;
import sos.spooler.Order;
import sos.spooler.Variable_set;
import sos.util.SOSClassUtil;
import sos.util.SOSString;

public class JobSchedulerMailBounceHandler
extends JobSchedulerMailJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobSchedulerMailBounceHandler.class);
    private static final String X_SOSMAIL_DELIVERY_COUNTER_HEADER = "X-SOSMail-delivery-counter";
    private List<Map<String, String>> mailBouncePatternTableList = new ArrayList<Map<String, String>>();
    private SOSMailReceiver receiver = null;
    private LinkedHashMap<String, Pattern> patternMap = null;
    private Map<String, String> patternActions = null;
    private String patternId = null;
    private String forwardSubject = "Here is the original message:\n\n";
    private boolean handleBouncedMailOnly = true;
    private String bounceDirectory;
    private int retryInterval = -1;
    private String xSOSMailDeliveryCounterHeader;
    private String jobChainName = "scheduler_send_bounced_mails";
    private String mailId = null;
    SOSMail forwardMessage = null;
    SOSMimeMessage sosMimeMessage = null;
    String smtpHost = "";
    String smtpPort = "25";
    String receiverHost = "";
    String receiverPort = "110";
    String protocol = "imap";
    String pop3_user = "";
    String pop3_password = "";
    boolean mailUseSsl = false;
    String[] toArray = null;
    String[] ccArray = null;
    String[] bccArray = null;
    String from = "";
    String fromName = "";

    @Override
    public boolean spooler_init() {
        try {
            if (!super.spooler_init()) {
                return false;
            }
            LOGGER.debug("Calling " + SOSClassUtil.getMethodName());
            this.getJobSettings().setKeysToLowerCase();
            this.setJobSettings();
            this.getMailBouncePatterns();
            this.setMailBouncePatterns();
            this.setPatternActions();
            if (this.spooler_task != null) {
                this.setJobId(this.spooler_task.id());
            }
            if (this.spooler_job != null) {
                this.setJobName(this.spooler_job.name());
            }
            if (this.spooler_job != null) {
                this.setJobTitle(this.spooler_job.title());
            }
            if (this.spooler_task.params().var("mail_use_ssl") != null && !this.spooler_task.params().var("mail_use_ssl").isEmpty()) {
                if ("true".equalsIgnoreCase(this.spooler_task.params().var("mail_use_ssl"))) {
                    this.mailUseSsl = true;
                }
                this.spooler_log.debug6(".. job parameter [mail_use_ssl]: [" + this.spooler_task.params().var("mail_use_ssl") + "]");
            }
            if (this.spooler_task.params().var("handle_bounced_mail_only") != null && !this.spooler_task.params().var("handle_bounced_mail_only").isEmpty()) {
                if ("true".equalsIgnoreCase(this.spooler_task.params().var("handle_bounced_mail_only"))) {
                    this.setHandleBouncedMailOnly(true);
                }
                this.spooler_log.debug6(".. job parameter [handle_bounced_mail_only]: [" + this.spooler_task.params().var("handle_bounced_mail_only") + "]");
            }
            if (this.spooler_task.params().var("bounce_directory") == null || this.spooler_task.params().var("bounce_directory").isEmpty()) {
                throw new Exception("No bounce directory specified in entry [bounce_directory] of job section in file " + this.spooler.ini_path());
            }
            this.setBounceDirectory(this.spooler_task.params().var("bounce_directory"));
            this.spooler_log.debug6(".. job parameter [bounce_directory]: [" + this.spooler_task.params().var("bounce_directory") + "]");
            new File(this.getBounceDirectory()).mkdirs();
        }
        catch (Exception e) {
            try {
                LOGGER.error(SOSClassUtil.getMethodName() + ": " + e.getMessage(), (Throwable)e);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean spooler_process() throws Exception {
        boolean expunge = false;
        Folder folder = null;
        Message[] messages = new Message[]{};
        SOSMimeMessage sosMimeMessage = null;
        try {
            LOGGER.debug("Calling " + SOSClassUtil.getMethodName());
            this.receiver = new SOSMailReceiver(this.receiverHost, this.receiverPort, this.pop3_user, this.pop3_password, this.mailUseSsl, this.protocol);
            this.receiver.connect(this.protocol);
            folder = this.receiver.openFolder("INBOX", this.receiver.READ_WRITE);
            messages = this.isHandleBouncedMessagesOnly() ? folder.search(this.getBounceSerachTerm()) : folder.getMessages();
            LOGGER.debug("total found messages: " + messages.length);
            for (int i = 0; i < messages.length; ++i) {
                sosMimeMessage = new SOSMimeMessage(messages[i]);
                if (!sosMimeMessage.isBounce()) continue;
                this.handleBounceMessage(sosMimeMessage);
            }
            this.getConnection().commit();
            expunge = true;
        }
        finally {
            try {
                this.receiver.closeFolder(expunge);
            }
            catch (Exception exception) {}
            try {
                this.receiver.disconnect();
            }
            catch (Exception exception) {}
            try {
                this.getConnection().disconnect();
            }
            catch (Exception exception) {}
        }
        return false;
    }

    private void setJobSettings() throws Exception {
        this.setJobProperties(this.getJobSettings().getSection("job " + this.spooler_job.name()));
        Properties ini = this.getJobProperties();
        if (ini.getProperty("protocol") == null) {
            throw new Exception("[protocol] missing!!");
        }
        this.protocol = ini.getProperty("protocol");
        LOGGER.debug("..protocol [" + this.protocol + "]");
        if (ini.getProperty("pop3_host") == null) {
            throw new Exception("[pop3_host] missing!!");
        }
        this.receiverHost = ini.getProperty("pop3_host");
        LOGGER.debug("..receiver host [" + this.receiverHost + "]");
        if (ini.getProperty("smtp_host") == null) {
            throw new Exception("[smtp host] missing!!");
        }
        this.smtpHost = ini.getProperty("smtp_host");
        LOGGER.debug("..smtp host [" + this.smtpHost + "]");
        if (ini.getProperty("smtp_port") == null) {
            throw new Exception("[smtp port] missing!!");
        }
        this.smtpPort = ini.getProperty("smtp_port");
        LOGGER.debug("..smtp port [" + this.smtpPort + "]");
        if (ini.getProperty("pop3_user") == null) {
            throw new Exception("[pop3_user] missing!!");
        }
        this.pop3_user = ini.getProperty("pop3_user");
        LOGGER.debug("..pop3 user [" + this.pop3_user + "]");
        if (ini.getProperty("pop3_password") == null) {
            throw new Exception("[pop3_password] missing!!");
        }
        this.pop3_password = ini.getProperty("pop3_password");
        LOGGER.debug("..pop3 password [****]");
        if (ini.getProperty("forward_subject") == null) {
            throw new Exception("[forward_subject] missing!!");
        }
        this.forwardSubject = ini.getProperty("forward_subject");
        LOGGER.debug("..forward subject [" + this.forwardSubject + "]");
    }

    public final SearchTerm getBounceSerachTerm() throws Exception {
        LOGGER.debug("Calling " + SOSClassUtil.getMethodName());
        return new AndTerm((SearchTerm)new HeaderTerm("Return-Path", "<>"), (SearchTerm)new HeaderTerm("Content-Type", "multipart/report"));
    }

    public String getPatternAction(SOSMimeMessage sosMimeMessage) throws Exception {
        LOGGER.debug("Calling " + SOSClassUtil.getMethodName());
        String actionPattern = null;
        Matcher matcher = null;
        String inputString = null;
        inputString = sosMimeMessage.getPlainTextBody();
        for (Map.Entry<String, Pattern> entry : this.patternMap.entrySet()) {
            this.patternId = entry.getKey();
            Pattern pattern = entry.getValue();
            matcher = pattern.matcher(inputString);
            LOGGER.debug("..try find string matched [" + inputString + "]" + pattern.pattern());
            if (!matcher.find()) continue;
            LOGGER.debug("string matched [" + inputString + "]" + pattern.pattern());
            LOGGER.info("..pattern captured \"" + pattern.pattern() + "\"");
            break;
        }
        for (Map map : this.mailBouncePatternTableList) {
            if (!((String)map.get("pattern_id")).equals(this.patternId)) continue;
            actionPattern = (String)map.get("action");
            break;
        }
        return this.patternActions.get(actionPattern);
    }

    private void getMailBouncePatterns() throws Exception {
        LOGGER.debug("Calling " + SOSClassUtil.getMethodName());
        StringBuilder query = new StringBuilder();
        query.append("SELECT \"PATTERN_ID\",\"PATTERN\",\"ACTION\",\"MAX_RETRIES\",");
        query.append("\"RETRY_INTERVAL\",\"MAIL_TO\",\"CC_TO\",\"BCC_TO\",\"REPLY_TO\",");
        query.append("\"SUBJECT\",\"SUBJECT_TEMPLATE\",\"SUBJECT_TEMPLATE_TYPE\" FROM ");
        query.append(this.getTableMailBouncePatterns());
        query.append(" ORDER BY \"ORDERING\" ASC");
        LOGGER.debug("..query [" + query + "]");
        this.mailBouncePatternTableList.addAll(this.getConnection().getArray(query.toString()));
        if (this.mailBouncePatternTableList.isEmpty()) {
            throw new Exception(SOSClassUtil.getMethodName() + ": No entries found!!");
        }
    }

    private void setMailBouncePatterns() throws Exception {
        LOGGER.debug("Calling " + SOSClassUtil.getMethodName());
        this.patternMap = new LinkedHashMap();
        String patternId = "";
        String patternString = "";
        Pattern pattern = null;
        for (Map<String, String> record : this.mailBouncePatternTableList) {
            if (record.get("pattern_id") == null || record.get("pattern") == null) continue;
            LOGGER.debug(record.get("pattern_id") + "==" + record.get("pattern"));
            patternId = record.get("pattern_id");
            patternString = record.get("pattern");
            pattern = Pattern.compile(patternString, 10);
            LOGGER.trace("..pattern \"" + record.get("pattern") + "\" compiled successfully.");
            this.patternMap.put(patternId, pattern);
        }
    }

    public void handleBounceMessage(SOSMimeMessage sosMimeMessage) throws Exception {
        String bouncedMailAction = "";
        int bouncedMailStatus = -1;
        Vector sosMailAttachmentList = sosMimeMessage.getSosMailAttachments();
        LOGGER.info("..bounced message found:");
        Iterator it = sosMailAttachmentList.iterator();
        SOSMailAttachment sosMailAttachment = null;
        while (it.hasNext()) {
            sosMailAttachment = (SOSMailAttachment)it.next();
            if (!"message/rfc822".equalsIgnoreCase(sosMailAttachment.getContentType())) continue;
            SOSMimeMessage originalMessage = sosMimeMessage.getAttachedSosMimeMessage(this.receiver.getSession(), sosMailAttachment.getContent());
            this.setXSOSMailDeliveryCounterHeader(this.getXSOSMailDeliveryCounterHeader(originalMessage));
            LOGGER.info("....originally message attributes:");
            LOGGER.info("....message id [" + originalMessage.getMessageId() + "]");
            LOGGER.info("....from [" + originalMessage.getFromAddress() + "]");
            LOGGER.info("....sent date [" + originalMessage.getSentDateAsString("yyyy-MM-dd HH:mm:ss") + "]");
            this.setMailId(this.getMailId(originalMessage.getMessageId()));
            if (SOSString.isEmpty((String)this.getMailId())) continue;
            this.updateTableMails(originalMessage.getMessageId());
            if (!SOSString.isEmpty((String)this.getXSOSMailDeliveryCounterHeader())) {
                LOGGER.info("...current X-SOSMail-delivery-counter [" + this.getXSOSMailDeliveryCounterHeader() + "]");
            }
            bouncedMailAction = this.getPatternAction(sosMimeMessage);
            LOGGER.info("..available pattern action for this bounce [" + bouncedMailAction + "]");
            if ("drop".equalsIgnoreCase(bouncedMailAction)) {
                LOGGER.info("..Message with ID [" + sosMimeMessage.getMessageId() + "] is marked for delete.");
                sosMimeMessage.deleteMessage();
                bouncedMailStatus = 1001;
            } else if ("store".equalsIgnoreCase(bouncedMailAction)) {
                String fileName = this.getLogDirectory() + File.separator + sosMimeMessage.getMessageId();
                sosMimeMessage.dumpMessageToFile(fileName, true, false);
                bouncedMailStatus = 0;
            } else if ("retry".equalsIgnoreCase(bouncedMailAction)) {
                if (this.isRetrySendingAllowed(originalMessage.getMessageId())) {
                    this.setRetryInterval(this.getRetryInterval(originalMessage));
                    int currentHeaderValue = originalMessage.incrementHeader(X_SOSMAIL_DELIVERY_COUNTER_HEADER);
                    if (currentHeaderValue == -1) {
                        currentHeaderValue = 1;
                        originalMessage.setHeader(X_SOSMAIL_DELIVERY_COUNTER_HEADER, "1");
                        LOGGER.debug(".. [X-SOSMail-delivery-counter] set.");
                    }
                    LOGGER.debug("..current value of \"X-SOSMail-delivery-counter\" [" + currentHeaderValue + "]");
                    LOGGER.debug("..query directory [" + this.bounceDirectory + " ] set.");
                    originalMessage.setQueueDir(this.bounceDirectory);
                    originalMessage.dumpMessageToFile(true, false);
                    LOGGER.debug("..currently dumped message [" + originalMessage.getDumpedFileName() + "]");
                    if (!this.orderRetrySend(originalMessage)) continue;
                }
                bouncedMailStatus = 1;
            } else if ("forward".equalsIgnoreCase(bouncedMailAction)) {
                this.forwardMessage(sosMimeMessage.getMessage(), this.receiver.getSession());
                bouncedMailStatus = 1;
            }
            this.updateMailBouncesTable(originalMessage, bouncedMailStatus);
        }
    }

    public void updateMailBouncesTable(SOSMimeMessage sosMimeMessage, int bouncedMailStatusCode) throws Exception {
        StringBuilder query = new StringBuilder();
        String bouncedMailStatusText = "";
        LOGGER.debug("Calling " + SOSClassUtil.getMethodName());
        if (bouncedMailStatusCode == 0) {
            bouncedMailStatusText = "requested";
        } else if (bouncedMailStatusCode == 1001) {
            bouncedMailStatusText = "CANCELLED";
        } else if (bouncedMailStatusCode == 1) {
            bouncedMailStatusText = "DELIVERED";
        } else if (bouncedMailStatusCode == 1002) {
            bouncedMailStatusText = "HAS_ERRORS";
        }
        query = new StringBuilder();
        query.append("INSERT INTO ");
        query.append(this.getTableMailBounces());
        query.append(" (\"JOB_ID\",\"INBOUND_ID\",\"MESSAGE_ID\",");
        query.append("\"RECEIVED\",\"PATTERN_ID\",\"OUTBOUND_ID\",\"STATUS\",");
        query.append("\"STATUS_TEXT\",\"CREATED\",\"CREATED_BY\",\"MODIFIED\",\"MODIFIED_BY\")");
        query.append(" VALUES (");
        query.append(this.getJobId());
        query.append(",");
        query.append(SOSString.isEmpty((String)this.getMailId()) ? "0" : this.getMailId());
        query.append(",'");
        query.append(sosMimeMessage.getMessageId());
        query.append("',%timestamp('");
        query.append(sosMimeMessage.getSentDateAsString());
        query.append("'),");
        query.append(this.patternId);
        query.append(",");
        query.append(SOSString.isEmpty((String)this.getMailId()) ? "0" : this.getMailId());
        query.append(",");
        query.append(bouncedMailStatusCode);
        query.append(",'");
        query.append(bouncedMailStatusText);
        query.append("',");
        query.append("%now,'");
        query.append(this.getJobName());
        query.append("',%now,'");
        query.append(this.getJobName());
        query.append("')");
        LOGGER.debug("update MAIL_BOUNCES_TABLE: " + query);
        this.getConnection().execute(query.toString());
        this.getConnection().commit();
    }

    public boolean isHandleBouncedMessagesOnly() {
        return this.handleBouncedMailOnly;
    }

    public void setHandleBouncedMailOnly(boolean handleBouncedMailOnly) {
        this.handleBouncedMailOnly = handleBouncedMailOnly;
    }

    public void setPatternActions() throws Exception {
        LOGGER.debug("Calling " + SOSClassUtil.getMethodName());
        this.patternActions = new HashMap<String, String>();
        this.patternActions.put("0", "drop");
        this.patternActions.put("10", "store");
        this.patternActions.put("100", "retry");
        this.patternActions.put("200", "forward");
    }

    public int getRetryCounter(String messageId) throws Exception {
        LOGGER.debug("Calling " + SOSClassUtil.getMethodName());
        Map result = new HashMap();
        StringBuffer query = new StringBuffer();
        query.append("SELECT \"RETRY_COUNT\" FROM ");
        query.append(this.getTableMails());
        query.append(" WHERE \"MESSAGE_ID\" ='");
        query.append(messageId);
        query.append("'");
        LOGGER.debug("..query[" + query.toString() + "]");
        result = this.getConnection().getSingle(query.toString());
        if (result.get("retry_count") != null && !SOSString.isEmpty((String)((String)result.get("retry_count")))) {
            try {
                LOGGER.info("..message with ID [" + messageId + "] is already delivered [" + (String)result.get("retry_count") + "] time(s)");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return Integer.parseInt((String)result.get("retry_count"));
        }
        return -1;
    }

    public void updateTableMails(String messageId) throws Exception {
        StringBuilder query = new StringBuilder();
        LOGGER.debug("Calling " + SOSClassUtil.getMethodName());
        query.append("UPDATE ");
        query.append(this.getTableMails());
        query.append(" SET \"STATUS\"=");
        query.append(0);
        query.append(",\"STATUS_TEXT\"='requested',");
        query.append("\"MODIFIED\"=%now,\"MODIFIED_BY\"='");
        query.append(this.getJobName());
        query.append("' WHERE \"MESSAGE_ID\"='");
        query.append(messageId);
        query.append("'");
        LOGGER.debug("update table \"MAILS\": " + query);
        this.getConnection().execute(query.toString());
    }

    private String getMailId(String messageId) throws Exception {
        StringBuilder query = new StringBuilder();
        LOGGER.debug("Calling " + SOSClassUtil.getMethodName());
        query.append("SELECT \"ID\" FROM ");
        query.append(this.getTableMails());
        query.append(" WHERE \"MESSAGE_ID\"='");
        query.append(messageId);
        query.append("'");
        LOGGER.debug(".. query: " + query);
        return this.getConnection().getSingleValue(query.toString());
    }

    public boolean isRetrySendingAllowed(String messageId) throws Exception {
        int retryCounter = -1;
        LOGGER.debug("Calling " + SOSClassUtil.getMethodName());
        retryCounter = this.getRetryCounter(messageId);
        if (retryCounter <= 0 && !SOSString.isEmpty((String)this.getXSOSMailDeliveryCounterHeader())) {
            retryCounter = Integer.parseInt(this.getXSOSMailDeliveryCounterHeader());
        }
        LOGGER.debug(".. current retry counter [" + retryCounter + "]");
        if (retryCounter > 0) {
            for (Map<String, String> patternEntry : this.mailBouncePatternTableList) {
                if (patternEntry.get("pattern_id") == null || !patternEntry.get("pattern_id").equals(this.patternId) || patternEntry.get("max_retries") == null) continue;
                return Integer.parseInt(patternEntry.get("max_retries").toString()) > retryCounter;
            }
        }
        return false;
    }

    public int getRetryInterval(SOSMimeMessage sosMimeMessage) throws Exception {
        StringBuilder query = new StringBuilder();
        String retryItervalString = null;
        LOGGER.debug("Calling " + SOSClassUtil.getMethodName());
        int atIndex = sosMimeMessage.getFromAddress().indexOf(64);
        String domain = sosMimeMessage.getFromAddress().substring(atIndex + 1, sosMimeMessage.getFromAddress().length());
        this.retryInterval = -1;
        query.append("SELECT \"RETRY_INTERVAL\" FROM ");
        query.append(this.getTableMailBounceDeliveries());
        query.append(" WHERE \"DOMAIN\"='");
        query.append(domain);
        query.append("'");
        LOGGER.debug("..query [" + query + "]");
        retryItervalString = this.getConnection().getSingleValue(query.toString());
        if (!SOSString.isEmpty((String)retryItervalString)) {
            this.retryInterval = Integer.parseInt(retryItervalString);
        }
        if (this.retryInterval <= 0) {
            query = new StringBuilder();
            query.append("SELECT \"RETRY_INTERVAL\" FROM ");
            query.append(this.getTableMailBouncePatternRetries());
            query.append(" WHERE \"PATTERN_ID\"=");
            query.append(this.patternId);
            LOGGER.debug("..query [" + query + "]");
            retryItervalString = this.getConnection().getSingleValue(query.toString());
            if (!SOSString.isEmpty((String)retryItervalString)) {
                this.retryInterval = Integer.parseInt(retryItervalString);
            }
        }
        LOGGER.debug("..current retry interval [" + this.retryInterval + "]");
        return this.retryInterval;
    }

    public String getBounceDirectory() {
        return this.bounceDirectory;
    }

    public void setBounceDirectory(String bounceDirectory) {
        this.bounceDirectory = bounceDirectory;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
    }

    public String getXSOSMailDeliveryCounterHeader() {
        return this.xSOSMailDeliveryCounterHeader;
    }

    private String getXSOSMailDeliveryCounterHeader(SOSMimeMessage sosMimeMessage) throws Exception {
        return sosMimeMessage.getHeaderValue(X_SOSMAIL_DELIVERY_COUNTER_HEADER);
    }

    private void setXSOSMailDeliveryCounterHeader(String mailDeliveryCounterHeader) {
        this.xSOSMailDeliveryCounterHeader = mailDeliveryCounterHeader;
    }

    public boolean orderRetrySend(SOSMimeMessage sosMimeMessage) throws Exception {
        LOGGER.debug("Calling " + SOSClassUtil.getMethodName());
        Variable_set orderData = this.spooler.create_variable_set();
        orderData.set_var("file", new File(sosMimeMessage.getDumpedFileName()).getName());
        if (!SOSString.isEmpty((String)this.getMailId())) {
            orderData.set_var("id", this.getMailId());
        }
        Order order = this.spooler.create_order();
        order.set_title(this.getJobTitle() + "." + this.jobChainName);
        order.set_payload((Object)orderData);
        if (!this.spooler.job_chain_exists(this.jobChainName)) {
            LOGGER.warn("could not find job chain: " + this.jobChainName);
            return false;
        }
        this.spooler.job_chain(this.jobChainName).add_or_replace_order(order);
        this.spooler_task.job().set_delay_order_after_setback(1, (double)this.getRetryInterval());
        LOGGER.debug(".. order " + order.title() + " added.");
        return true;
    }

    public String getJobChainName() {
        return this.jobChainName;
    }

    public void setJobChainName(String jobChainName) {
        this.jobChainName = jobChainName;
    }

    public void forwardMessage(MimeMessage message, Session session) throws Exception {
        int i;
        LOGGER.debug("Calling " + SOSClassUtil.getMethodName());
        String[] toArray = new String[]{};
        String[] ccArray = new String[]{};
        String[] bccArray = new String[]{};
        String mailFrom = "";
        for (Map<String, String> patternEntry : this.mailBouncePatternTableList) {
            if (patternEntry.get("pattern_id") == null || !patternEntry.get("pattern_id").equals(this.patternId)) continue;
            if (patternEntry.get("mail_to") == null) {
                throw new Exception("[mail_to] missing!!");
            }
            toArray = patternEntry.get("mail_to").trim().split("[;,]");
            LOGGER.trace("..mail to  [" + patternEntry.get("mail_to") + "]");
            if (patternEntry.get("mail_cc") != null) {
                ccArray = patternEntry.get("mail_cc").trim().split("[;,]");
                LOGGER.trace("..mail cc [" + patternEntry.get("mail_cc") + "]");
            }
            if (patternEntry.get("mail_bcc") != null) {
                ccArray = patternEntry.get("mail_bcc").trim().split("[;,]");
                LOGGER.trace("..mail bcc [" + patternEntry.get("mail_bcc") + "]");
            }
            if (patternEntry.get("reply_to") == null) {
                throw new Exception("[reply_to] missing!!");
            }
            mailFrom = patternEntry.get("reply_to");
            LOGGER.trace("..reply_to [" + patternEntry.get("reply_to") + "]");
            break;
        }
        session.getProperties().put("mail.smtp.host", this.smtpHost);
        session.getProperties().put("mail.smtp.port", this.smtpPort);
        MimeMessage forward = new MimeMessage(session);
        forward.setSubject("Fw. " + message.getSubject());
        forward.setFrom((Address)new InternetAddress(mailFrom));
        for (i = 0; i < toArray.length; ++i) {
            forward.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(toArray[i]));
        }
        for (i = 0; i < ccArray.length; ++i) {
            forward.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(ccArray[i]));
        }
        for (i = 0; i < bccArray.length; ++i) {
            forward.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress(bccArray[i]));
        }
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setText(this.forwardSubject);
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)messageBodyPart);
        messageBodyPart = new MimeBodyPart();
        messageBodyPart.setDataHandler(message.getDataHandler());
        multipart.addBodyPart((BodyPart)messageBodyPart);
        forward.setContent((Multipart)multipart);
        Transport.send((Message)forward);
    }

    public String getMailId() {
        return this.mailId;
    }

    public void setMailId(String mailId) {
        this.mailId = mailId;
    }

    final class BounceMailStatus {
        public static final int REQUESTED = 0;
        public static final int DELIVERED = 1;
        public static final int CANCELLED = 1001;
        public static final int HAS_ERRORS = 1002;

        BounceMailStatus() {
        }
    }
}

