/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.launcher;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import sos.scheduler.command.SOSSchedulerCommand;
import sos.util.SOSClassUtil;
import sos.util.SOSString;
import sos.xml.SOSXMLXPath;

public class JobSchedulerLoadTestLauncher {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobSchedulerLoadTestLauncher.class);
    private String schedulerLauncherHost = "localhost";
    private int schedulerLauncherPort = 4444;
    private String schedulerLauncherProtocol = "tcp";
    private int schedulerLauncherMinStarts = 1;
    private int schedulerLauncherMaxStarts = -1;
    private int schedulerLauncherStartIncrement = 1;
    private String schedulerLauncherStartIncrementFactor = "+";
    private int schedulerLauncherInterval = 0;
    private long schedulerLauncherDuration = 120L;
    private long terminateTimeInSec = 0L;
    private String schedulerLauncherJob = "";
    private String schedulerLauncherJobAfter = "";
    private String schedulerLauncherJobAt = "";
    private String schedulerLauncherJobWebService = "";
    private String schedulerLauncherOrder = "";
    private String schedulerLauncherOrderJobChain = "";
    private boolean schedulerLauncherOrderReplace = true;
    private String schedulerLauncherOrderState = "";
    private String schedulerLauncherOrderTitle = "";
    private String schedulerLauncherOrderAt = "";
    private String schedulerLauncherOrderPriority = "";
    private String schedulerLauncherOrderWebService = "";
    private SOSString sosString = null;
    private HashMap allParam = new HashMap();
    private String configFile = "";
    private String stateText = "";
    private String jobname = "";

    public JobSchedulerLoadTestLauncher() throws Exception {
        try {
            this.init();
        }
        catch (Exception e) {
            throw new Exception("..error in " + SOSClassUtil.getMethodName() + ": " + e.getMessage(), e);
        }
    }

    public JobSchedulerLoadTestLauncher(String configFile_, String jobname_, String host_, int port_) throws Exception {
        try {
            this.configFile = configFile_;
            if (jobname_ != null && !jobname_.isEmpty()) {
                this.jobname = jobname_;
                LOGGER.debug("..argument[job] = " + this.jobname);
            }
            this.init();
            if (!this.sosString.parseToString((Object)host_).isEmpty()) {
                this.schedulerLauncherHost = host_;
                LOGGER.debug("..argument[host] = " + this.schedulerLauncherHost);
            }
            if (port_ != -1 && !this.sosString.parseToString((Object)String.valueOf(port_)).isEmpty()) {
                this.schedulerLauncherPort = port_;
                LOGGER.debug("..argument[port] = " + this.schedulerLauncherPort);
            }
        }
        catch (Exception e) {
            throw new Exception("..error in " + SOSClassUtil.getMethodName() + ": " + e.getMessage(), e);
        }
    }

    private void init() throws Exception {
        try {
            this.sosString = new SOSString();
            if (!this.sosString.parseToString((Object)this.jobname).isEmpty()) {
                this.extractParameters(this.jobname);
            } else {
                this.extractParameters();
            }
        }
        catch (Exception e) {
            throw new Exception("..error in " + SOSClassUtil.getMethodName() + ": " + e.getMessage(), e);
        }
    }

    private void extractParameters() throws Exception {
        LOGGER.debug("..reading parameters ...");
        String paramName = "";
        String paramValue = "";
        try {
            if (this.configFile.isEmpty()) {
                return;
            }
            this.allParam = new HashMap();
            SOSXMLXPath xpath = new SOSXMLXPath(this.configFile);
            NodeList nl = xpath.selectNodeList(xpath.getDocument().getElementsByTagName("param").item(0), "//param");
            for (int i = 0; i < nl.getLength(); ++i) {
                Node nParam = nl.item(i);
                NamedNodeMap map = nParam.getAttributes();
                for (int j = 0; j < map.getLength(); ++j) {
                    paramName = map.item(j).getNodeValue();
                    if (map.getLength() > 1) {
                        paramValue = map.item(++j).getNodeValue();
                    }
                    LOGGER.debug(".. parameter: " + paramName + "=" + paramValue);
                    this.allParam.put(paramName, paramValue);
                }
            }
            this.getParameters();
        }
        catch (Exception e) {
            throw new Exception("..error occurred processing job parameters: " + e.getMessage(), e);
        }
    }

    private void extractParameters(String jobname) throws Exception {
        String paramName = "";
        String paramValue = "";
        boolean existJob = false;
        try {
            if (this.configFile.isEmpty()) {
                return;
            }
            this.allParam = new HashMap();
            SOSXMLXPath xpath = new SOSXMLXPath(this.configFile);
            NodeList nl = xpath.selectNodeList("//param");
            for (int i = 0; i < nl.getLength(); ++i) {
                Node nParam = nl.item(i);
                if (!"job".equals(nParam.getParentNode().getParentNode().getNodeName()) || !nParam.getParentNode().getParentNode().getAttributes().getNamedItem("name").getNodeValue().equals(jobname)) continue;
                existJob = true;
                NamedNodeMap map = nParam.getAttributes();
                for (int j = 0; j < map.getLength(); ++j) {
                    paramName = map.item(j).getNodeValue();
                    if (map.getLength() > 1) {
                        paramValue = map.item(++j).getNodeValue();
                    }
                    LOGGER.debug(".. attribute: " + paramName + "=" + paramValue);
                    this.allParam.put(paramName, paramValue);
                }
            }
            if (!existJob) {
                throw new Exception("..job [" + jobname + "] not found in configuration file: " + this.configFile);
            }
            this.getParameters();
        }
        catch (Exception e) {
            throw new Exception("..error occurred processing job parameters: " + e.getMessage(), e);
        }
    }

    public void setParameters(HashMap allParams_) throws Exception {
        try {
            this.allParam = allParams_;
            this.getParameters();
        }
        catch (Exception e) {
            throw new Exception("..error occurred processing job parameters: " + e.getMessage(), e);
        }
    }

    private void getParameters() throws Exception {
        LOGGER.debug("get parameters ...");
        try {
            if (this.sosString.parseToString((Object)this.schedulerLauncherHost).isEmpty() && !this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_host").isEmpty()) {
                this.schedulerLauncherHost = this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_host");
                LOGGER.debug("..parameter[scheduler_launcher_host] = " + this.schedulerLauncherHost);
            }
            if (!this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_port").isEmpty()) {
                this.schedulerLauncherPort = Integer.parseInt(this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_port"));
                LOGGER.debug("..parameter[scheduler_launcher_port] = " + this.schedulerLauncherPort);
            }
            if (!this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_protocol").isEmpty()) {
                this.schedulerLauncherProtocol = this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_protocol");
                LOGGER.debug("..parameter[scheduler_launcher_protocol] = " + this.schedulerLauncherProtocol);
            }
            if (!this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_min_starts").isEmpty()) {
                this.schedulerLauncherMinStarts = Integer.parseInt(this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_min_starts"));
                LOGGER.debug("..parameter[scheduler_launcher_min_starts] = " + this.schedulerLauncherMinStarts);
            }
            if (!this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_start_increment").isEmpty()) {
                LOGGER.debug("..parameter[scheduler_launcher_start_increment] = " + this.schedulerLauncherStartIncrement);
                if (this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_start_increment").trim().startsWith("+") || this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_start_increment").trim().startsWith("*")) {
                    this.schedulerLauncherStartIncrement = Integer.parseInt(this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_start_increment").trim().substring(1));
                    this.schedulerLauncherStartIncrementFactor = this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_start_increment").trim().substring(0, 1);
                } else {
                    this.schedulerLauncherStartIncrement = Integer.parseInt(this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_start_increment"));
                }
            }
            if (!this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_max_starts").isEmpty()) {
                this.schedulerLauncherMaxStarts = Integer.parseInt(this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_max_starts"));
                LOGGER.debug("..parameter[scheduler_launcher_max_starts] = " + this.schedulerLauncherMaxStarts);
            }
            if (!this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_interval").isEmpty()) {
                this.schedulerLauncherInterval = Integer.parseInt(this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_interval"));
                LOGGER.debug("..parameter[scheduler_launcher_interval] = " + this.schedulerLauncherInterval);
            }
            if (!this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_job").isEmpty()) {
                this.schedulerLauncherJob = this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_job");
                LOGGER.debug("..parameter[scheduler_launcher_job] = " + this.schedulerLauncherJob);
            }
            if (!this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_job_after").isEmpty()) {
                this.schedulerLauncherJobAfter = this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_job_after");
                LOGGER.debug("..parameter[scheduler_launcher_job_after] = " + this.schedulerLauncherJobAfter);
            }
            if (!this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_job_at").isEmpty()) {
                this.schedulerLauncherJobAt = this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_job_at");
                LOGGER.debug("..parameter[scheduler_launcher_job_at] = " + this.schedulerLauncherJobAt);
            }
            if (!this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_duration").isEmpty()) {
                this.schedulerLauncherDuration = Long.parseLong(this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_duration"));
                LOGGER.debug("..parameter[scheduler_launcher_duration] = " + this.schedulerLauncherDuration);
            }
            if (!this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_job_web_service").isEmpty()) {
                this.schedulerLauncherJobWebService = this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_job_web_service");
                LOGGER.debug("..parameter[scheduler_launcher_web_service] = " + this.schedulerLauncherJobWebService);
            }
            if (!this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_order").isEmpty()) {
                this.schedulerLauncherOrder = this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_order");
                LOGGER.debug("..parameter[scheduler_launcher_order] = " + this.schedulerLauncherOrder);
            }
            if (!this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_order_replace").isEmpty()) {
                this.schedulerLauncherOrderReplace = this.sosString.parseToBoolean((Object)this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_order_replace"));
                LOGGER.debug("..parameter[scheduler_launcher_order_replace] = " + this.schedulerLauncherOrderReplace);
            }
            if (!this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_order_job_chain").isEmpty()) {
                this.schedulerLauncherOrderJobChain = this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_order_job_chain");
                LOGGER.debug("..parameter[scheduler_launcher_order_job_chain] = " + this.schedulerLauncherOrderJobChain);
            }
            if (!this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_order_state").isEmpty()) {
                this.schedulerLauncherOrderState = this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_order_state");
                LOGGER.debug("..parameter[scheduler_launcher_order_state] = " + this.schedulerLauncherOrderState);
            }
            if (!this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_order_title").isEmpty()) {
                this.schedulerLauncherOrderTitle = this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_order_title");
                LOGGER.debug("..parameter[scheduler_launcher_title] = " + this.schedulerLauncherOrderTitle);
            }
            if (!this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_order_at").isEmpty()) {
                this.schedulerLauncherOrderAt = this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_order_at");
                LOGGER.debug("..parameter[scheduler_launcher_order_at] = " + this.schedulerLauncherOrderAt);
            }
            if (!this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_order_priority").isEmpty()) {
                this.schedulerLauncherOrderPriority = this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_order_priority");
                LOGGER.debug("..parameter[scheduler_launcher_order_priority] = " + this.schedulerLauncherOrderPriority);
            }
            if (!this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_order_web_service").isEmpty()) {
                this.schedulerLauncherOrderWebService = this.sosString.parseToString((Map)this.allParam, "scheduler_launcher_order_web_service");
                LOGGER.debug("..parameter[scheduler_launcher_order_web_service] = " + this.schedulerLauncherOrderWebService);
            }
        }
        catch (Exception e) {
            throw new Exception("..error occurred processing job parameters: " + e.getMessage(), e);
        }
    }

    private String getRequest() throws Exception {
        String request = "";
        try {
            if (!this.sosString.parseToString((Object)this.schedulerLauncherOrder).isEmpty()) {
                request = "<add_order";
                request = request + " replace=\"" + (this.schedulerLauncherOrderReplace ? "yes" : "no") + "\"";
                if (!this.sosString.parseToString((Object)this.schedulerLauncherOrder).isEmpty()) {
                    request = request + " id=\"" + this.schedulerLauncherOrder + "\"";
                }
                request = !this.sosString.parseToString((Object)this.schedulerLauncherOrderAt).isEmpty() ? request + " at=\"" + this.schedulerLauncherOrderAt + "\"" : request + " at=\"now + " + this.schedulerLauncherInterval + "\"";
                this.schedulerLauncherJobAt = this.schedulerLauncherOrderAt;
                if (!this.sosString.parseToString((Object)this.schedulerLauncherOrderJobChain).isEmpty()) {
                    request = request + " job_chain=\"" + this.schedulerLauncherOrderJobChain + "\"";
                }
                if (!this.sosString.parseToString((Object)this.schedulerLauncherOrderPriority).isEmpty()) {
                    request = request + " priority=\"" + this.schedulerLauncherOrderPriority + "\"";
                }
                if (!this.sosString.parseToString((Object)this.schedulerLauncherOrderState).isEmpty()) {
                    request = request + " state=\"" + this.schedulerLauncherOrderState + "\"";
                }
                if (!this.sosString.parseToString((Object)this.schedulerLauncherOrderTitle).isEmpty()) {
                    request = request + " title=\"" + this.schedulerLauncherOrderTitle + "\"";
                }
                if (!this.sosString.parseToString((Object)this.schedulerLauncherOrderWebService).isEmpty()) {
                    request = request + " web_service=\"" + this.schedulerLauncherOrderWebService + "\"";
                }
                request = request + ">";
                request = request + "<params>";
                Object[] params = this.allParam.entrySet().toArray();
                for (int i = 0; i < params.length; ++i) {
                    if (this.sosString.parseToString(params[i]).startsWith("scheduler_launcher_")) continue;
                    request = request + "<param name=\"" + this.sosString.parseToString(params[i]).split("=")[0] + "\" value=\"" + this.sosString.parseToString(params[i]).split("=")[1] + "\"/>";
                }
                request = request + "</params>";
                request = request + "</add_order>";
            } else if (!this.sosString.parseToString((Object)this.schedulerLauncherJob).isEmpty()) {
                request = "<start_job job=\"" + this.schedulerLauncherJob + "\"";
                if (!this.sosString.parseToString((Object)this.schedulerLauncherJobAfter).isEmpty()) {
                    request = request + " after=\"" + this.schedulerLauncherJobAfter + "\"";
                }
                request = !this.sosString.parseToString((Object)this.schedulerLauncherJobAt).isEmpty() ? request + " at=\"" + this.schedulerLauncherJobAt + "\"" : request + " at=\"now + " + this.schedulerLauncherInterval + "\"";
                if (!this.sosString.parseToString((Object)this.schedulerLauncherJobWebService).isEmpty()) {
                    request = request + " web_service=\"" + this.schedulerLauncherJobWebService + "\"";
                }
                request = request + ">";
                request = request + "<params>";
                Object[] params = this.allParam.entrySet().toArray();
                for (int i = 0; i < params.length; ++i) {
                    if (this.sosString.parseToString(params[i]).startsWith("scheduler_launcher_")) continue;
                    request = request + "<param name=\"" + this.sosString.parseToString(params[i]).split("=")[0] + "\" value=\"" + this.sosString.parseToString(params[i]).split("=")[1] + "\"/>";
                }
                request = request + "</params>";
                request = request + "</start_job>";
            }
            LOGGER.debug("request: " + request);
            return request;
        }
        catch (Exception e) {
            throw new Exception("..error in " + SOSClassUtil.getClassName() + ": " + e.getMessage(), e);
        }
    }

    public void process() throws Exception {
        String request = "";
        String response = "";
        int counter = 0;
        int counterError = 0;
        long timeInSec = 0L;
        SOSSchedulerCommand remoteCommand = null;
        try {
            timeInSec = System.currentTimeMillis();
            this.checkParams();
            request = this.getRequest();
            remoteCommand = new SOSSchedulerCommand();
            remoteCommand.setProtocol(this.schedulerLauncherProtocol);
            remoteCommand.connect(this.schedulerLauncherHost, this.schedulerLauncherPort);
            boolean loop = true;
            this.terminateTimeInSec = System.currentTimeMillis() + this.schedulerLauncherDuration * 1000L;
            LOGGER.debug("..time until termination: " + this.terminateTimeInSec);
            while (loop) {
                LOGGER.info("..sending request to job scheduler [" + this.schedulerLauncherHost + ":" + this.schedulerLauncherPort + "]: " + request);
                if (System.currentTimeMillis() > this.terminateTimeInSec) {
                    LOGGER.debug("..time until termination: " + this.terminateTimeInSec);
                    loop = false;
                    break;
                }
                for (int i = 0; i < this.schedulerLauncherMinStarts; ++i) {
                    remoteCommand.sendRequest(request);
                    ++counter;
                    if (!"tcp".equalsIgnoreCase(this.schedulerLauncherProtocol)) continue;
                    response = remoteCommand.getResponse();
                    SOSXMLXPath xpath = new SOSXMLXPath(new StringBuffer(response));
                    String errCode = xpath.selectSingleNodeValue("//ERROR/@code");
                    String errMessage = xpath.selectSingleNodeValue("//ERROR/@text");
                    LOGGER.info("..job scheduler response: " + response);
                    if ((errCode == null || errCode.isEmpty()) && (errMessage == null || errMessage.isEmpty())) continue;
                    LOGGER.warn("..job scheduler response reports error message: " + errMessage + " [" + errCode + "]");
                    ++counterError;
                }
                this.schedulerLauncherMinStarts = this.startIncrement(this.schedulerLauncherMinStarts);
            }
            LOGGER.info("..number of jobs launched: " + counter);
            this.stateText = "..number of jobs launched: " + counter + "(error=" + counterError + ";success=" + (counter - counterError) + ")";
            this.showSummary(counter, counterError, timeInSec);
        }
        catch (Exception e) {
            this.stateText = "..number of jobs launched: " + counter + "(error=" + counterError + ";success=" + (counter - counterError) + ")" + e.getMessage();
            LOGGER.info("..error in " + SOSClassUtil.getClassName() + ": " + e.getMessage());
            throw new Exception("..error in " + SOSClassUtil.getClassName() + ": " + e.getMessage(), e);
        }
        finally {
            if (remoteCommand != null) {
                try {
                    remoteCommand.disconnect();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void checkParams() throws Exception {
        int oneOfUs = 0;
        try {
            oneOfUs += this.sosString.parseToString((Object)this.schedulerLauncherJob).isEmpty() ? 0 : 1;
            if ((oneOfUs += this.sosString.parseToString((Object)this.schedulerLauncherOrder).isEmpty() ? 0 : 1) == 0) {
                throw new Exception("one of the parameters [scheduler_launcher_job, scheduler_launcher_order] must be specified");
            }
            if (oneOfUs > 1) {
                throw new Exception("only one of the parameters [scheduler_launcher_job, scheduler_launcher_order] must be specified, " + oneOfUs + " were given");
            }
        }
        catch (Exception e) {
            throw new Exception("..error in " + SOSClassUtil.getClassName() + ": " + e.getMessage(), e);
        }
    }

    private int startIncrement(int i) throws Exception {
        int retVal = 0;
        try {
            retVal = this.schedulerLauncherStartIncrementFactor.startsWith("*") ? i * this.schedulerLauncherStartIncrement : i + this.schedulerLauncherStartIncrement;
            if (retVal > this.schedulerLauncherMaxStarts) {
                retVal = this.schedulerLauncherMaxStarts;
                LOGGER.debug("..maximum number of jobs to be launched is reached: " + this.schedulerLauncherMaxStarts);
            }
            if (this.schedulerLauncherInterval > 0) {
                LOGGER.debug("..delay " + this.schedulerLauncherInterval + " sec.");
                Thread.sleep(this.schedulerLauncherInterval * 1000);
            }
            LOGGER.debug("..next start increment from " + i + " to " + retVal);
            return retVal;
        }
        catch (Exception e) {
            throw new Exception("..error in " + SOSClassUtil.getClassName() + ": " + e.getMessage(), e);
        }
    }

    public void showSummary(int counter, int counterError, long timeInSec) throws Exception {
        try {
            LOGGER.debug("..end time in miliseconds: " + System.currentTimeMillis());
            LOGGER.info("---------------------------------------------------------------");
            LOGGER.info("..number of job starts                            : " + counter);
            LOGGER.info("..number of jobs processed successfully           : " + (counter - counterError));
            LOGGER.info("..number of jobs processed with errors            : " + counterError);
            LOGGER.info("..time elapsed in seconds                         : " + Math.round((System.currentTimeMillis() - timeInSec) / 1000L) + "s");
            LOGGER.info("---------------------------------------------------------------");
        }
        catch (Exception e) {
            throw new Exception("..error occurred in " + SOSClassUtil.getMethodName() + ": " + e.getMessage(), e);
        }
    }

    public String getStateText() {
        return this.stateText;
    }

    public static void main(String[] args) {
        String configFile = "";
        String host = "";
        int port = -1;
        String job = "";
        SOSString sosString = null;
        try {
            sosString = new SOSString();
            if (args.length == 0) {
                System.err.println("Usage: ");
                System.out.println("sos.scheduler.launcher.JobSchedulerLoadTestLauncher");
                System.out.println("     -config=         xml configuration file");
                System.out.println("     -host=           host (optional)");
                System.out.println("     -port=           port (optional)");
                System.out.println("     -job=            job  (optional)");
                System.out.println();
                System.out.println("for example:");
                System.err.println("java -cp=. sos.scheduler.launcher.JobSchedulerLoadTestLauncher -config=<xml configuration file> -host=<host> -port=<port> -job=<job name>");
                System.exit(0);
            }
            JobSchedulerLoadTestLauncher launcher = null;
            for (int i = 0; i < args.length; ++i) {
                String[] currArg = args[i].split("=");
                if ("-config".equalsIgnoreCase(currArg[0])) {
                    configFile = currArg[1];
                    continue;
                }
                if ("-host".equalsIgnoreCase(currArg[0])) {
                    host = currArg[1];
                    continue;
                }
                if ("-port".equalsIgnoreCase(currArg[0])) {
                    if (sosString.parseToString((Object)currArg[1]).isEmpty()) continue;
                    port = Integer.parseInt(currArg[1]);
                    continue;
                }
                if (!"-job".equalsIgnoreCase(currArg[0])) continue;
                job = currArg[1];
            }
            launcher = new JobSchedulerLoadTestLauncher(configFile, job, host, port);
            launcher.process();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }
}

