/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.misc;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.net.SOSMail;
import sos.scheduler.job.JobSchedulerJob;
import sos.settings.SOSProfileSettings;
import sos.settings.SOSSettings;
import sos.spooler.Job_impl;
import sos.spooler.Log;
import sos.spooler.Monitor_impl;
import sos.spooler.Spooler;
import sos.spooler.Variable_set;

public class SchedulerMailer {
    private SOSMail sosMail;
    private final Spooler spooler;
    private static final Logger LOGGER = LoggerFactory.getLogger(SchedulerMailer.class);

    public SchedulerMailer(Job_impl job) throws Exception {
        this.spooler = job.spooler;
        this.init(job.spooler_log);
        Variable_set params = job.spooler.create_variable_set();
        params.merge(job.spooler_task.params());
        if (job.spooler_job.order_queue() != null) {
            params.merge(job.spooler_task.order().params());
        }
        this.readParams(params);
    }

    public SchedulerMailer(Monitor_impl monitor) throws Exception {
        this.spooler = monitor.spooler;
        this.init(monitor.spooler_log);
        Variable_set params = monitor.spooler.create_variable_set();
        params.merge(monitor.spooler_task.params());
        if (monitor.spooler_job.order_queue() != null) {
            params.merge(monitor.spooler_task.order().params());
        }
        this.readParams(params);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SchedulerMailer(JobSchedulerJob job) throws Exception {
        String readSettings;
        this.spooler = job.spooler;
        Variable_set params = job.spooler.create_variable_set();
        params.merge(job.spooler_task.params());
        if (job.spooler_job.order_queue() != null && job.spooler_task.order() != null) {
            params.merge(job.spooler_task.order().params());
        }
        if ((readSettings = params.value("read_mail_settings")) != null && ("yes".equalsIgnoreCase(readSettings) || "1".equalsIgnoreCase(readSettings) || "true".equalsIgnoreCase(readSettings))) {
            if (job.getConnectionSettings() == null || job.getConnectionSettings().getSection("email", "mail_server").isEmpty()) throw new Exception("Mail Settings could not be found.");
            this.sosMail = new SOSMail((SOSSettings)job.getConnectionSettings());
        } else {
            this.init(job.spooler_log);
        }
        this.readParams(params);
    }

    private void init(Log spooler_log) throws Exception {
        try {
            this.sosMail = new SOSMail(spooler_log.mail().smtp());
            this.sosMail.setQueueDir(spooler_log.mail().queue_dir());
            this.sosMail.setFrom(spooler_log.mail().from());
            this.sosMail.addRecipient(spooler_log.mail().to());
            this.sosMail.addCC(spooler_log.mail().cc());
            this.sosMail.addBCC(spooler_log.mail().bcc());
            SOSProfileSettings smtpSettings = new SOSProfileSettings(this.spooler.ini_path());
            Properties smtpProperties = smtpSettings.getSection("smtp");
            if (!smtpProperties.isEmpty()) {
                if (smtpProperties.getProperty("mail.smtp.user") != null && !smtpProperties.getProperty("mail.smtp.user").isEmpty()) {
                    this.sosMail.setUser(smtpProperties.getProperty("mail.smtp.user"));
                }
                if (smtpProperties.getProperty("mail.smtp.password") != null && !smtpProperties.getProperty("mail.smtp.password").isEmpty()) {
                    this.sosMail.setPassword(smtpProperties.getProperty("mail.smtp.password"));
                }
            }
        }
        catch (Exception e) {
            throw new JobSchedulerException("Error initializing SOSMail: " + e, (Throwable)e);
        }
    }

    private void readParams(Variable_set params) throws Exception {
        try {
            LOGGER.debug("Setting mail parameters:");
            if (params.value("to") != null && !params.value("to").isEmpty()) {
                this.sosMail.clearRecipients();
                this.sosMail.addRecipient(params.value("to"));
                this.debugParameter(params, "to");
            }
            if (params.value("from") != null && !params.value("from").isEmpty()) {
                this.sosMail.setFrom(params.value("from"));
                this.debugParameter(params, "from");
            }
            if (params.value("from_name") != null && !params.value("from_name").isEmpty()) {
                this.sosMail.setFromName(params.value("from_name"));
                this.debugParameter(params, "from_name");
            }
            if (params.value("reply_to") != null && !params.value("reply_to").isEmpty()) {
                this.sosMail.setReplyTo(params.value("reply_to"));
                this.debugParameter(params, "reply_to");
            }
            if (params.value("cc") != null && !params.value("cc").isEmpty()) {
                this.sosMail.addCC(params.value("cc"));
                this.debugParameter(params, "cc");
            }
            if (params.value("bcc") != null && !params.value("bcc").isEmpty()) {
                this.sosMail.addBCC(params.value("bcc"));
                this.debugParameter(params, "bcc");
            }
            if (params.value("subject") != null && !params.value("subject").isEmpty()) {
                this.sosMail.setSubject(params.value("subject"));
                this.debugParameter(params, "subject");
            }
            if (params.value("host") != null && !params.value("host").isEmpty()) {
                this.sosMail.setHost(params.value("host"));
                this.debugParameter(params, "host");
            }
            if (params.value("port") != null && !params.value("port").isEmpty()) {
                try {
                    int port = Integer.parseInt(params.value("port"));
                    this.sosMail.setPort("" + port);
                    this.debugParameter(params, "port");
                }
                catch (Exception e) {
                    throw new Exception("illegal, non-numeric value [" + params.value("port") + "] for parameter [port]: " + e.getMessage());
                }
            }
            if (params.value("smtp_user") != null && !params.value("smtp_user").isEmpty()) {
                this.sosMail.setUser(params.value("smtp_user"));
                this.debugParameter(params, "smtp_user");
            }
            if (params.value("smtp_password") != null && !params.value("smtp_password").isEmpty()) {
                this.sosMail.setPassword(params.value("smtp_password"));
                this.debugParameter(params, "smtp_password");
            }
            if (params.value("queue_directory") != null && !params.value("queue_directory").isEmpty()) {
                this.sosMail.setQueueDir(params.value("queue_directory"));
                this.debugParameter(params, "queue_director");
            }
            if (params.value("body") != null && !params.value("body").isEmpty()) {
                this.sosMail.setBody(params.value("body"));
                this.debugParameter(params, "body");
            }
            if (params.value("content_type") != null && !params.value("content_type").isEmpty()) {
                this.sosMail.setContentType(params.value("content_type"));
                this.debugParameter(params, "content_type");
            }
            if (params.value("encoding") != null && !params.value("encoding").isEmpty()) {
                this.sosMail.setEncoding(params.value("encoding"));
                this.debugParameter(params, "encoding");
            }
            if (params.value("charset") != null && !params.value("charset").isEmpty()) {
                this.sosMail.setCharset(params.value("charset"));
                this.debugParameter(params, "charset");
            }
            if (params.value("attachment_charset") != null && !params.value("attachment_charset").isEmpty()) {
                this.sosMail.setAttachmentCharset(params.value("attachment_charset"));
                this.debugParameter(params, "attachment_charset");
            }
            if (params.value("attachment_content_type") != null && !params.value("attachment_content_type").isEmpty()) {
                this.sosMail.setAttachmentContentType(params.value("attachment_content_type"));
                this.debugParameter(params, "attachment_content_type");
            }
            if (params.value("attachment_encoding") != null && !params.value("attachment_encoding").isEmpty()) {
                this.sosMail.setAttachmentEncoding(params.value("attachment_encoding"));
                this.debugParameter(params, "attachment_encoding");
            }
            if (params.value("attachment") != null && !params.value("attachment").isEmpty()) {
                String[] attachments = params.value("attachment").split(";");
                for (int i = 0; i < attachments.length; ++i) {
                    String attFile = attachments[i];
                    LOGGER.debug(".. mail attachment [" + i + "]: " + attFile);
                    this.sosMail.addAttachment(attFile);
                }
            }
        }
        catch (Exception e) {
            throw new Exception("Error occured reading parameters: " + e, e);
        }
    }

    private void debugParameter(Variable_set params, String paramName) {
        try {
            if (paramName.contains("password")) {
                LOGGER.debug(".. mail parameter [" + paramName + "]: *****");
            } else {
                LOGGER.debug(".. mail parameter [" + paramName + "]: " + params.value(paramName));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SOSMail getSosMail() {
        return this.sosMail;
    }
}

