/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.process;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import sos.net.SOSMail;
import sos.spooler.Monitor_impl;
import sos.spooler.Variable_set;
import sos.xml.SOSXMLXPath;

public class ProcessBaseMonitor
extends Monitor_impl {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessBaseMonitor.class);
    private Document configuration = null;
    private StringBuilder configurationBuilder = null;
    private String configurationPath = "";
    private String configurationFilename = "";
    private Vector orderParameterKeys = null;
    private TreeMap envvars = null;

    public void initConfiguration() throws Exception {
        Variable_set orderParams = null;
        if (this.spooler_job.order_queue() != null) {
            orderParams = this.spooler_task.order().params();
            if (orderParams.value("configuration_path") != null && !orderParams.value("configuration_path").isEmpty()) {
                this.setConfigurationPath(orderParams.value("configuration_path"));
            }
            if (orderParams.value("configuration_file") != null && !orderParams.value("configuration_file").isEmpty()) {
                this.setConfigurationFilename(orderParams.value("configuration_file"));
            }
            this.initConfiguration(this.getConfigurationPath(), this.getConfigurationFilename(), orderParams);
        }
    }

    private void initConfiguration(String configurationPath, String configurationFilename, Variable_set orderParams) throws Exception {
        if (orderParams.value("configuration_path") != null && !orderParams.value("configuration_path").isEmpty()) {
            this.setConfigurationPath(orderParams.value("configuration_path"));
        }
        if (configurationFilename.startsWith(".") || configurationFilename.startsWith("/") || configurationFilename.startsWith("\\") || configurationFilename.indexOf(":") > -1 || configurationPath == null || configurationPath.isEmpty()) {
            this.initConfiguration(configurationFilename, orderParams);
        } else {
            this.initConfiguration(configurationPath + (!configurationPath.endsWith("/") && !configurationPath.endsWith("\\") ? "/" : "") + configurationFilename, orderParams);
        }
    }

    private void initConfiguration(String configurationFilename, Variable_set orderParams) throws Exception {
        FileInputStream fis = null;
        try {
            int inBytesRead;
            if (configurationFilename == null || configurationFilename.isEmpty()) {
                throw new Exception("no configuration filename was specified");
            }
            File configurationFile = new File(configurationFilename);
            if (!configurationFile.exists()) {
                throw new Exception("configuration file not found: " + configurationFile.getCanonicalPath());
            }
            if (!configurationFile.canRead()) {
                throw new Exception("configuration file is not accessible: " + configurationFile.getCanonicalPath());
            }
            fis = new FileInputStream(configurationFile);
            BufferedInputStream in = new BufferedInputStream(fis);
            byte[] inBuffer = new byte[1024];
            this.configurationBuilder = new StringBuilder();
            while ((inBytesRead = in.read(inBuffer)) != -1) {
                this.configurationBuilder.append(new String(inBuffer, 0, inBytesRead));
            }
            this.spooler_task.order().set_xml_payload(this.configurationBuilder.toString());
            orderParams.set_var("scheduler_order_configuration_loaded", "true");
            orderParams.set_var("configuration_file", configurationFilename);
        }
        catch (Exception e) {
            LOGGER.warn("error occurred initializing configuration: " + e.toString(), (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                    fis = null;
                }
            }
            catch (Exception exception) {}
        }
    }

    public Document prepareConfiguration() throws Exception {
        String nodeQuery = "";
        String payload = "";
        try {
            this.orderParameterKeys = new Vector();
            if (this.spooler_task.job().order_queue() != null) {
                Node node;
                int i;
                if (this.spooler_task.order().xml_payload() == null || this.spooler_task.order().xml_payload().isEmpty() || this.spooler_task.order().params() == null || this.spooler_task.order().params().value("scheduler_order_configuration_loaded") == null || this.spooler_task.order().params().value("scheduler_order_configuration_loaded").isEmpty()) {
                    this.initConfiguration();
                }
                if (this.spooler_task.order().xml_payload() == null) {
                    throw new Exception("monitor:no configuration was specified for this order: " + this.spooler_task.order().id());
                }
                DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                docFactory.setNamespaceAware(false);
                docFactory.setValidating(false);
                DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                payload = this.spooler_task.order().xml_payload();
                if (!payload.startsWith("<?xml ")) {
                    payload = "<?xml version='1.0' encoding='ISO-8859-1'?>" + payload;
                }
                this.setConfiguration(docBuilder.parse(new ByteArrayInputStream(payload.getBytes())));
                SOSXMLXPath xpath = new SOSXMLXPath(new StringBuffer(payload));
                NodeList nodeList = null;
                NamedNodeMap nodeMapSettings = null;
                nodeQuery = "//settings/log_level";
                Node nodeSettings = xpath.selectSingleNode(nodeQuery);
                if (nodeSettings != null && (nodeMapSettings = nodeSettings.getAttributes()) != null && nodeMapSettings.getNamedItem("value") != null) {
                    LOGGER.debug("Log Level is: " + nodeMapSettings.getNamedItem("value").getNodeValue());
                }
                this.setEnvVars();
                nodeQuery = "//job_chain[@name='" + this.spooler_task.order().job_chain().name() + "']/order";
                LOGGER.trace("monitor: lookup order for job chain: " + nodeQuery + "/params/param");
                nodeList = xpath.selectNodeList(nodeQuery + "/params/param");
                if (nodeList == null || nodeList.getLength() == 0) {
                    nodeQuery = "//application[@name='" + this.spooler_task.order().job_chain().name() + "']/order";
                    LOGGER.trace("monitor: lookup order for application: " + nodeQuery + "/params/param");
                    nodeList = xpath.selectNodeList(nodeQuery + "/params/param");
                }
                for (i = 0; i < nodeList.getLength(); ++i) {
                    NamedNodeMap nodeMap;
                    node = nodeList.item(i);
                    String nodeValue = "";
                    String nodeName = "";
                    if (!"param".equalsIgnoreCase(node.getNodeName()) || (nodeMap = node.getAttributes()) == null || nodeMap.getNamedItem("name") == null) continue;
                    nodeName = nodeMap.getNamedItem("name").getNodeValue();
                    if (nodeMap.getNamedItem("value") != null) {
                        nodeValue = nodeMap.getNamedItem("value").getNodeValue();
                    } else {
                        NodeList children = node.getChildNodes();
                        for (int j = 0; j < children.getLength(); ++j) {
                            Node item = children.item(j);
                            switch (item.getNodeType()) {
                                case 3: 
                                case 4: {
                                    nodeValue = nodeValue + item.getNodeValue();
                                }
                            }
                        }
                    }
                    LOGGER.debug(".. monitor: global configuration parameter [" + nodeName + "]: " + nodeValue);
                    this.spooler_task.order().params().set_var(nodeName, nodeValue);
                }
                nodeQuery = "//job_chain[@name='" + this.spooler_task.order().job_chain().name() + "']/order/process[@state='" + this.spooler_task.order().state() + "']";
                LOGGER.trace("monitor: lookup order node query for job chain: " + nodeQuery + "/params/param");
                nodeList = xpath.selectNodeList(nodeQuery + "/params/param");
                if (nodeList == null || nodeList.getLength() == 0) {
                    nodeQuery = "//application[@name='" + this.spooler_task.order().job_chain().name() + "']/order/process[@state='" + this.spooler_task.order().state() + "']";
                    LOGGER.trace("monitor: lookup order node query for application: " + nodeQuery + "/params/param");
                    nodeList = xpath.selectNodeList(nodeQuery + "/params/param");
                }
                for (i = 0; i < nodeList.getLength(); ++i) {
                    NamedNodeMap nodeMap;
                    node = nodeList.item(i);
                    if (!"param".equalsIgnoreCase(node.getNodeName()) || (nodeMap = node.getAttributes()) == null || nodeMap.getNamedItem("name") == null) continue;
                    if (nodeMap.getNamedItem("value") != null) {
                        LOGGER.debug(".. monitor: configuration parameter [" + nodeMap.getNamedItem("name").getNodeValue() + "]: " + nodeMap.getNamedItem("value").getNodeValue());
                        this.spooler_task.order().params().set_var(nodeMap.getNamedItem("name").getNodeValue(), nodeMap.getNamedItem("value").getNodeValue());
                        this.orderParameterKeys.add(nodeMap.getNamedItem("name").getNodeValue());
                        continue;
                    }
                    NodeList children = node.getChildNodes();
                    String nodeValue = "";
                    for (int j = 0; j < children.getLength(); ++j) {
                        Node item = children.item(j);
                        switch (item.getNodeType()) {
                            case 3: 
                            case 4: {
                                nodeValue = nodeValue + item.getNodeValue();
                            }
                        }
                    }
                    LOGGER.debug(".. configuration parameter [" + nodeMap.getNamedItem("name").getNodeValue() + "]: " + nodeValue);
                    this.spooler_task.order().params().set_var(nodeMap.getNamedItem("name").getNodeValue(), nodeValue);
                }
                String[] parameterNames = this.spooler_task.order().params().names().split(";");
                for (int i2 = 0; i2 < parameterNames.length; ++i2) {
                    String currParam = String.valueOf(this.spooler_task.order().params().value(parameterNames[i2]));
                    if (currParam == null || !currParam.matches("^.*\\$\\{.*\\}.*$")) continue;
                    boolean parameterFound = false;
                    boolean envFound = false;
                    String parameterValue = this.spooler_task.order().params().value(parameterNames[i2]);
                    for (int trials = 0; parameterValue.indexOf("${") != -1 && trials <= 1; ++trials) {
                        LOGGER.debug("substitution trials: " + trials + " --> " + parameterValue);
                        for (int j = 0; j < parameterNames.length; ++j) {
                            LOGGER.trace("parameterNames[j]=" + parameterNames[j] + " -->" + parameterValue.indexOf("${" + parameterNames[j] + "}"));
                            if (parameterNames[i2].equals(parameterNames[j]) || parameterValue.indexOf("${" + parameterNames[j] + "}") == -1 && parameterValue.indexOf("${basename:" + parameterNames[j] + "}") == -1) continue;
                            parameterValue = parameterValue.indexOf("${basename:") != -1 ? ProcessBaseMonitor.myReplaceAll(parameterValue, "\\$\\{basename:" + parameterNames[j] + "\\}", new File(this.spooler_task.order().params().value(parameterNames[j])).getName().replaceAll("[\\\\]", "\\\\\\\\")) : ProcessBaseMonitor.myReplaceAll(parameterValue, "\\$\\{" + parameterNames[j] + "\\}", this.spooler_task.order().params().value(parameterNames[j]).replaceAll("[\\\\]", "\\\\\\\\"));
                            parameterFound = true;
                            trials = 0;
                        }
                    }
                    if (this.envvars != null) {
                        for (Object envName : this.envvars.keySet()) {
                            Object envValue = this.envvars.get(envName.toString());
                            if (parameterValue.indexOf("${" + envName.toString() + "}") != -1) {
                                parameterValue = ProcessBaseMonitor.myReplaceAll(parameterValue, "\\$\\{" + envName.toString() + "\\}", envValue.toString().replaceAll("[\\\\]", "\\\\\\\\"));
                                envFound = true;
                                continue;
                            }
                            if (parameterValue.indexOf("${basename:" + envName.toString() + "}") == -1) continue;
                            parameterValue = ProcessBaseMonitor.myReplaceAll(parameterValue, "\\$\\{basename:" + envName.toString() + "\\}", new File(envValue.toString()).getName().replaceAll("[\\\\]", "\\\\\\\\"));
                            envFound = true;
                        }
                    }
                    if (parameterFound) {
                        LOGGER.debug("parameter substitution [" + parameterNames[i2] + "]: " + parameterValue);
                        this.spooler_task.order().params().set_var(parameterNames[i2], parameterValue);
                    }
                    if (!envFound) continue;
                    LOGGER.debug("environment variable substitution [" + parameterNames[i2] + "]: " + parameterValue);
                    this.spooler_task.order().params().set_var(parameterNames[i2], parameterValue);
                }
            }
            return this.getConfiguration();
        }
        catch (Exception e) {
            LOGGER.warn("Monitor: error occurred preparing configuration: " + e.getMessage());
            throw e;
        }
    }

    public void cleanupConfiguration() throws Exception {
        try {
            if (this.orderParameterKeys != null) {
                Variable_set resultParameters = this.spooler.create_variable_set();
                String[] parameterNames = this.spooler_task.order().params().names().split(";");
                for (int i = 0; i < parameterNames.length; ++i) {
                    if (this.orderParameterKeys.contains(parameterNames[i])) continue;
                    resultParameters.set_var(parameterNames[i], this.spooler_task.order().params().value(parameterNames[i]));
                }
                this.spooler_task.order().set_params(resultParameters);
            }
        }
        catch (Exception e) {
            throw new Exception("error occurred in monitor on cleanup: " + e.getMessage());
        }
    }

    public void sendMail(String recipient, String recipientCC, String recipientBCC, String subject, String body) throws Exception {
        try {
            SOSMail sosMail = new SOSMail(this.spooler_log.mail().smtp());
            sosMail.setQueueDir(this.spooler_log.mail().queue_dir());
            sosMail.setFrom(this.spooler_log.mail().from());
            sosMail.setContentType("text/plain");
            sosMail.setEncoding("Base64");
            String[] recipients = recipient.split(",");
            for (int i = 0; i < recipients.length; ++i) {
                if (i == 0) {
                    sosMail.setReplyTo(recipients[i].trim());
                }
                sosMail.addRecipient(recipients[i].trim());
            }
            String[] recipientsCC = recipientCC.split(",");
            for (int i = 0; i < recipientsCC.length; ++i) {
                sosMail.addCC(recipientsCC[i].trim());
            }
            String[] recipientsBCC = recipientBCC.split(",");
            for (int i = 0; i < recipientsBCC.length; ++i) {
                sosMail.addBCC(recipientsBCC[i].trim());
            }
            sosMail.setSubject(subject);
            sosMail.setBody(body);
            LOGGER.info("sending mail: \n" + sosMail.dumpMessageAsString());
            if (!sosMail.send()) {
                LOGGER.warn("mail server is unavailable, mail for recipient [" + recipient + "] is queued in local directory [" + sosMail.getQueueDir() + "]:" + sosMail.getLastError());
            }
            sosMail.clearRecipients();
        }
        catch (Exception e) {
            throw new Exception("error occurred in monitor sending mai: " + e.getMessage());
        }
    }

    public Document getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Document configuration) {
        this.configuration = configuration;
    }

    public String getConfigurationPath() {
        return this.configurationPath;
    }

    public void setConfigurationPath(String configurationPath) {
        this.configurationPath = configurationPath;
    }

    public String getConfigurationFilename() {
        return this.configurationFilename;
    }

    public void setConfigurationFilename(String configurationFilename) {
        this.configurationFilename = configurationFilename;
    }

    private void setEnvVars() throws Exception {
        String OS = System.getProperty("os.name").toLowerCase();
        boolean win = false;
        this.envvars = new TreeMap();
        if (OS.indexOf("nt") > -1 || OS.indexOf("windows") > -1) {
            win = true;
        }
        Variable_set env = this.spooler_task.create_subprocess().env();
        LOGGER.trace("environment variable names: " + env.names());
        StringTokenizer t = new StringTokenizer(env.names(), ";");
        while (t.hasMoreTokens()) {
            String envname = t.nextToken();
            if (envname == null) continue;
            String envvalue = env.value(envname);
            if (win) {
                LOGGER.trace("set environment variable: " + envname.toUpperCase() + "=" + envvalue);
                this.envvars.put(envname.toUpperCase(), envvalue);
                continue;
            }
            LOGGER.trace("set environment variable: " + envname + "=" + envvalue);
            this.envvars.put(envname, envvalue);
        }
    }

    public static String myReplaceAll(String source, String what, String replacement) {
        String newReplacement = replacement.replaceAll("\\$", "\\\\\\$");
        newReplacement = newReplacement.replaceAll("\"", "");
        return source.replaceAll(what, newReplacement);
    }
}

