/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.cryptlib.CryptlibObjectIdentifiers;
import org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.RawAgreement;
import org.bouncycastle.crypto.Wrapper;
import org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.bouncycastle.crypto.agreement.X25519Agreement;
import org.bouncycastle.crypto.agreement.X448Agreement;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.generators.X25519KeyPairGenerator;
import org.bouncycastle.crypto.generators.X448KeyPairGenerator;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.X25519KeyGenerationParameters;
import org.bouncycastle.crypto.params.X25519PublicKeyParameters;
import org.bouncycastle.crypto.params.X448KeyGenerationParameters;
import org.bouncycastle.crypto.params.X448PublicKeyParameters;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.PGPPad;
import org.bouncycastle.openpgp.operator.PublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.RFC6637Utils;
import org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPKeyConverter;
import org.bouncycastle.openpgp.operator.bc.BcUtil;
import org.bouncycastle.openpgp.operator.bc.RFC6637KDFCalculator;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;

public class BcPublicKeyKeyEncryptionMethodGenerator
extends PublicKeyKeyEncryptionMethodGenerator {
    private static final byte X_HDR = 64;
    private SecureRandom random;
    private BcPGPKeyConverter keyConverter = new BcPGPKeyConverter();

    public BcPublicKeyKeyEncryptionMethodGenerator(PGPPublicKey pGPPublicKey) {
        super(pGPPublicKey);
    }

    public BcPublicKeyKeyEncryptionMethodGenerator setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    protected byte[] encryptSessionInfo(PGPPublicKey pGPPublicKey, byte[] byArray) throws PGPException {
        try {
            AsymmetricKeyParameter asymmetricKeyParameter = this.keyConverter.getPublicKey(pGPPublicKey);
            PublicKeyPacket publicKeyPacket = pGPPublicKey.getPublicKeyPacket();
            if (pGPPublicKey.getAlgorithm() == 18) {
                ECDHPublicBCPGKey eCDHPublicBCPGKey = (ECDHPublicBCPGKey)publicKeyPacket.getKey();
                byte[] byArray2 = RFC6637Utils.createUserKeyingMaterial(publicKeyPacket, new BcKeyFingerprintCalculator());
                if (eCDHPublicBCPGKey.getCurveOID().equals((ASN1Primitive)CryptlibObjectIdentifiers.curvey25519)) {
                    AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.getAsymmetricCipherKeyPair((AsymmetricCipherKeyPairGenerator)new X25519KeyPairGenerator(), (KeyGenerationParameters)new X25519KeyGenerationParameters(this.random));
                    byte[] byArray3 = BcUtil.getSecret((RawAgreement)new X25519Agreement(), asymmetricCipherKeyPair.getPrivate(), asymmetricKeyParameter);
                    byte[] byArray4 = new byte[33];
                    byArray4[0] = 64;
                    ((X25519PublicKeyParameters)asymmetricCipherKeyPair.getPublic()).encode(byArray4, 1);
                    return this.encryptSessionInfo(byArray, byArray3, byArray2, byArray4, eCDHPublicBCPGKey.getHashAlgorithm(), eCDHPublicBCPGKey.getSymmetricKeyAlgorithm());
                }
                AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.getAsymmetricCipherKeyPair((AsymmetricCipherKeyPairGenerator)new ECKeyPairGenerator(), (KeyGenerationParameters)new ECKeyGenerationParameters(((ECPublicKeyParameters)asymmetricKeyParameter).getParameters(), this.random));
                ECDHBasicAgreement eCDHBasicAgreement = new ECDHBasicAgreement();
                eCDHBasicAgreement.init((CipherParameters)asymmetricCipherKeyPair.getPrivate());
                BigInteger bigInteger = eCDHBasicAgreement.calculateAgreement((CipherParameters)asymmetricKeyParameter);
                byte[] byArray5 = BigIntegers.asUnsignedByteArray((int)eCDHBasicAgreement.getFieldSize(), (BigInteger)bigInteger);
                byte[] byArray6 = ((ECPublicKeyParameters)asymmetricCipherKeyPair.getPublic()).getQ().getEncoded(false);
                return this.encryptSessionInfo(byArray, byArray5, byArray2, byArray6, eCDHPublicBCPGKey.getHashAlgorithm(), eCDHPublicBCPGKey.getSymmetricKeyAlgorithm());
            }
            if (pGPPublicKey.getAlgorithm() == 25) {
                return this.encryptSessionInfo(publicKeyPacket, byArray, 8, 7, "X25519", (AsymmetricCipherKeyPairGenerator)new X25519KeyPairGenerator(), (KeyGenerationParameters)new X25519KeyGenerationParameters(this.random), (RawAgreement)new X25519Agreement(), asymmetricKeyParameter, 32, new ephPubEncodingOperation(){

                    public void getEphPubEncoding(AsymmetricKeyParameter asymmetricKeyParameter, byte[] byArray) {
                        ((X25519PublicKeyParameters)asymmetricKeyParameter).encode(byArray, 0);
                    }
                });
            }
            if (pGPPublicKey.getAlgorithm() == 26) {
                return this.encryptSessionInfo(publicKeyPacket, byArray, 10, 9, "X448", (AsymmetricCipherKeyPairGenerator)new X448KeyPairGenerator(), (KeyGenerationParameters)new X448KeyGenerationParameters(this.random), (RawAgreement)new X448Agreement(), asymmetricKeyParameter, 56, new ephPubEncodingOperation(){

                    public void getEphPubEncoding(AsymmetricKeyParameter asymmetricKeyParameter, byte[] byArray) {
                        ((X448PublicKeyParameters)asymmetricKeyParameter).encode(byArray, 0);
                    }
                });
            }
            AsymmetricBlockCipher asymmetricBlockCipher = BcImplProvider.createPublicKeyCipher(pGPPublicKey.getAlgorithm());
            asymmetricBlockCipher.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)asymmetricKeyParameter, this.random));
            return asymmetricBlockCipher.processBlock(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            throw new PGPException("exception encrypting session info: " + exception.getMessage(), exception);
        }
    }

    private byte[] encryptSessionInfo(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n, int n2) throws IOException, PGPException {
        RFC6637KDFCalculator rFC6637KDFCalculator = new RFC6637KDFCalculator(new BcPGPDigestCalculatorProvider().get(n), n2);
        KeyParameter keyParameter = new KeyParameter(rFC6637KDFCalculator.createKey(byArray2, byArray3));
        byte[] byArray5 = PGPPad.padSessionData(byArray, this.sessionKeyObfuscation);
        return BcPublicKeyKeyEncryptionMethodGenerator.getSessionInfo(byArray4, this.getWrapper(n2, keyParameter, byArray5));
    }

    private byte[] encryptSessionInfo(PublicKeyPacket publicKeyPacket, byte[] byArray, int n, int n2, String string, AsymmetricCipherKeyPairGenerator asymmetricCipherKeyPairGenerator, KeyGenerationParameters keyGenerationParameters, RawAgreement rawAgreement, AsymmetricKeyParameter asymmetricKeyParameter, int n3, ephPubEncodingOperation ephPubEncodingOperation2) throws PGPException, IOException {
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.getAsymmetricCipherKeyPair(asymmetricCipherKeyPairGenerator, keyGenerationParameters);
        byte[] byArray2 = BcUtil.getSecret(rawAgreement, asymmetricCipherKeyPair.getPrivate(), asymmetricKeyParameter);
        byte[] byArray3 = new byte[n3];
        ephPubEncodingOperation2.getEphPubEncoding(asymmetricCipherKeyPair.getPublic(), byArray3);
        KeyParameter keyParameter = new KeyParameter(RFC6637KDFCalculator.createKey(n, n2, Arrays.concatenate((byte[])byArray3, (byte[])publicKeyPacket.getKey().getEncoded(), (byte[])byArray2), "OpenPGP " + string));
        byte[] byArray4 = new byte[byArray.length - 3];
        System.arraycopy(byArray, 1, byArray4, 0, byArray4.length);
        return BcPublicKeyKeyEncryptionMethodGenerator.getSessionInfo(byArray3, byArray[0], this.getWrapper(n2, keyParameter, byArray4));
    }

    private byte[] getWrapper(int n, KeyParameter keyParameter, byte[] byArray) throws PGPException {
        Wrapper wrapper = BcImplProvider.createWrapper(n);
        wrapper.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)keyParameter, this.random));
        return wrapper.wrap(byArray, 0, byArray.length);
    }

    private AsymmetricCipherKeyPair getAsymmetricCipherKeyPair(AsymmetricCipherKeyPairGenerator asymmetricCipherKeyPairGenerator, KeyGenerationParameters keyGenerationParameters) {
        asymmetricCipherKeyPairGenerator.init(keyGenerationParameters);
        return asymmetricCipherKeyPairGenerator.generateKeyPair();
    }

    @FunctionalInterface
    private static interface ephPubEncodingOperation {
        public void getEphPubEncoding(AsymmetricKeyParameter var1, byte[] var2);
    }
}

