/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.security;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.UUID;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.io.CipherInputStream;
import org.bouncycastle.crypto.io.CipherOutputStream;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.linguafranca.pwdb.security.CipherAlgorithm;
import org.linguafranca.pwdb.security.Encryption;
import org.linguafranca.pwdb.security.KeyDerivationFunction;
import org.linguafranca.pwdb.security.VariantDictionary;

public class Aes
implements CipherAlgorithm,
KeyDerivationFunction {
    private static final UUID KDF = UUID.fromString("C9D9F39A-628A-4460-BF74-0D08C18A4FEA");
    private static final String name = "AES";
    private static final VariantDictionary kdfParameters = new VariantDictionary(1);
    private static final UUID CIPHER;
    private static final Aes instance;

    private Aes() {
    }

    public static Aes getInstance() {
        return instance;
    }

    @Override
    public VariantDictionary createKdfParameters() {
        return kdfParameters.copy();
    }

    @Override
    public UUID getCipherUuid() {
        return CIPHER;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public InputStream getDecryptedInputStream(InputStream encryptedInputStream, byte[] key, byte[] iv) {
        ParametersWithIV keyAndIV = new ParametersWithIV((CipherParameters)new KeyParameter(key), iv);
        PaddedBufferedBlockCipher pbbc = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESEngine()));
        pbbc.init(false, (CipherParameters)keyAndIV);
        return new CipherInputStream(encryptedInputStream, (BufferedBlockCipher)pbbc);
    }

    @Override
    public OutputStream getEncryptedOutputStream(OutputStream decryptedOutputStream, byte[] key, byte[] iv) {
        ParametersWithIV keyAndIV = new ParametersWithIV((CipherParameters)new KeyParameter(key), iv);
        PaddedBufferedBlockCipher pbbc = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESEngine()));
        pbbc.init(true, (CipherParameters)keyAndIV);
        return new CipherOutputStream(decryptedOutputStream, (BufferedBlockCipher)pbbc);
    }

    @Override
    public UUID getKdfUuid() {
        return KDF;
    }

    @Override
    public byte[] getTransformedKey(byte[] key, VariantDictionary transformParams) {
        return Aes.getTransformedKey(key, transformParams.mustGet("S").asByteArray(), transformParams.mustGet("R").asLong());
    }

    public static byte[] getTransformedKey(byte[] key, byte[] transformSeed, long transformRounds) {
        AESEngine engine = new AESEngine();
        engine.init(true, (CipherParameters)new KeyParameter(transformSeed));
        byte[] transformedKey = new byte[key.length];
        System.arraycopy(key, 0, transformedKey, 0, transformedKey.length);
        for (long rounds = 0L; rounds < transformRounds; ++rounds) {
            engine.processBlock(transformedKey, 0, transformedKey, 0);
            engine.processBlock(transformedKey, 16, transformedKey, 16);
        }
        MessageDigest md = Encryption.getSha256MessageDigestInstance();
        return md.digest(transformedKey);
    }

    static {
        kdfParameters.putUuid("$UUID", KDF);
        kdfParameters.putULong("R", 6000L);
        kdfParameters.putByteArray("S", SecureRandom.getSeed(32));
        CIPHER = UUID.fromString("31C1F2E6-BF71-4350-BE58-05216AFC5AFF");
        instance = new Aes();
    }

    public static class KdfKeys {
        public static final String ParamRounds = "R";
        public static final String ParamSeed = "S";
    }
}

