/*
 * Decompiled with CFR 0.152.
 */
package sos.marshalling;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.xerces.parsers.SAXParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import sos.connection.SOSConnection;
import sos.connection.SOSMySQLConnection;
import sos.marshalling.SOSImExportTableFieldTypes;

public class SOSImport
extends DefaultHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSImport.class);
    private SOSConnection connection = null;
    private boolean autoCommit = false;
    private boolean enableInsert = true;
    private boolean enableUpdate = true;
    private String fileName = null;
    private boolean restrictMode = true;
    private String packageId = null;
    private String packageElement = null;
    private String packageValue = null;
    private String xmlTagname = "sos_export";
    private String xmlEncoding = "iso-8859-1";
    private String normalizeFieldName = "strtoupper";
    private boolean autoNormalizeField = true;
    private boolean autoChecked = false;
    private HashMap restrictObject = new HashMap();
    private HashMap keyHandler = new HashMap();
    private HashMap recordHandler = new HashMap();
    private Tables tables = new Tables();
    private MetaRecords metaKeyRecords = new MetaRecords();
    private MetaRecords metaFieldRecords = new MetaRecords();
    private Records records = new Records();
    private int recordIndex = -1;
    private HashMap recordIdentifier = new HashMap();
    private boolean curExportOpen = false;
    private boolean curPackageOpened = false;
    private String curPackageId = null;
    private boolean curMetaOpened = false;
    private String curMetaTableName = null;
    private boolean curMetaKeysOpened = false;
    private boolean curMetaFieldsOpened = false;
    private boolean curDataOpened = false;
    private boolean curDataRecordOpened = false;
    private String curDataRecordName = null;
    private boolean curDataFieldsOpened = false;
    private boolean curDataFieldOpened = false;
    private String curDataFieldName = null;
    private StringBuilder curDataFieldData = null;
    private boolean curDataFieldNull = false;
    private String curElement = null;
    private int curImportPackage = 1;
    private int curImportPackageDepth = 0;
    private int curBlockedPackageDepth = 0;
    private int curPackageDepth = 0;
    private String operation = null;
    private HashMap mappingTablenames = null;

    public SOSImport(SOSConnection conn, String fileName, String packageId, String packageElement, String packageValue) {
        if (conn != null) {
            this.connection = conn;
        }
        if (fileName != null) {
            this.fileName = fileName;
        }
        if (packageId != null) {
            this.packageId = packageId;
        }
        if (packageElement != null) {
            this.packageElement = packageElement;
        }
        if (packageValue != null) {
            this.packageValue = packageValue;
        }
    }

    public SOSImport(SOSConnection conn, String fileName) {
        this(conn, fileName, null, null, null);
    }

    public SOSImport() {
        this(null, null, null, null, null);
    }

    public void setConnection(SOSConnection conn) {
        this.connection = conn;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public void setUpdate(boolean update) {
        this.enableUpdate = update;
    }

    public void setInsert(boolean insert) {
        this.enableInsert = insert;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setRestrictMode(boolean restrictMode) {
        this.restrictMode = restrictMode;
    }

    public void setPackageId(String packageId) {
        this.packageId = packageId;
    }

    public void setPackageValue(String packageValue) {
        this.packageValue = packageValue;
    }

    public void setPackageElement(String packageElement) {
        this.packageElement = packageElement;
    }

    public void setXMLTagname(String xmlTagname) {
        this.xmlTagname = xmlTagname;
    }

    public void setXMLEncoding(String xmlEncoding) {
        this.xmlEncoding = xmlEncoding;
    }

    public void setNormalizeFieldName(String normalizeFieldName) throws Exception {
        if (!"strtolower".equalsIgnoreCase(normalizeFieldName) && !"strtoupper".equalsIgnoreCase(normalizeFieldName)) {
            throw new IllegalArgumentException("SOSExport.setNormalizeFieldName: normalizeFielName must be \"strtolower\" or \"strtoupper\"");
        }
        try {
            this.normalizeFieldName = normalizeFieldName;
            this.connection.setFieldNameToUpperCase("strtoupper".equalsIgnoreCase(normalizeFieldName));
            if ("strtoupper".equalsIgnoreCase(normalizeFieldName)) {
                this.connection.setKeysToUpperCase();
            } else {
                this.connection.setKeysToLowerCase();
            }
        }
        catch (Exception e) {
            throw new Exception("SOSImport.setNormalizeFieldName: " + e.getMessage());
        }
    }

    public void setAutoNormalizeField(boolean auto) {
        this.autoNormalizeField = auto;
    }

    @Override
    public void startDocument() throws SAXException {
        this.autoChecked = false;
        try {
            LOGGER.debug("Starte Import...");
        }
        catch (Exception e) {
            throw new SAXException("SOSImport.startDocument: " + e.getMessage(), e);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.autoChecked = false;
        try {
            LOGGER.debug("...beende Import");
        }
        catch (Exception e) {
            throw new SAXException("SOSImport.endDocument: " + e.getMessage(), e);
        }
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) throws SAXException {
        this.curElement = name;
        try {
            LOGGER.trace("import startElement: " + name);
            if (name.equalsIgnoreCase(this.xmlTagname)) {
                this.curExportOpen = true;
            } else if (name.equalsIgnoreCase(this.xmlTagname + "_package") && this.curExportOpen) {
                this.curPackageOpened = true;
                this.curPackageId = atts.getValue("id");
            } else if (name.equalsIgnoreCase(this.xmlTagname + "_meta") && this.curPackageOpened) {
                this.metaKeyRecords.add(this.curPackageId);
                this.metaFieldRecords.add(this.curPackageId);
                this.curMetaOpened = true;
            } else if ("table".equalsIgnoreCase(name) && this.curMetaOpened) {
                this.curMetaTableName = atts.getValue("name");
                if (this.mappingTablenames != null && this.mappingTablenames.get(this.curMetaTableName) != null && !this.mappingTablenames.get(this.curMetaTableName).toString().isEmpty()) {
                    LOGGER.debug("import tablename " + this.curMetaTableName + " is mapping in " + this.mappingTablenames.get(this.curMetaTableName));
                    this.curMetaTableName = this.mappingTablenames.get(this.curMetaTableName).toString();
                }
                this.metaKeyRecords.get(this.curPackageId).setTable(this.curMetaTableName);
                this.metaFieldRecords.get(this.curPackageId).setTable(this.curMetaTableName);
            } else if ("key_fields".equalsIgnoreCase(name) && this.curMetaOpened) {
                this.curMetaKeysOpened = true;
            } else if ("field".equalsIgnoreCase(name) && this.curMetaKeysOpened) {
                LOGGER.trace("add keyfield: name = " + this.normalizeFieldName(atts.getValue("name")) + " type = " + atts.getValue("type") + " typeID = " + atts.getValue("typeID") + " len = " + atts.getValue("len") + " scale = " + atts.getValue("scale"));
                String field = atts.getValue("name");
                if (this.autoNormalizeField && !this.autoChecked) {
                    this.autoNormalize(field);
                    this.autoChecked = true;
                }
                this.metaKeyRecords.get(this.curPackageId).addField(this.normalizeFieldName(field), atts.getValue("type"), new Integer(atts.getValue("typeID")), new BigInteger(atts.getValue("len")), new Integer(atts.getValue("scale")));
            } else if ("fields".equalsIgnoreCase(name) && this.curMetaOpened) {
                this.curMetaFieldsOpened = true;
            } else if ("field".equalsIgnoreCase(name) && this.curMetaFieldsOpened) {
                LOGGER.trace("add field: name = " + this.normalizeFieldName(atts.getValue("name")) + " type = " + atts.getValue("type") + " typeID = " + atts.getValue("typeID") + " len = " + atts.getValue("len") + " scale = " + atts.getValue("scale"));
                String field = atts.getValue("name");
                if (this.autoNormalizeField && !this.autoChecked) {
                    this.autoNormalize(field);
                    this.autoChecked = true;
                }
                this.metaFieldRecords.get(this.curPackageId).addField(this.normalizeFieldName(field), atts.getValue("type"), new Integer(atts.getValue("typeID")), new BigInteger(atts.getValue("len")), new Integer(atts.getValue("scale")));
            } else if (name.equalsIgnoreCase(this.xmlTagname + "_data") && this.curPackageOpened && !this.curMetaOpened) {
                this.curDataOpened = true;
            } else if (name.equalsIgnoreCase(this.xmlTagname + "_record")) {
                this.curDataRecordOpened = true;
                this.curDataRecordName = atts.getValue("name");
                ++this.curPackageDepth;
            } else if (name.equalsIgnoreCase(this.xmlTagname + "_fields") && this.curDataRecordOpened) {
                this.curDataFieldsOpened = true;
                if (this.curBlockedPackageDepth <= 0 || this.curBlockedPackageDepth > this.curPackageDepth) {
                    this.recordIndex = this.records.addRecord();
                }
                if (atts.getValue("operation") != null && !atts.getValue("operation").isEmpty()) {
                    this.operation = atts.getValue("operation");
                }
            } else if (this.curDataFieldsOpened) {
                this.curDataFieldOpened = true;
                this.curDataFieldName = this.normalizeFieldName(name);
                this.curDataFieldData = new StringBuilder();
                this.curDataFieldNull = atts.getValue("null") != null && "true".equalsIgnoreCase(atts.getValue("null"));
                this.records.addValue(this.recordIndex, this.curDataFieldName, this.curDataFieldData.toString());
            }
        }
        catch (Exception e) {
            throw new SAXException("SOSImport.startElement: " + e.getMessage(), e);
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) throws SAXException {
        try {
            LOGGER.trace("import endElement: " + name);
            if (name.equalsIgnoreCase(this.xmlTagname)) {
                this.curExportOpen = false;
            } else if (name.equalsIgnoreCase(this.xmlTagname + "_package")) {
                this.curPackageOpened = false;
            } else if (name.equalsIgnoreCase(this.xmlTagname + "_meta")) {
                this.curMetaOpened = false;
            } else if ("key_fields".equalsIgnoreCase(name)) {
                this.curMetaKeysOpened = false;
            } else if ("fields".equalsIgnoreCase(name)) {
                this.curMetaFieldsOpened = false;
            } else if (name.equalsIgnoreCase(this.xmlTagname + "_data")) {
                this.curDataOpened = false;
            } else if (name.equalsIgnoreCase(this.xmlTagname + "_record")) {
                this.curDataRecordOpened = false;
                if (this.packageId != null && this.curPackageDepth == this.curImportPackageDepth) {
                    this.curImportPackage = 0;
                }
                if (this.curBlockedPackageDepth == this.curPackageDepth) {
                    this.curBlockedPackageDepth = 0;
                }
                --this.curPackageDepth;
            } else if (name.equalsIgnoreCase(this.xmlTagname + "_fields")) {
                this.curDataFieldsOpened = false;
                if (this.curImportPackage == 1 && (this.curBlockedPackageDepth == 0 || this.curPackageDepth == 0)) {
                    if (this.operation != null && "insert".equals(this.operation)) {
                        this.importRecord(this.curDataRecordName, this.recordIndex, this.operation);
                    } else if (this.operation != null && "update".equals(this.operation)) {
                        this.importRecord(this.curDataRecordName, this.recordIndex, this.operation);
                    } else if (this.operation != null && "delete".equals(this.operation)) {
                        this.deleteRecord(this.curDataRecordName, this.recordIndex);
                    } else {
                        this.importRecord(this.curDataRecordName, this.recordIndex);
                    }
                    this.operation = null;
                }
            } else if (this.curDataFieldOpened) {
                if (this.curDataFieldNull) {
                    this.records.addValue(this.recordIndex, this.curDataFieldName, null);
                } else {
                    this.records.addValue(this.recordIndex, this.curDataFieldName, this.curDataFieldData.toString());
                }
                if (this.curImportPackage <= 0 && this.curDataRecordName.equalsIgnoreCase(this.packageId) && this.curElement.equalsIgnoreCase(this.packageElement) && this.curDataFieldData.toString().equalsIgnoreCase(this.packageValue)) {
                    this.curImportPackage = 1;
                    this.curImportPackageDepth = this.curPackageDepth;
                }
                this.curDataFieldOpened = false;
                this.curDataFieldName = null;
                this.curDataFieldData = null;
            }
        }
        catch (Exception e) {
            throw new SAXException("SOSImport.endElement: " + e.getMessage(), e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String str;
        if (this.curDataFieldOpened && !"".equals(str = new String(ch, start, length))) {
            this.curDataFieldData.append(str);
        }
    }

    public void setTable(String table, boolean replace, HashMap restrict) throws Exception {
        try {
            if (table == null || "".equals(table)) {
                throw new IllegalArgumentException("SOSImport.setTable: you have to give a table name");
            }
            LOGGER.debug("setTable: table=" + table + " replace=" + replace);
            this.tables.addTable(table, replace, restrict);
        }
        catch (Exception e) {
            throw new Exception("SOSImport.setTable: " + e.getMessage(), e);
        }
    }

    public void setHandler(String table, String keyHandler, String recordHandler, String recordIdentifier) {
        if (table == null || "".equals(table)) {
            throw new IllegalArgumentException("SOSImport.setHandler: you have to give a table name");
        }
        if (keyHandler != null && !"".equals(keyHandler)) {
            this.keyHandler.put(table.toLowerCase(), keyHandler);
        }
        if (recordHandler != null && !"".equals(recordHandler)) {
            this.recordHandler.put(table.toLowerCase(), recordHandler);
        }
        if (recordIdentifier != null && !"".equals(recordIdentifier)) {
            this.recordIdentifier.put(table.toLowerCase(), recordIdentifier);
        }
    }

    public void doImport() throws Exception, SAXException, FileNotFoundException {
        try {
            if ("strtoupper".equalsIgnoreCase(this.normalizeFieldName)) {
                this.connection.setKeysToUpperCase();
                this.connection.setFieldNameToUpperCase(true);
            } else {
                this.connection.setKeysToLowerCase();
                this.connection.setFieldNameToUpperCase(false);
            }
            SAXParser parser = new SAXParser();
            parser.setContentHandler((ContentHandler)this);
            File file = new File(this.fileName);
            if (!file.canRead()) {
                throw new FileNotFoundException("File not found: " + this.fileName);
            }
            LOGGER.debug("Using file: " + this.fileName);
            parser.parse(this.fileName);
        }
        catch (SAXException e) {
            throw new SAXException("SOSImport.doImport: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new Exception("SOSImport.doImport: " + e.getMessage(), e);
        }
    }

    public void doImport(SOSConnection conn, String fileName) throws Exception, SAXException, FileNotFoundException {
        try {
            if (conn != null) {
                this.connection = conn;
            }
            if (fileName != null) {
                this.fileName = fileName;
            }
            if (this.packageId != null) {
                this.curImportPackage = 0;
            }
            this.doImport();
        }
        catch (SAXException e) {
            throw new SAXException("SOSImport.doImport: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new Exception("SOSImport.doImport: " + e.getMessage(), e);
        }
    }

    public void doImport(SOSConnection conn, String fileName, String packageId, String packageElement, String packageValue) throws Exception, SAXException, FileNotFoundException {
        try {
            if (conn != null) {
                this.connection = conn;
            }
            if (fileName != null) {
                this.fileName = fileName;
            }
            if (packageId != null) {
                this.packageId = packageId;
            }
            if (packageElement != null) {
                this.packageElement = packageElement;
            }
            if (packageValue != null) {
                this.packageValue = packageValue;
            }
            if (packageId != null) {
                this.curImportPackage = 0;
            }
            this.doImport();
        }
        catch (SAXException e) {
            throw new SAXException("SOSImport.doImport: " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new Exception("SOSImport.doImport: " + e.getMessage(), e);
        }
    }

    private void importRecord(String name, int index, String operation) throws Exception {
        boolean isNewKey = false;
        try {
            String key;
            Iterator it;
            LOGGER.debug("import_record(" + name + ", " + index + "): key_fields=" + this.normalizeFieldName(this.metaKeyRecords.get(name).getKeyString() + " table=" + this.metaKeyRecords.get(name).getTable()));
            if (this.connection == null) {
                throw new Exception("No aktive database connection!");
            }
            boolean restrictMode = this.restrictMode;
            HashMap restrictObject = this.restrictObject;
            if (!this.tables.isEmpty()) {
                boolean found = false;
                it = this.tables.getIterator();
                while (it.hasNext()) {
                    key = it.next().toString();
                    if (!name.equalsIgnoreCase(key)) continue;
                    found = true;
                    restrictMode = this.tables.getReplace(key);
                    restrictObject = this.tables.getRestrict(key);
                    break;
                }
                if (!found) {
                    LOGGER.debug("Import denied for table by restriction: " + name);
                    return;
                }
            }
            if (restrictObject != null && !restrictObject.isEmpty()) {
                Iterator it2 = restrictObject.keySet().iterator();
                while (it2.hasNext()) {
                    String restrictName = it2.next().toString();
                    String restrictValue = (String)restrictObject.get(restrictName);
                    LOGGER.debug("checking for element: " + restrictName + "=" + restrictValue);
                    if (this.records.getValue(index, restrictName) == null) {
                        this.curBlockedPackageDepth = this.curPackageDepth;
                        LOGGER.debug("import denied for element by restriction at depth " + this.curBlockedPackageDepth + ": " + restrictName + " not in record");
                        return;
                    }
                    if (this.records.getValue(index, restrictName) == null || !restrictValue.equalsIgnoreCase(this.records.getValue(index, restrictName))) continue;
                    this.curBlockedPackageDepth = this.curPackageDepth;
                    LOGGER.debug("import denied for element by restriction at depth " + this.curBlockedPackageDepth + ": " + restrictName + ": " + restrictValue + " != " + this.records.getValue(index, restrictName));
                    return;
                }
                restrictObject = null;
            }
            HashMap keys = new HashMap();
            it = this.metaKeyRecords.get(name).getIterator();
            while (it.hasNext()) {
                key = it.next().toString();
                LOGGER.debug("key_fields key [" + key + "] = " + this.records.getValue(index, key));
                keys.put(this.normalizeFieldName(key), this.records.getValue(index, key));
            }
            String keyHandler = this.metaKeyRecords.get(name).getTable().toLowerCase();
            if (this.keyHandler.containsKey(keyHandler)) {
                LOGGER.debug("key_handler: " + (String)this.keyHandler.get(keyHandler));
                Class[] params = new Class[]{HashMap.class};
                Method method = this.getClass().getMethod((String)this.keyHandler.get(keyHandler), params);
                Object[] args = new HashMap[]{keys};
                keys = (HashMap)method.invoke((Object)this, args);
            }
            Map<String, String> record = null;
            boolean isNew = false;
            if (operation != null && "insert".equalsIgnoreCase(operation)) {
                isNew = true;
            } else if (operation != null && "update".equalsIgnoreCase(operation)) {
                isNew = false;
            } else {
                if (keys != null && !keys.isEmpty() && restrictMode) {
                    StringBuilder stm = new StringBuilder();
                    stm.append("SELECT * FROM " + this.metaFieldRecords.get(name).getTable());
                    String and = " WHERE ";
                    Iterator it3 = keys.keySet().iterator();
                    while (it3.hasNext()) {
                        String key2 = it3.next().toString();
                        stm.append(and + "\"" + this.normalizeFieldName(key2) + "\"=" + this.quote(name, key2, (String)keys.get(key2)));
                        and = " AND ";
                    }
                    record = this.connection.getSingle(stm.toString());
                }
                isNew = record == null || record.isEmpty();
            }
            LOGGER.debug("is_new: " + isNew);
            record = new HashMap();
            Iterator it4 = this.records.getIterator(index);
            while (it4.hasNext()) {
                String key3 = it4.next().toString();
                String val = this.records.getValue(index, key3);
                if (val != null) {
                    LOGGER.trace("record[" + key3 + "] = " + (val.length() > 255 ? "(" + val.length() + " Chars)" : val));
                } else {
                    LOGGER.trace("record[" + key3 + "] = NULL");
                }
                record.put(key3, this.fromXML(val));
            }
            String recordHandler = this.metaFieldRecords.get(name).getTable().toLowerCase();
            if (this.recordHandler.containsKey(recordHandler)) {
                String key4;
                String recordIdentifier = this.recordIdentifier.containsKey(recordHandler) ? (String)this.recordIdentifier.get(recordHandler) : null;
                LOGGER.debug("recordHandler: " + (String)this.recordHandler.get(recordHandler));
                Class[] params = new Class[]{HashMap.class, HashMap.class, String.class};
                Method method = this.getClass().getMethod((String)this.recordHandler.get(recordHandler), params);
                Object[] args = new Object[]{keys, record, recordIdentifier};
                record = (HashMap)method.invoke((Object)this, args);
                HashMap<String, String> recordKeys = new HashMap<String, String>();
                Iterator it5 = this.metaKeyRecords.get(name).getIterator();
                while (it5.hasNext()) {
                    key4 = it5.next().toString();
                    recordKeys.put(this.normalizeFieldName(key4), this.records.getValue(index, key4));
                }
                if (record != null && !record.isEmpty()) {
                    it5 = this.metaKeyRecords.get(name).getIterator();
                    while (it5.hasNext()) {
                        key4 = this.normalizeFieldName(it5.next().toString());
                        if (recordKeys.get(key4) == record.get(key4)) continue;
                        isNew = true;
                        isNewKey = true;
                        break;
                    }
                    if (record.containsKey("SOS_EXPORT_IS_NEW")) {
                        isNew = new Boolean(record.get("SOS_EXPORT_IS_NEW"));
                        isNewKey = true;
                        record.remove("SOS_EXPORT_IS_NEW");
                    }
                }
            }
            if (record != null && !record.isEmpty()) {
                if (this.keyHandler.containsKey(keyHandler)) {
                    String key5;
                    Iterator it6;
                    if (isNewKey) {
                        it6 = this.metaKeyRecords.get(name).getIterator();
                        while (it6.hasNext()) {
                            key5 = this.normalizeFieldName(it6.next().toString());
                            LOGGER.debug("updating key_fields key[" + key5 + "] = " + record.get(key5));
                            keys.put(key5, record.get(key5));
                        }
                    } else {
                        it6 = this.metaKeyRecords.get(name).getIterator();
                        while (it6.hasNext()) {
                            key5 = this.normalizeFieldName(it6.next().toString());
                            LOGGER.debug("updating key_fields record[" + key5 + "] = " + record.get(key5));
                            record.put(key5, (String)keys.get(key5));
                        }
                    }
                }
                Map<String, List<Object>> blobs = this.getBlobs(name, record);
                if (isNew) {
                    if (!this.enableInsert) {
                        LOGGER.debug("record skipped: no insert enabled");
                    } else {
                        this.insertRecord(name, record);
                    }
                } else if (!this.enableUpdate) {
                    LOGGER.debug("record skipped: no update enabled");
                } else {
                    this.updateRecord(name, keys, record);
                }
                this.updateBlob(name, blobs, keys, record);
            } else {
                LOGGER.debug("record skipped");
            }
            if (this.autoCommit) {
                this.connection.commit();
            }
        }
        catch (Exception e) {
            if (this.autoCommit) {
                this.connection.rollback();
            }
            LOGGER.error(e.toString(), (Throwable)e);
            throw new Exception("SOSImport.import_record: " + e.toString(), e);
        }
    }

    private void deleteRecord(String name, int index) throws Exception {
        try {
            String key;
            Iterator it;
            LOGGER.debug("delete_record(" + name + ", " + index + "): key_fields=" + this.normalizeFieldName(this.metaKeyRecords.get(name).getKeyString() + " table=" + this.metaKeyRecords.get(name).getTable()));
            if (this.connection == null) {
                throw new Exception("No aktive database connection!");
            }
            boolean restrictMode = this.restrictMode;
            HashMap restrictObject = this.restrictObject;
            if (!this.tables.isEmpty()) {
                boolean found = false;
                it = this.tables.getIterator();
                while (it.hasNext()) {
                    key = it.next().toString();
                    if (!name.equalsIgnoreCase(key)) continue;
                    found = true;
                    restrictMode = this.tables.getReplace(key);
                    restrictObject = this.tables.getRestrict(key);
                    break;
                }
                if (!found) {
                    LOGGER.debug("Import denied for table by restriction: " + name);
                    return;
                }
            }
            if (restrictObject != null && !restrictObject.isEmpty()) {
                Iterator it2 = restrictObject.keySet().iterator();
                while (it2.hasNext()) {
                    String restrictName = it2.next().toString();
                    String restrictValue = (String)restrictObject.get(restrictName);
                    LOGGER.debug("checking for element: " + restrictName + "=" + restrictValue);
                    if (this.records.getValue(index, restrictName) == null) {
                        this.curBlockedPackageDepth = this.curPackageDepth;
                        LOGGER.debug("import denied for element by restriction at depth " + this.curBlockedPackageDepth + ": " + restrictName + " not in record");
                        return;
                    }
                    if (this.records.getValue(index, restrictName) == null || !restrictValue.equalsIgnoreCase(this.records.getValue(index, restrictName))) continue;
                    this.curBlockedPackageDepth = this.curPackageDepth;
                    LOGGER.debug("import denied for element by restriction at depth " + this.curBlockedPackageDepth + ": " + restrictName + ": " + restrictValue + " != " + this.records.getValue(index, restrictName));
                    return;
                }
                restrictObject = null;
            }
            HashMap keys = new HashMap();
            it = this.metaKeyRecords.get(name).getIterator();
            while (it.hasNext()) {
                key = it.next().toString();
                LOGGER.debug("key_fields key [" + key + "] = " + this.records.getValue(index, key));
                keys.put(this.normalizeFieldName(key), this.records.getValue(index, key));
            }
            String keyHandler = this.metaKeyRecords.get(name).getTable().toLowerCase();
            if (this.keyHandler.containsKey(keyHandler)) {
                LOGGER.debug("key_handler: " + (String)this.keyHandler.get(keyHandler));
                Class[] params = new Class[]{HashMap.class};
                Method method = this.getClass().getMethod((String)this.keyHandler.get(keyHandler), params);
                Object[] args = new HashMap[]{keys};
                keys = (HashMap)method.invoke((Object)this, args);
            }
            this.deleteRecord(name, keys);
            if (this.autoCommit) {
                this.connection.commit();
            }
        }
        catch (Exception e) {
            if (this.autoCommit) {
                this.connection.rollback();
            }
            LOGGER.error(e.toString(), (Throwable)e);
            throw new Exception("SOSImport.import_record: " + e.toString(), e);
        }
    }

    private void importRecord(String name, int index) throws Exception {
        boolean isNewKey = false;
        try {
            String key;
            Iterator it;
            String key2;
            Iterator it2;
            LOGGER.debug("import_record(" + name + ", " + index + "): key_fields=" + this.normalizeFieldName(this.metaKeyRecords.get(name).getKeyString() + " table=" + this.metaKeyRecords.get(name).getTable()));
            if (this.connection == null) {
                throw new Exception("No aktive database connection!");
            }
            boolean restrictMode = this.restrictMode;
            HashMap restrictObject = this.restrictObject;
            if (!this.tables.isEmpty()) {
                boolean found = false;
                it2 = this.tables.getIterator();
                while (it2.hasNext()) {
                    key2 = it2.next().toString();
                    if (!name.equalsIgnoreCase(key2)) continue;
                    found = true;
                    restrictMode = this.tables.getReplace(key2);
                    restrictObject = this.tables.getRestrict(key2);
                    break;
                }
                if (!found) {
                    LOGGER.debug("Import denied for table by restriction: " + name);
                    return;
                }
            }
            if (restrictObject != null && !restrictObject.isEmpty()) {
                Iterator it3 = restrictObject.keySet().iterator();
                while (it3.hasNext()) {
                    String restrictName = it3.next().toString();
                    String restrictValue = (String)restrictObject.get(restrictName);
                    LOGGER.debug("checking for element: " + restrictName + "=" + restrictValue);
                    if (this.records.getValue(index, restrictName) == null) {
                        this.curBlockedPackageDepth = this.curPackageDepth;
                        LOGGER.debug("import denied for element by restriction at depth " + this.curBlockedPackageDepth + ": " + restrictName + " not in record");
                        return;
                    }
                    if (this.records.getValue(index, restrictName) == null || !restrictValue.equalsIgnoreCase(this.records.getValue(index, restrictName))) continue;
                    this.curBlockedPackageDepth = this.curPackageDepth;
                    LOGGER.debug("import denied for element by restriction at depth " + this.curBlockedPackageDepth + ": " + restrictName + ": " + restrictValue + " != " + this.records.getValue(index, restrictName));
                    return;
                }
                restrictObject = null;
            }
            HashMap keys = new HashMap();
            it2 = this.metaKeyRecords.get(name).getIterator();
            while (it2.hasNext()) {
                key2 = it2.next().toString();
                LOGGER.debug("key_fields key [" + key2 + "] = " + this.records.getValue(index, key2));
                keys.put(this.normalizeFieldName(key2), this.records.getValue(index, key2));
            }
            String keyHandler = this.metaKeyRecords.get(name).getTable().toLowerCase();
            if (this.keyHandler.containsKey(keyHandler)) {
                LOGGER.debug("key_handler: " + (String)this.keyHandler.get(keyHandler));
                Class[] params = new Class[]{HashMap.class};
                Method method = this.getClass().getMethod((String)this.keyHandler.get(keyHandler), params);
                Object[] args = new HashMap[]{keys};
                keys = (HashMap)method.invoke((Object)this, args);
            }
            Map<String, String> record = null;
            if (keys != null && !keys.isEmpty() && restrictMode) {
                StringBuilder stm = new StringBuilder();
                stm.append("SELECT * FROM " + this.metaFieldRecords.get(name).getTable());
                String and = " WHERE ";
                it = keys.keySet().iterator();
                while (it.hasNext()) {
                    key = it.next().toString();
                    stm.append(and + "\"" + this.normalizeFieldName(key) + "\"=" + this.quote(name, key, (String)keys.get(key)));
                    and = " AND ";
                }
                record = this.connection.getSingle(stm.toString());
            }
            boolean isNew = record == null || record.isEmpty();
            LOGGER.debug("is_new: " + isNew);
            record = new HashMap();
            Iterator it4 = this.records.getIterator(index);
            while (it4.hasNext()) {
                String key3 = it4.next().toString();
                String val = this.records.getValue(index, key3);
                if (val != null) {
                    LOGGER.trace("record[" + key3 + "] = " + (val.length() > 255 ? "(" + val.length() + " Chars)" : val));
                } else {
                    LOGGER.trace("record[" + key3 + "] = NULL");
                }
                record.put(key3, this.fromXML(val));
            }
            String recordHandler = this.metaFieldRecords.get(name).getTable().toLowerCase();
            if (this.recordHandler.containsKey(recordHandler)) {
                String key4;
                String recordIdentifier = this.recordIdentifier.containsKey(recordHandler) ? (String)this.recordIdentifier.get(recordHandler) : null;
                LOGGER.debug("recordHandler: " + (String)this.recordHandler.get(recordHandler));
                Class[] params = new Class[]{HashMap.class, HashMap.class, String.class};
                Method method = this.getClass().getMethod((String)this.recordHandler.get(recordHandler), params);
                Object[] args = new Object[]{keys, record, recordIdentifier};
                record = (HashMap)method.invoke((Object)this, args);
                HashMap<String, String> recordKeys = new HashMap<String, String>();
                Iterator it5 = this.metaKeyRecords.get(name).getIterator();
                while (it5.hasNext()) {
                    key4 = it5.next().toString();
                    recordKeys.put(this.normalizeFieldName(key4), this.records.getValue(index, key4));
                }
                if (record != null && !record.isEmpty()) {
                    it5 = this.metaKeyRecords.get(name).getIterator();
                    while (it5.hasNext()) {
                        key4 = this.normalizeFieldName(it5.next().toString());
                        if (recordKeys.get(key4) == record.get(key4)) continue;
                        isNew = true;
                        isNewKey = true;
                        break;
                    }
                    if (record.containsKey("SOS_EXPORT_IS_NEW")) {
                        isNew = new Boolean(record.get("SOS_EXPORT_IS_NEW"));
                        isNewKey = true;
                        record.remove("SOS_EXPORT_IS_NEW");
                    }
                }
            }
            if (record != null && !record.isEmpty()) {
                if (this.keyHandler.containsKey(keyHandler)) {
                    if (isNewKey) {
                        it = this.metaKeyRecords.get(name).getIterator();
                        while (it.hasNext()) {
                            key = this.normalizeFieldName(it.next().toString());
                            LOGGER.debug("updating key_fields key[" + key + "] = " + record.get(key));
                            keys.put(key, record.get(key));
                        }
                    } else {
                        it = this.metaKeyRecords.get(name).getIterator();
                        while (it.hasNext()) {
                            key = this.normalizeFieldName(it.next().toString());
                            LOGGER.debug("updating key_fields record[" + key + "] = " + record.get(key));
                            record.put(key, (String)keys.get(key));
                        }
                    }
                }
                Map<String, List<Object>> blobs = this.getBlobs(name, record);
                if (isNew) {
                    if (!this.enableInsert) {
                        LOGGER.debug("record skipped: no insert enabled");
                    } else {
                        this.insertRecord(name, record);
                    }
                } else if (!this.enableUpdate) {
                    LOGGER.debug("record skipped: no update enabled");
                } else {
                    this.updateRecord(name, keys, record);
                }
                this.updateBlob(name, blobs, keys, record);
            } else {
                LOGGER.debug("record skipped");
            }
            if (this.autoCommit) {
                this.connection.commit();
            }
        }
        catch (Exception e) {
            if (this.autoCommit) {
                this.connection.rollback();
            }
            LOGGER.error(e.toString(), (Throwable)e);
            throw new Exception("SOSImport.import_record: " + e.toString(), e);
        }
    }

    private Map<String, List<Object>> getBlobs(String name, Map<String, String> record) throws Exception {
        try {
            HashMap<String, List<Object>> blobs = new HashMap<String, List<Object>>();
            for (String key : record.keySet()) {
                String xmlVal = record.get(key);
                byte[] val = SOSImport.fromHexString(xmlVal);
                String blobType = null;
                ArrayList<Object> obj = new ArrayList<Object>(2);
                switch (this.metaFieldRecords.get(name).getTypeId(key)) {
                    case -1: 
                    case 2005: {
                        blobType = "clob";
                        if (val != null && val.length > 0) {
                            obj.add(new String(val));
                            break;
                        }
                        obj.add(null);
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: 
                    case 2004: {
                        blobType = "blob";
                        if (val != null && val.length > 0) {
                            obj.add(val);
                            break;
                        }
                        obj.add(null);
                    }
                }
                LOGGER.debug("found " + blobType + ": name = " + key + " type = " + this.metaFieldRecords.get(name).getTypeName(key) + " typeID = " + this.metaFieldRecords.get(name).getTypeId(key));
                obj.add(blobType);
                blobs.put(key, obj);
                record.put(key, null);
            }
            return blobs;
        }
        catch (Exception e) {
            throw new Exception("SOSImport.getBlobs: " + e.getMessage(), e);
        }
    }

    private void updateBlob(String name, Map<String, List<Object>> blobs, HashMap keys, Map<String, String> record) throws Exception {
        try {
            for (String blobName : blobs.keySet()) {
                List<Object> blobValue = blobs.get(blobName);
                LOGGER.debug("update " + (String)blobValue.get(0) + ": " + blobName);
                StringBuilder stm = new StringBuilder();
                String and = "";
                Iterator it2 = keys.keySet().iterator();
                while (it2.hasNext()) {
                    String key = it2.next().toString();
                    if (!record.containsKey(key)) {
                        throw new Exception("SOSImport.import_record: missing key in record: " + key);
                    }
                    stm.append(and + " \"" + this.normalizeFieldName(key) + "\"=" + this.quote(name, this.normalizeFieldName(key), record.get(key)));
                    and = " AND ";
                }
                if (blobValue.get(1) == null) continue;
                if ("blob".equals((String)blobValue.get(0))) {
                    this.connection.updateBlob(this.metaFieldRecords.get(name).getTable(), blobName, (byte[])blobValue.get(1), stm.toString());
                    continue;
                }
                this.connection.updateClob(this.metaFieldRecords.get(name).getTable(), blobName, (String)blobValue.get(1), stm.toString());
            }
        }
        catch (Exception e) {
            throw new Exception("SOSImport.updateBlob: " + e.getMessage(), e);
        }
    }

    private void insertRecord(String name, Map<String, String> record) throws Exception {
        try {
            LOGGER.debug("inserting record");
            StringBuilder fields = new StringBuilder();
            StringBuilder values = new StringBuilder();
            Iterator<String> it = record.keySet().iterator();
            while (it.hasNext()) {
                String key = it.next();
                fields.append("\"" + key + "\"");
                values.append(this.quote(name, key, record.get(key)));
                if (!it.hasNext()) continue;
                fields.append(", ");
                values.append(", ");
            }
            this.connection.execute("INSERT INTO " + this.metaFieldRecords.get(name).getTable() + " (" + fields + ") VALUES(" + values + ")");
        }
        catch (Exception e) {
            throw new Exception("SOSImport.insertRecord: " + e.getMessage(), e);
        }
    }

    private void updateRecord(String name, HashMap keys, Map<String, String> record) throws Exception {
        try {
            LOGGER.debug("updating record");
            StringBuilder stm = new StringBuilder("UPDATE " + this.metaFieldRecords.get(name).getTable() + " SET ");
            Iterator<String> it = record.keySet().iterator();
            while (it.hasNext()) {
                String key = it.next();
                stm.append("\"" + this.normalizeFieldName(key) + "\"=" + this.quote(name, key, record.get(key)));
                if (!it.hasNext()) continue;
                stm.append(", ");
            }
            String and = " WHERE ";
            Iterator it2 = keys.keySet().iterator();
            while (it2.hasNext()) {
                String key = it2.next().toString();
                stm.append(and + "\"" + this.normalizeFieldName(key) + "\"=" + this.quote(name, key, (String)keys.get(key)));
                and = " AND ";
            }
            this.connection.execute(stm.toString());
        }
        catch (Exception e) {
            throw new Exception("SOSImport.updateRecord: " + e.getMessage(), e);
        }
    }

    private void deleteRecord(String name, HashMap keys) throws Exception {
        try {
            LOGGER.debug("delete record");
            StringBuilder stm = new StringBuilder("DELETE FROM " + this.metaFieldRecords.get(name).getTable());
            String and = " WHERE ";
            Iterator it = keys.keySet().iterator();
            while (it.hasNext()) {
                String key = it.next().toString();
                if (keys.get(key) == null) continue;
                stm.append(and + "\"" + this.normalizeFieldName(key) + "\"=" + this.quote(name, key, (String)keys.get(key)));
                and = " AND ";
            }
            LOGGER.trace("deleted record:" + stm.toString());
            this.connection.execute(stm.toString());
        }
        catch (Exception e) {
            throw new Exception("SOSImport.updateRecord: " + e.getMessage(), e);
        }
    }

    private String quote(String packageId, String field, String val) {
        if (val == null) {
            return "NULL";
        }
        switch (this.metaFieldRecords.get(packageId).getTypeId(field)) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if ("".equals(val)) {
                    val = "NULL";
                }
                return val;
            }
            case 91: 
            case 93: {
                return "%timestamp_iso('" + val + "')";
            }
        }
        val = val.replaceAll("'", "''");
        if (this.connection instanceof SOSMySQLConnection) {
            val = val.replaceAll("\\\\", "\\\\\\\\");
        }
        return "'" + val + "'";
    }

    private void autoNormalize(String field) throws Exception {
        String copy = new String(field);
        try {
            if (field.equals(copy.toLowerCase())) {
                LOGGER.debug("Auto Normalisation: lower case");
                this.setNormalizeFieldName("strtolower");
            } else if (field.equals(copy.toUpperCase())) {
                LOGGER.debug("Auto Normalisation: upper case");
                this.setNormalizeFieldName("strtoupper");
            } else {
                LOGGER.debug("Auto Normalisation: upper case");
                this.setNormalizeFieldName("strtoupper");
            }
        }
        catch (Exception e) {
            throw new Exception("SOSImport.autoNormalize: " + e.getMessage());
        }
    }

    private String normalizeFieldName(String field) {
        if ("strtoupper".equalsIgnoreCase(this.normalizeFieldName)) {
            return field.toUpperCase();
        }
        return field.toLowerCase();
    }

    private String fromXML(String xml) {
        return xml;
    }

    private static byte[] fromHexString(String s) {
        if (s == null) {
            return null;
        }
        if ("".equals(s)) {
            return null;
        }
        int length = 0;
        int strLength = s.length();
        for (int i = 0; i < strLength; ++i) {
            if (s.charAt(i) != ' ' && s.charAt(i) != '\n' && s.charAt(i) != '\t') continue;
            ++length;
        }
        length = s.length() - length;
        if ((length & 1) != 0) {
            throw new IllegalArgumentException("fromHexString requires an even number of hex characters");
        }
        byte[] b = new byte[length /= 2];
        int i = 0;
        int j = 0;
        while (i < strLength) {
            char cLow = s.charAt(i);
            if (cLow == ' ' || cLow == '\n' || cLow == '\t') {
                ++i;
                continue;
            }
            char cHigh = s.charAt(i + 1);
            int high = SOSImport.charToNibble(cLow);
            int low = SOSImport.charToNibble(cHigh);
            b[j] = (byte)(high << 4 | low);
            ++j;
            i += 2;
        }
        return b;
    }

    private static int charToNibble(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        throw new IllegalArgumentException("Invalid hex character: " + c);
    }

    public HashMap getMappingTablenames() {
        return this.mappingTablenames;
    }

    public void setMappingTablenames(HashMap mappingTablenames) {
        this.mappingTablenames = mappingTablenames;
    }

    private class Tables {
        private HashMap tables = new HashMap();

        private Tables() {
        }

        public void addTable(String table, boolean replace, HashMap restrict) {
            ArrayList<Serializable> array = new ArrayList<Serializable>();
            array.add(new Boolean(replace));
            array.add(restrict);
            this.tables.put(table.toLowerCase(), array);
        }

        public boolean getReplace(String table) {
            try {
                ArrayList list = (ArrayList)this.tables.get(table.toLowerCase());
                if (list != null) {
                    return (Boolean)list.get(0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }

        public HashMap getRestrict(String table) {
            try {
                ArrayList list = (ArrayList)this.tables.get(table.toLowerCase());
                if (list != null) {
                    return (HashMap)list.get(1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        public int size() {
            return this.tables.size();
        }

        public Iterator getIterator() {
            return this.tables.keySet().iterator();
        }

        public boolean isEmpty() {
            return this.tables.isEmpty();
        }
    }

    private class Records {
        private ArrayList records = new ArrayList();

        private Records() {
        }

        public int addRecord() {
            this.records.add(new HashMap());
            return this.records.size() - 1;
        }

        public void addValue(int index, String key, String val) {
            HashMap hash = (HashMap)this.records.get(index);
            if (hash != null) {
                hash.put(SOSImport.this.normalizeFieldName(key), val);
            }
        }

        public String getValue(int index, String key) {
            try {
                HashMap hash = (HashMap)this.records.get(index);
                if (hash != null) {
                    return (String)hash.get(SOSImport.this.normalizeFieldName(key));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        public int size() {
            return this.records.size();
        }

        public Iterator getIterator(int index) {
            HashMap hash = (HashMap)this.records.get(index);
            if (hash != null) {
                return hash.keySet().iterator();
            }
            return null;
        }
    }

    private class MetaRecords {
        private HashMap metaRecords = new HashMap();

        private MetaRecords() {
        }

        public SOSImExportTableFieldTypes get(String packageId) {
            return (SOSImExportTableFieldTypes)this.metaRecords.get(packageId);
        }

        public void add(String packageId) {
            this.metaRecords.put(packageId, new SOSImExportTableFieldTypes());
        }
    }
}

