/*
 * Decompiled with CFR 0.152.
 */
package com.sos.hibernate.layer;

import com.sos.hibernate.classes.ClassList;
import com.sos.hibernate.classes.SOSHibernateFactory;
import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.hibernate.exceptions.SOSHibernateException;
import java.io.File;

public class SOSHibernateDBLayer {
    protected SOSHibernateSession sosHibernateSession = null;
    private SOSHibernateFactory sosHibernateFactory = null;
    private String configurationFileName = null;

    public String getConfigurationFileName() {
        return this.configurationFileName;
    }

    public File getConfigurationFile() {
        return new File(this.configurationFileName);
    }

    public void setConfigurationFileName(String configurationFileName) {
        this.configurationFileName = configurationFileName;
    }

    public SOSHibernateSession getSession() {
        return this.sosHibernateSession;
    }

    public SOSHibernateSession createStatefullConnection(String confFile) throws SOSHibernateException {
        if (this.sosHibernateFactory == null) {
            this.sosHibernateFactory = new SOSHibernateFactory(confFile);
            this.sosHibernateFactory.addClassMapping(SOSHibernateDBLayer.getDefaultClassMapping());
            this.sosHibernateFactory.build();
        }
        this.sosHibernateSession = this.sosHibernateFactory.openSession();
        return this.sosHibernateSession;
    }

    public SOSHibernateSession createStatelessConnection(String confFile) throws SOSHibernateException {
        if (this.sosHibernateFactory == null) {
            this.sosHibernateFactory = new SOSHibernateFactory(confFile);
            this.sosHibernateFactory.addClassMapping(SOSHibernateDBLayer.getDefaultClassMapping());
            this.sosHibernateFactory.build();
        }
        this.sosHibernateSession = this.sosHibernateFactory.openStatelessSession();
        return this.sosHibernateSession;
    }

    private static ClassList getDefaultClassMapping() {
        ClassList classList = new ClassList();
        classList.addClassIfExist("com.sos.jitl.dailyplan.db.DailyPlanDBItem");
        classList.addClassIfExist("com.sos.jitl.dailyplan.db.DailyPlanWithReportTriggerDBItem");
        classList.addClassIfExist("com.sos.jitl.dailyplan.db.DailyPlanWithReportExecutionDBItem");
        classList.addClassIfExist("com.sos.jitl.schedulerhistory.db.SchedulerTaskHistoryDBItem");
        classList.addClassIfExist("com.sos.jitl.schedulerhistory.db.SchedulerOrderStepHistoryDBItem");
        classList.addClassIfExist("com.sos.jitl.schedulerhistory.db.SchedulerOrderHistoryDBItem");
        classList.addClassIfExist("sos.jadehistory.db.JadeFilesDBItem");
        classList.addClassIfExist("sos.jadehistory.db.JadeFilesHistoryDBItem");
        classList.addClassIfExist("com.sos.jitl.eventing.db.SchedulerEventDBItem");
        classList.addClassIfExist("com.sos.jitl.reporting.db.DBItemReportTrigger");
        classList.addClassIfExist("com.sos.jitl.reporting.db.DBItemReportTriggerWithResult");
        classList.addClassIfExist("com.sos.jitl.reporting.db.DBItemReportTriggerResult");
        classList.addClassIfExist("com.sos.jitl.reporting.db.DBItemReportExecution");
        classList.addClassIfExist("com.sos.jitl.reporting.db.DBItemReportTriggerResult");
        classList.addClassIfExist("com.sos.jitl.reporting.db.DBItemReportExecutionDate");
        return classList;
    }
}

