/*
 * Decompiled with CFR 0.152.
 */
package com.sos.hibernate.layer;

import com.sos.hibernate.classes.SOSHibernateIntervalFilter;
import com.sos.hibernate.exceptions.SOSHibernateException;
import com.sos.hibernate.layer.SOSHibernateDBLayer;
import java.util.GregorianCalendar;
import java.util.List;

public abstract class SOSHibernateIntervalDBLayer<T>
extends SOSHibernateDBLayer {
    public abstract SOSHibernateIntervalFilter getFilter();

    public abstract void onAfterDeleting(T var1) throws SOSHibernateException;

    public abstract List<T> getListOfItemsToDelete() throws SOSHibernateException;

    public abstract long deleteInterval() throws SOSHibernateException;

    public long deleteInterval(int interval, int limit) throws SOSHibernateException {
        long deleted = 0L;
        if (limit == 0) {
            GregorianCalendar to = new GregorianCalendar();
            to.add(6, -interval);
            this.getFilter().setIntervalFrom(null);
            this.getFilter().setIntervalTo(to.getTime());
            this.getSession().beginTransaction();
            deleted = this.deleteInterval();
            this.getSession().commit();
        } else {
            if (this.sosHibernateSession == null) {
                this.getSession().beginTransaction();
            }
            if (interval > 0) {
                GregorianCalendar to = new GregorianCalendar();
                to.add(6, -interval);
                this.getFilter().setLimit(limit);
                this.getFilter().setIntervalFrom(null);
                this.getFilter().setIntervalTo(to.getTime());
                List<T> listOfDBItems = this.getListOfItemsToDelete();
                int i = 0;
                if (listOfDBItems != null) {
                    for (T h : listOfDBItems) {
                        this.sosHibernateSession.delete(h);
                        this.onAfterDeleting(h);
                        ++deleted;
                        if (++i != limit) continue;
                        i = 0;
                    }
                }
                this.getSession().commit();
            }
        }
        return deleted;
    }

    public long deleteInterval(int interval) throws SOSHibernateException {
        return this.deleteInterval(interval, 300);
    }
}

