/*
 * Decompiled with CFR 0.152.
 */
package com.sos.controller.model.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum OutcomeType {
    Succeeded("Succeeded"),
    Failed("Failed"),
    Disrupted("Disrupted"),
    Cancelled("Cancelled"),
    Killed("Killed"),
    TimedOut("TimedOut"),
    ProcessLost("ProcessLost"),
    JobSchedulerRestarted("JobSchedulerRestarted"),
    Other("Other");

    private final String value;
    private static final Map<String, OutcomeType> CONSTANTS;

    private OutcomeType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static OutcomeType fromValue(String value) {
        OutcomeType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, OutcomeType>();
        for (OutcomeType c : OutcomeType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

