/*
 * Decompiled with CFR 0.152.
 */
package com.sos.controller.model.deploy;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum DeleteType {
    WORKFLOW("WorkflowPath", 1),
    JOBCLASS("JobClassPath", 2),
    LOCK("LockPath", 4),
    FILEORDERSOURCE("FileWatchPath", 9),
    JOBRESOURCE("JobResourcePath", 10),
    NOTICEBOARD("BoardPath", 11);

    private final String value;
    private final Integer intValue;
    private static final Map<String, DeleteType> CONSTANTS;
    private static final Map<Integer, DeleteType> INTCONSTANTS;

    private DeleteType(String value, Integer intValue) {
        this.value = value;
        this.intValue = intValue;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Integer intValue() {
        return this.intValue;
    }

    @JsonCreator
    public static DeleteType fromValue(String value) {
        DeleteType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    public static DeleteType fromValue(Integer intValue) {
        DeleteType constant = INTCONSTANTS.get(intValue);
        if (constant == null) {
            throw new IllegalArgumentException("" + intValue);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, DeleteType>();
        INTCONSTANTS = new HashMap<Integer, DeleteType>();
        for (DeleteType c : DeleteType.values()) {
            INTCONSTANTS.put(c.intValue, c);
        }
        for (DeleteType c : DeleteType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

