/*
 * Decompiled with CFR 0.152.
 */
package com.sos.inventory.model.deploy;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum DeployType {
    WORKFLOW("Workflow", 1),
    JOBCLASS("JobClass", 2),
    LOCK("Lock", 4),
    FILEORDERSOURCE("FileWatch", 9),
    JOBRESOURCE("JobResource", 10),
    NOTICEBOARD("Board", 11);

    private final String value;
    private final Integer intValue;
    private static final Map<String, DeployType> CONSTANTS;
    private static final Map<Integer, DeployType> INTCONSTANTS;

    private DeployType(String value, Integer intValue) {
        this.value = value;
        this.intValue = intValue;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Integer intValue() {
        return this.intValue;
    }

    @JsonCreator
    public static DeployType fromValue(String value) {
        DeployType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    public static DeployType fromValue(Integer intValue) {
        DeployType constant = INTCONSTANTS.get(intValue);
        if (constant == null) {
            throw new IllegalArgumentException("" + intValue);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, DeployType>();
        INTCONSTANTS = new HashMap<Integer, DeployType>();
        for (DeployType c : DeployType.values()) {
            INTCONSTANTS.put(c.intValue, c);
        }
        for (DeployType c : DeployType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

