/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.inventory.dependencies.get;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum OperationType {
    DEPLOY("DEPLOY"),
    RELEASE("RELEASE"),
    REVOKE("REVOKE"),
    RECALL("RECALL"),
    REMOVE("REMOVE"),
    EXPORT("EXPORT"),
    GIT("GIT");

    private final String value;
    private static final Map<String, OperationType> CONSTANTS;

    private OperationType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static OperationType fromValue(String value) {
        OperationType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, OperationType>();
        for (OperationType c : OperationType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

