/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.order;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.sos.controller.model.order.OrderModeType;
import com.sos.controller.model.workflow.WorkflowId;
import com.sos.inventory.model.common.Variables;
import com.sos.joc.model.audit.AuditParams;
import com.sos.joc.model.common.Folder;
import com.sos.joc.model.order.OrderStateText;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"controllerId", "orderIds", "workflowIds", "states", "folders", "dateFrom", "dateTo", "timeZone", "orderType", "kill", "deep", "reset", "force", "position", "fromCurrentBlock", "variables", "cycleEndTime", "auditLog"})
public class ModifyOrders {
    @JsonProperty(value="controllerId")
    private String controllerId;
    @JsonProperty(value="orderIds")
    @JsonDeserialize(as=LinkedHashSet.class)
    private Set<String> orderIds = new LinkedHashSet<String>();
    @JsonProperty(value="workflowIds")
    private List<WorkflowId> workflowIds = new ArrayList<WorkflowId>();
    @JsonProperty(value="states")
    private List<OrderStateText> states = new ArrayList<OrderStateText>();
    @JsonProperty(value="folders")
    private List<Folder> folders = new ArrayList<Folder>();
    @JsonProperty(value="dateFrom")
    @JsonPropertyDescription(value="0 or [number][smhdwMy] (where smhdwMy unit for second, minute, etc) or ISO 8601 timestamp")
    private String dateFrom;
    @JsonProperty(value="dateTo")
    @JsonPropertyDescription(value="0 or [number][smhdwMy] (where smhdwMy unit for second, minute, etc) or ISO 8601 timestamp")
    private String dateTo;
    @JsonProperty(value="timeZone")
    @JsonPropertyDescription(value="see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones")
    private String timeZone;
    @JsonProperty(value="orderType")
    @JsonPropertyDescription(value="relevant for cancel or suspend order")
    private OrderModeType orderType = OrderModeType.fromValue("FreshOrStarted");
    @JsonProperty(value="kill")
    @JsonPropertyDescription(value="only relevant for 'suspend' and 'cancel'")
    private Boolean kill = false;
    @JsonProperty(value="deep")
    @JsonPropertyDescription(value="only relevant for 'suspend' and 'cancel'")
    private Boolean deep = false;
    @JsonProperty(value="reset")
    @JsonPropertyDescription(value="only relevant for 'suspend'")
    private Boolean reset = false;
    @JsonProperty(value="force")
    @JsonPropertyDescription(value="only relevant for 'resume'")
    private Boolean force = false;
    @JsonProperty(value="position")
    private Object position;
    @JsonProperty(value="fromCurrentBlock")
    @JsonPropertyDescription(value="only relevant for 'resume'")
    private Boolean fromCurrentBlock = false;
    @JsonProperty(value="variables")
    @JsonPropertyDescription(value="a map for arbitrary key-value pairs")
    private Variables variables;
    @JsonProperty(value="cycleEndTime")
    private Long cycleEndTime;
    @JsonProperty(value="auditLog")
    private AuditParams auditLog;

    @JsonProperty(value="controllerId")
    public String getControllerId() {
        return this.controllerId;
    }

    @JsonProperty(value="controllerId")
    public void setControllerId(String controllerId) {
        this.controllerId = controllerId;
    }

    @JsonProperty(value="orderIds")
    public Set<String> getOrderIds() {
        return this.orderIds;
    }

    @JsonProperty(value="orderIds")
    public void setOrderIds(Set<String> orderIds) {
        this.orderIds = orderIds;
    }

    @JsonProperty(value="workflowIds")
    public List<WorkflowId> getWorkflowIds() {
        return this.workflowIds;
    }

    @JsonProperty(value="workflowIds")
    public void setWorkflowIds(List<WorkflowId> workflowIds) {
        this.workflowIds = workflowIds;
    }

    @JsonProperty(value="states")
    public List<OrderStateText> getStates() {
        return this.states;
    }

    @JsonProperty(value="states")
    public void setStates(List<OrderStateText> states) {
        this.states = states;
    }

    @JsonProperty(value="folders")
    public List<Folder> getFolders() {
        return this.folders;
    }

    @JsonProperty(value="folders")
    public void setFolders(List<Folder> folders) {
        this.folders = folders;
    }

    @JsonProperty(value="dateFrom")
    public String getDateFrom() {
        return this.dateFrom;
    }

    @JsonProperty(value="dateFrom")
    public void setDateFrom(String dateFrom) {
        this.dateFrom = dateFrom;
    }

    @JsonProperty(value="dateTo")
    public String getDateTo() {
        return this.dateTo;
    }

    @JsonProperty(value="dateTo")
    public void setDateTo(String dateTo) {
        this.dateTo = dateTo;
    }

    @JsonProperty(value="timeZone")
    public String getTimeZone() {
        return this.timeZone;
    }

    @JsonProperty(value="timeZone")
    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    @JsonProperty(value="orderType")
    public OrderModeType getOrderType() {
        return this.orderType;
    }

    @JsonProperty(value="orderType")
    public void setOrderType(OrderModeType orderType) {
        this.orderType = orderType;
    }

    @JsonProperty(value="kill")
    public Boolean getKill() {
        return this.kill;
    }

    @JsonProperty(value="kill")
    public void setKill(Boolean kill) {
        this.kill = kill;
    }

    @JsonProperty(value="deep")
    public Boolean getDeep() {
        return this.deep;
    }

    @JsonProperty(value="deep")
    public void setDeep(Boolean deep) {
        this.deep = deep;
    }

    @JsonProperty(value="reset")
    public Boolean getReset() {
        return this.reset;
    }

    @JsonProperty(value="reset")
    public void setReset(Boolean reset) {
        this.reset = reset;
    }

    @JsonProperty(value="force")
    public Boolean getForce() {
        return this.force;
    }

    @JsonProperty(value="force")
    public void setForce(Boolean force) {
        this.force = force;
    }

    @JsonProperty(value="position")
    public Object getPosition() {
        if (this.position != null && this.position instanceof String && ((String)this.position).isEmpty()) {
            return null;
        }
        return this.position;
    }

    @JsonProperty(value="position")
    public void setPosition(Object position) {
        this.position = position;
    }

    @JsonProperty(value="fromCurrentBlock")
    public Boolean getFromCurrentBlock() {
        return this.fromCurrentBlock;
    }

    @JsonProperty(value="fromCurrentBlock")
    public void setFromCurrentBlock(Boolean fromCurrentBlock) {
        this.fromCurrentBlock = fromCurrentBlock;
    }

    @JsonProperty(value="variables")
    public Variables getVariables() {
        return this.variables;
    }

    @JsonProperty(value="variables")
    public void setVariables(Variables variables) {
        this.variables = variables;
    }

    @JsonProperty(value="cycleEndTime")
    public Long getCycleEndTime() {
        return this.cycleEndTime;
    }

    @JsonProperty(value="cycleEndTime")
    public void setCycleEndTime(Long cycleEndTime) {
        this.cycleEndTime = cycleEndTime;
    }

    @JsonProperty(value="auditLog")
    public AuditParams getAuditLog() {
        return this.auditLog;
    }

    @JsonProperty(value="auditLog")
    public void setAuditLog(AuditParams auditLog) {
        this.auditLog = auditLog;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("controllerId", (Object)this.controllerId).append("orderIds", this.orderIds).append("workflowIds", this.workflowIds).append("states", this.states).append("folders", this.folders).append("dateFrom", (Object)this.dateFrom).append("dateTo", (Object)this.dateTo).append("timeZone", (Object)this.timeZone).append("orderType", (Object)this.orderType).append("kill", (Object)this.kill).append("deep", (Object)this.deep).append("reset", (Object)this.reset).append("force", (Object)this.force).append("position", this.position).append("fromCurrentBlock", (Object)this.fromCurrentBlock).append("variables", (Object)this.variables).append("cycleEndTime", (Object)this.cycleEndTime).append("auditLog", (Object)this.auditLog).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.workflowIds).append((Object)this.orderType).append((Object)this.deep).append((Object)this.variables).append(this.folders).append((Object)this.controllerId).append((Object)this.auditLog).append((Object)this.timeZone).append((Object)this.dateFrom).append((Object)this.kill).append(this.states).append((Object)this.cycleEndTime).append((Object)this.dateTo).append((Object)this.reset).append((Object)this.force).append((Object)this.fromCurrentBlock).append(this.orderIds).append(this.position).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ModifyOrders)) {
            return false;
        }
        ModifyOrders rhs = (ModifyOrders)other;
        return new EqualsBuilder().append(this.workflowIds, rhs.workflowIds).append((Object)this.orderType, (Object)rhs.orderType).append((Object)this.deep, (Object)rhs.deep).append((Object)this.variables, (Object)rhs.variables).append(this.folders, rhs.folders).append((Object)this.controllerId, (Object)rhs.controllerId).append((Object)this.auditLog, (Object)rhs.auditLog).append((Object)this.timeZone, (Object)rhs.timeZone).append((Object)this.dateFrom, (Object)rhs.dateFrom).append((Object)this.kill, (Object)rhs.kill).append(this.states, rhs.states).append((Object)this.cycleEndTime, (Object)rhs.cycleEndTime).append((Object)this.dateTo, (Object)rhs.dateTo).append((Object)this.reset, (Object)rhs.reset).append((Object)this.force, (Object)rhs.force).append((Object)this.force, (Object)rhs.force).append((Object)this.fromCurrentBlock, (Object)rhs.fromCurrentBlock).append(this.position, rhs.position).isEquals();
    }
}

