/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.sign;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum SignatureType {
    PGP("PGP"),
    X_509("X509"),
    SILLY("Silly");

    private final String value;
    private static final Map<String, SignatureType> CONSTANTS;

    private SignatureType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static SignatureType fromValue(String value) {
        SignatureType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, SignatureType>();
        for (SignatureType c : SignatureType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

