/*
 * Decompiled with CFR 0.152.
 */
package com.sos.joc.model.yade;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum Operation {
    UNKNOWN("UNKNOWN"),
    COPY("COPY"),
    MOVE("MOVE"),
    GETLIST("GETLIST"),
    RENAME("RENAME"),
    COPYTOINTERNET("COPYTOINTERNET"),
    COPYFROMINTERNET("COPYFROMINTERNET"),
    REMOVE("REMOVE");

    private final String value;
    private static final Map<String, Operation> CONSTANTS;

    private Operation(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static Operation fromValue(String value) {
        Operation constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, Operation>();
        for (Operation c : Operation.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

