/*
 * Decompiled with CFR 0.152.
 */
package com.sos.monitoring.notification;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum NotificationApplication {
    ORDER_NOTIFICATION(0),
    SYSTEM_NOTIFICATION(1);

    private final Integer intValue;
    private static final Map<String, NotificationApplication> CONSTANTS;
    private static final Map<Integer, NotificationApplication> INTCONSTANTS;

    private NotificationApplication(Integer intValue) {
        this.intValue = intValue;
    }

    public String toString() {
        return this.name();
    }

    @JsonValue
    public String value() {
        return this.name();
    }

    public Integer intValue() {
        return this.intValue;
    }

    @JsonCreator
    public static NotificationApplication fromValue(String value) {
        NotificationApplication constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    public static NotificationApplication fromValue(Integer intValue) {
        NotificationApplication constant = INTCONSTANTS.get(intValue);
        if (constant == null) {
            throw new IllegalArgumentException("" + intValue);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, NotificationApplication>();
        INTCONSTANTS = new HashMap<Integer, NotificationApplication>();
        for (NotificationApplication c : NotificationApplication.values()) {
            CONSTANTS.put(c.name(), c);
        }
        for (NotificationApplication c : NotificationApplication.values()) {
            INTCONSTANTS.put(c.intValue, c);
        }
    }
}

