/*
 * Decompiled with CFR 0.152.
 */
package com.sos.monitoring.notification;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum NotificationStatus {
    OK(0),
    WARNING(1),
    CRITICAL(2),
    UNKNOWN(3);

    private final Integer intValue;
    private static final Map<String, NotificationStatus> CONSTANTS;
    private static final Map<Integer, NotificationStatus> INTCONSTANTS;

    private NotificationStatus(Integer intValue) {
        this.intValue = intValue;
    }

    public String toString() {
        return this.name();
    }

    @JsonValue
    public String value() {
        return this.name();
    }

    public Integer intValue() {
        return this.intValue;
    }

    @JsonCreator
    public static NotificationStatus fromValue(String value) {
        NotificationStatus constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    public static NotificationStatus fromValue(Integer intValue) {
        NotificationStatus constant = INTCONSTANTS.get(intValue);
        if (constant == null) {
            throw new IllegalArgumentException("" + intValue);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, NotificationStatus>();
        INTCONSTANTS = new HashMap<Integer, NotificationStatus>();
        for (NotificationStatus c : NotificationStatus.values()) {
            CONSTANTS.put(c.name(), c);
        }
        for (NotificationStatus c : NotificationStatus.values()) {
            INTCONSTANTS.put(c.intValue, c);
        }
    }
}

