/*
 * Decompiled with CFR 0.152.
 */
package com.sos.monitoring.notification;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum SystemNotificationCategory {
    SYSTEM(0),
    JOC(1),
    CONTROLLER(2),
    AGENT(3);

    private final Integer intValue;
    private static final Map<String, SystemNotificationCategory> CONSTANTS;
    private static final Map<Integer, SystemNotificationCategory> INTCONSTANTS;

    private SystemNotificationCategory(Integer intValue) {
        this.intValue = intValue;
    }

    public String toString() {
        return this.name();
    }

    @JsonValue
    public String value() {
        return this.name();
    }

    public Integer intValue() {
        return this.intValue;
    }

    @JsonCreator
    public static SystemNotificationCategory fromValue(String value) {
        SystemNotificationCategory constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    public static SystemNotificationCategory fromValue(Integer intValue) {
        SystemNotificationCategory constant = INTCONSTANTS.get(intValue);
        if (constant == null) {
            throw new IllegalArgumentException("" + intValue);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, SystemNotificationCategory>();
        INTCONSTANTS = new HashMap<Integer, SystemNotificationCategory>();
        for (SystemNotificationCategory c : SystemNotificationCategory.values()) {
            CONSTANTS.put(c.name(), c);
        }
        for (SystemNotificationCategory c : SystemNotificationCategory.values()) {
            INTCONSTANTS.put(c.intValue, c);
        }
    }
}

