/*
 * Decompiled with CFR 0.152.
 */
package com.sos.js7.job;

import com.sos.commons.exception.ISOSRequiredArgumentMissingException;
import com.sos.commons.util.SOSString;
import com.sos.js7.job.JobArguments;
import js7.launcher.forjava.internal.BlockingInternalJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderProcessStepLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrderProcessStepLogger.class);
    private final BlockingInternalJob.Step step;
    private boolean isDebugEnabled;
    private boolean isTraceEnabled;

    protected OrderProcessStepLogger(BlockingInternalJob.Step step) {
        this.step = step;
    }

    protected void init(Object args) {
        if (this.step == null) {
            this.isTraceEnabled = LOGGER.isTraceEnabled();
            this.isDebugEnabled = LOGGER.isDebugEnabled();
        } else if (args != null && args instanceof JobArguments) {
            JobArguments ja = (JobArguments)args;
            this.isTraceEnabled = ((JobArguments.LogLevel)((Object)ja.getLogLevel().getValue())).equals((Object)JobArguments.LogLevel.TRACE);
            this.isDebugEnabled = ((JobArguments.LogLevel)((Object)ja.getLogLevel().getValue())).equals((Object)JobArguments.LogLevel.DEBUG) || this.isTraceEnabled;
        }
    }

    public void info(Object msg) {
        String m = this.getMessage(JobArguments.LogLevel.INFO, msg);
        if (this.step == null) {
            LOGGER.info(m);
            return;
        }
        this.step.out().println(m);
    }

    public void info(String format, Object ... args) {
        if (args.length == 0) {
            this.info(format);
        } else {
            this.info(String.format(format, args));
        }
    }

    public void debug(Object msg) {
        if (!this.isDebugEnabled) {
            return;
        }
        String m = this.getMessage(JobArguments.LogLevel.DEBUG, msg);
        if (this.step == null) {
            LOGGER.debug(m);
            return;
        }
        this.step.out().println(m);
    }

    public void debug(String format, Object ... args) {
        if (!this.isDebugEnabled) {
            return;
        }
        if (args.length == 0) {
            this.debug(format);
        } else {
            this.debug(String.format(format, args));
        }
    }

    public void trace(Object msg) {
        if (!this.isTraceEnabled) {
            return;
        }
        String m = this.getMessage(JobArguments.LogLevel.TRACE, msg);
        if (this.step == null) {
            LOGGER.trace(m);
            return;
        }
        this.step.out().println(m);
    }

    public void trace(String format, Object ... args) {
        if (!this.isTraceEnabled) {
            return;
        }
        if (args.length == 0) {
            this.trace(format);
        } else {
            this.trace(String.format(format, args));
        }
    }

    public void warn(Object msg) {
        String m = this.getMessage(JobArguments.LogLevel.WARN, msg);
        if (this.step == null) {
            LOGGER.warn(m);
            return;
        }
        this.step.out().println(m);
    }

    public void warn(String format, Object ... args) {
        if (args.length == 0) {
            this.warn(format);
        } else {
            this.warn(String.format(format, args));
        }
    }

    public void warn(String msg, Throwable e) {
        this.warn(this.warn2String(msg, e));
    }

    protected void warn2allLoggers(String stepInfo, String msg, Throwable e) {
        Throwable ex = this.handleException(e);
        if (ex != null) {
            this.warn2slf4j(stepInfo, msg, ex);
            this.warn(this.warn2String(msg, ex));
        }
    }

    public void error(Object msg) {
        String m = this.getMessage(JobArguments.LogLevel.ERROR, msg);
        if (this.step == null) {
            LOGGER.error(m);
            return;
        }
        this.step.err().println(m);
    }

    public void error(String format, Object ... args) {
        if (args.length == 0) {
            this.error(format);
        } else {
            this.error(String.format(format, args));
        }
    }

    public void error(String msg, Throwable e) {
        this.error(this.throwable2String(msg, e));
    }

    public void error(Throwable e) {
        this.error(this.throwable2String(null, e));
    }

    protected void error2allLoggers(String stepInfo, String msg, Throwable e) {
        Throwable ex = this.handleException(e);
        if (ex != null) {
            this.error2slf4j(stepInfo, msg, ex);
            this.error(this.throwable2String(msg, ex));
        }
    }

    protected void log(JobArguments.LogLevel logLevel, Object msg) {
        switch (logLevel) {
            case INFO: {
                this.info(msg);
                break;
            }
            case DEBUG: {
                this.debug(msg);
                break;
            }
            case TRACE: {
                this.trace(msg);
                break;
            }
            case WARN: {
                this.warn(msg);
                break;
            }
            case ERROR: {
                this.error(msg);
            }
        }
    }

    protected void log(JobArguments.LogLevel logLevel, String format, Object ... args) {
        switch (logLevel) {
            case INFO: {
                this.info(format, args);
                break;
            }
            case DEBUG: {
                this.debug(format, args);
                break;
            }
            case TRACE: {
                this.trace(format, args);
                break;
            }
            case WARN: {
                this.warn(format, args);
                break;
            }
            case ERROR: {
                this.error(format, args);
            }
        }
    }

    public boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }

    public boolean isTraceEnabled() {
        return this.isTraceEnabled;
    }

    private String warn2String(String msg, Throwable e) {
        return this.throwable2String(msg, e);
    }

    protected Throwable handleException(Throwable e) {
        if (e == null || e instanceof ISOSRequiredArgumentMissingException) {
            return null;
        }
        return e;
    }

    protected void failed2slf4j(String stepInfo, String msg) {
        LOGGER.info(String.format("[failed]%s%s", stepInfo, SOSString.isEmpty((String)msg) ? "" : msg));
    }

    protected void failed2slf4j(String stepInfo, String msg, Throwable e) {
        LOGGER.info(String.format("[failed]%s%s", stepInfo, msg), e);
    }

    private void warn2slf4j(String stepInfo, String msg, Throwable e) {
        LOGGER.info(String.format("%s%s", stepInfo, msg), e);
    }

    private void error2slf4j(String stepInfo, String msg, Throwable e) {
        LOGGER.info(String.format("%s%s", stepInfo, msg), e);
    }

    private String getMessage(JobArguments.LogLevel logLevel, Object msg) {
        return String.format("[%s]%s", logLevel.name(), msg);
    }

    protected String throwable2String(String msg, Throwable e) {
        if (e == null) {
            return msg;
        }
        StringBuilder sb = new StringBuilder();
        if (!SOSString.isEmpty((String)msg)) {
            sb.append(msg);
            sb.append("\n");
        }
        sb.append(SOSString.toString((Throwable)e));
        return sb.toString();
    }
}

