/*
 * Decompiled with CFR 0.152.
 */
package com.sos.js7.job;

import com.sos.commons.util.SOSReflection;
import com.sos.commons.util.common.SOSTimeout;
import com.sos.js7.job.Job;
import com.sos.js7.job.JobArgument;
import com.sos.js7.job.JobArguments;
import com.sos.js7.job.JobHelper;
import com.sos.js7.job.OrderProcessStep;
import com.sos.js7.job.OrderProcessStepLogger;
import com.sos.js7.job.exception.JobArgumentException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import js7.data_for_java.order.JOutcome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnitTestJobHelper<A extends JobArguments> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnitTestJobHelper.class);
    private final Job<A> job;
    private final UnitTestStepConfig stepConfig;
    private Map<String, String> environment;

    public UnitTestJobHelper(Job<A> job) {
        this.job = job;
        this.stepConfig = new UnitTestStepConfig();
        this.setModifiableEnvironment();
    }

    public void onStart(Map<String, Object> args) throws Exception {
        this.job.getJobEnvironment().setDeclaredArguments(this.toArgs(null, args, null).instance);
        SOSReflection.setDeclaredFieldValue(this.job.getJobEnvironment(), (String)"allArguments", args);
        this.job.onStart();
    }

    public void onStop() throws Exception {
        this.job.onStop();
    }

    public JOutcome.Completed processOrder(Map<String, Object> args) throws Exception {
        return this.processOrder(args, null);
    }

    public JOutcome.Completed processOrder(Map<String, Object> args, SOSTimeout timeout) throws Exception {
        if (timeout == null) {
            timeout = new SOSTimeout(2L, TimeUnit.MINUTES);
        }
        OrderProcessStep<A> step = this.newOrderProcessStep(args);
        return CompletableFuture.supplyAsync(() -> {
            try {
                ArgumentsResult r = this.toArgs(step, args, this.job.onCreateJobArguments(null, step));
                step.init4unittest(r.instance, r.undeclared, this.stepConfig);
                step.checkAndLogParameterization(null, null);
                this.job.processOrder(step);
                return step.processed();
            }
            catch (Throwable e) {
                return step.failed(e.toString(), e);
            }
        }).get(timeout.getInterval(), timeout.getTimeUnit());
    }

    public static OrderProcessStepLogger newLogger() {
        OrderProcessStepLogger l = new OrderProcessStepLogger(null);
        l.init(null);
        return l;
    }

    public void setEnvVar(String n, String v) {
        if (this.environment != null) {
            this.environment.put(n, v);
        }
    }

    public Job<A> getJob() {
        return this.job;
    }

    public UnitTestStepConfig getStepConfig() {
        return this.stepConfig;
    }

    private OrderProcessStep<A> newOrderProcessStep(final Map<String, Object> args) throws Exception {
        OrderProcessStep step = new OrderProcessStep<A>(this.job.getJobEnvironment(), null){

            @Override
            protected <AJ extends JobArguments> AJ onExecuteJobCreateArguments(Job<AJ> job, OrderProcessStep<AJ> step, List<JobArgumentException> exceptions) throws Exception {
                Object aj = job.onCreateJobArguments(exceptions, step);
                aj = (JobArguments)job.getJobArgumensClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                aj = job.setDeclaredJobArguments(exceptions, step, args, null, null, aj);
                return aj;
            }
        };
        return step;
    }

    private ArgumentsResult toArgs(OrderProcessStep<A> step, Map<String, Object> args, A instance) throws Exception {
        instance = instance == null ? (JobArguments)this.job.getJobArgumensClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : instance;
        Set<String> declared = this.getDeclaredJobArgumentNames((JobArguments)instance);
        ArrayList<JobArgumentException> exceptions = new ArrayList<JobArgumentException>();
        instance = this.job.setDeclaredJobArguments(exceptions, step, args, null, null, instance);
        ArgumentsResult r = new ArgumentsResult();
        r.instance = instance;
        r.undeclared = args.entrySet().stream().filter(e -> !declared.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return r;
    }

    private Set<String> getDeclaredJobArgumentNames(JobArguments instance) throws Exception {
        HashSet<String> declared = new HashSet<String>();
        if (instance.getIncludedArguments() != null && instance.getIncludedArguments().size() > 0) {
            for (Map.Entry entry : instance.getIncludedArguments().entrySet()) {
                for (JobArgument arg : (List)entry.getValue()) {
                    if (arg.getName() == null) continue;
                    declared.add(arg.getName());
                }
            }
        }
        if (instance.hasDynamicArgumentFields()) {
            for (JobArgument jobArgument : instance.getDynamicArgumentFields()) {
                if (jobArgument.getName() == null) continue;
                declared.add(jobArgument.getName());
            }
        }
        List<Field> fields = JobHelper.getJobArgumentFields(instance);
        for (Field field : fields) {
            try {
                JobArgument arg;
                field.setAccessible(true);
                arg = (JobArgument)((Object)field.get(instance));
                if (arg == null || arg.getName() == null) continue;
                declared.add(arg.getName());
            }
            catch (Throwable throwable) {}
        }
        return declared;
    }

    private void setModifiableEnvironment() {
        try {
            Class<?> pe = Class.forName("java.lang.ProcessEnvironment");
            Field props = pe.getDeclaredField("theCaseInsensitiveEnvironment");
            props.setAccessible(true);
            this.environment = (Map)props.get(null);
            this.setDefaultEnvVar("JS7_AGENT_HOME", "");
            this.setDefaultEnvVar("JS7_AGENT_CONFIG_DIR", "");
            this.setDefaultEnvVar("JS7_AGENT_WORK_DIR", "");
        }
        catch (Throwable e) {
            LOGGER.info(String.format("[can't set env][use 'Run Configurations -> Environment' instead or allow access with '--add-opens java.base/java.util=ALL-UNNAMED']%s", e.toString()));
        }
    }

    private void setDefaultEnvVar(String n, String v) {
        if (this.environment != null && this.environment.get(n) == null) {
            this.environment.put(n, v);
        }
    }

    public class UnitTestStepConfig {
        private String controllerId;
        private String orderId;
        private String agentId;
        private String jobInstructionLabel;
        private String jobName;
        private String workflowPath;
        private String workflowName;
        private String workflowVersionId;
        private String workflowPosition;

        public String getControllerId() {
            return this.controllerId;
        }

        public void setControllerId(String val) {
            this.controllerId = val;
        }

        public String getOrderId() {
            return this.orderId;
        }

        public void setOrderId(String val) {
            this.orderId = val;
        }

        public String getAgentId() {
            return this.agentId;
        }

        public void setAgentId(String val) {
            this.agentId = val;
        }

        public String getJobInstructionLabel() {
            return this.jobInstructionLabel;
        }

        public void setJobInstructionLabel(String val) {
            this.jobInstructionLabel = val;
        }

        public String getJobName() {
            return this.jobName;
        }

        public void setJobName(String val) {
            this.jobName = val;
        }

        public String getWorkflowPath() {
            return this.workflowPath;
        }

        public void setWorkflowPath(String val) {
            this.workflowPath = val;
        }

        public String getWorkflowName() {
            return this.workflowName;
        }

        public void setWorkflowName(String val) {
            this.workflowName = val;
        }

        public String getWorkflowVersionId() {
            return this.workflowVersionId;
        }

        public void setWorkflowVersionId(String val) {
            this.workflowVersionId = val;
        }

        public String getWorkflowPosition() {
            return this.workflowPosition;
        }

        public void setWorkflowPosition(String val) {
            this.workflowPosition = val;
        }
    }

    private class ArgumentsResult {
        private A instance;
        private Map<String, Object> undeclared;

        private ArgumentsResult() {
        }
    }
}

