/*
 * Decompiled with CFR 0.152.
 */
package com.sos.js7.job.jocapi;

import com.sos.commons.credentialstore.keepass.SOSKeePassResolver;
import com.sos.commons.credentialstore.keepass.exceptions.SOSKeePassDatabaseException;
import com.sos.commons.encryption.common.EncryptedValue;
import com.sos.commons.encryption.decrypt.Decrypt;
import com.sos.commons.encryption.exception.SOSEncryptionException;
import com.sos.commons.exception.SOSException;
import com.sos.commons.exception.SOSMissingDataException;
import com.sos.commons.httpclient.SOSRestApiClient;
import com.sos.commons.httpclient.exception.SOSBadRequestException;
import com.sos.commons.httpclient.exception.SOSConnectionRefusedException;
import com.sos.commons.sign.keys.key.KeyUtil;
import com.sos.commons.sign.keys.keyStore.KeyStoreCredentials;
import com.sos.commons.sign.keys.keyStore.KeyStoreUtil;
import com.sos.commons.sign.keys.keyStore.KeystoreType;
import com.sos.commons.util.SOSString;
import com.sos.commons.vfs.exception.SOSAuthenticationFailedException;
import com.sos.exception.SOSKeyException;
import com.sos.js7.job.DetailValue;
import com.sos.js7.job.OrderProcessStepLogger;
import com.sos.js7.job.jocapi.ApiResponse;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValue;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiExecutor {
    private static final String X_ID_TOKEN = "X-ID-TOKEN";
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiExecutor.class);
    private static final String DEFAULT_TRUSTSTORE_FILENAME = "https-truststore.p12";
    private static final String WS_API_LOGIN = "/joc/api/authentication/login";
    private static final String WS_API_LOGOUT = "/joc/api/authentication/logout";
    private static final String WS_API_PREFIX = "/joc/api";
    private static final String ACCESS_TOKEN_HEADER = "X-Access-Token";
    private static final String APPLICATION_JSON = "application/json";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String AGENT_CONF_DIR_ENV_PARAM = "JS7_AGENT_CONFIG_DIR";
    private static final String PRIVATE_CONF_JS7_PARAM_CONFDIR = "js7.config-directory";
    private static final String PRIVATE_CONF_JS7_PARAM_API_SERVER = "js7.api-server";
    private static final String PRIVATE_CONF_JS7_PARAM_URL = "url";
    private static final String PRIVATE_CONF_JS7_PARAM_KEYSTORE_FILEPATH = "js7.web.https.keystore.file";
    private static final String PRIVATE_CONF_JS7_PARAM_KEYSTORE_KEYPWD = "js7.web.https.keystore.key-password";
    private static final String PRIVATE_CONF_JS7_PARAM_KEYSTORE_STOREPWD = "js7.web.https.keystore.store-password";
    private static final String PRIVATE_CONF_JS7_PARAM_KEYSTORE_ALIAS = "js7.web.https.keystore.alias";
    private static final String PRIVATE_CONF_JS7_PARAM_TRUSTORES_ARRAY = "js7.web.https.truststores";
    private static final String PRIVATE_CONF_JS7_PARAM_TRUSTSTORES_SUB_FILEPATH = "file";
    private static final String PRIVATE_CONF_JS7_PARAM_TRUSTORES_SUB_STOREPWD = "store-password";
    private static final String PRIVATE_FOLDER_NAME = "private";
    private static final String PRIVATE_CONF_FILENAME = "private.conf";
    private static final String PRIVATE_CONF_JS7_PARAM_HTTP_BASIC_AUTH_CS_FILE = "js7.api-server.cs-file";
    private static final String PRIVATE_CONF_JS7_PARAM_HTTP_BASIC_AUTH_CS_KEYFILE = "js7.api-server.cs-key";
    private static final String PRIVATE_CONF_JS7_PARAM_HTTP_BASIC_AUTH_CS_PWD = "js7.api-server.cs-password";
    private static final String PRIVATE_CONF_JS7_PARAM_HTTP_BASIC_AUTH_USERNAME = "js7.api-server.username";
    private static final String PRIVATE_CONF_JS7_PARAM_HTTP_BASIC_AUTH_TOKEN = "js7.api-server.token ";
    private static final String PRIVATE_CONF_JS7_PARAM_HTTP_BASIC_AUTH_PWD = "js7.api-server.password";
    private static final String PRIVATE_CONF_JS7_PARAM_HTTP_BASIC_AUTH_PK_PATH = "js7.api-server.privatekey.path";
    private static final List<String> DO_NOT_LOG_KEY = Arrays.asList("js7.api-server.password", "js7.api-server.cs-password", "js7.web.https.keystore.store-password", "js7.web.https.keystore.key-password", "js7.web.https.keystore.alias", "js7.web.https.truststores", "store-password", "js7.api-server.privatekey.path");
    private static final String DO_NOT_LOG_VAL = "store-password";
    private SOSRestApiClient client;
    private URI jocUri;
    private List<String> jocUris;
    private final OrderProcessStepLogger jobLogger;
    private Config config;
    private String truststorePath;
    private String keystorePath;
    private String truststorePasswd;
    private String keystorePasswd;
    private String keystoreKeyPasswd;
    private String truststoreType;
    private String keystoreType;
    private Map<String, DetailValue> jobResources;

    public void setJobResources(Map<String, DetailValue> jobResources) {
        this.jobResources = jobResources;
    }

    public ApiExecutor(OrderProcessStepLogger jobLogger) {
        this.jobLogger = jobLogger;
    }

    private String getReasonPhrase() {
        String reasonPhrase = "";
        if (this.getClient() != null && this.getClient().getHttpResponse() != null && this.getClient().getHttpResponse().getStatusLine() != null) {
            reasonPhrase = this.getClient().getHttpResponse().getStatusLine().getReasonPhrase();
        }
        return reasonPhrase;
    }

    public void setKeystoreCredentials(String path, String type, String storePwd, String keyPwd) {
        this.keystorePath = path;
        this.keystoreType = type;
        this.keystorePasswd = storePwd;
        this.keystoreKeyPasswd = keyPwd;
    }

    public void setTruststoreCredentials(String path, String type, String storePwd) {
        this.truststorePath = path;
        this.truststoreType = type;
        this.truststorePasswd = storePwd;
    }

    public ApiResponse login() throws Exception {
        this.logDebug("***ApiExecutor***");
        this.jocUris = this.getUris();
        Object latestError = "";
        String latestResponse = "";
        Integer statusCode = -1;
        URI loginUri = null;
        Throwable latestException = null;
        for (String uri : this.jocUris) {
            try {
                String response;
                this.logDebug(String.format("processing Url - %1$s", uri));
                this.tryCreateClient(uri);
                this.jocUri = URI.create(uri);
                loginUri = this.jocUri.resolve(WS_API_LOGIN);
                this.logDebug("send login to: " + loginUri.toString());
                latestResponse = response = this.client.postRestService(loginUri, null);
                statusCode = this.client.statusCode();
                this.logDebug("HTTP status code: " + statusCode);
                this.handleExitCode(this.client);
                if (this.client.statusCode() == 401) {
                    String message = "";
                    try (JsonReader jsonReader = null;){
                        jsonReader = Json.createReader((Reader)new StringReader(response));
                        JsonObject json = jsonReader.readObject();
                        message = json.getString("message", "");
                        if (!message.isEmpty()) {
                            latestError = statusCode + " : " + this.getReasonPhrase() + " " + message;
                            throw new Exception((String)latestError);
                        }
                    }
                    latestException = new Exception("login failed.");
                    throw latestException;
                }
                if (statusCode == 200) {
                    this.logDebug(String.format("Connection to URI %1$s established.", loginUri.toString()));
                    return new ApiResponse(statusCode, this.getReasonPhrase(), response, this.client.getResponseHeader(ACCESS_TOKEN_HEADER), null);
                }
                String message = statusCode + " : " + this.getReasonPhrase();
                throw new Exception((String)latestError);
            }
            catch (SOSConnectionRefusedException e) {
                latestError = String.format("connection to URI %1$s failed, trying next Uri.", loginUri.toString());
                this.logDebug((String)latestError);
                latestException = e;
            }
            catch (Exception e) {
                if (loginUri != null) {
                    latestError = String.format("connection to URI %1$s: %2$s occurred: %3$s", loginUri, e.getClass(), e.getMessage());
                    this.logDebug((String)latestError);
                } else {
                    latestError = String.format("%1$s occurred: %2$s", e.getClass(), e.getMessage());
                    this.logDebug((String)latestError);
                }
                latestException = e;
            }
        }
        this.logInfo("No connection attempt was successful. Check agents private.conf.");
        throw latestException;
    }

    public ApiResponse post(String token, String apiUrl, String body) throws SOSConnectionRefusedException, SOSBadRequestException {
        if (token == null) {
            throw new SOSBadRequestException("no access token provided. permission denied.");
        }
        if (this.jocUri != null) {
            try {
                this.client.addHeader(ACCESS_TOKEN_HEADER, token);
                this.client.addHeader(CONTENT_TYPE, APPLICATION_JSON);
                this.logDebug("REQUEST: " + (String)apiUrl);
                this.logDebug("PARAMS: " + body);
                if (!((String)apiUrl).toLowerCase().startsWith(WS_API_PREFIX)) {
                    apiUrl = WS_API_PREFIX + (String)apiUrl;
                }
                this.logDebug("resolvedUri: " + this.jocUri.resolve((String)apiUrl).toString());
                String response = this.client.postRestService(this.jocUri.resolve((String)apiUrl), (Object)body);
                this.logDebug("HTTP status code: " + this.client.statusCode());
                this.handleExitCode(this.client);
                return new ApiResponse(this.client.statusCode(), this.getReasonPhrase(), response, token, null);
            }
            catch (SOSException e) {
                return new ApiResponse(this.client.statusCode(), this.getReasonPhrase(), null, token, (Exception)((Object)e));
            }
        }
        throw new SOSConnectionRefusedException("No connection established through previous login api call.");
    }

    public ApiResponse logout(String token) throws SOSBadRequestException {
        if (token != null && this.jocUri != null) {
            try {
                this.client.addHeader(ACCESS_TOKEN_HEADER, token);
                this.logDebug("send logout");
                String response = this.client.postRestService(this.jocUri.resolve(WS_API_LOGOUT), null);
                this.logDebug("HTTP status code: " + this.client.statusCode());
                this.handleExitCode(this.client);
                return new ApiResponse(this.client.statusCode(), this.getReasonPhrase(), response, token, null);
            }
            catch (SOSException e) {
                return new ApiResponse(this.client.statusCode(), this.getReasonPhrase(), null, token, (Exception)((Object)e));
            }
        }
        throw new SOSBadRequestException("no access token provided. permission denied.");
    }

    public void close() {
        this.closeClient();
    }

    private List<String> getUris() throws SOSMissingDataException {
        if (this.config == null) {
            this.readConfig();
        }
        List uris = this.config.getConfig(PRIVATE_CONF_JS7_PARAM_API_SERVER).getStringList(PRIVATE_CONF_JS7_PARAM_URL);
        Collections.sort(uris);
        return uris;
    }

    public List<String> getJocUris() {
        return this.jocUris;
    }

    private KeyStore readTrustStore(String path, KeystoreType type, String passwd) throws FileNotFoundException {
        if (!Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) {
            throw new FileNotFoundException(String.format("Cannot read from truststore %1$s. File does not exist!", path));
        }
        try {
            return KeyStoreUtil.readTrustStore((String)path, (KeystoreType)type, (String)passwd);
        }
        catch (Exception e) {
            return null;
        }
    }

    private KeyStore readKeyStore(String path, KeystoreType type, String passwd) throws FileNotFoundException {
        if (!Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) {
            throw new FileNotFoundException(String.format("Cannot read from keystore %1$s. File does not exist!", path));
        }
        try {
            return KeyStoreUtil.readKeyStore((String)path, (KeystoreType)type, (String)passwd);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void applySSLContextCredentials(SOSRestApiClient client) throws KeyManagementException, SOSMissingDataException, NoSuchAlgorithmException, FileNotFoundException {
        SSLContextBuilder sslContextBuilder;
        block18: {
            if (this.config == null) {
                this.readConfig();
            }
            List<KeyStoreCredentials> truststoresCredentials = this.readTruststoreCredentials(this.config);
            sslContextBuilder = SSLContexts.custom();
            sslContextBuilder.setKeyManagerFactoryAlgorithm(KeyManagerFactory.getDefaultAlgorithm());
            sslContextBuilder.setTrustManagerFactoryAlgorithm(TrustManagerFactory.getDefaultAlgorithm());
            if (this.truststorePath != null && this.truststoreType != null && this.truststorePasswd != null) {
                KeyStore truststore = this.readTrustStore(this.truststorePath, KeystoreType.fromValue((String)this.truststoreType), this.truststorePasswd);
                if (truststore != null) {
                    try {
                        sslContextBuilder.loadTrustMaterial(truststore, null);
                    }
                    catch (Exception exception) {}
                }
            } else if (truststoresCredentials != null && !truststoresCredentials.isEmpty()) {
                truststoresCredentials.stream().forEach(item -> {
                    KeyStore truststore;
                    try {
                        truststore = this.readTrustStore(item.getPath(), KeystoreType.PKCS12, item.getStorePwd());
                    }
                    catch (FileNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                    if (truststore != null) {
                        try {
                            sslContextBuilder.loadTrustMaterial(truststore, null);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
            KeyStoreCredentials credentials = this.readKeystoreCredentials(this.config);
            if (this.keystorePath != null && this.keystoreType != null && this.keystorePasswd != null) {
                KeyStore keystore = this.readKeyStore(this.keystorePath, KeystoreType.fromValue((String)this.keystoreType), this.keystorePasswd);
                if (keystore != null) {
                    try {
                        if (this.keystoreKeyPasswd != null) {
                            sslContextBuilder.loadKeyMaterial(keystore, this.keystoreKeyPasswd.toCharArray());
                            break block18;
                        }
                        sslContextBuilder.loadKeyMaterial(keystore, "".toCharArray());
                    }
                    catch (Exception exception) {}
                }
            } else if (credentials != null) {
                KeyStore keystore = this.readKeyStore(credentials.getPath(), KeystoreType.PKCS12, credentials.getStorePwd());
                try {
                    if (this.keystoreKeyPasswd != null) {
                        sslContextBuilder.loadKeyMaterial(keystore, this.keystoreKeyPasswd.toCharArray());
                    } else {
                        sslContextBuilder.loadKeyMaterial(keystore, "".toCharArray());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        client.setSSLContext(sslContextBuilder.build());
    }

    private void tryCreateClient(String jocUri) throws SOSMissingDataException, KeyManagementException, SOSKeePassDatabaseException, NoSuchAlgorithmException, FileNotFoundException {
        if (this.client != null) {
            this.client.closeHttpClient();
        }
        if (this.config == null) {
            this.readConfig();
        }
        this.client = new SOSRestApiClient();
        this.setBasicAuthorizationIfExists(this.config);
        this.logDebug("initiate REST api client");
        if (jocUri.toLowerCase().startsWith("https:")) {
            this.applySSLContextCredentials(this.client);
        }
    }

    private String getPrivateKeyPath() {
        try {
            return this.config.getString(PRIVATE_CONF_JS7_PARAM_HTTP_BASIC_AUTH_PK_PATH);
        }
        catch (ConfigException e) {
            this.logError("no private key path found in private.conf.");
            return "";
        }
    }

    private String getDcryptedValue(String in, String privateKeyPath, String propertyName) {
        if (in != null && in.startsWith("enc:")) {
            String encryptedIn = in;
            encryptedIn = encryptedIn.startsWith("enc://") ? encryptedIn.substring("enc://".length()) : encryptedIn.substring("enc:".length());
            if (privateKeyPath == null) {
                privateKeyPath = this.getPrivateKeyPath();
            }
            try {
                in = this.decryptValue(encryptedIn, propertyName, privateKeyPath);
            }
            catch (SOSEncryptionException | SOSMissingDataException | SOSKeyException e) {
                this.logError("error occurred decrypting ".concat(PRIVATE_CONF_JS7_PARAM_HTTP_BASIC_AUTH_PWD).concat(" !"), e);
            }
        }
        return in;
    }

    private void setBasicAuthorizationIfExists(Config config) throws SOSKeePassDatabaseException, SOSMissingDataException {
        String csFile = null;
        String csKeyFile = null;
        String csPwd = null;
        try {
            csFile = config.getString(PRIVATE_CONF_JS7_PARAM_HTTP_BASIC_AUTH_CS_FILE);
        }
        catch (Exception e) {
            this.logDebug(e.getMessage());
        }
        try {
            csKeyFile = config.getString(PRIVATE_CONF_JS7_PARAM_HTTP_BASIC_AUTH_CS_KEYFILE);
        }
        catch (Exception e) {
            this.logDebug(e.getMessage());
        }
        try {
            csPwd = config.getString(PRIVATE_CONF_JS7_PARAM_HTTP_BASIC_AUTH_CS_PWD);
        }
        catch (Exception e) {
            this.logDebug(e.getMessage());
        }
        String username = "";
        String pwd = "";
        String token = "";
        if (csFile != null && !csFile.isEmpty()) {
            SOSKeePassResolver resolver = new SOSKeePassResolver(csFile, csKeyFile, csPwd);
            username = resolver.resolve(config.getString(PRIVATE_CONF_JS7_PARAM_HTTP_BASIC_AUTH_USERNAME));
            pwd = resolver.resolve(config.getString(PRIVATE_CONF_JS7_PARAM_HTTP_BASIC_AUTH_PWD));
            token = resolver.resolve(config.getString(PRIVATE_CONF_JS7_PARAM_HTTP_BASIC_AUTH_TOKEN));
        } else {
            try {
                token = config.getString(PRIVATE_CONF_JS7_PARAM_HTTP_BASIC_AUTH_TOKEN);
            }
            catch (ConfigException e) {
                this.logDebug("no token found in private.conf.");
            }
            if (token.isEmpty()) {
                try {
                    username = config.getString(PRIVATE_CONF_JS7_PARAM_HTTP_BASIC_AUTH_USERNAME);
                }
                catch (ConfigException e) {
                    this.logDebug("no username found in private.conf.");
                }
                try {
                    pwd = config.getString(PRIVATE_CONF_JS7_PARAM_HTTP_BASIC_AUTH_PWD);
                }
                catch (ConfigException e) {
                    this.logDebug("no (user-)password found in private.conf.");
                }
                String privateKeyPath = null;
                username = this.getDcryptedValue(username, privateKeyPath, "username");
                pwd = this.getDcryptedValue(pwd, privateKeyPath, "password");
            }
        }
        if (!token.isEmpty() && this.jobResources != null) {
            LOGGER.debug("get jobresource and variable from token:" + token);
            String[] tokenJobResource = token.split(":");
            if (tokenJobResource.length == 2) {
                String variableName = tokenJobResource[1];
                String jobResourceName = tokenJobResource[0];
                DetailValue detailValue = this.jobResources.get(variableName);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(SOSString.toString((Object)detailValue));
                    LOGGER.debug("variableName:" + variableName);
                    LOGGER.debug("jobResourceName:" + jobResourceName);
                }
                if (detailValue != null) {
                    if (detailValue.getSource().equals(jobResourceName)) {
                        token = (String)detailValue.getValue();
                    } else {
                        LOGGER.info("Name of JobResource: " + detailValue.getSource() + " does not match the " + tokenJobResource[0]);
                    }
                }
            }
            this.client.addHeader(X_ID_TOKEN, token);
        }
        if (!username.isEmpty() && !pwd.isEmpty()) {
            String basicAuth = Base64.getMimeEncoder().encodeToString((username + ":" + pwd).getBytes());
            this.client.setBasicAuthorization(basicAuth);
        }
    }

    private void closeClient() {
        if (this.client != null) {
            this.client.closeHttpClient();
        }
    }

    public void readConfig() throws SOSMissingDataException {
        String agentConfDirPath = System.getenv(AGENT_CONF_DIR_ENV_PARAM);
        if (agentConfDirPath == null) {
            agentConfDirPath = System.getProperty(AGENT_CONF_DIR_ENV_PARAM);
        }
        if (agentConfDirPath == null) {
            throw new SOSMissingDataException(String.format("Environment variable %1$s not set. Can\u00b4t read credentials from agents private.conf file.", AGENT_CONF_DIR_ENV_PARAM));
        }
        this.logDebug("agentConfDirPath: " + agentConfDirPath);
        Path agentConfDir = Paths.get(agentConfDirPath, new String[0]);
        Config defaultConfig = ConfigFactory.load();
        Properties props = new Properties();
        props.setProperty(PRIVATE_CONF_JS7_PARAM_CONFDIR, agentConfDir.toString());
        Path privatFolderPath = agentConfDir.resolve(PRIVATE_FOLDER_NAME);
        this.logDebug("agents private folder: " + privatFolderPath.toString());
        Config defaultConfigWithAgentConfDir = ConfigFactory.parseProperties((Properties)props).withFallback((ConfigMergeable)defaultConfig).resolve();
        this.logDebug("js7.config-directory (Config): " + defaultConfigWithAgentConfDir.getString(PRIVATE_CONF_JS7_PARAM_CONFDIR));
        if (Files.exists(privatFolderPath.resolve(PRIVATE_CONF_FILENAME), new LinkOption[0])) {
            this.config = ConfigFactory.parseFile((File)privatFolderPath.resolve(PRIVATE_CONF_FILENAME).toFile()).withFallback((ConfigMergeable)defaultConfigWithAgentConfDir).resolve();
            if (this.config != null) {
                for (Map.Entry entry : this.config.entrySet()) {
                    if (!((String)entry.getKey()).startsWith("js7") || DO_NOT_LOG_KEY.contains(entry.getKey())) continue;
                    this.logDebug((String)entry.getKey() + ": " + ((ConfigValue)entry.getValue()).toString());
                }
            }
        } else {
            throw new SOSMissingDataException(String.format("File %1$s does not exists. Can\u00b4t read credentials from agents private.conf file.", privatFolderPath.resolve(PRIVATE_CONF_FILENAME).toString()));
        }
    }

    private KeyStoreCredentials readKeystoreCredentials(Config config) {
        String keystorePath = null;
        try {
            keystorePath = config.getString(PRIVATE_CONF_JS7_PARAM_KEYSTORE_FILEPATH);
            this.logDebug("read Keystore from: " + config.getString(PRIVATE_CONF_JS7_PARAM_KEYSTORE_FILEPATH));
        }
        catch (ConfigException e) {
            this.logDebug("no keystore file found in private.conf.");
        }
        String keyPasswd = null;
        try {
            keyPasswd = config.getString(PRIVATE_CONF_JS7_PARAM_KEYSTORE_KEYPWD);
        }
        catch (ConfigException e) {
            this.logDebug("no keystore key-password found in private.conf.");
        }
        String storePasswd = null;
        try {
            storePasswd = config.getString(PRIVATE_CONF_JS7_PARAM_KEYSTORE_STOREPWD);
        }
        catch (ConfigException e) {
            this.logDebug("no keystore store-password found in private.conf.");
        }
        String alias = null;
        try {
            alias = config.getString(PRIVATE_CONF_JS7_PARAM_KEYSTORE_ALIAS);
        }
        catch (ConfigException e) {
            this.logDebug("no (key-)alias found in private.conf.");
        }
        if (keystorePath != null && !keystorePath.isEmpty()) {
            return new KeyStoreCredentials(keystorePath, storePasswd, keyPasswd, alias);
        }
        return null;
    }

    private List<KeyStoreCredentials> readTruststoreCredentials(Config config) {
        List credentials = null;
        try {
            credentials = config.getConfigList(PRIVATE_CONF_JS7_PARAM_TRUSTORES_ARRAY).stream().map(item -> new KeyStoreCredentials(item.getString(PRIVATE_CONF_JS7_PARAM_TRUSTSTORES_SUB_FILEPATH), item.getString("store-password"))).filter(Objects::nonNull).collect(Collectors.toList());
            this.logDebug("read Trustore from: " + ((Config)config.getConfigList(PRIVATE_CONF_JS7_PARAM_TRUSTORES_ARRAY).get(0)).getString(PRIVATE_CONF_JS7_PARAM_TRUSTSTORES_SUB_FILEPATH));
        }
        catch (ConfigException e) {
            this.logDebug("no truststore credentials found in private.conf.");
        }
        if (credentials != null) {
            return credentials;
        }
        return Collections.emptyList();
    }

    private void logInfo(String log) {
        if (this.jobLogger != null) {
            this.jobLogger.info(log);
        } else {
            LOGGER.info(log);
        }
    }

    private void logDebug(String log) {
        if (this.jobLogger != null) {
            this.jobLogger.debug(log);
        } else {
            LOGGER.debug(log);
        }
    }

    private void logError(String log) {
        this.logError(log, null);
    }

    private void logError(String log, Throwable t) {
        if (this.jobLogger != null) {
            if (t != null) {
                this.jobLogger.error(log, t);
            } else {
                this.jobLogger.error(log);
            }
        } else {
            LOGGER.error(log);
        }
    }

    private void handleExitCode(SOSRestApiClient client) throws SOSAuthenticationFailedException, SOSConnectionRefusedException, SOSException {
        if (client.statusCode() >= 500) {
            throw new SOSConnectionRefusedException();
        }
    }

    public SOSRestApiClient getClient() {
        return this.client;
    }

    public Config getConfig() throws SOSMissingDataException {
        if (this.config == null) {
            this.readConfig();
        }
        return this.config;
    }

    private String decryptValue(String encryptedValue, String propertyName, String privateKeyPath) throws SOSKeyException, SOSMissingDataException, SOSEncryptionException {
        return this.decryptValue(encryptedValue, propertyName, Paths.get(privateKeyPath, new String[0]));
    }

    private String decryptValue(String encryptedValue, String propertyName, Path privateKeyPath) throws SOSKeyException, SOSMissingDataException, SOSEncryptionException {
        PrivateKey pk = KeyUtil.getPrivateKey((Path)privateKeyPath);
        if (pk == null) {
            throw new SOSMissingDataException("encrypted values found, but no private key provided or path wrong for decryption!");
        }
        EncryptedValue encrypted = EncryptedValue.getInstance((String)propertyName, (String)encryptedValue);
        return Decrypt.decrypt((EncryptedValue)encrypted, (PrivateKey)pk);
    }
}

