/*
 * Decompiled with CFR 0.152.
 */
package com.sos.JSHelper.DataElements;

import com.sos.JSHelper.Basics.JSToolBox;
import com.sos.JSHelper.DataElements.JSDataElementDate;
import com.sos.JSHelper.DataElements.JSDataElementDouble;
import com.sos.JSHelper.DataElements.JSDateFormat;
import com.sos.JSHelper.Exceptions.FormatPatternException;
import com.sos.JSHelper.io.Files.JSXMLFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSDataElement
extends JSToolBox {
    private String strValue = "";
    private String strDefaultValue = "";
    private String strDescription = "";
    private int intSize = 0;
    private String strTitle = "";
    private String strColumnHeader = "";
    private String strXMLTagName = "";
    private boolean flgOmitXMLTag = false;
    private String strFormatString = "";
    private String strFormatPattern = "";
    private boolean flgAllowEmptyValue = true;
    private boolean flgTrimValue = false;
    private boolean flgIsCData = false;
    private boolean flgIsDirty = false;
    public static boolean flgXMLTagOnSingleLine = false;
    public static boolean flgTrimValues = false;
    public static boolean flgOmitEmptyXMLTags = true;
    public static boolean flgExceptionOnFieldTruncation = true;
    public int intPos = 0;

    public JSDataElement() {
        this.doInit();
    }

    public JSDataElement(String pstrValue) {
        this.setValue(pstrValue);
        this.doInit();
    }

    public JSDataElement(String pstrValue, String pstrDescription) {
        this.setValue(pstrValue);
        this.description(pstrDescription);
        this.doInit();
    }

    public JSDataElement(String pstrValue, String pstrDescription, int pintSize, int pintPos, String pstrFormatString, String pstrColumnHeader, String pstrXMLTagName) {
        this.doInit();
        this.setValue(pstrValue);
        this.description(pstrDescription);
        this.size(pintSize);
        this.intPos = pintPos;
        this.setFormatString(pstrFormatString.trim());
        this.description(pstrDescription);
        if (pstrColumnHeader.length() <= 0) {
            this.columnHeader(pstrDescription);
        } else {
            this.columnHeader(pstrColumnHeader);
        }
        if (pstrXMLTagName.length() <= 0) {
            this.xmlTagName(pstrDescription);
        } else {
            this.xmlTagName(pstrXMLTagName);
        }
    }

    public void setDirty(boolean pflgIsDirty) {
        this.flgIsDirty = pflgIsDirty;
    }

    public boolean isDirty() {
        return this.flgIsDirty;
    }

    public void setCData(boolean pflgIsCData) {
        this.flgIsCData = pflgIsCData;
    }

    public boolean isCData() {
        return this.flgIsCData;
    }

    public String toString() {
        return this.strDescription + ": " + this.strValue;
    }

    public JSDataElement columnHeader(String pstrColumnHeader) {
        if (pstrColumnHeader != null) {
            this.strColumnHeader = pstrColumnHeader;
        }
        return this;
    }

    public String getColumnHeader() {
        if (this.strColumnHeader == null) {
            this.strColumnHeader = "";
        }
        return this.strColumnHeader;
    }

    public JSDataElement title(String pstrTitle) {
        if (pstrTitle != null) {
            this.strTitle = pstrTitle;
        }
        return this;
    }

    public String getTitle() {
        if (this.strTitle == null) {
            this.strTitle = "";
        }
        return this.strTitle;
    }

    public void setValue(JSDataElement objDE) {
        this.setValue(objDE.getValue());
    }

    public void setValue(String pstrValue) {
        if (pstrValue != null) {
            if (!this.strValue.equals(pstrValue)) {
                this.setDirty(true);
                this.strValue = pstrValue;
                if (this.flgTrimValue || flgTrimValues) {
                    this.strValue = this.strValue.trim();
                }
            }
        } else {
            this.strValue = "";
        }
    }

    public String getValue() {
        if (this.strValue == null) {
            this.strValue = "";
        }
        return this.strValue;
    }

    public JSDataElement defaultValue(String pstrDefaultValue) {
        this.strDefaultValue = pstrDefaultValue;
        return this;
    }

    public String getDefaultValue() {
        return this.strDefaultValue;
    }

    public JSDataElement description(String pstrDescription) {
        if (pstrDescription != null) {
            this.strDescription = pstrDescription;
        }
        return this;
    }

    public String getDescription() {
        if (this.strDescription == null) {
            this.strDescription = "";
        }
        return this.strDescription;
    }

    public JSDataElement size(int pintSize) {
        this.intSize = pintSize;
        return this;
    }

    public JSDataElement size(Integer pintSize) {
        this.intSize = pintSize;
        return this;
    }

    public int getIntSize() {
        return this.intSize;
    }

    public Integer getIntegerSize() {
        return new Integer(this.intSize);
    }

    public JSDataElement xmlTagName(String pstrXMLTagName) {
        if (pstrXMLTagName != null) {
            this.strXMLTagName = pstrXMLTagName;
        }
        return this;
    }

    public String getXMLTagName() {
        if (this.strXMLTagName == null) {
            this.strXMLTagName = "";
        }
        return this.strXMLTagName;
    }

    public String toXml(String pstrTagName) {
        if (this.isOmittXMLTag()) {
            JSDataElementDate objD;
            if (this instanceof JSDataElementDouble) {
                JSDataElementDouble objT = (JSDataElementDouble)this;
                if (objT.dblValue == 0.0) {
                    return "";
                }
            }
            if (this instanceof JSDataElementDate && (objD = (JSDataElementDate)this).isEmpty()) {
                return "";
            }
            if (this.getFormattedValue().isEmpty()) {
                return "";
            }
        }
        String strT = "";
        if (!this.getValue().isEmpty()) {
            strT = "<" + pstrTagName + ">";
            strT = this.isCData() ? strT + "<![CDATA[" + this.getFormattedValue() + "]]>" : strT + this.getFormattedValue();
            strT = strT + "</" + pstrTagName + ">";
        } else {
            strT = "<" + pstrTagName + "/>";
        }
        if (flgXMLTagOnSingleLine) {
            strT = strT + "\n";
        }
        return strT;
    }

    public String toXml() {
        return this.toXml(this.getXMLTagName());
    }

    public void toXml(JSXMLFile pobjXMLFile) throws Exception {
        pobjXMLFile.writeLine(this.toXml());
    }

    public void setFormatString(String pstrFormatString) {
        if (!this.isEmpty(pstrFormatString)) {
            this.strFormatString = pstrFormatString;
        } else if (this.isEmpty(this.strFormatString)) {
            this.strFormatString = pstrFormatString;
        }
    }

    public void setFormatString(JSDateFormat pJSDateFormat) {
        this.setFormatString(pJSDateFormat.toPattern());
    }

    public String getFormatString() {
        if (this.strFormatString == null) {
            this.strFormatString = "";
        }
        return this.strFormatString;
    }

    public void doInit() {
    }

    public String getFormattedValue() {
        return this.getValue();
    }

    public JSDataElement omitXMLTag(boolean pflgOmitXMLTag) {
        this.flgOmitXMLTag = pflgOmitXMLTag;
        return this;
    }

    public boolean isOmittXMLTag() {
        return this.flgOmitXMLTag;
    }

    public boolean isEmpty() {
        return this.getValue().trim().isEmpty();
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public boolean hasValue() {
        return !this.getValue().trim().isEmpty();
    }

    public void setTrimValue(boolean pflgTrimValue) {
        this.flgTrimValue = pflgTrimValue;
    }

    public void setRecordValue(StringBuffer pstrRecord) {
        this.setValue(pstrRecord.substring(this.intPos, this.intPos + this.intSize).trim());
    }

    public void buildRecord(StringBuffer pstrRecord) throws Exception {
        String strVal = this.getValue();
        if ((strVal.length() > this.intSize || !this.getFormatString().isEmpty()) && (strVal = this.getFormattedValue()).length() > this.intSize && flgExceptionOnFieldTruncation) {
            throw new Exception("Value truncated. max " + this.intSize + ", actual " + this.getValue().length() + ". Description:" + this.getDescription() + ". Value = '" + this.getValue() + "', " + this.getFormattedValue());
        }
        this.doReplace(pstrRecord, this.intPos, this.intPos + this.intSize, strVal);
    }

    protected StringBuffer doReplace(StringBuffer pstrS, int pintPos, int pintPos2, String pstrR) {
        int intlSize = pintPos2 - pintPos;
        int intLen = pstrS.length();
        if (intLen < pintPos2) {
            pstrS.append(JSDataElement.repeatString(" ", pintPos2 - intLen + 1));
        }
        String strT = pstrR + JSDataElement.repeatString(" ", intlSize);
        strT = strT.substring(0, intlSize);
        pstrS.replace(pintPos, pintPos2, strT);
        return pstrS;
    }

    public void setFormatPattern(String pstrFormatPattern) {
        if (pstrFormatPattern != null) {
            this.strFormatPattern = pstrFormatPattern;
        }
    }

    public void allowEmptyValue(boolean pflgAllowEmptyValue) {
        this.flgAllowEmptyValue = pflgAllowEmptyValue;
    }

    public void checkFormatPattern() throws FormatPatternException {
        Pattern objP;
        Matcher objM;
        if (!(!this.isNotEmpty(this.strFormatPattern) || this.flgAllowEmptyValue && "".equals(this.getValue().trim()) || (objM = (objP = Pattern.compile(this.strFormatPattern)).matcher(this.getValue())).find())) {
            throw new FormatPatternException("the value '" + this.getValue() + "' does not correspond with the pattern " + this.strFormatPattern);
        }
    }

    public boolean isEqual(JSDataElement pobjO) {
        boolean flgC = false;
        if (pobjO != null) {
            flgC = this.getValue().equalsIgnoreCase(pobjO.getValue());
        }
        return flgC;
    }

    public String getSQLValue() {
        String strT = this.getValue();
        strT = strT.replace("'", "''");
        return "'" + strT + "'";
    }

    public boolean equals(Object pobjO) {
        if (pobjO instanceof String) {
            String strT = (String)pobjO;
            return this.getValue().equals(strT);
        }
        if (pobjO instanceof JSDataElement) {
            return this.getValue().equals(((JSDataElement)pobjO).getValue());
        }
        return pobjO.equals(this);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

