/*
 * Decompiled with CFR 0.152.
 */
package com.sos.JSHelper.DataElements;

import com.sos.JSHelper.DataElements.JSDataElement;
import com.sos.JSHelper.DataElements.JSDateFormat;
import com.sos.JSHelper.Exceptions.FormatPatternException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSDataElementDate
extends JSDataElement {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSDataElementDate.class);
    private JSDateFormat objFormat = null;

    public JSDataElementDate() {
    }

    public JSDataElementDate(String pstrDate, String pstrTime) {
        super.setValue(pstrDate + pstrTime);
    }

    public JSDataElementDate(JSDataElement pelemDate, JSDataElement pelemTime) {
        String strD = pelemDate.getValue();
        String strT = pelemTime.getValue();
        if (strT.trim().isEmpty()) {
            strT = "000000";
        }
        super.setValue(strD + strT);
    }

    public JSDataElementDate(String pstrDate) {
        super.setValue(pstrDate);
    }

    public JSDataElementDate(String pstrDate, JSDateFormat pobjFormat) {
        super.setValue(pstrDate);
        this.objFormat = pobjFormat;
    }

    public JSDataElementDate(Date pdteDate, JSDateFormat pobjFormat) {
        this.Value(pdteDate);
        this.objFormat = pobjFormat;
    }

    public JSDataElementDate(Date pdatDate) {
        JSDateFormat objFormat = JSDateFormat.dfTIMESTAMPS24;
        this.setValue(objFormat.format(pdatDate));
    }

    public JSDataElementDate(String pPstrValue, String pPstrDescription, int pPintSize, int pPintPos, String pPstrFormatString, String pPstrColumnHeader, String pPstrXMLTagName) {
        super(pPstrValue, pPstrDescription, pPintSize, pPintPos, pPstrFormatString, pPstrColumnHeader, pPstrXMLTagName);
    }

    @Override
    public void setValue(String pstrValue) {
        if (pstrValue == null || "00000000".equals(pstrValue)) {
            pstrValue = "";
        }
        super.setValue(pstrValue);
    }

    public void Value(Date pdatValue) {
        if (this.objFormat == null) {
            this.objFormat = JSDateFormat.dfDATE_N8;
        }
        super.setValue(this.objFormat.format(pdatValue));
    }

    public Date getDateObject() {
        try {
            if (this.objFormat == null) {
                this.objFormat = JSDateFormat.dfDATE_N8;
            }
            Date objD = this.objFormat.parse(this.getValue());
            return objD;
        }
        catch (ParseException e) {
            this.message(e.getMessage());
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void setParsePattern(JSDateFormat pobjFormat) {
        this.objFormat = pobjFormat;
    }

    public JSDateFormat getParsePattern() {
        return this.objFormat;
    }

    public void setFormatPattern(JSDateFormat pobjFormat) {
        super.setFormatString(pobjFormat.toPattern());
    }

    @Override
    public void doInit() {
        super.setFormatString(JSDateFormat.dfDATE_N8.toPattern());
        super.description("Date");
        super.columnHeader("Date");
        super.xmlTagName("Date");
        String strFormat = super.getFormatString();
        if (this.isNotEmpty(strFormat)) {
            JSDateFormat df = new JSDateFormat(strFormat);
            super.setFormatPattern(df.toPattern());
        }
    }

    @Override
    public String getFormattedValue() {
        String strFormat = super.getFormatString();
        if (strFormat.isEmpty()) {
            strFormat = JSDateFormat.dfDATE_N8.toPattern();
        }
        if (this.isNotEmpty(strFormat) && this.hasAValue()) {
            JSDateFormat df = new JSDateFormat(strFormat);
            return df.format(this.getDateObject());
        }
        return this.getValue();
    }

    @Override
    public void checkFormatPattern() throws FormatPatternException {
        if (this.objFormat != null) {
            try {
                this.objFormat.parse(this.getValue());
            }
            catch (ParseException e) {
                throw new FormatPatternException("the value '" + this.getValue() + "' does not correspond with the pattern " + this.objFormat.toPattern());
            }
        }
    }

    public boolean hasAValue() {
        return !this.isEmpty();
    }

    @Override
    public boolean isEmpty() {
        return super.getValue().trim().isEmpty() || "00000000".equals(super.getValue().trim());
    }

    @Override
    public String getSQLValue() {
        this.setFormatString(JSDateFormat.dfTIMESTAMPS.toPattern());
        String strV = this.getFormattedValue();
        strV = strV.substring(0, 14);
        String strMask = "YYYYMMDDHH24MISS";
        return "to_date(" + strV + ", '" + "YYYYMMDDHH24MISS" + "')";
    }

    @Override
    public Date now() {
        Calendar now = Calendar.getInstance();
        return now.getTime();
    }

    public static String getCurrentTimeAsString(String dateTimeFormat) throws Exception {
        String strFormat = dateTimeFormat;
        if (dateTimeFormat == null || dateTimeFormat.length() <= 0) {
            strFormat = "yyyyMMddHHmmss";
        }
        SimpleDateFormat formatter = new SimpleDateFormat(strFormat);
        Calendar now = Calendar.getInstance();
        return formatter.format(now.getTime());
    }

    public static String getCurrentTimeAsString() throws Exception {
        return JSDataElementDate.getCurrentTimeAsString("yyyyMMddHHmmss");
    }

    public int getLastFridayInAMonth(int month, int year) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month, 1, 0, 0, 0);
        cal.set(14, 0);
        int firstDay = cal.get(7);
        int daysOfMonth = cal.getMaximum(5);
        switch (firstDay) {
            case 1: {
                return 27;
            }
            case 2: {
                return 26;
            }
            case 3: {
                return 25;
            }
            case 4: {
                if (daysOfMonth == 31) {
                    return 31;
                }
                return 24;
            }
            case 5: {
                if (daysOfMonth >= 30) {
                    return 30;
                }
                return 23;
            }
            case 6: {
                if (daysOfMonth >= 29) {
                    return 29;
                }
                return 22;
            }
            case 7: {
                return 28;
            }
        }
        throw new RuntimeException("what day of the month?");
    }

    public int getLastThursday(int month, int year) {
        return this.getLastFridayInAMonth(month, year) - 1;
    }
}

